/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.qdoc;

import com.google.common.base.MoreObjects;
import com.timestored.TimeStored;
import com.timestored.qdoc.DocSource;
import com.timestored.qdoc.DocumentedEntity;
import java.net.URLEncoder;

public abstract class BuiltinDocumentedEntities
implements DocumentedEntity,
DocSource {
    protected final String docname;
    protected final String description;
    protected final String syntax;
    protected final String eg;

    protected BuiltinDocumentedEntities(String docname, String description) {
        this.docname = docname;
        this.description = description;
        this.syntax = null;
        this.eg = null;
    }

    protected BuiltinDocumentedEntities(String docname, String description, String syntax, String eg) {
        this.docname = docname;
        this.description = description;
        this.syntax = syntax;
        this.eg = eg;
    }

    public String getName() {
        return this.docname;
    }

    public String getDescription() {
        return this.description;
    }

    public abstract String getLink();

    @Override
    public String getDocName() {
        return this.docname;
    }

    @Override
    public String getHtmlDoc(boolean shortFormat) {
        String link;
        StringBuilder sb = new StringBuilder();
        sb.append("<html><body>");
        sb.append(this.description.replaceAll("\n", "<br />"));
        sb.append("<br/>");
        if (this.syntax != null && this.syntax.length() > 0) {
            sb.append("<br/><b>syntax:</b> ");
            sb.append(this.syntax.replace("\n", "<br />"));
        }
        if (this.eg != null && this.eg.length() > 0) {
            sb.append("<br/><b>eg:</b> ");
            if (this.eg.contains("\n")) {
                sb.append("<br />").append(this.eg.replace("\n", "<br />"));
            } else {
                sb.append(this.eg);
            }
        }
        if ((link = this.getLink()) != null && link.length() > 0) {
            sb.append("<br/><br/><a href='");
            sb.append(TimeStored.getRedirectPage(link, "qdoc"));
            sb.append("&qdoc=");
            sb.append(URLEncoder.encode(this.docname));
            sb.append("'>Open online doc</a>");
        }
        sb.append("</body></html>");
        return sb.toString();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("name", this.docname).add("description", this.description).toString();
    }

    @Override
    public DocumentedEntity.SourceType getSourceType() {
        return DocumentedEntity.SourceType.BUILTIN;
    }

    @Override
    public String getFullName() {
        int p = this.docname.indexOf(91);
        if (p != -1) {
            return this.docname.substring(0, p);
        }
        return this.docname;
    }
}

