/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.qdoc;

import com.google.common.collect.Maps;
import com.timestored.command.Command;
import com.timestored.command.CommandSplitPane;
import com.timestored.qdoc.DocumentationDialog;
import com.timestored.qdoc.DocumentedEntity;
import com.timestored.qdoc.DocumentedEntityDocCommand;
import com.timestored.qdoc.DocumentedMatcher;
import com.timestored.qdoc.Suggestion;
import com.timestored.qstudio.CommonActions;
import com.timestored.swingxx.AAction;
import com.timestored.swingxx.SwingUtils;
import com.timestored.theme.Theme;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.KeyStroke;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class AutoCompleteDialog
extends JDialog {
    private static final Logger LOG = Logger.getLogger(AutoCompleteDialog.class.getName());
    private static final long serialVersionUID = 1L;
    private final JEditorPane editorPane;
    private final CommandSplitPane docSplitPane;
    private final CaretListener caretListener;
    private final Map<KeyStroke, Replacement> replacementActions;
    private final Map<KeyStroke, Object> savedActions;
    private List<DocumentedEntity> docsShown = Collections.emptyList();
    private int prevDot;
    private final DocumentedMatcher documentedEntityMatcher;
    private MouseAdapter mouseListener;

    public AutoCompleteDialog(JEditorPane editorPane, JFrame parentFrame, DocumentedMatcher documentedEntityMatcher) {
        super(parentFrame);
        this.editorPane = editorPane;
        this.documentedEntityMatcher = documentedEntityMatcher;
        this.prevDot = editorPane.getCaretPosition();
        this.replacementActions = this.getReplacements();
        this.savedActions = this.getActions(this.replacementActions.keySet(), editorPane.getInputMap());
        AutoCompleteDialog.overrideKeyActions(editorPane, this.replacementActions);
        this.caretListener = new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                int newDot = e.getDot();
                if (Math.abs(newDot - AutoCompleteDialog.this.prevDot) > 1) {
                    AutoCompleteDialog.this.close();
                } else {
                    AutoCompleteDialog.this.prevDot = newDot;
                    AutoCompleteDialog.this.refreshSelection(true);
                }
            }
        };
        editorPane.addCaretListener(this.caretListener);
        this.mouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                AutoCompleteDialog.this.close();
            }
        };
        editorPane.addMouseListener(this.mouseListener);
        this.docSplitPane = new CommandSplitPane();
        this.docSplitPane.setFgColor(Theme.SUB_HEADER_FG_COLOR);
        this.docSplitPane.setBgColor(Theme.SUB_HEADER_BG_COLOR);
        this.setLayout(new BorderLayout());
        this.add((Component)this.docSplitPane, "Center");
        this.setName("autoCompleteDialog");
        this.setMinimumSize(DocumentationDialog.PREF_DIMENSION);
        this.setPreferredSize(DocumentationDialog.PREF_DIMENSION);
        this.refreshSelection(false);
        this.docSplitPane.setCloseAction(new AAction(e -> this.close()));
        this.docSplitPane.setSelectAction(new AAction(e -> {
            Command cmd = this.docSplitPane.getSelectedCommand();
            if (cmd != null) {
                cmd.perform();
            }
            this.dispose();
        }));
    }

    private Map<KeyStroke, Object> getActions(Set<KeyStroke> ksSet, InputMap inputMap) {
        HashMap<KeyStroke, Object> m = Maps.newHashMap();
        for (KeyStroke ks : ksSet) {
            m.put(ks, inputMap.get(ks));
        }
        return m;
    }

    private static void overrideKeyActions(JEditorPane editorPane, Map<KeyStroke, Replacement> replacementActions) {
        InputMap iMap = editorPane.getInputMap();
        ActionMap aMap = editorPane.getActionMap();
        Iterator<Map.Entry<KeyStroke, Replacement>> repActions = replacementActions.entrySet().iterator();
        while (repActions.hasNext()) {
            Replacement r = repActions.next().getValue();
            aMap.put(r.uniqueKey, r.action);
            iMap.put(r.ks, r.uniqueKey);
        }
    }

    private void doAutocomplete(DocumentedEntity documentedEntity) {
        Document d = this.editorPane.getDocument();
        Suggestion suggestion = null;
        try {
            String txt = d.getText(0, d.getLength());
            suggestion = this.documentedEntityMatcher.getSuggestion(documentedEntity, txt, this.prevDot);
        }
        catch (BadLocationException e) {
            LOG.warning("illegal doc access: " + e);
        }
        if (suggestion != null) {
            Document doc = this.editorPane.getDocument();
            try {
                String newText = doc.getText(0, this.prevDot) + suggestion.getTextInsert() + doc.getText(this.prevDot, doc.getLength() - this.prevDot);
                this.editorPane.setText(newText);
                this.editorPane.setSelectionStart(this.prevDot + suggestion.getSelectionStart());
                this.editorPane.setSelectionEnd(this.prevDot + suggestion.getSelectionEnd());
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
        this.close();
    }

    private void close() {
        LOG.info("close");
        this.setVisible(false);
        this.editorPane.removeCaretListener(this.caretListener);
        this.editorPane.removeMouseListener(this.mouseListener);
        InputMap iMap = this.editorPane.getInputMap();
        for (Map.Entry<KeyStroke, Object> savedAct : this.savedActions.entrySet()) {
            iMap.put(savedAct.getKey(), savedAct.getValue());
        }
        this.dispose();
    }

    private void refreshSelection(boolean closeIfNoMatches) {
        LOG.info("refreshSelection");
        this.docsShown = null;
        try {
            Document d = this.editorPane.getDocument();
            String txt = d.getText(0, d.getLength());
            this.docsShown = this.documentedEntityMatcher.findByPrefix(txt, this.prevDot);
        }
        catch (BadLocationException e) {
            LOG.fine("BadLocationException" + e.toString());
        }
        if (this.docsShown != null) {
            if (this.docsShown.size() == 0 && closeIfNoMatches) {
                this.close();
            }
            ArrayList<Command> commands = new ArrayList<Command>();
            for (final DocumentedEntity de : this.docsShown) {
                DocumentedEntityDocCommand docCommand = new DocumentedEntityDocCommand(de, true, ""){

                    @Override
                    public void perform() {
                        AutoCompleteDialog.this.doAutocomplete(de);
                    }
                };
                commands.add(docCommand);
            }
            this.docSplitPane.setDocsShown(commands);
        }
    }

    private Map<KeyStroke, Replacement> getReplacements() {
        HashMap<KeyStroke, Replacement> r = Maps.newHashMap();
        AAction upAction = new AAction(e -> this.docSplitPane.moveUp());
        KeyStroke upKey = KeyStroke.getKeyStroke("UP");
        r.put(upKey, new Replacement("upAction", upKey, upAction));
        AAction downAction = new AAction(e -> this.docSplitPane.moveDown());
        KeyStroke downKey = KeyStroke.getKeyStroke("DOWN");
        r.put(downKey, new Replacement("downAction", downKey, downAction));
        AAction escapeAction = new AAction(e -> this.close());
        r.put(SwingUtils.ESC_KEYSTROKE, new Replacement("escapeAction", SwingUtils.ESC_KEYSTROKE, escapeAction));
        AAction autocompleteAction = new AAction(e -> {});
        KeyStroke autocompleteKey = CommonActions.AUTO_COMPLETE_KS;
        r.put(autocompleteKey, new Replacement("autocompleteAction", autocompleteKey, autocompleteAction));
        AAction enterAction = new AAction(e -> this.docSplitPane.getSelectedCommand().perform());
        KeyStroke enterKey = KeyStroke.getKeyStroke(10, 0);
        r.put(enterKey, new Replacement("enterAction", enterKey, enterAction));
        return r;
    }

    private class Replacement {
        public final String uniqueKey;
        public final KeyStroke ks;
        public final Action action;

        private Replacement(String uniqueKey, KeyStroke ks, Action action) {
            this.uniqueKey = uniqueKey;
            this.ks = ks;
            this.action = action;
        }
    }
}

