/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.pro.sql;

import com.timestored.qdoc.BuiltinDocumentedEntities;
import com.timestored.qdoc.DocSource;
import com.timestored.qdoc.DocumentedEntity;
import com.timestored.theme.Theme;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.ImageIcon;

public class SqlFunctions
extends BuiltinDocumentedEntities
implements DocumentedEntity,
DocSource {
    private static final List<SqlFunctions> knownFunctions;
    private final String db;
    private final String area;

    private SqlFunctions(String name, String db, String call, String description, String eg, String area) {
        super(name, description, call, eg);
        this.db = db;
        this.area = area;
    }

    public static List<SqlFunctions> getKnownFunctions() {
        return knownFunctions;
    }

    @Override
    public String getLink() {
        String page = this.docname;
        int pos = page.indexOf("[");
        if (pos != -1) {
            page = page.substring(0, pos);
        }
        return "https://sqldock.com/h2/function/" + page.toLowerCase();
    }

    @Override
    public ImageIcon getIcon() {
        return Theme.CIcon.FUNCTION_ELEMENT.get16();
    }

    public List<SqlFunctions> getDocs() {
        return knownFunctions;
    }

    @Override
    public String getSource() {
        return "sql";
    }

    static {
        ArrayList<SqlFunctions> dz = new ArrayList<SqlFunctions>();
        dz.add(new SqlFunctions("lower", "duckdb,mysql,postgresql,sqlite", "`lower(`*`string`*`)`", "<p>  The lower(X) function returns a copy of string X with all ASCII characters  converted to lower case.  The default built-in lower() function works  for ASCII characters only.  To do case conversions on non-ASCII  characters, load the ICU extension.", "`lower('Hello')`", "char"));
        dz.add(new SqlFunctions("upper", "duckdb,mysql,postgresql,sqlite", "`upper(`*`string`*`)`", "<p>  The upper(X) function returns a copy of input string X in which all   lower-case ASCII characters are converted to their upper-case equivalent.", "`upper('Hello')`", "char"));
        dz.add(new SqlFunctions("ceil", "duckdb,postgresql,sqlite", "ceil( X ) ceiling( X )", "<p>  Return the first representable integer value greater than or equal to X.  For positive values of X, this routine rounds away from zero.  For negative values of X, this routine rounds toward zero.", "`ceil(17.4)`", "numeric"));
        dz.add(new SqlFunctions("concat", "duckdb,postgresql,sqlite", "`concat(`*`string`*`, ...)`", "<p>  The concat(...) function returns a string which is the concatenation of the  string representation of all of its non-NULL arguments.  If all arguments are  NULL, then concat() returns an empty string.", "concat('abcde', 2, NULL,          22)", "char"));
        dz.add(new SqlFunctions("concat_ws", "duckdb,postgresql,sqlite", "`concat_ws(`*`separator`*`, `*`string`*`, ...)`", "<p>  The concat_ws(SEP,...) function returns a string that is the concatenation of  all non-null arguments beyond the first argument, using the text value of the  first argument as a separator.  If the first argument is NULL, then concat_ws()  returns NULL.  If all arguments other than the first are NULL, then concat_ws()  returns an empty string.", "`concat_ws(', ', 'Banana', 'Apple', 'Melon')`", "char"));
        dz.add(new SqlFunctions("degrees", "duckdb,postgresql,sqlite", "`degrees(x)`", "<p>  Convert value X from radians into degrees.", "`degrees(pi())`", "numeric"));
        dz.add(new SqlFunctions("floor", "duckdb,postgresql,sqlite", "`floor(x)`", "<p>  Return the first representable integer value less than or equal to X.  For positive numbers, this function rounds toward zero.  For negative numbers, this function rounds away from zero.", "`floor(17.4)`", "numeric"));
        dz.add(new SqlFunctions("format", "duckdb,postgresql,sqlite", "`format(`*`format`*`, `*`parameters`*`...)`", "Format a string. This function is similar to the C          function <code class=\"FUNCTION\">sprintf</code>; but only          the following conversion specifications are recognized:          <tt class=\"LITERAL\">%s</tt> interpolates the          corresponding argument as a string; <tt class=          \"LITERAL\">%I</tt> escapes its argument as an SQL          identifier; <tt class=\"LITERAL\">%L</tt> escapes its          argument as an SQL literal; <tt class=\"LITERAL\">%%</tt>          outputs a literal <tt class=\"LITERAL\">%</tt>. A          conversion can reference an explicit parameter position          by preceding the conversion specifier with <tt class=          \"LITERAL\"><tt class=\"REPLACEABLE c3\">n</tt>$</tt>, where          <tt class=\"REPLACEABLE c3\">n</tt> is the argument          position. See also <a href=          \"plpgsql-statements.html#PLPGSQL-QUOTE-LITERAL-EXAMPLE\">Example          39-1</a>.</td>", "`format('Benchmark \"{}\" took {} seconds', 'CSV', 42)`", "char"));
        dz.add(new SqlFunctions("length", "duckdb,postgresql,sqlite", "`length(`*`bitstring`*`)`", "<p>  For a string value X, the length(X) function returns the number of   characters (not bytes) in X prior to the first NUL character.  Since SQLite strings do not normally contain NUL characters, the length(X)  function will usually return the total number of characters in the string X.  For a blob value X, length(X) returns the number of bytes in the blob.  If X is NULL then length(X) is NULL.  If X is numeric then length(X) returns the length of a string  representation of X.  <p>  Note that for strings, the length(X) function returns the <i>character</i>  length of the string, not the byte length.  The character length is the number  of characters in the string.  The character length is always different from  the byte length for UTF-16 strings, and can be different from the byte length  for UTF-8 strings if the string contains multi-byte characters.  Use the  <a href=\"lang_corefunc.html#octet_length\">octet_length()</a> function to find the byte length of a string.  <p>  For BLOB values, length(X) always returns the byte-length of the BLOB.  <p>  For string values, length(X) must read the entire string into memory in order  to compute the character length.  But for BLOB values, that is not necessary as  SQLite knows how many bytes are in the BLOB.  Hence, for multi-megabyte values,  the length(X) function is usually much faster for BLOBs than for strings, since  it does not need to load the value into memory.", "`length('1101011'::BIT)`", "bitstring"));
        dz.add(new SqlFunctions("log", "duckdb,postgresql,sqlite", "log( X ) log10( X ) log( B , X )", "<p>  Return the base-10 logarithm for X.  Or, for the two-argument version,  return the base-B logarithm of X.  <p>  Compatibility note:  SQLite works like PostgreSQL in that the log() function  computes a base-10 logarithm.  Most other SQL database engines compute a  natural logarithm for log().  In the two-argument version of log(B,X), the  first argument is the base and the second argument is the operand.  This is  the same as in PostgreSQL and MySQL, but is reversed from SQL Server which  uses the second argument as the base and the first argument as the operand.", "log(2.0, 64.0)", "numeric"));
        dz.add(new SqlFunctions("ltrim", "duckdb,postgresql,sqlite", "`ltrim(`*`string`*`, `*`characters`*`)`", "<p>  The ltrim(X,Y) function returns a string formed by removing any and all  characters that appear in Y from the left side of X.  If the Y argument is omitted, ltrim(X) removes spaces from the left side  of X.", "`ltrim('test')`", "char"));
        dz.add(new SqlFunctions("octet_length", "duckdb,postgresql,sqlite", "`octet_length(`*`bitstring`*`)`", "<p>  The octet_length(X) function returns the number of bytes in the encoding  of text string X.  If X is NULL then octet_length(X) returns NULL.  If X is  a BLOB value, then octet_length(X) is the same as <a href=\"lang_corefunc.html#length\">length(X)</a>.  If X is a  numeric value, then octet_length(X) returns the number of bytes in a text  rendering of that number.  <p>  Because octet_length(X) returns the number of bytes in X, not the number  of characters, the value returned depends on the database encoding.  The  octet_length() function can return different answers for the same input string  if the database encoding is UTF16 instead of UTF8.  <p>  If argument X is a table column and the value is of type text or blob,  then octet_length(X) avoids reading the content of X from disk, as the byte  length can be computed from metadata.  Thus, octet_length(X) is efficient  even if X is a column containing a multi-megabyte text or blob value.", "`octet_length('\\xAA\\xBB'::BLOB)`", "bitstring"));
        dz.add(new SqlFunctions("pi", "duckdb,postgresql,sqlite", "`pi()`", "<span class=\"QUOTE\">\"\u00cf\u20ac\"</span> constant</td>", "`pi()`", "numeric"));
        dz.add(new SqlFunctions("radians", "duckdb,postgresql,sqlite", "`radians(x)`", "<p>  Convert X from degrees into radians.", "`radians(90)`", "numeric"));
        dz.add(new SqlFunctions("random", "duckdb,postgresql,sqlite", "`random()`", "<p>  The random() function returns a pseudo-random integer  between -9223372036854775808 and +9223372036854775807.", "`random()`", "numeric"));
        dz.add(new SqlFunctions("replace", "duckdb,postgresql,sqlite", "`replace(`*`string`*`, `*`source`*`, `*`target`*`)`", "<p>  The replace(X,Y,Z) function returns a string formed by substituting  string Z for every occurrence of string Y in string X.  The <a href=\"datatype3.html#collation\">BINARY</a>  collating sequence is used for comparisons.  If Y is an empty  string then return X unchanged.  If Z is not initially  a string, it is cast to a UTF-8 string prior to processing.", "replace('abcdefabcdef', 'cd',          'XX')", "char"));
        dz.add(new SqlFunctions("round", "duckdb,postgresql,sqlite", "`round(v NUMERIC, s INT)`", "<p>  The round(X,Y) function returns a floating-point  value X rounded to Y digits to the right of the decimal point.  If the Y argument is omitted or negative, it is taken to be 0.", "`round(42.4332, 2)`", "numeric"));
        dz.add(new SqlFunctions("rtrim", "duckdb,postgresql,sqlite", "`rtrim(`*`string`*`, `*`characters`*`)`", "<p>  The rtrim(X,Y) function returns a string formed by removing any and all  characters that appear in Y from the right side of X.  If the Y argument is omitted, rtrim(X) removes spaces from the right  side of X.", "`rtrim('test')`", "char"));
        dz.add(new SqlFunctions("sign", "duckdb,postgresql,sqlite", "`sign(x)`", "<p>  The sign(X) function returns -1, 0, or +1 if the argument X is a numeric  value that is negative, zero, or positive, respectively.  If the argument  to sign(X) is NULL or is a string or blob that cannot be losslessly converted  into a number, then sign(X) returns NULL.", "`sign(-349)`", "numeric"));
        dz.add(new SqlFunctions("trim", "duckdb,postgresql,sqlite", "`trim(`*`string`*`, `*`characters`*`)`", "Remove the longest string containing only the          <tt class=\"PARAMETER\">characters</tt> (a space by          default) from the start/end/both ends of the <tt class=          \"PARAMETER\">string</tt></td>", "trim(both 'x' from          'xTomxx')", "char"));
        dz.add(new SqlFunctions("trunc", "duckdb,postgresql,sqlite", "`trunc(x)`", "<p>  Return the representable integer in between X and 0 (inclusive)  that is furthest away from zero.  Or, in other words, return the  integer part of X, rounding toward zero.  The trunc() function is similar to <a href=\"lang_mathfunc.html#ceil\">ceiling(X)</a> and <a href=\"lang_mathfunc.html#floor\">floor(X)</a> except  that it always rounds toward zero whereas ceiling(X) and floor(X) round  up and down, respectively.", "trunc(42.4382, 2)", "numeric"));
        dz.add(new SqlFunctions("ascii", "duckdb,postgresql", "`ascii(`*`string`*`)`", "<acronym class=\"ACRONYM\">ASCII</acronym> code of the          first character of the argument. For <acronym class=          \"ACRONYM\">UTF8</acronym> returns the Unicode code point          of the character. For other multibyte encodings, the          argument must be an <acronym class=          \"ACRONYM\">ASCII</acronym> character.</td>", "`ascii('\u00ce\u00a9')`", "char"));
        dz.add(new SqlFunctions("bit_length", "duckdb,postgresql", "`bit_length(`*`bitstring`*`)`", "Returns the number of bits in the bitstring.", "`bit_length('1101011'::BIT)`", "bitstring"));
        dz.add(new SqlFunctions("ceiling", "duckdb,postgresql", "`ceiling(x)`", "smallest integer not less than argument (alias for          <code class=\"FUNCTION\">ceil</code>)</td>", "`ceiling(17.4)`", "numeric"));
        dz.add(new SqlFunctions("chr", "duckdb,postgresql", "`chr(`*`x`*`)`", "Character with the given code. For <acronym class=          \"ACRONYM\">UTF8</acronym> the argument is treated as a          Unicode code point. For other multibyte encodings the          argument must designate an <acronym class=          \"ACRONYM\">ASCII</acronym> character. The NULL (0)          character is not allowed because text data types cannot          store such bytes.</td>", "`chr(65)`", "char"));
        dz.add(new SqlFunctions("decode", "duckdb,postgresql", "`decode(`*`blob`*`)`", "Decode binary data from textual representation in          <tt class=\"PARAMETER\">string</tt>. Options for <tt class=          \"PARAMETER\">format</tt> are same as in <code class=          \"FUNCTION\">encode</code>.</td>", "decode('MTIzAAE=',          'base64')", "blob"));
        dz.add(new SqlFunctions("encode", "duckdb,postgresql", "`encode(`*`string`*`)`", "Encode binary data into a textual representation.          Supported formats are: <tt class=\"LITERAL\">base64</tt>,          <tt class=\"LITERAL\">hex</tt>, <tt class=          \"LITERAL\">escape</tt>. <tt class=\"LITERAL\">escape</tt>          converts zero bytes and high-bit-set bytes to octal          sequences (<tt class=\"LITERAL\">\\</tt><tt class=          \"REPLACEABLE c3\">nnn</tt>) and doubles backslashes.</td>", "encode(E'123\\\\000\\\\001',          'base64')", "blob"));
        dz.add(new SqlFunctions("left", "duckdb,postgresql", "`left(`*`string`*`, `*`count`*`)`", "Return first <tt class=\"REPLACEABLE c3\">n</tt>          characters in the string. When <tt class=          \"REPLACEABLE c3\">n</tt> is negative, return all but last          |<tt class=\"REPLACEABLE c3\">n</tt>| characters.</td>", "`left('Hello', 2)`", "char"));
        dz.add(new SqlFunctions("lpad", "duckdb,postgresql", "`lpad(`*`string`*`, `*`count`*`, `*`character`*`)`", "Fill up the <tt class=\"PARAMETER\">string</tt> to          length <tt class=\"PARAMETER\">length</tt> by prepending          the characters <tt class=\"PARAMETER\">fill</tt> (a space          by default). If the <tt class=\"PARAMETER\">string</tt> is          already longer than <tt class=\"PARAMETER\">length</tt>          then it is truncated (on the right).</td>", "`lpad('hello', 10, '>')`", "char"));
        dz.add(new SqlFunctions("md5", "duckdb,postgresql", "`md5(`*`string`*`)`", "Calculates the MD5 hash of <tt class=          \"PARAMETER\">string</tt>, returning the result in          hexadecimal</td>", "`md5('123')`", "char"));
        dz.add(new SqlFunctions("position", "duckdb,postgresql", "`position(`*`search_string`*` in `*`string`*`)`", "Return location of first occurrence of `search_string` in `string`, counting from 1. Returns 0 if no match found.", "position('om' in          'Thomas')", "char"));
        dz.add(new SqlFunctions("power", "duckdb,postgresql", "`power(x, y)`", "<tt class=\"PARAMETER\">a</tt> raised to the power of          <tt class=\"PARAMETER\">b</tt></td>", "power(9.0, 3.0)", "numeric"));
        dz.add(new SqlFunctions("regexp_matches", "duckdb,postgresql", "`regexp_matches('hello world', '^hello', 's')`", "Return all captured substrings resulting from          matching a POSIX regular expression against the          <tt class=\"PARAMETER\">string</tt>. See <a href=          \"functions-matching.html#FUNCTIONS-POSIX-REGEXP\">Section          9.7.3</a> for more information.</td>", "regexp_matches('foobarbequebaz',          '(bar)(beque)')", "char"));
        dz.add(new SqlFunctions("regexp_replace", "duckdb,postgresql", "`regexp_replace(`*`string`*`, `*`pattern`*`, `*`replacement`*`)`;", "Replace substring(s) matching a POSIX regular          expression. See <a href=          \"functions-matching.html#FUNCTIONS-POSIX-REGEXP\">Section          9.7.3</a> for more information.</td>", "regexp_replace('Thomas',          '.[mN]a.', 'M')", "char"));
        dz.add(new SqlFunctions("regexp_split_to_array", "duckdb,postgresql", "`regexp_split_to_array(`*`string`*`, `*`regex`*`)`", "Split <tt class=\"PARAMETER\">string</tt> using a POSIX          regular expression as the delimiter. See <a href=          \"functions-matching.html#FUNCTIONS-POSIX-REGEXP\">Section          9.7.3</a> for more information.</td>", "regexp_split_to_array('hello          world', E'\\\\s+')", "char"));
        dz.add(new SqlFunctions("repeat", "duckdb,postgresql", "`repeat(`*`string`*`, `*`count`*`)`", "Repeat <tt class=\"PARAMETER\">string</tt> the          specified <tt class=\"PARAMETER\">number</tt> of times</td>", "`repeat('A', 5)`", "char"));
        dz.add(new SqlFunctions("reverse", "duckdb,postgresql", "`reverse(`*`string`*`)`", "Return reversed string.</td>", "`reverse('hello')`", "char"));
        dz.add(new SqlFunctions("right", "duckdb,postgresql", "`right(`*`string`*`, `*`count`*`)`", "Return last <tt class=\"REPLACEABLE c3\">n</tt>          characters in the string. When <tt class=          \"REPLACEABLE c3\">n</tt> is negative, return all but first          |<tt class=\"REPLACEABLE c3\">n</tt>| characters.</td>", "`right('Hello', 3)`", "char"));
        dz.add(new SqlFunctions("rpad", "duckdb,postgresql", "`rpad(`*`string`*`, `*`count`*`, `*`character`*`)`", "Fill up the <tt class=\"PARAMETER\">string</tt> to          length <tt class=\"PARAMETER\">length</tt> by appending the          characters <tt class=\"PARAMETER\">fill</tt> (a space by          default). If the <tt class=\"PARAMETER\">string</tt> is          already longer than <tt class=\"PARAMETER\">length</tt>          then it is truncated.</td>", "`rpad('hello', 10, '<')`", "char"));
        dz.add(new SqlFunctions("setseed", "duckdb,postgresql", "`setseed(x)`", "set seed for subsequent <tt class=          \"LITERAL\">random()</tt> calls (value between -1.0 and          1.0, inclusive)</td>", "setseed(0.54823)", "numeric"));
        dz.add(new SqlFunctions("split_part", "duckdb,postgresql", "`split_part(`*`string`*`, `*`separator`*`, `*`index`*`)`", "Split the *string* along the *separator* and return the data at the (1-based) *index* of the list. If the *index* is outside the bounds of the list, return an empty string (to match PostgreSQL's behavior).", "split_part('abc~@~def~@~ghi',          '~@~', 2)", "char"));
        dz.add(new SqlFunctions("strpos", "duckdb,postgresql", "`strpos(`*`string`*`, `*`search_string`*`)`", "Location of specified substring (same as <tt class=          \"LITERAL\">position(<tt class=\"PARAMETER\">substring</tt>          in <tt class=\"PARAMETER\">string</tt>)</tt>, but note the          reversed argument order)</td>", "`strpos('test test', 'es')`", "char"));
        dz.add(new SqlFunctions("substring", "duckdb,postgresql", "`substring(`*`string`*`, `*`start`*`, `*`length`*`)`", "Extract substring matching <acronym class=          \"ACRONYM\">SQL</acronym> regular expression. See <a href=          \"functions-matching.html\">Section 9.7</a> for more          information on pattern matching.</td>", "substring('Thomas' from          '%#\"o_a#\"_' for '#')", "char"));
        dz.add(new SqlFunctions("acos", "duckdb,sqlite", "`acos(x)`", "<p>  Return the arccosine of X.  The result is in radians.", "`acos(0.5)`", "numeric"));
        dz.add(new SqlFunctions("asin", "duckdb,sqlite", "`asin(x)`", "<p>  Return the arcsine of X.  The result is in radians.", "`asin(0.5)`", "numeric"));
        dz.add(new SqlFunctions("atan", "duckdb,sqlite", "`atan(x)`", "<p>  Return the arctangent of X.  The result is in radians.", "`atan(0.5)`", "numeric"));
        dz.add(new SqlFunctions("atan2", "duckdb,sqlite", "atan2( Y , X )", "<p>  Return the arctangent of Y/X.  The result is in radians.  The  result is placed into correct quadrant depending on the signs  of X and Y.", "`atan2(0.5, 0.5)`", "numeric"));
        dz.add(new SqlFunctions("coalesce", "duckdb,sqlite", "`coalesce(`*`expr`*`, `*`...`*`)`", "Return the first expression that evaluates to a non-`NULL` value. Accepts 1 or more parameters. Each expression can be a column, literal value, function result, or many others.", "`coalesce(NULL, NULL, 'default_string')`", "utility"));
        dz.add(new SqlFunctions("cos", "duckdb,sqlite", "`cos(x)`", "<p>  Return the cosine of X.  X is in radians.", "`cos(90)`", "numeric"));
        dz.add(new SqlFunctions("exp", "duckdb,sqlite", "`exp(x)`", "<p>  Compute <i>e</i> (Euler's number, approximately 2.71828182845905) raised  to the power X.", "`exp(0.693)`", "numeric"));
        dz.add(new SqlFunctions("glob", "duckdb,sqlite", "`glob(`*`search_path`*`)`", "<p>  The glob(X,Y) function is equivalent to the  expression \"<b>Y GLOB X</b>\".  Note that the X and Y arguments are reversed in the glob() function  relative to the infix <a href=\"lang_expr.html#glob\">GLOB</a> operator.  Y is the string and X is the  pattern.  So, for example, the following expressions are equivalent:  <blockquote><pre>     name GLOB '*helium*'     glob('*helium*',name)  </pre></blockquote>  <p>If the <a href=\"c3ref/create_function.html\">sqlite3_create_function()</a> interface is used to  override the glob(X,Y) function with an alternative implementation then  the <a href=\"lang_expr.html#glob\">GLOB</a> operator will invoke the alternative implementation.", "`glob('*')`", "utility"));
        dz.add(new SqlFunctions("ifnull", "duckdb,sqlite", "`ifnull(`*`expr`*`, `*`other`*`)`", "<p>  The ifnull() function returns a copy of its first non-NULL argument, or  NULL if both arguments are NULL.  Ifnull() must have exactly 2 arguments.  The ifnull() function is equivalent to <a href=\"lang_corefunc.html#coalesce\">coalesce()</a> with two arguments.", "`ifnull(NULL, 'default_string')`", "utility"));
        dz.add(new SqlFunctions("instr", "duckdb,sqlite", "`instr(`*`string`*`, `*`search_string`*`)`", "<p>  The instr(X,Y) function finds the first occurrence of string Y within   string X and returns the number of prior characters plus 1, or 0 if  Y is nowhere found within X.  Or, if X and Y are both BLOBs, then instr(X,Y) returns one  more than the number bytes prior to the first occurrence of Y, or 0 if  Y does not occur anywhere within X.  If both arguments X and Y to instr(X,Y) are non-NULL and are not BLOBs  then both are interpreted as strings.  If either X or Y are NULL in instr(X,Y) then the result is NULL.", "`instr('test test', 'es')`", "char"));
        dz.add(new SqlFunctions("ln", "duckdb,sqlite", "`ln(x)`", "<p>  Return the natural logarithm of X.", "`ln(2)`", "numeric"));
        dz.add(new SqlFunctions("log2", "duckdb,sqlite", "`log2(x)`", "<p>  Return the logarithm base-2 for the number X.", "`log2(8)`", "numeric"));
        dz.add(new SqlFunctions("nullif", "duckdb,sqlite", "`nullif(`*`a`*`, `*`b`*`)`", "<p>  The nullif(X,Y) function returns its first argument if the arguments are  different and NULL if the arguments are the same.  The nullif(X,Y) function  searches its arguments from left to right for an argument that defines a  collating function and uses that collating function for all string  comparisons.  If neither argument to nullif() defines a collating function  then the BINARY collating function is used.", "`nullif(1+1, 2)`", "utility"));
        dz.add(new SqlFunctions("pow", "duckdb,sqlite", "pow( X , Y ) power( X , Y )", "<p>  Compute X raised to the power Y.", "`pow(2, 3)`", "numeric"));
        dz.add(new SqlFunctions("printf", "duckdb,sqlite", "`printf(`*`format`*`, `*`parameters`*`...)`", "<p>  The printf() SQL function is an alias for the <a href=\"lang_corefunc.html#format\">format() SQL function</a>.  The format() SQL function was originally named printf(). But the name was  later changed to format() for compatibility with other database engines.  The printf() name is retained as an alias so as not to break legacy code.", "`printf('Benchmark \"%s\" took %d seconds', 'CSV', 42)`", "char"));
        dz.add(new SqlFunctions("sin", "duckdb,sqlite", "`sin(x)`", "<p>  Return the sine of X.  X is in radians.", "`sin(90)`", "numeric"));
        dz.add(new SqlFunctions("sqrt", "duckdb,sqlite", "`sqrt(x)`", "<p>  Return the square root of X.  NULL is returned if X is negative.", "`sqrt(9)`", "numeric"));
        dz.add(new SqlFunctions("tan", "duckdb,sqlite", "`tan(x)`", "<p>  Return the tangent of X.  X is in radians.", "`tan(90)`", "numeric"));
        dz.add(new SqlFunctions("typeof", "duckdb,sqlite", "`typeof(`*`expression`*`)`", "<p>  The typeof(X) function returns a string that indicates the <a href=\"datatype3.html\">datatype</a> of  the expression X: \"null\", \"integer\", \"real\", \"text\", or \"blob\".", "`typeof('abc')`", "utility"));
        dz.add(new SqlFunctions("unicode", "duckdb,sqlite", "`unicode(`*`string`*`)`", "<p>  The unicode(X) function returns the numeric unicode code point corresponding to  the first character of the string X.  If the argument to unicode(X) is not a string  then the result is undefined.", "`unicode('\u00c3\u00bc')`", "char"));
        dz.add(new SqlFunctions("ABS", "h2,mysql", "", "<p>Returns the absolute value of a specified value. The returned value is of the same data type as the parameter.", "", "functions"));
        dz.add(new SqlFunctions("ACOS", "h2,mysql", "", "<p>Calculate the arc cosine. See also Java <code class=\"notranslate\">Math.acos</code>. This method returns a double.", "", "functions"));
        dz.add(new SqlFunctions("ANY_VALUE", "h2,mysql", "", "<p>Returns any non-<code class=\"notranslate\">NULL</code> value from aggregated values. If no rows are selected, the result is <code class=\"notranslate\">NULL</code>. This function uses the same pseudo random generator as <a href=\"functions.html#rand\"><code class=\"notranslate\">RAND</code>()</a> function.", "", "functions-aggregate"));
        dz.add(new SqlFunctions("ASCII", "h2,mysql", "", "<p>Returns the <code class=\"notranslate\">ASCII</code> value of the first character in the string. This method returns an int.", "", "functions"));
        dz.add(new SqlFunctions("ASIN", "h2,mysql", "", "<p>Calculate the arc sine. See also Java <code class=\"notranslate\">Math.asin</code>. This method returns a double.", "", "functions"));
        dz.add(new SqlFunctions("ATAN", "h2,mysql", "", "<p>Calculate the arc tangent. See also Java <code class=\"notranslate\">Math.atan</code>. This method returns a double.", "", "functions"));
        dz.add(new SqlFunctions("AVG", "h2,mysql", "", "<p>The average (mean) value. If no rows are selected, the result is <code class=\"notranslate\">NULL</code>. Aggregates are only allowed in select statements.", "", "functions-aggregate"));
        dz.add(new SqlFunctions("BINARY", "h2,mysql", "", "<p>Represents a binary string (byte array) of fixed predefined length.", "", "datatypes"));
        dz.add(new SqlFunctions("BIT_LENGTH", "h2,mysql", "", "<p>Returns the number of bits in a binary string. This method returns a long.", "", "functions"));
        dz.add(new SqlFunctions("CEIL", "h2,mysql", "", "<p>Returns the smallest integer value that is greater than or equal to the argument. This method returns value of the same type as argument, but with scale set to 0 and adjusted precision, if applicable.", "", "functions"));
        dz.add(new SqlFunctions("CHAR", "h2,mysql", "", "<p>Returns the character that represents the <code class=\"notranslate\">ASCII</code> value. This method returns a string.", "", "functions"));
        dz.add(new SqlFunctions("CHAR_LENGTH", "h2,mysql", "", "<p>Returns the number of characters in a character string. This method returns a long.", "", "functions"));
        dz.add(new SqlFunctions("COALESCE", "h2,mysql", "", "<p>Returns the first value that is not null.", "", "functions"));
        dz.add(new SqlFunctions("COMPRESS", "h2,mysql", "", "<p>Compresses the data using the specified compression algorithm. Supported algorithms are: <code class=\"notranslate\">LZF</code> (faster but lower compression; default), and <code class=\"notranslate\">DEFLATE</code> (higher compression). Compression does not always reduce size. Very small objects and objects with little redundancy may get larger. This method returns bytes.", "", "functions"));
        dz.add(new SqlFunctions("CONCAT", "h2,mysql", "", "<p>Combines strings. Unlike with the operator <code class=\"notranslate\">||, NULL</code> parameters are ignored, and do not cause the result to become <code class=\"notranslate\">NULL</code>. If all parameters are <code class=\"notranslate\">NULL</code> the result is an empty string. This method returns a string.", "", "functions"));
        dz.add(new SqlFunctions("CONCAT_WS", "h2,mysql", "", "<p>Combines strings with separator. If separator is <code class=\"notranslate\">NULL</code> it is treated like an empty string. Other <code class=\"notranslate\">NULL</code> parameters are ignored. Remaining non-<code class=\"notranslate\">NULL</code> parameters, if any, are concatenated with the specified separator. If there are no remaining parameters the result is an empty string. This method returns a string.", "", "functions"));
        dz.add(new SqlFunctions("CONVERT", "h2,mysql", "", "<p>Converts a value to another data type.", "", "functions"));
        dz.add(new SqlFunctions("COS", "h2,mysql", "", "<p>Calculate the trigonometric cosine. See also Java <code class=\"notranslate\">Math.cos</code>. This method returns a double.", "", "functions"));
        dz.add(new SqlFunctions("COT", "h2,mysql", "", "<p>Calculate the trigonometric cotangent (<code class=\"notranslate\">1/TAN(ANGLE)</code>). See also Java <code class=\"notranslate\">Math.*</code> functions. This method returns a double.", "", "functions"));
        dz.add(new SqlFunctions("COUNT", "h2,mysql", "", "<p>The count of all row, or of the non-null values. This method returns a long. If no rows are selected, the result is 0. Aggregates are only allowed in select statements.", "", "functions-aggregate"));
        dz.add(new SqlFunctions("CUME_DIST", "h2,mysql", "", "<p>Returns the relative rank of the current row. The relative rank is calculated as <code class=\"notranslate\">NP</code> / <code class=\"notranslate\">NR</code> where <code class=\"notranslate\">NP</code> is a number of rows that precede the current row or have the same values in <code class=\"notranslate\">ORDER BY</code> columns and <code class=\"notranslate\">NR</code> is a number of rows in window partition with this row. Note that result is always 1 if window order clause is not specified. Window frame clause is not allowed for this function.", "", "functions-window"));
        dz.add(new SqlFunctions("CURRENT_DATE", "h2,mysql", "", "<p>Returns the current date.", "", "functions"));
        dz.add(new SqlFunctions("CURRENT_ROLE", "h2,mysql", "", "<p>Returns the name of the <code class=\"notranslate\">PUBLIC</code> role.", "", "functions"));
        dz.add(new SqlFunctions("CURRENT_TIME", "h2,mysql", "", "<p>Returns the current time with time zone. If fractional seconds precision is specified it should be from 0 to 9, 0 is default. The specified value can be used only to limit precision of a result. The actual maximum available precision depends on operating system and <code class=\"notranslate\">JVM</code> and can be 3 (milliseconds) or higher. Higher precision is not available before Java 9.", "", "functions"));
        dz.add(new SqlFunctions("CURRENT_TIMESTAMP", "h2,mysql", "", "<p>Returns the current timestamp with time zone. Time zone offset is set to a current time zone offset. If fractional seconds precision is specified it should be from 0 to 9, 6 is default. The specified value can be used only to limit precision of a result. The actual maximum available precision depends on operating system and <code class=\"notranslate\">JVM</code> and can be 3 (milliseconds) or higher. Higher precision is not available before Java 9.", "", "functions"));
        dz.add(new SqlFunctions("CURRENT_USER", "h2,mysql", "", "<p>Returns the name of the current user of this session.", "", "functions"));
        dz.add(new SqlFunctions("DATE", "h2,mysql", "", "<p>The date data type. The proleptic Gregorian calendar is used.", "", "datatypes"));
        dz.add(new SqlFunctions("DATEDIFF", "h2,mysql", "", "<p>Returns the number of crossed unit boundaries between two date/time values. This method returns a long. The datetimeField indicates the unit. Only <code class=\"notranslate\">TIMEZONE_HOUR, TIMEZONE_MINUTE</code>, and <code class=\"notranslate\">TIMEZONE_SECOND</code> fields use the time zone offset component. With all other fields if date/time values have time zone offset component it is ignored.", "", "functions"));
        dz.add(new SqlFunctions("DAYNAME", "h2,mysql", "", "<p>Returns the name of the day (in English).", "", "functions"));
        dz.add(new SqlFunctions("DEGREES", "h2,mysql", "", "<p>See also Java <code class=\"notranslate\">Math.toDegrees</code>. This method returns a double.", "", "functions"));
        dz.add(new SqlFunctions("DENSE_RANK", "h2,mysql", "", "<p>Returns the dense rank of the current row. The rank of a row is the number of groups of rows with the same values in <code class=\"notranslate\">ORDER BY</code> columns that precede group with this row plus 1. If two or more rows have the same values in <code class=\"notranslate\">ORDER BY</code> columns, these rows get the same rank. Gaps in ranks are not possible. This function requires window order clause. Window frame clause is not allowed for this function.", "", "functions-window"));
        dz.add(new SqlFunctions("EXP", "h2,mysql", "", "<p>See also Java <code class=\"notranslate\">Math.exp</code>. This method returns a double.", "", "functions"));
        dz.add(new SqlFunctions("EXTRACT", "h2,mysql", "", "<p>Returns a value of the specific time unit from a date/time value. This method returns a numeric value with <code class=\"notranslate\">EPOCH</code> field and an int for all other fields.", "", "functions"));
        dz.add(new SqlFunctions("FIRST_VALUE", "h2,mysql", "", "<p>Returns the first value in a window. If <code class=\"notranslate\">IGNORE NULLS</code> is specified null values are skipped and the function returns first non-null value, if any.", "", "functions-window"));
        dz.add(new SqlFunctions("FLOOR", "h2,mysql", "", "<p>Returns the largest integer value that is less than or equal to the argument. This method returns value of the same type as argument, but with scale set to 0 and adjusted precision, if applicable.", "", "functions"));
        dz.add(new SqlFunctions("GREATEST", "h2,mysql", "", "<p>Returns the largest value or <code class=\"notranslate\">NULL</code> if any value is <code class=\"notranslate\">NULL</code> or the largest value cannot be determined. For example, <code class=\"notranslate\">ROW</code> (<code class=\"notranslate\">NULL</code>, 1) is neither equal to nor smaller than nor larger than <code class=\"notranslate\">ROW</code> (1, 1). If <code class=\"notranslate\">IGNORE NULLS</code> is specified, <code class=\"notranslate\">NULL</code> values are ignored.", "", "functions"));
        dz.add(new SqlFunctions("HOUR", "h2,mysql", "", "<p>Returns the hour (0-23) from a date/time value.", "", "functions"));
        dz.add(new SqlFunctions("INSERT", "h2,mysql", "", "Insert substring at specified position up to specified number of      characters", "", "commands"));
        dz.add(new SqlFunctions("INTERVAL", "h2,mysql", "", "<p>Interval data type. There are two classes of intervals. Year-month intervals can store years and months. Day-time intervals can store days, hours, minutes, and seconds. Year-month intervals are comparable only with another year-month intervals. Day-time intervals are comparable only with another day-time intervals.", "", "datatypes"));
        dz.add(new SqlFunctions("JSON_ARRAY", "h2,mysql", "", "<p>Returns a <code class=\"notranslate\">JSON</code> array constructed from the specified values or from the specified single-column subquery. If <code class=\"notranslate\">NULL ON NULL</code> is specified <code class=\"notranslate\">NULL</code> values are included in the array.", "", "functions"));
        dz.add(new SqlFunctions("JSON_ARRAYAGG", "h2,mysql", "", "<p>Aggregates the values into a <code class=\"notranslate\">JSON</code> array. If <code class=\"notranslate\">NULL ON NULL</code> is specified <code class=\"notranslate\">NULL</code> values are included in the array. If no values are selected, the result is <code class=\"notranslate\">SQL NULL</code> value.", "", "functions-aggregate"));
        dz.add(new SqlFunctions("JSON_OBJECT", "h2,mysql", "", "<p>Returns a <code class=\"notranslate\">JSON</code> object constructed from the specified properties. If <code class=\"notranslate\">ABSENT ON NULL</code> is specified properties with <code class=\"notranslate\">NULL</code> value are not included in the object. If <code class=\"notranslate\">WITH UNIQUE KEYS</code> is specified the constructed object is checked for uniqueness of keys, nested objects, if any, are checked too.", "", "functions"));
        dz.add(new SqlFunctions("JSON_OBJECTAGG", "h2,mysql", "", "<p>Aggregates the keys with values into a <code class=\"notranslate\">JSON</code> object. If <code class=\"notranslate\">ABSENT ON NULL</code> is specified properties with <code class=\"notranslate\">NULL</code> value are not included in the object. If <code class=\"notranslate\">WITH UNIQUE KEYS</code> is specified the constructed object is checked for uniqueness of keys, nested objects, if any, are checked too. If no values are selected, the result is <code class=\"notranslate\">SQL NULL</code> value.", "", "functions-aggregate"));
        dz.add(new SqlFunctions("LAG", "h2,mysql", "", "<p>Returns the value in a previous row with specified offset relative to the current row. Offset must be non-negative. If <code class=\"notranslate\">IGNORE NULLS</code> is specified rows with null values in selected expression are skipped. If number of considered rows is less than specified relative number this function returns <code class=\"notranslate\">NULL</code> or the specified default value, if any. If offset is 0 the value from the current row is returned unconditionally. This function requires window order clause. Window frame clause is not allowed for this function.", "", "functions-window"));
        dz.add(new SqlFunctions("LAST_DAY", "h2,mysql", "", "<p>Returns the last day of the month that contains the specified date-time value. This function returns a date.", "", "functions"));
        dz.add(new SqlFunctions("LAST_VALUE", "h2,mysql", "", "<p>Returns the last value in a window. If <code class=\"notranslate\">IGNORE NULLS</code> is specified null values are skipped and the function returns last non-null value before them, if any; if there is no non-null value it returns <code class=\"notranslate\">NULL</code>. Note that the last value is actually a value in the current group of rows if window order clause is specified and window frame clause is not specified.", "", "functions-window"));
        dz.add(new SqlFunctions("LEAD", "h2,mysql", "", "<p>Returns the value in a next row with specified offset relative to the current row. Offset must be non-negative. If <code class=\"notranslate\">IGNORE NULLS</code> is specified rows with null values in selected expression are skipped. If number of considered rows is less than specified relative number this function returns <code class=\"notranslate\">NULL</code> or the specified default value, if any. If offset is 0 the value from the current row is returned unconditionally. This function requires window order clause. Window frame clause is not allowed for this function.", "", "functions-window"));
        dz.add(new SqlFunctions("LEAST", "h2,mysql", "", "<p>Returns the smallest value or <code class=\"notranslate\">NULL</code> if any value is <code class=\"notranslate\">NULL</code> or the smallest value cannot be determined. For example, <code class=\"notranslate\">ROW</code> (<code class=\"notranslate\">NULL</code>, 1) is neither equal to nor smaller than nor larger than <code class=\"notranslate\">ROW</code> (1, 1). If <code class=\"notranslate\">IGNORE NULLS</code> is specified, <code class=\"notranslate\">NULL</code> values are ignored.", "", "functions"));
        dz.add(new SqlFunctions("LEFT", "h2,mysql", "", "Return the leftmost number of characters as specified", "", "functions"));
        dz.add(new SqlFunctions("LN", "h2,mysql", "", "<p>Calculates the natural (base e) logarithm as a double value. Argument must be a positive numeric value.", "", "functions"));
        dz.add(new SqlFunctions("LOCALTIME", "h2,mysql", "", "<p>Returns the current time without time zone. If fractional seconds precision is specified it should be from 0 to 9, 0 is default. The specified value can be used only to limit precision of a result. The actual maximum available precision depends on operating system and <code class=\"notranslate\">JVM</code> and can be 3 (milliseconds) or higher. Higher precision is not available before Java 9.", "", "functions"));
        dz.add(new SqlFunctions("LOCALTIMESTAMP", "h2,mysql", "", "<p>Returns the current timestamp without time zone. If fractional seconds precision is specified it should be from 0 to 9, 6 is default. The specified value can be used only to limit precision of a result. The actual maximum available precision depends on operating system and <code class=\"notranslate\">JVM</code> and can be 3 (milliseconds) or higher. Higher precision is not available before Java 9.", "", "functions"));
        dz.add(new SqlFunctions("LOCATE", "h2,mysql", "", "<p>Returns the location of a search string in a string. If a start position is used, the characters before it are ignored. If position is negative, the rightmost location is returned. 0 is returned if the search string is not found. Please note this function is case sensitive, even if the parameters are not.", "", "functions"));
        dz.add(new SqlFunctions("LOG", "h2,mysql", "", "<p>Calculates the logarithm with specified base as a double value. Argument and base must be positive numeric values. Base cannot be equal to 1.", "", "functions"));
        dz.add(new SqlFunctions("LOG10", "h2,mysql", "", "<p>Calculates the base 10 logarithm as a double value. Argument must be a positive numeric value.", "", "functions"));
        dz.add(new SqlFunctions("LOWER", "h2,mysql", "", "<p>Converts a string to lowercase.", "", "functions"));
        dz.add(new SqlFunctions("LPAD", "h2,mysql", "", "<p>Left pad the string to the specified length. If the length is shorter than the string, it will be truncated at the end. If the padding string is not set, spaces will be used.", "", "functions"));
        dz.add(new SqlFunctions("LTRIM", "h2,mysql", "", "<p>Removes all leading spaces or other specified characters from a string, multiple characters can be specified.", "", "functions"));
        dz.add(new SqlFunctions("MAX", "h2,mysql", "", "<p>The highest value. If no rows are selected, the result is <code class=\"notranslate\">NULL</code>. Aggregates are only allowed in select statements. The returned value is of the same data type as the parameter.", "", "functions-aggregate"));
        dz.add(new SqlFunctions("MIN", "h2,mysql", "", "<p>The lowest value. If no rows are selected, the result is <code class=\"notranslate\">NULL</code>. Aggregates are only allowed in select statements. The returned value is of the same data type as the parameter.", "", "functions-aggregate"));
        dz.add(new SqlFunctions("MINUTE", "h2,mysql", "", "<p>Returns the minute (0-59) from a date/time value.", "", "functions"));
        dz.add(new SqlFunctions("MOD", "h2,mysql", "", "<p>The modulus expression.", "", "functions"));
        dz.add(new SqlFunctions("MONTH", "h2,mysql", "", "<p>Returns the month (1-12) from a date/time value.", "", "functions"));
        dz.add(new SqlFunctions("MONTHNAME", "h2,mysql", "", "<p>Returns the name of the month (in English).", "", "functions"));
        dz.add(new SqlFunctions("NTH_VALUE", "h2,mysql", "", "<p>Returns the value in a row with a specified relative number in a window. Relative row number must be positive. If <code class=\"notranslate\">FROM LAST</code> is specified rows a counted backwards from the last row. If <code class=\"notranslate\">IGNORE NULLS</code> is specified rows with null values in selected expression are skipped. If number of considered rows is less than specified relative number this function returns <code class=\"notranslate\">NULL</code>. Note that the last row is actually a last row in the current group of rows if window order clause is specified and window frame clause is not specified.", "", "functions-window"));
        dz.add(new SqlFunctions("NTILE", "h2,mysql", "", "<p>Distributes the rows into a specified number of groups. Number of groups should be a positive long value. <code class=\"notranslate\">NTILE</code> returns the 1-based number of the group to which the current row belongs. First groups will have more rows if number of rows is not divisible by number of groups. For example, if 5 rows are distributed into 2 groups this function returns 1 for the first 3 row and 2 for the last 2 rows. This function requires window order clause. Window frame clause is not allowed for this function.", "", "functions-window"));
        dz.add(new SqlFunctions("NULLIF", "h2,mysql", "", "<p>Returns <code class=\"notranslate\">NULL</code> if &#39;a&#39; is equal to &#39;b&#39;, otherwise &#39;a&#39;.", "", "functions"));
        dz.add(new SqlFunctions("OCTET_LENGTH", "h2,mysql", "", "<p>Returns the number of bytes in a binary string. This method returns a long.", "", "functions"));
        dz.add(new SqlFunctions("PERCENT_RANK", "h2,mysql", "", "<p>Returns the relative rank of the current row. The relative rank is calculated as (<code class=\"notranslate\">RANK</code> - 1) / (<code class=\"notranslate\">NR</code> - 1), where <code class=\"notranslate\">RANK</code> is a rank of the row and <code class=\"notranslate\">NR</code> is a number of rows in window partition with this row. Note that result is always 0 if window order clause is not specified. Window frame clause is not allowed for this function.", "", "functions-window"));
        dz.add(new SqlFunctions("PI", "h2,mysql", "", "<p>See also Java <code class=\"notranslate\">Math.PI</code>. This method returns a double.", "", "functions"));
        dz.add(new SqlFunctions("POWER", "h2,mysql", "", "<p>See also Java <code class=\"notranslate\">Math.pow</code>. This method returns a double.", "", "functions"));
        dz.add(new SqlFunctions("QUARTER", "h2,mysql", "", "<p>Returns the quarter (1-4) from a date/time value.", "", "functions"));
        dz.add(new SqlFunctions("RADIANS", "h2,mysql", "", "<p>See also Java <code class=\"notranslate\">Math.toRadians</code>. This method returns a double.", "", "functions"));
        dz.add(new SqlFunctions("RAND", "h2,mysql", "", "<p>Calling the function without parameter returns the next a pseudo random number. Calling it with an parameter seeds the session&#39;s random number generator. This method returns a double between 0 (including) and 1 (excluding).", "", "functions"));
        dz.add(new SqlFunctions("RANK", "h2,mysql", "", "<p>Returns the rank of the current row. The rank of a row is the number of rows that precede this row plus 1. If two or more rows have the same values in <code class=\"notranslate\">ORDER BY</code> columns, these rows get the same rank from the first row with the same values. It means that gaps in ranks are possible. This function requires window order clause. Window frame clause is not allowed for this function.", "", "functions-window"));
        dz.add(new SqlFunctions("REGEXP_LIKE", "h2,mysql", "", "<p>Matches string to a regular expression. For details, see the Java <code class=\"notranslate\">Matcher.find()</code> method. If any parameter is null (except optional flagsString parameter), the result is null.", "", "functions"));
        dz.add(new SqlFunctions("REGEXP_REPLACE", "h2,mysql", "", "<p>Replaces each substring that matches a regular expression. For details, see the Java <code class=\"notranslate\">String.replaceAll()</code> method. If any parameter is null (except optional flagsString parameter), the result is null.", "", "functions"));
        dz.add(new SqlFunctions("REGEXP_SUBSTR", "h2,mysql", "", "<p>Matches string to a regular expression and returns the matched substring. For details, see the java.util.regex.Pattern and related functionality.", "", "functions"));
        dz.add(new SqlFunctions("REPEAT", "h2,mysql", "", "<p>Returns a string repeated some number of times.", "", "functions"));
        dz.add(new SqlFunctions("REPLACE", "h2,mysql", "", "<p>Replaces all occurrences of a search string in a text with another string. If no replacement is specified, the search string is removed from the original string. If any parameter is null, the result is null.", "", "functions"));
        dz.add(new SqlFunctions("RIGHT", "h2,mysql", "", "Return the specified rightmost number of characters", "", "functions"));
        dz.add(new SqlFunctions("ROUND", "h2,mysql", "", "<p>Rounds to a number of fractional digits. This method returns value of the same type as argument, but with adjusted precision and scale, if applicable.", "", "functions"));
        dz.add(new SqlFunctions("ROW_NUMBER", "h2,mysql", "", "<p>Returns the number of the current row starting with 1. Window frame clause is not allowed for this function.", "", "functions-window"));
        dz.add(new SqlFunctions("RPAD", "h2,mysql", "", "<p>Right pad the string to the specified length. If the length is shorter than the string, it will be truncated. If the padding string is not set, spaces will be used.", "", "functions"));
        dz.add(new SqlFunctions("RTRIM", "h2,mysql", "", "<p>Removes all trailing spaces or other specified characters from a string, multiple characters can be specified.", "", "functions"));
        dz.add(new SqlFunctions("SECOND", "h2,mysql", "", "<p>Returns the second (0-59) from a date/time value.", "", "functions"));
        dz.add(new SqlFunctions("SIGN", "h2,mysql", "", "<p>Returns -1 if the value is smaller than 0, 0 if zero or NaN, and otherwise 1.", "", "functions"));
        dz.add(new SqlFunctions("SIN", "h2,mysql", "", "<p>Calculate the trigonometric sine. See also Java <code class=\"notranslate\">Math.sin</code>. This method returns a double.", "", "functions"));
        dz.add(new SqlFunctions("SOUNDEX", "h2,mysql", "", "<p>Returns a four character upper-case code representing the sound of a string as pronounced in English. This method returns a string, or null if parameter is null. See <a href=\"https://en.wikipedia.org/wiki/Soundex\">https://en.wikipedia.org/wiki/Soundex</a> for more information.", "", "functions"));
        dz.add(new SqlFunctions("SPACE", "h2,mysql", "", "<p>Returns a string consisting of a number of spaces.", "", "functions"));
        dz.add(new SqlFunctions("SQRT", "h2,mysql", "", "<p>See also Java <code class=\"notranslate\">Math.sqrt</code>. This method returns a double.", "", "functions"));
        dz.add(new SqlFunctions("STDDEV_POP", "h2,mysql", "", "<p>The population standard deviation. This method returns a double. If no rows are selected, the result is <code class=\"notranslate\">NULL</code>. Aggregates are only allowed in select statements.", "", "functions-aggregate"));
        dz.add(new SqlFunctions("STDDEV_SAMP", "h2,mysql", "", "<p>The sample standard deviation. This method returns a double. If less than two rows are selected, the result is <code class=\"notranslate\">NULL</code>. Aggregates are only allowed in select statements.", "", "functions-aggregate"));
        dz.add(new SqlFunctions("SUBSTRING", "h2,mysql", "", "<p>Returns a substring of a string starting at a position. If the start index is negative, then the start index is relative to the end of the string. The length is optional.", "", "functions"));
        dz.add(new SqlFunctions("SUM", "h2,mysql", "", "<p>The sum of all values. If no rows are selected, the result is <code class=\"notranslate\">NULL</code>. Aggregates are only allowed in select statements.", "", "functions-aggregate"));
        dz.add(new SqlFunctions("TAN", "h2,mysql", "", "<p>Calculate the trigonometric tangent. See also Java <code class=\"notranslate\">Math.tan</code>. This method returns a double.", "", "functions"));
        dz.add(new SqlFunctions("TIME", "h2,mysql", "", "<p>The time data type. The format is hh:mm:ss[.nnnnnnnnn]. If fractional seconds precision is specified it should be from 0 to 9, 0 is default.", "", "datatypes"));
        dz.add(new SqlFunctions("TIMESTAMP", "h2,mysql", "", "<p>The timestamp data type. The proleptic Gregorian calendar is used. If fractional seconds precision is specified it should be from 0 to 9, 6 is default.", "", "datatypes"));
        dz.add(new SqlFunctions("TRIM", "h2,mysql", "", "<p>Removes all leading spaces, trailing spaces, or spaces at both ends from a string. If character to trim is specified, these characters are removed instead of spaces, only one character can be specified. To trim multiple different characters use <a href=\"functions.html#ltrim\"><code class=\"notranslate\">LTRIM</code></a>, <a href=\"functions.html#rtrim\"><code class=\"notranslate\">RTRIM</code></a>, or <a href=\"functions.html#btrim\"><code class=\"notranslate\">BTRIM</code></a>.", "", "functions"));
        dz.add(new SqlFunctions("UPPER", "h2,mysql", "", "<p>Converts a string to uppercase.", "", "functions"));
        dz.add(new SqlFunctions("UUID", "h2,mysql", "", "<p>Universally unique identifier. This is a 128 bit value. To store values, use <code class=\"notranslate\">PreparedStatement.setBytes, setString</code>, or <code class=\"notranslate\">setObject(uuid)</code> (where <code class=\"notranslate\">uuid</code> is a <code class=\"notranslate\">java.util.UUID</code>). <code class=\"notranslate\">ResultSet.getObject</code> will return a <code class=\"notranslate\">java.util.UUID</code>.", "", "datatypes"));
        dz.add(new SqlFunctions("VAR_POP", "h2,mysql", "", "<p>The population variance (square of the population standard deviation). This method returns a double. If no rows are selected, the result is <code class=\"notranslate\">NULL</code>. Aggregates are only allowed in select statements.", "", "functions-aggregate"));
        dz.add(new SqlFunctions("VAR_SAMP", "h2,mysql", "", "<p>The sample variance (square of the sample standard deviation). This method returns a double. If less than two rows are selected, the result is <code class=\"notranslate\">NULL</code>. Aggregates are only allowed in select statements.", "", "functions-aggregate"));
        dz.add(new SqlFunctions("WEEK", "h2,mysql", "", "<p>Returns the week (1-53) from a date/time value.", "", "functions"));
        dz.add(new SqlFunctions("YEAR", "h2,mysql", "", "<p>Returns the year from a date/time value.", "", "functions"));
        dz.add(new SqlFunctions("mod", "postgresql,sqlite", "mod( X , Y )", "<p>  Return the remainder after dividing X by Y.  This is similar to the '%'  operator, except that it works for non-integer arguments.", "mod(9,4)", "math"));
        dz.add(new SqlFunctions("substr", "postgresql,sqlite", "substr( X , Y , Z ) substr( X , Y ) substring( X , Y , Z ) substring( X , Y )", "<p>  The substr(X,Y,Z) function returns a substring of input string X that begins  with the Y-th character and which is Z characters long.  If Z is omitted then substr(X,Y) returns all characters through the end  of the string X beginning with the Y-th.  The left-most character of X is number 1.  If Y is negative  then the first character of the substring is found by counting from the  right rather than the left.  If Z is negative then  the abs(Z) characters preceding the Y-th character are returned.  If X is a string then characters indices refer to actual UTF-8   characters.  If X is a BLOB then the indices refer to bytes.  <p>  \"substring()\" is an alias for \"substr()\" beginning with SQLite version 3.34.", "substr('alphabet', 3,          2)", "scalar"));
        dz.add(new SqlFunctions("add", "duckdb", "`add(x, y)`", "Alias for `x + y`", "`add(2, 3)`", "numeric"));
        dz.add(new SqlFunctions("age", "duckdb", "`age(`*`timestamptz`*`, `*`timestamptz`*`)`", "Subtract arguments, resulting in the time difference between the two timestamps", "`age(TIMESTAMPTZ '2001-04-10', TIMESTAMPTZ '1992-09-20')`", "timestamp"));
        dz.add(new SqlFunctions("alias", "duckdb", "`alias(`*`column`*`)`", "Return the name of the column", "`alias(column1)`", "utility"));
        dz.add(new SqlFunctions("array_extract", "duckdb", "`array_extract(`*`list`*`, `*`index`*`)`", "Extract a single character using a (1-based) index.", "`array_extract('DuckDB', 2)`", "char"));
        dz.add(new SqlFunctions("array_slice", "duckdb", "`array_slice(`*`list`*`, `*`begin`*`, `*`end`*`)`", "Extract a string using slice conventions. Negative values are accepted.", "`array_slice('DuckDB', 5, NULL)`", "char"));
        dz.add(new SqlFunctions("bar", "duckdb", "`bar(`*`x`*`, `*`min`*`, `*`max`*`[, `*`width`*`])`", "Draw a band whose width is proportional to (*x* - *min*) and equal to *width* characters when *x* = *max*. *width* defaults to 80.", "`bar(5, 0, 20, 10)`", "char"));
        dz.add(new SqlFunctions("bit_and", "duckdb", "`bit_and(arg)`", "Returns the bitwise AND operation performed on all bitstrings in a given expression.", "`bit_and(A)`", "bitstring"));
        dz.add(new SqlFunctions("bit_count", "duckdb", "`bit_count(`*`bitstring`*`)`", "Returns the number of set bits in the bitstring.", "`bit_count('1101011'::BIT)`", "bitstring"));
        dz.add(new SqlFunctions("bit_or", "duckdb", "`bit_or(arg)`", "Returns the bitwise OR operation performed on all bitstrings in a given expression.", "`bit_or(A)`", "bitstring"));
        dz.add(new SqlFunctions("bit_position", "duckdb", "`bit_position(`*`substring`*`, `*`bitstring`*`)`", "Returns first starting index of the specified substring within bits, or zero if it's not present. The first (leftmost) bit is indexed 1", "`bit_position('010'::BIT, '1110101'::BIT)`", "bitstring"));
        dz.add(new SqlFunctions("bit_xor", "duckdb", "`bit_xor(arg)`", "Returns the bitwise XOR operation performed on all bitstrings in a given expression.", "`bit_xor(A)`", "bitstring"));
        dz.add(new SqlFunctions("bitstring", "duckdb", "`bitstring(`*`bitstring`*`, `*`length`*`)`", "Returns a bitstring of determined length.", "`bitstring('1010'::BIT, 7)`", "bitstring"));
        dz.add(new SqlFunctions("bitstring_agg", "duckdb", "`bitstring_agg(arg, min, max)`", "Returns a bitstring with bits set for each distinct value.", "`bitstring_agg(A, 1, 42)`", "bitstring"));
        dz.add(new SqlFunctions("cardinality", "duckdb", "`cardinality(`*`map`*`)`", "Return the size of the map (or the number of entries in the map).", "`cardinality(map([4, 2], ['a', 'b']))`", "nested"));
        dz.add(new SqlFunctions("cbrt", "duckdb", "`cbrt(x)`", "Returns the cube root of the number", "`cbrt(8)`", "numeric"));
        dz.add(new SqlFunctions("century", "duckdb", "`century(`*`timestamp`*`)`", "Extracts the century of a timestamp", "`century(TIMESTAMP '1992-03-22')`", "timestamp"));
        dz.add(new SqlFunctions("checkpoint", "duckdb", "`checkpoint(`*`database`*`)`", "Synchronize WAL with file for (optional) database without interrupting transactions.", "`checkpoint(my_db)`", "utility"));
        dz.add(new SqlFunctions("constant_or_null", "duckdb", "`constant_or_null(`*`arg1`*`, `*`arg2`*`)`", "If *`arg2`* is `NULL`, return `NULL`. Otherwise, return *`arg1`*.", "`constant_or_null(42, NULL)`", "utility"));
        dz.add(new SqlFunctions("contains", "duckdb", "`contains(`*`string`*`, `*`search_string`*`)`", "Return true if *search_string* is found within *string*", "`contains('abc', 'a')`", "char"));
        dz.add(new SqlFunctions("cot", "duckdb", "`cot(x)`", "Computes the cotangent of x", "`cot(0.5)`", "numeric"));
        dz.add(new SqlFunctions("count_if", "duckdb", "`count_if(`*`x`*`)`", "Returns 1 if *x* is `true` or a non-zero number", "`count_if(42)`", "utility"));
        dz.add(new SqlFunctions("current_date", "duckdb", "`current_date`", "Current date (at start of current transaction)", "`current_date`", "date"));
        dz.add(new SqlFunctions("current_localtime", "duckdb", "`current_localtime()`", "Returns a `TIME` whose GMT bin values correspond to local time in the current time zone.", "`current_localtime()`", "timestamptz"));
        dz.add(new SqlFunctions("current_localtimestamp", "duckdb", "`current_localtimestamp()`", "Returns a `TIMESTAMP` whose GMT bin values correspond to local date and time in the current time zone.", "`current_localtimestamp()`", "timestamptz"));
        dz.add(new SqlFunctions("current_schema", "duckdb", "`current_schema()`", "Return the name of the currently active schema. Default is main.", "`current_schema()`", "utility"));
        dz.add(new SqlFunctions("current_schemas", "duckdb", "`current_schemas(`*`boolean`*`)`", "Return list of schemas. Pass a parameter of `true` to include implicit schemas.", "`current_schemas(true)`", "utility"));
        dz.add(new SqlFunctions("current_setting", "duckdb", "`current_setting(`*`'setting_name'`*`)`", "Return the current value of the configuration setting", "`current_setting('access_mode')`", "utility"));
        dz.add(new SqlFunctions("current_timestamp", "duckdb", "`current_timestamp`", "Current date and time (start of current transaction)", "`current_timestamp`", "timestamptz"));
        dz.add(new SqlFunctions("currval", "duckdb", "`currval(`*`'sequence_name'`*`)`", "Return the current value of the sequence. Note that `nextval` must be called at least once prior to calling `currval`.", "`currval('my_sequence_name')`", "utility"));
        dz.add(new SqlFunctions("damerau_levenshtein", "duckdb", "`damerau_levenshtein(`*`s1`*`,` *`s2`*`)`", "Extension of Levenshtein distance to also include transposition of adjacent characters as an allowed edit operation. In other words, the minimum number of edit operations (insertions, deletions, substitutions or transpositions) required to change one string to another. Different case is considered different.", "`damerau_levenshtein('duckdb', 'udckbd')`", "char"));
        dz.add(new SqlFunctions("date_add", "duckdb", "`date_add(`*`date`*`, `*`interval`*`)`", "Add the interval to the date", "`date_add(DATE '1992-09-15', INTERVAL 2 MONTH)`", "date"));
        dz.add(new SqlFunctions("date_diff", "duckdb", "`date_diff(`*`part`*`, `*`startdate`*`, `*`enddate`*`)`", "The number of [partition](../../sql/functions/datepart) boundaries between the timestamps", "`date_diff('hour', TIMESTAMPTZ '1992-09-30 23:59:59', TIMESTAMPTZ '1992-10-01 01:58:00')`", "date"));
        dz.add(new SqlFunctions("date_part", "duckdb", "`date_part([`*`part`*`, ...], `*`timestamptz`*`)`", "Get the listed [subfields](../../sql/functions/datepart) as a `struct`. The list must be constant.", "`date_part(['year', 'month', 'day'], TIMESTAMPTZ '1992-09-20 20:38:40-07')`", "date"));
        dz.add(new SqlFunctions("date_sub", "duckdb", "`date_sub(`*`part`*`, `*`startdate`*`, `*`enddate`*`)`", "The number of complete [partitions](../../sql/functions/datepart) between the timestamps", "`date_sub('hour', TIMESTAMPTZ '1992-09-30 23:59:59', TIMESTAMPTZ '1992-10-01 01:58:00')`", "date"));
        dz.add(new SqlFunctions("date_trunc", "duckdb", "`date_trunc(`*`part`*`, `*`timestamptz`*`)`", "Truncate to specified [precision](../../sql/functions/datepart)", "`date_trunc('hour', TIMESTAMPTZ '1992-09-20 20:38:40')`", "date"));
        dz.add(new SqlFunctions("datediff", "duckdb", "`datediff(`*`part`*`, `*`startdate`*`, `*`enddate`*`)`", "Alias of date_diff. The number of [partition](../../sql/functions/datepart) boundaries between the timestamps", "`datediff('hour', TIMESTAMPTZ '1992-09-30 23:59:59', TIMESTAMPTZ '1992-10-01 01:58:00')`", "date"));
        dz.add(new SqlFunctions("datepart", "duckdb", "`datepart([`*`part`*`, ...], `*`timestamptz`*`)`", "Alias of date_part. Get the listed [subfields](../../sql/functions/datepart) as a `struct`. The list must be constant.", "`datepart(['year', 'month', 'day'], TIMESTAMPTZ '1992-09-20 20:38:40-07')`", "date"));
        dz.add(new SqlFunctions("datesub", "duckdb", "`datesub(`*`part`*`, `*`startdate`*`, `*`enddate`*`)`", "Alias of date_sub. The number of complete [partitions](../../sql/functions/datepart) between the timestamps", "`datesub('hour', TIMESTAMPTZ '1992-09-30 23:59:59', TIMESTAMPTZ '1992-10-01 01:58:00')`", "date"));
        dz.add(new SqlFunctions("datetrunc", "duckdb", "`datetrunc(`*`part`*`, `*`timestamptz`*`)`", "Alias of date_trunc. Truncate to specified [precision](../../sql/functions/datepart)", "`datetrunc('hour', TIMESTAMPTZ '1992-09-20 20:38:40')`", "date"));
        dz.add(new SqlFunctions("dayname", "duckdb", "`dayname(`*`timestamp`*`)`", "The (English) name of the weekday", "`dayname(TIMESTAMP '1992-03-22')`", "date"));
        dz.add(new SqlFunctions("dayofweek", "duckdb", "`dayofweek(`*`date`*`)`", "Numeric weekday (Sunday = 0, Saturday = 6)", "`dayofweek(date '1992-02-15')`", "datepart"));
        dz.add(new SqlFunctions("dayofyear", "duckdb", "`dayofyear(`*`date`*`)`", "Day of the year (starts from 1, i.e., January 1 = 1)", "`dayofyear(date '1992-02-15')`", "datepart"));
        dz.add(new SqlFunctions("decade", "duckdb", "`decade(`*`date`*`)`", "Decade (year / 10)", "`decade(date '1992-02-15')`", "datepart"));
        dz.add(new SqlFunctions("divide", "duckdb", "`divide(x, y)`", "Alias for `x // y`", "`divide(5, 2)`", "numeric"));
        dz.add(new SqlFunctions("editdist3", "duckdb", "`editdist3(`*`s1`*`,` *`s2`*`)`", "Alias of `levenshtein` for SQLite compatibility. The minimum number of single-character edits (insertions, deletions or substitutions) required to change one string to the other. Different case is considered different.", "`editdist3('duck', 'db')`", "char"));
        dz.add(new SqlFunctions("element_at", "duckdb", "`element_at(`*`map, key`*`)`", "Return a list containing the value for a given key or an empty list if the key is not contained in the map. The type of the key provided in the second parameter must match the type of the map's keys else an error is returned.", "`element_at(map([100, 5], [42, 43]), 100)`", "nested"));
        dz.add(new SqlFunctions("ends_with", "duckdb", "`ends_with(`*`string`*`, `*`search_string`*`)`", "Return true if *string* ends with *search_string*", "`ends_with('abc', 'c')`", "char"));
        dz.add(new SqlFunctions("enum_code", "duckdb", "`enum_code(`*`enum_value`*`)`", "Returns the numeric value backing the given enum value", "`enum_code('happy'::mood)`", "enum"));
        dz.add(new SqlFunctions("enum_first", "duckdb", "`enum_first(`*`enum`*`)`", "Returns the first value of the input enum type.", "`enum_first(null::mood)`", "enum"));
        dz.add(new SqlFunctions("enum_last", "duckdb", "`enum_last(`*`enum`*`)`", "Returns the last value of the input enum type.", "`enum_last(null::mood)`", "enum"));
        dz.add(new SqlFunctions("enum_range", "duckdb", "`enum_range(`*`enum`*`)`", "Returns all values of the input enum type as an array.", "`enum_range(null::mood)`", "enum"));
        dz.add(new SqlFunctions("enum_range_boundary", "duckdb", "`enum_range_boundary(`*`enum`*`, `*`enum`*`)`", "Returns the range between the two given enum values as an array. The values must be of the same enum type. When the first parameter is `NULL`, the result starts with the first value of the enum type. When the second parameter is `NULL`, the result ends with the last value of the enum type.", "`enum_range_boundary(NULL, 'happy'::mood)`", "enum"));
        dz.add(new SqlFunctions("epoch", "duckdb", "`epoch(`*`timestamp`*`)`", "Converts a timestamp to seconds since the epoch", "`epoch('2022-11-07 08:43:04'::TIMESTAMP);`", "datepart"));
        dz.add(new SqlFunctions("epoch_ms", "duckdb", "`epoch_ms(`*`timestamptz`*`)`", "Return the total number of milliseconds since the epoch", "`epoch_ms('2022-11-07 08:43:04.123456+00'::TIMESTAMPTZ);`", "timestamp"));
        dz.add(new SqlFunctions("epoch_ns", "duckdb", "`epoch_ns(`*`timestamptz`*`)`", "Return the total number of nanoseconds since the epoch", "`epoch_ns('2022-11-07 08:43:04.123456+00'::TIMESTAMPTZ);`", "timestamp"));
        dz.add(new SqlFunctions("epoch_us", "duckdb", "`epoch_us(`*`timestamptz`*`)`", "Return the total number of microseconds since the epoch", "`epoch_us('2022-11-07 08:43:04.123456+00'::TIMESTAMPTZ);`", "timestamp"));
        dz.add(new SqlFunctions("error", "duckdb", "`error(`*`message`*`)`", "Throws the given error *`message`*", "`error('access_mode')`", "utility"));
        dz.add(new SqlFunctions("even", "duckdb", "`even(x)`", "Round to next even number by rounding away from zero", "`even(2.9)`", "numeric"));
        dz.add(new SqlFunctions("extract", "duckdb", "`extract(`*`field`* `from` *`timestamptz`*`)`", "Get [subfield](../../sql/functions/datepart) from a timestamp with time zone", "`extract('hour' FROM TIMESTAMPTZ '1992-09-20 20:38:48')`", "date"));
        dz.add(new SqlFunctions("factorial", "duckdb", "`factorial(x)`", "See `!` operator. Computes the product of the current integer and all integers below it", "`factorial(4)`", "numeric"));
        dz.add(new SqlFunctions("fdiv", "duckdb", "`fdiv(x, y)`", "Performs integer division (`x // y`) but returns a `DOUBLE` value", "`fdiv(5, 2)`", "numeric"));
        dz.add(new SqlFunctions("fmod", "duckdb", "`fmod(x, y)`", "Calculates the modulo value. Always returns a `DOUBLE` value", "`fmod(5, 2)`", "numeric"));
        dz.add(new SqlFunctions("force_checkpoint", "duckdb", "`force_checkpoint(`*`database`*`)`", "Synchronize WAL with file for (optional) database interrupting transactions.", "`force_checkpoint(my_db)`", "utility"));
        dz.add(new SqlFunctions("format_bytes", "duckdb", "`format_bytes(`*`bytes`*`)`", "Converts bytes to a human-readable representation using units based on powers of 2 (KiB, MiB, GiB, etc.).", "`format_bytes(16384)`", "char"));
        dz.add(new SqlFunctions("from_base64", "duckdb", "`from_base64(`*`string`*`)`", "Convert a base64 encoded string to a character string.", "`from_base64('QQ==')`", "char"));
        dz.add(new SqlFunctions("gamma", "duckdb", "`gamma(x)`", "Interpolation of (x-1) factorial (so decimal inputs are allowed)", "`gamma(5.5)`", "numeric"));
        dz.add(new SqlFunctions("gcd", "duckdb", "`gcd(x, y)`", "Computes the greatest common divisor of x and y", "`gcd(42, 57)`", "numeric"));
        dz.add(new SqlFunctions("gen_random_uuid", "duckdb", "`gen_random_uuid()`", "Alias of `uuid`. Return a random uuid similar to this: eeccb8c5-9943-b2bb-bb5e-222f4e14b687.", "`gen_random_uuid()`", "utility"));
        dz.add(new SqlFunctions("generate_series", "duckdb", "`generate_series(`*`timestamptz`*`, `*`timestamptz`*`, `*`interval`*`)`", "Generate a table of timestamps in the closed range (including both the starting timestamp and the ending timestamp), stepping by the interval", "`generate_series(TIMESTAMPTZ '2001-04-10', TIMESTAMPTZ '2001-04-11', INTERVAL 30 MINUTE)`", "timestamp"));
        dz.add(new SqlFunctions("get_bit", "duckdb", "`get_bit(`*`bitstring`*`, `*`index`*`)`", "Extracts the nth bit from bitstring; the first (leftmost) bit is indexed 0.", "`get_bit('0110010'::BIT, 2)`", "bitstring"));
        dz.add(new SqlFunctions("get_current_timestamp", "duckdb", "`get_current_timestamp()`", "Current date and time (start of current transaction)", "`get_current_timestamp()`", "timestamptz"));
        dz.add(new SqlFunctions("greatest", "duckdb", "`greatest(`*`timestamptz`*`, `*`timestamptz`*`)`", "The later of two timestamps", "`greatest(TIMESTAMPTZ '1992-09-20 20:38:48', TIMESTAMPTZ '1992-03-22 01:02:03.1234')`", "date"));
        dz.add(new SqlFunctions("greatest_common_divisor", "duckdb", "`greatest_common_divisor(x, y)`", "Computes the greatest common divisor of x and y", "`greatest_common_divisor(42, 57)`", "numeric"));
        dz.add(new SqlFunctions("hash", "duckdb", "`hash(`*`value`*`)`", "Returns an integer with the hash of the *`value`*", "`hash('')`", "char"));
        dz.add(new SqlFunctions("icu_sort_key", "duckdb", "`icu_sort_key(`*`string`*`, `*`collator`*`)`", "Surrogate key used to sort special characters according to the specific locale. Collator parameter is optional. Valid only when ICU extension is installed.", "`icu_sort_key('\u00c3\u00b6', 'DE')`", "utility"));
        dz.add(new SqlFunctions("ilike_escape", "duckdb", "`ilike_escape(`*`string`*`, `*`like_specifier`*`, `*`escape_character`*`)`", "Returns true if the *string* matches the *like_specifier* (see [Pattern Matching](../../sql/functions/patternmatching)) using case-insensitive matching. *escape_character* is used to search for wildcard characters in the *string*.", "`ilike_escape('A%c', 'a$%C', '$')`", "char"));
        dz.add(new SqlFunctions("isfinite", "duckdb", "`isfinite(`*`timestamptz`*`)`", "Returns true if the timestamp with time zone is finite, false otherwise", "`isfinite(TIMESTAMPTZ '1992-03-07')`", "date"));
        dz.add(new SqlFunctions("isinf", "duckdb", "`isinf(`*`timestamptz`*`)`", "Returns true if the timestamp with time zone is infinite, false otherwise", "`isinf(TIMESTAMPTZ '-infinity')`", "date"));
        dz.add(new SqlFunctions("isnan", "duckdb", "`isnan(x)`", "Returns true if the floating point value is not a number, false otherwise", "`isnan('NaN'::float)`", "numeric"));
        dz.add(new SqlFunctions("isodow", "duckdb", "`isodow(`*`date`*`)`", "Numeric ISO weekday (Monday = 1, Sunday = 7)", "`isodow(date '1992-02-15')`", "datepart"));
        dz.add(new SqlFunctions("isoyear", "duckdb", "`isoyear(`*`date`*`)`", "ISO Year number (Starts on Monday of week containing Jan 4th)", "`isoyear(date '2022-01-01')`", "datepart"));
        dz.add(new SqlFunctions("jaccard", "duckdb", "`jaccard(`*`s1`*`,` *`s2`*`)`", "The Jaccard similarity between two strings. Different case is considered different. Returns a number between 0 and 1.", "`jaccard('duck', 'luck')`", "char"));
        dz.add(new SqlFunctions("jaro_similarity", "duckdb", "`jaro_similarity(`*`s1`*`,` *`s2`*`)`", "The Jaro similarity between two strings. Different case is considered different. Returns a number between 0 and 1.", "`jaro_similarity('duck', 'duckdb')`", "char"));
        dz.add(new SqlFunctions("jaro_winkler_similarity", "duckdb", "`jaro_winkler_similarity(`*`s1`*`,` *`s2`*`)`", "The Jaro-Winkler similarity between two strings. Different case is considered different. Returns a number between 0 and 1.", "`jaro_winkler_similarity('duck', 'duckdb')`", "char"));
        dz.add(new SqlFunctions("last_day", "duckdb", "`last_day(`*`timestamptz`*`)`", "The last day of the corresponding month in the date", "`last_day(TIMESTAMPTZ '1992-03-22 01:02:03.1234')`", "date"));
        dz.add(new SqlFunctions("lcm", "duckdb", "`lcm(x, y)`", "Computes the least common multiple of x and y", "`lcm(42, 57)`", "numeric"));
        dz.add(new SqlFunctions("least", "duckdb", "`least(`*`timestamptz`*`, `*`timestamptz`*`)`", "The earlier of two timestamps", "`least(TIMESTAMPTZ '1992-09-20 20:38:48', TIMESTAMPTZ '1992-03-22 01:02:03.1234')`", "date"));
        dz.add(new SqlFunctions("least_common_multiple", "duckdb", "`least_common_multiple(x, y)`", "Computes the least common multiple of x and y", "`least_common_multiple(42, 57)`", "numeric"));
        dz.add(new SqlFunctions("levenshtein", "duckdb", "`levenshtein(`*`s1`*`,` *`s2`*`)`", "The minimum number of single-character edits (insertions, deletions or substitutions) required to change one string to the other. Different case is considered different.", "`levenshtein('duck', 'db')`", "char"));
        dz.add(new SqlFunctions("lgamma", "duckdb", "`lgamma(x)`", "Computes the log of the `gamma` function", "`lgamma(2)`", "numeric"));
        dz.add(new SqlFunctions("like_escape", "duckdb", "`like_escape(`*`string`*`, `*`like_specifier`*`, `*`escape_character`*`)`", "Returns true if the *string* matches the *like_specifier* (see [Pattern Matching](../../sql/functions/patternmatching)) using case-sensitive matching. *escape_character* is used to search for wildcard characters in the *string*.", "`like_escape('a%c', 'a$%c', '$')`", "char"));
        dz.add(new SqlFunctions("list_aggregate", "duckdb", "`list_aggregate(`*`list`*`, `*`name`*`)`", "`list_aggr`, `aggregate`, `array_aggregate`, `array_aggr`", "Executes the aggregate function `name` on the elements of `list`. See the [List Aggregates](nested#list-aggregates) section for more details.", "nested"));
        dz.add(new SqlFunctions("list_concat", "duckdb", "`list_concat(`*`list1`*`, `*`list2`*`)`", "`list_cat`, `array_concat`, `array_cat`", "Concatenates two lists.", "nested"));
        dz.add(new SqlFunctions("list_contains", "duckdb", "`list_contains(`*`list`*`, `*`element`*`)`", "`list_has`, `array_contains`, `array_has`", "Returns true if the list contains the element.", "nested"));
        dz.add(new SqlFunctions("list_position", "duckdb", "`list_position(`*`list`*`, `*`element`*`)`", "`list_indexof`, `array_position`, `array_indexof`", "Returns the index of the element if the list contains the element.", "nested"));
        dz.add(new SqlFunctions("list_transform", "duckdb", "`list_transform(`*`list`*`, `*`lambda`*`)`", "`array_transform`, `apply`, `list_apply`, `array_apply`", "Returns a list that is the result of applying the lambda function to each element of the input list. See the [Lambda Functions](lambda#transform) page for more details.", "nested"));
        dz.add(new SqlFunctions("localtime", "duckdb", "`localtime`", "Synonym for the `current_localtime()` function call.", "`localtime`", "timestamptz"));
        dz.add(new SqlFunctions("localtimestamp", "duckdb", "`localtimestamp`", "Synonym for the `current_localtimestamp()` function call.", "`localtimestamp`", "timestamptz"));
        dz.add(new SqlFunctions("log10", "duckdb", "`log10(x)`", "Alias of `log`. computes the 10-log of *x*", "`log10(1000)`", "numeric"));
        dz.add(new SqlFunctions("make_date", "duckdb", "`make_date(`*`bigint`*`, `*`bigint`*`, `*`bigint`*`)`", "The date for the given parts", "`make_date(1992, 9, 20)`", "date"));
        dz.add(new SqlFunctions("make_time", "duckdb", "`make_time(`*`bigint`*`, `*`bigint`*`, `*`double`*`)`", "The time for the given parts", "`make_time(13, 34, 27.123456)`", "time"));
        dz.add(new SqlFunctions("make_timestamp", "duckdb", "`make_timestamp(`*`bigint`*`, `*`bigint`*`, `*`bigint`*`, `*`bigint`*`, `*`bigint`*`, `*`double`*`)`", "The timestamp for the given number of \u00c2\u00b5s since the epoch", "`make_timestamp(1992, 9, 20, 13, 34, 27.123456)`", "timestamp"));
        dz.add(new SqlFunctions("make_timestamptz", "duckdb", "`make_timestamptz(`*`bigint`*`, `*`bigint`*`, `*`bigint`*`, `*`bigint`*`, `*`bigint`*`, `*`double`*`, `*`string`*`)`", "The timestamp with time zone for the given parts in the current time zone", "`make_timestamptz(1992, 9, 20, 15, 34, 27.123456, 'CET')`", "timestamptz"));
        dz.add(new SqlFunctions("map", "duckdb", "`map()`", "Returns an empty map.", "`map()`", "nested"));
        dz.add(new SqlFunctions("map_entries", "duckdb", "`map_entries(`*`map`*`)`", "Return a list of struct(k, v) for each key-value pair in the map.", "`map_entries(map([100, 5], [42, 43]))`", "nested"));
        dz.add(new SqlFunctions("map_extract", "duckdb", "`map_extract(`*`map, key`*`)`", "Alias of `element_at`. Return a list containing the value for a given key or an empty list if the key is not contained in the map. The type of the key provided in the second parameter must match the type of the map's keys else an error is returned.", "`map_extract(map([100, 5], [42, 43]), 100)`", "nested"));
        dz.add(new SqlFunctions("map_from_entries", "duckdb", "`map_from_entries(`*`STRUCT(k, v)[]`*`)`", "Returns a map created from the entries of the array", "`map_from_entries([{k: 5, v: 'val1'}, {k: 3, v: 'val2'}])`", "nested"));
        dz.add(new SqlFunctions("map_keys", "duckdb", "`map_keys(`*`map`*`)`", "Return a list of all keys in the map.", "`map_keys(map([100, 5], [42, 43]))`", "nested"));
        dz.add(new SqlFunctions("map_values", "duckdb", "`map_values(`*`map`*`)`", "Return a list of all values in the map.", "`map_values(map([100, 5], [42, 43]))`", "nested"));
        dz.add(new SqlFunctions("mismatches", "duckdb", "`mismatches(`*`s1`*`,` *`s2`*`)`", "Alias for `hamming(`*`s1`*`,` *`s2`*`)`. The number of positions with different characters for two strings of equal length. Different case is considered different.", "`mismatches('duck', 'luck')`", "char"));
        dz.add(new SqlFunctions("monthname", "duckdb", "`monthname(`*`timestamp`*`)`", "The (English) name of the month.", "`monthname(TIMESTAMP '1992-09-20')`", "date"));
        dz.add(new SqlFunctions("multiply", "duckdb", "`multiply(x, y)`", "Alias for `x * y`", "`multiply(2, 3)`", "numeric"));
        dz.add(new SqlFunctions("nextafter", "duckdb", "`nextafter(x, y)`", "Return the next floating point value after *x* in the direction of *y*", "`nextafter(1::float, 2::float)`", "numeric"));
        dz.add(new SqlFunctions("nextval", "duckdb", "`nextval(`*`'sequence_name'`*`)`", "Return the following value of the sequence.", "`nextval('my_sequence_name')`", "utility"));
        dz.add(new SqlFunctions("nfc_normalize", "duckdb", "`nfc_normalize(`*`string`*`)`", "Convert string to Unicode NFC normalized string. Useful for comparisons and ordering if text data is mixed between NFC normalized and not.", "`nfc_normalize('arde\u00cc\u20acch')`", "char"));
        dz.add(new SqlFunctions("not_ilike_escape", "duckdb", "`not_ilike_escape(`*`string`*`, `*`like_specifier`*`, `*`escape_character`*`)`", "Returns false if the *string* matches the *like_specifier* (see [Pattern Matching](../../sql/functions/patternmatching)) using case-sensitive matching. *escape_character* is used to search for wildcard characters in the *string*.", "`not_ilike_escape('A%c', 'a$%C', '$')`", "char"));
        dz.add(new SqlFunctions("not_like_escape", "duckdb", "`not_like_escape(`*`string`*`, `*`like_specifier`*`, `*`escape_character`*`)`", "Returns false if the *string* matches the *like_specifier* (see [Pattern Matching](../../sql/functions/patternmatching)) using case-insensitive matching. *escape_character* is used to search for wildcard characters in the *string*.", "`not_like_escape('a%c', 'a$%c', '$')`", "char"));
        dz.add(new SqlFunctions("now", "duckdb", "`now()`", "Current date and time (start of current transaction)", "`now()`", "timestamptz"));
        dz.add(new SqlFunctions("ord", "duckdb", "`ord(`*`string`*`)`", "Return ASCII character code of the leftmost character in a string.", "`ord('\u00c3\u00bc')`", "char"));
        dz.add(new SqlFunctions("pg_typeof", "duckdb", "`pg_typeof(`*`expression`*`)`", "Returns the lower case name of the data type of the result of the expression. For PostgreSQL compatibility.", "`pg_typeof('abc')`", "utility"));
        dz.add(new SqlFunctions("range", "duckdb", "`range(`*`timestamptz`*`, `*`timestamptz`*`, `*`interval`*`)`", "Generate a table of timestamps in the half open range (including the starting timestamp, but stopping before the ending timestamp) , stepping by the interval", "`range(TIMESTAMPTZ '2001-04-10', TIMESTAMPTZ '2001-04-11', INTERVAL 30 MINUTE)`", "timestamp"));
        dz.add(new SqlFunctions("regexp_escape", "duckdb", "`regexp_escape(`*`string`*`)`", "Escapes special patterns to turn *string* into a regular expression similarly to Python's [`re.escape` function](https://docs.python.org/3/library/re.html#re.escape)", "`regexp_escape('https://duckdb.org')`", "char"));
        dz.add(new SqlFunctions("regexp_extract", "duckdb", "`regexp_extract(`*`string`*`, `*`pattern `*`, `*`name_list`*`)`;", "If *string* contains the regexp *pattern*, returns the capturing groups as a struct with corresponding names from *name_list* (see [Pattern Matching](patternmatching#using-regexp_extract))", "`regexp_extract('2023-04-15', '(\\d+)-(\\d+)-(\\d+)', ['y', 'm', 'd'])`", "char"));
        dz.add(new SqlFunctions("regexp_extract_all", "duckdb", "`regexp_extract_all(`*`string`*`, `*`regex`*`[, `*`group`*` = 0])`", "Split the *string* along the *regex* and extract all occurrences of *group*", "`regexp_extract_all('hello_world', '([a-z ]+)_?', 1)`", "char"));
        dz.add(new SqlFunctions("regexp_full_match", "duckdb", "`regexp_full_match(`*`string`*`, `*`regex`*`)`", "Returns `true` if the entire *string* matches the *regex* (see [Pattern Matching](patternmatching))", "`regexp_full_match('anabanana', '(an)*')`", "char"));
        dz.add(new SqlFunctions("repeat_row", "duckdb", "`repeat_row(`*`varargs`*`, `*`num_rows`*`)`", "Returns a table with *`num_rows`* rows, each containing the fields defined in *`varargs`*", "`repeat_row(1, 2, 'foo', num_rows = 3)`", "utility"));
        dz.add(new SqlFunctions("round_even", "duckdb", "`round_even(v NUMERIC, s INT)`", "Alias of `roundbankers(v, s)`. Round to *s* decimal places using the [_rounding half to even_ rule](https://en.wikipedia.org/wiki/Rounding#Rounding_half_to_even). Values *s < 0* are allowed", "`round_even(24.5, 0)`", "numeric"));
        dz.add(new SqlFunctions("row", "duckdb", "`row(`*`any`*`, ...)`", "Create a `STRUCT` containing the argument values. If the values are column references, the entry name will be the column name; otherwise it will be the string `'vN'` where `N` is the (1-based) position of the argument.", "`row(i, i % 4, i / 4)`", "nested"));
        dz.add(new SqlFunctions("set_bit", "duckdb", "`set_bit(`*`bitstring`*`, `*`index`*`, `*`new_value`*`)`", "Sets the nth bit in bitstring to newvalue; the first (leftmost) bit is indexed 0. Returns a new bitstring.", "`set_bit('0110010'::BIT, 2, 0)`", "bitstring"));
        dz.add(new SqlFunctions("signbit", "duckdb", "`signbit(x)`", "Returns whether the signbit is set or not", "`signbit(-0.0)`", "numeric"));
        dz.add(new SqlFunctions("starts_with", "duckdb", "`starts_with(`*`string`*`, `*`search_string`*`)`", "Return true if *string* begins with *search_string*", "`starts_with('abc', 'a')`", "char"));
        dz.add(new SqlFunctions("stats", "duckdb", "`stats(`*`expression`*`)`", "Returns a string with statistics about the expression. Expression can be a column, constant, or SQL expression.", "`stats(5)`", "utility"));
        dz.add(new SqlFunctions("strftime", "duckdb", "`strftime(`*`timestamptz`*`, `*`format`*`)`", "Converts timestamp with time zone to string according to the [format string](../../sql/functions/dateformat)", "`strftime(timestamptz '1992-01-01 20:38:40', '%a, %-d %B %Y - %I:%M:%S %p')`", "date"));
        dz.add(new SqlFunctions("string_split", "duckdb", "`string_split(`*`string`*`, `*`separator`*`)`", "Splits the *string* along the *separator*", "`string_split('helloworld', '')`", "char"));
        dz.add(new SqlFunctions("string_split_regex", "duckdb", "`string_split_regex(`*`string`*`, `*`regex`*`)`", "Splits the *string* along the *regex*", "`string_split_regex('helloworld; 42', ';?')`", "char"));
        dz.add(new SqlFunctions("strip_accents", "duckdb", "`strip_accents(`*`string`*`)`", "Strips accents from *string*", "`strip_accents('m\u00c3\u00bchleisen')`", "char"));
        dz.add(new SqlFunctions("strlen", "duckdb", "`strlen(`*`string`*`)`", "Number of bytes in *string*", "`strlen('')`", "char"));
        dz.add(new SqlFunctions("strptime", "duckdb", "`strptime(`*`text`*`, `*`format-list`*`)`", "Converts string to timestamp applying the [format strings](../../sql/functions/dateformat) in the list until one succeeds. Throws on failure.", "`strptime('Wed, 1 January 1992 - 08:38:40 PST', '%a, %-d %B %Y - %H:%M:%S %Z')`", "timestamp"));
        dz.add(new SqlFunctions("struct_extract", "duckdb", "`struct_extract(`*`struct`*`, `*`'entry'`*`)`", "Extract the named entry from the struct.", "`struct_extract({'i': 3, 'v2': 3, 'v3': 0}, 'i')`", "nested"));
        dz.add(new SqlFunctions("struct_insert", "duckdb", "`struct_insert(`*`struct`*`, `*`name := any`*`, ...)`", "Add field(s)/value(s) to an existing `STRUCT` with the argument values. The entry name(s) will be the bound variable name(s).", "`struct_insert({'a': 1}, b := 2)`", "nested"));
        dz.add(new SqlFunctions("struct_pack", "duckdb", "`struct_pack(`*`name := any`*`, ...)`", "Create a `STRUCT` containing the argument values. The entry name will be the bound variable name.", "`struct_pack(i := 4, s := 'string')`", "nested"));
        dz.add(new SqlFunctions("subtract", "duckdb", "`subtract(x, y)`", "Alias for `x - y`", "`subtract(2, 3)`", "numeric"));
        dz.add(new SqlFunctions("time_bucket", "duckdb", "`time_bucket(`*`bucket_width`*`, `*`timestamptz`*`[, `*`timezone`*`])`", "Truncate `timestamptz` by the specified interval `bucket_width`. Buckets are aligned relative to `origin` timestamptz. `origin` defaults to 2000-01-03 00:00:00+00 for buckets that don't include a month or year interval, and to 2000-01-01 00:00:00+00 for month and year buckets.", "`time_bucket(INTERVAL '2 weeks', TIMESTAMPTZ '1992-04-20 15:26:00-07', TIMESTAMPTZ '1992-04-01 00:00:00-07')`", "date"));
        dz.add(new SqlFunctions("timezone", "duckdb", "`timezone(`*`text`*`, `*`timestamptz`*`)`", "Use the [date parts](../../sql/functions/datepart) of the timestamp in GMT to construct a timestamp in the given time zone. Effectively, the argument is a \"local\" time.", "`timezone('America/Denver', TIMESTAMPTZ '2001-02-16 20:38:40-05')`", "datepart"));
        dz.add(new SqlFunctions("timezone_hour", "duckdb", "`timezone_hour(`*`date`*`)`", "Time zone offset hour portion", "`timezone_hour(date '1992-02-15')`", "datepart"));
        dz.add(new SqlFunctions("timezone_minute", "duckdb", "`timezone_minute(`*`date`*`)`", "Time zone offset minutes portion", "`timezone_minute(date '1992-02-15')`", "datepart"));
        dz.add(new SqlFunctions("to_base64", "duckdb", "`to_base64(`*`blob`*`)`", "Convert a blob to a base64 encoded string.", "`to_base64('A'::blob)`", "char"));
        dz.add(new SqlFunctions("to_centuries", "duckdb", "`to_centuries(`*`integer`*`)`", "Construct a century interval", "`to_centuries(5)`", "interval"));
        dz.add(new SqlFunctions("to_days", "duckdb", "`to_days(`*`integer`*`)`", "Construct a day interval", "`to_days(5)`", "interval"));
        dz.add(new SqlFunctions("to_decades", "duckdb", "`to_decades(`*`integer`*`)`", "Construct a decade interval", "`to_decades(5)`", "interval"));
        dz.add(new SqlFunctions("to_hours", "duckdb", "`to_hours(`*`integer`*`)`", "Construct a hour interval", "`to_hours(5)`", "interval"));
        dz.add(new SqlFunctions("to_microseconds", "duckdb", "`to_microseconds(`*`integer`*`)`", "Construct a microsecond interval", "`to_microseconds(5)`", "interval"));
        dz.add(new SqlFunctions("to_millennia", "duckdb", "`to_millennia(`*`integer`*`)`", "Construct a millenium interval", "`to_millennia(5)`", "interval"));
        dz.add(new SqlFunctions("to_milliseconds", "duckdb", "`to_milliseconds(`*`integer`*`)`", "Construct a millisecond interval", "`to_milliseconds(5)`", "interval"));
        dz.add(new SqlFunctions("to_minutes", "duckdb", "`to_minutes(`*`integer`*`)`", "Construct a minute interval", "`to_minutes(5)`", "interval"));
        dz.add(new SqlFunctions("to_months", "duckdb", "`to_months(`*`integer`*`)`", "Construct a month interval", "`to_months(5)`", "interval"));
        dz.add(new SqlFunctions("to_seconds", "duckdb", "`to_seconds(`*`integer`*`)`", "Construct a second interval", "`to_seconds(5)`", "interval"));
        dz.add(new SqlFunctions("to_timestamp", "duckdb", "`to_timestamp(`*`double`*`)`", "Converts seconds since the epoch to a timestamp with time zone", "`to_timestamp(1284352323.5)`", "timestamp"));
        dz.add(new SqlFunctions("to_weeks", "duckdb", "`to_weeks(`*`integer`*`)`", "Construct a week interval", "`to_weeks(5)`", "interval"));
        dz.add(new SqlFunctions("to_years", "duckdb", "`to_years(`*`integer`*`)`", "Construct a year interval", "`to_years(5)`", "interval"));
        dz.add(new SqlFunctions("today", "duckdb", "`today()`", "Current date (start of current transaction)", "`today()`", "date"));
        dz.add(new SqlFunctions("transaction_timestamp", "duckdb", "`transaction_timestamp()`", "Current date and time (start of current transaction)", "`transaction_timestamp()`", "timestamptz"));
        dz.add(new SqlFunctions("try_strptime", "duckdb", "`try_strptime(`*`text`*`, `*`format-list`*`)`", "Converts string to timestamp applying the [format strings](../../sql/functions/dateformat) in the list until one succeeds. Returns `NULL` on failure.", "`try_strptime('Wed, 1 January 1992 - 08:38:40 PM', '%a, %-d %B %Y - %I:%M:%S %p')`", "timestamp"));
        dz.add(new SqlFunctions("txid_current", "duckdb", "`txid_current()`", "Returns the current transaction's ID (a `BIGINT`). It will assign a new one if the current transaction does not have one already.", "`txid_current()`", "utility"));
        dz.add(new SqlFunctions("union_extract", "duckdb", "`union_extract(`*`union`*`, `*`'tag'`*`)`", "Extract the value with the named tags from the union. `NULL` if the tag is not currently selected", "`union_extract(s, 'k')`", "nested"));
        dz.add(new SqlFunctions("union_tag", "duckdb", "`union_tag(`*`union`*`)`", "Retrieve the currently selected tag of the union as an [Enum](../../sql/data_types/enum).", "`union_tag(union_value(k := 'foo'))`", "nested"));
        dz.add(new SqlFunctions("union_value", "duckdb", "`union_value(`*`tag := any`*`)`", "Create a single member `UNION` containing the argument value. The tag of the value will be the bound variable name.", "`union_value(k := 'hello')`", "nested"));
        dz.add(new SqlFunctions("uuid", "duckdb", "`uuid()`", "Return a random uuid similar to this: eeccb8c5-9943-b2bb-bb5e-222f4e14b687.", "`uuid()`", "utility"));
        dz.add(new SqlFunctions("version", "duckdb", "`version()`", "Return the currently active version of DuckDB in this format", "`version()`", "utility"));
        dz.add(new SqlFunctions("weekday", "duckdb", "`weekday(`*`date`*`)`", "Numeric weekday synonym (Sunday = 0, Saturday = 6)", "`weekday(date '1992-02-15')`", "datepart"));
        dz.add(new SqlFunctions("weekofyear", "duckdb", "`weekofyear(`*`date`*`)`", "ISO Week (synonym)", "`weekofyear(date '1992-02-15')`", "datepart"));
        dz.add(new SqlFunctions("yearweek", "duckdb", "`yearweek(`*`date`*`)`", "`BIGINT` of combined ISO Year number and 2-digit version of ISO Week number", "`yearweek(date '1992-02-15')`", "datepart"));
        dz.add(new SqlFunctions("ABORT_SESSION", "h2", "", "<p>Cancels the currently executing statement of another session. Closes the session and releases the allocated resources. Returns true if the session was closed, false if no session with the given id was found.", "", "functions"));
        dz.add(new SqlFunctions("ANALYZE", "h2", "", "<p>Updates the selectivity statistics of tables. If no table name is given, all tables are analyzed. The selectivity is used by the cost based optimizer to select the best index for a given query. If no sample size is set, up to 10000 rows per table are read. The value 0 means all rows are read. The selectivity can be set manually using <code class=\"notranslate\">ALTER TABLE ALTER COLUMN SELECTIVITY</code>. Manual values are overwritten by this statement. The selectivity is available in the <code class=\"notranslate\">INFORMATION_SCHEMA.COLUMNS</code> table.", "", "commands"));
        dz.add(new SqlFunctions("ANY", "h2", "", "<p>Returns true if any expression is true. If no rows are selected, the result is <code class=\"notranslate\">NULL</code>. Aggregates are only allowed in select statements.", "", "functions-aggregate"));
        dz.add(new SqlFunctions("ARRAY", "h2", "", "<p>A data type for array of values. Base data type specifies the data type of elements. Array may have <code class=\"notranslate\">NULL</code> elements. Maximum cardinality, if any, specifies maximum allowed number of elements in the array. The allowed cardinality is from 0 to 65536 elements.", "", "datatypes"));
        dz.add(new SqlFunctions("ARRAY_AGG", "h2", "", "<p>Aggregate the value into an array. This method returns an array. <code class=\"notranslate\">NULL</code> values are included in the array, <code class=\"notranslate\">FILTER</code> clause can be used to exclude them. If no rows are selected, the result is <code class=\"notranslate\">NULL</code>. If <code class=\"notranslate\">ORDER BY</code> is not specified order of values is not determined. When this aggregate is used with <code class=\"notranslate\">OVER</code> clause that contains <code class=\"notranslate\">ORDER BY</code> subclause it does not enforce exact order of values. This aggregate needs additional own <code class=\"notranslate\">ORDER BY</code> clause to make it deterministic. Aggregates are only allowed in select statements.", "", "functions-aggregate"));
        dz.add(new SqlFunctions("ARRAY_APPEND", "h2", "", "<p>Append an element to the end of an array.", "", "functions"));
        dz.add(new SqlFunctions("ARRAY_CAT", "h2", "", "<p>Returns the concatenation of two arrays.", "", "functions"));
        dz.add(new SqlFunctions("ARRAY_CONTAINS", "h2", "", "<p>Returns a boolean <code class=\"notranslate\">TRUE</code> if the array contains the value or <code class=\"notranslate\">FALSE</code> if it does not contain it. Returns <code class=\"notranslate\">NULL</code> if the specified array is <code class=\"notranslate\">NULL</code>.", "", "functions"));
        dz.add(new SqlFunctions("ARRAY_GET", "h2", "", "<p>Returns element at the specified 1-based index from an array.", "", "functions"));
        dz.add(new SqlFunctions("ARRAY_MAX_CARDINALITY", "h2", "", "<p>Returns the maximum allowed array cardinality (length) of the declared data type of argument.", "", "functions"));
        dz.add(new SqlFunctions("ARRAY_SLICE", "h2", "", "<p>Returns elements from the array as specified by the lower and upper bound parameters. Both parameters are inclusive and the first element has index 1, i.e. <code class=\"notranslate\">ARRAY_SLICE</code>(a, 2, 2) has only the second element. Returns <code class=\"notranslate\">NULL</code> if any parameter is <code class=\"notranslate\">NULL</code> or if an index is out of bounds.", "", "functions"));
        dz.add(new SqlFunctions("ATAN2", "h2", "", "<p>Calculate the angle when converting the rectangular coordinates to polar coordinates. See also Java <code class=\"notranslate\">Math.atan2</code>. This method returns a double.", "", "functions"));
        dz.add(new SqlFunctions("AUTOCOMMIT", "h2", "", "<p>Returns true if auto commit is switched on for this session.", "", "functions"));
        dz.add(new SqlFunctions("Alias", "h2", "", "<p>An alias is a name that is only valid in the context of the statement.", "", "grammar"));
        dz.add(new SqlFunctions("Array", "h2", "", "<p>An array of values.", "", "grammar"));
        dz.add(new SqlFunctions("BACKUP", "h2", "", "<p>Backs up the database files to a .zip file. Objects are not locked, but the backup is transactionally consistent because the transaction log is also copied. Admin rights are required to execute this command.", "", "commands"));
        dz.add(new SqlFunctions("BIGINT", "h2", "", "<p>Possible values: -9223372036854775808 to 9223372036854775807.", "", "datatypes"));
        dz.add(new SqlFunctions("BITAND", "h2", "", "<p>The bitwise <code class=\"notranslate\">AND</code> operation. Arguments should have <code class=\"notranslate\">TINYINT, SMALLINT, INTEGER, BIGINT, BINARY</code>, or <code class=\"notranslate\">BINARY VARYING</code> data type. This function returns result of the same data type.", "", "functions"));
        dz.add(new SqlFunctions("BITCOUNT", "h2", "", "<p>Returns count of set bits in the specified value. Value should have <code class=\"notranslate\">TINYINT, SMALLINT, INTEGER, BIGINT, BINARY</code>, or <code class=\"notranslate\">BINARY VARYING</code> data type. This method returns a long.", "", "functions"));
        dz.add(new SqlFunctions("BITGET", "h2", "", "<p>Returns true if and only if the first argument has a bit set in the position specified by the second parameter. The first argument should have <code class=\"notranslate\">TINYINT, SMALLINT, INTEGER, BIGINT, BINARY</code>, or <code class=\"notranslate\">BINARY VARYING</code> data type. This method returns a boolean. The second argument is zero-indexed; the least significant bit has position 0.", "", "functions"));
        dz.add(new SqlFunctions("BITNAND", "h2", "", "<p>The bitwise <code class=\"notranslate\">NAND</code> operation equivalent to <code class=\"notranslate\">BITNOT(BITAND(expression, expression))</code>. Arguments should have <code class=\"notranslate\">TINYINT, SMALLINT, INTEGER, BIGINT, BINARY</code>, or <code class=\"notranslate\">BINARY VARYING</code> data type. This function returns result of the same data type.", "", "functions"));
        dz.add(new SqlFunctions("BITNOR", "h2", "", "<p>The bitwise <code class=\"notranslate\">NOR</code> operation equivalent to <code class=\"notranslate\">BITNOT(BITOR(expression, expression))</code>. Arguments should have <code class=\"notranslate\">TINYINT, SMALLINT, INTEGER, BIGINT, BINARY</code>, or <code class=\"notranslate\">BINARY VARYING</code> data type. This function returns result of the same data type.", "", "functions"));
        dz.add(new SqlFunctions("BITNOT", "h2", "", "<p>The bitwise <code class=\"notranslate\">NOT</code> operation. Argument should have <code class=\"notranslate\">TINYINT, SMALLINT, INTEGER, BIGINT, BINARY</code>, or <code class=\"notranslate\">BINARY VARYING</code> data type. This function returns result of the same data type.", "", "functions"));
        dz.add(new SqlFunctions("BITOR", "h2", "", "<p>The bitwise <code class=\"notranslate\">OR</code> operation. Arguments should have <code class=\"notranslate\">TINYINT, SMALLINT, INTEGER, BIGINT, BINARY</code>, or <code class=\"notranslate\">BINARY VARYING</code> data type. This function returns result of the same data type.", "", "functions"));
        dz.add(new SqlFunctions("BITXNOR", "h2", "", "<p>The bitwise <code class=\"notranslate\">XNOR</code> operation equivalent to <code class=\"notranslate\">BITNOT(BITXOR(expression, expression))</code>. Arguments should have <code class=\"notranslate\">TINYINT, SMALLINT, INTEGER, BIGINT, BINARY</code>, or <code class=\"notranslate\">BINARY VARYING</code> data type. This function returns result of the same data type.", "", "functions"));
        dz.add(new SqlFunctions("BITXOR", "h2", "", "<p>Arguments should have <code class=\"notranslate\">TINYINT, SMALLINT, INTEGER, BIGINT, BINARY</code>, or <code class=\"notranslate\">BINARY VARYING</code> data type. This function returns result of the same data type.", "", "functions"));
        dz.add(new SqlFunctions("BIT_AND_AGG", "h2", "", "<p>The bitwise <code class=\"notranslate\">AND</code> of all non-null values. If no rows are selected, the result is <code class=\"notranslate\">NULL</code>. Aggregates are only allowed in select statements.", "", "functions-aggregate"));
        dz.add(new SqlFunctions("BIT_NAND_AGG", "h2", "", "<p>The bitwise <code class=\"notranslate\">NAND</code> of all non-null values. If no rows are selected, the result is <code class=\"notranslate\">NULL</code>. Aggregates are only allowed in select statements.", "", "functions-aggregate"));
        dz.add(new SqlFunctions("BIT_NOR_AGG", "h2", "", "<p>The bitwise <code class=\"notranslate\">NOR</code> of all non-null values. If no rows are selected, the result is <code class=\"notranslate\">NULL</code>. Aggregates are only allowed in select statements.", "", "functions-aggregate"));
        dz.add(new SqlFunctions("BIT_OR_AGG", "h2", "", "<p>The bitwise <code class=\"notranslate\">OR</code> of all non-null values. If no rows are selected, the result is <code class=\"notranslate\">NULL</code>. Aggregates are only allowed in select statements.", "", "functions-aggregate"));
        dz.add(new SqlFunctions("BIT_XNOR_AGG", "h2", "", "<p>The bitwise <code class=\"notranslate\">XNOR</code> of all non-null values. If no rows are selected, the result is <code class=\"notranslate\">NULL</code>. Aggregates are only allowed in select statements.", "", "functions-aggregate"));
        dz.add(new SqlFunctions("BIT_XOR_AGG", "h2", "", "<p>The bitwise <code class=\"notranslate\">XOR</code> of all non-null values. If no rows are selected, the result is <code class=\"notranslate\">NULL</code>. Aggregates are only allowed in select statements.", "", "functions-aggregate"));
        dz.add(new SqlFunctions("BOOLEAN", "h2", "", "<p>Possible values: <code class=\"notranslate\">TRUE, FALSE</code>, and <code class=\"notranslate\">UNKNOWN</code> (<code class=\"notranslate\">NULL</code>).", "", "datatypes"));
        dz.add(new SqlFunctions("BTRIM", "h2", "", "<p>Removes all leading and trailing spaces or other specified characters from a string, multiple characters can be specified.", "", "functions"));
        dz.add(new SqlFunctions("Boolean", "h2", "", "<p>A boolean value. <code class=\"notranslate\">UNKNOWN</code> is a <code class=\"notranslate\">NULL</code> value with the boolean data type.", "", "grammar"));
        dz.add(new SqlFunctions("Bytes", "h2", "", "<p>A binary string value. The hex value is not case sensitive and may contain space characters as separators. If there are more than one group of quoted hex values, groups must be separated with whitespace.", "", "grammar"));
        dz.add(new SqlFunctions("CALL", "h2", "", "<p>Calculates a simple expression. This statement returns a result set with one row, except if the called function returns a result set itself. If the called function returns an array, then each element in this array is returned as a column.", "", "commands"));
        dz.add(new SqlFunctions("CANCEL_SESSION", "h2", "", "<p>Cancels the currently executing statement of another session. Returns true if the statement was canceled, false if the session is closed or no statement is currently executing.", "", "functions"));
        dz.add(new SqlFunctions("CARDINALITY", "h2", "", "<p>Returns the length of an array or <code class=\"notranslate\">JSON</code> array. Returns <code class=\"notranslate\">NULL</code> if the specified array is <code class=\"notranslate\">NULL</code>.", "", "functions"));
        dz.add(new SqlFunctions("CHARACTER", "h2", "", "<p>A Unicode String of fixed length.", "", "datatypes"));
        dz.add(new SqlFunctions("CHECKPOINT", "h2", "", "<p>Flushes the data to disk.", "", "commands"));
        dz.add(new SqlFunctions("COMMIT", "h2", "", "<p>Commits a transaction.", "", "commands"));
        dz.add(new SqlFunctions("CORR", "h2", "", "<p>Pearson&#39;s correlation coefficient. This method returns a double. Rows in which either argument is <code class=\"notranslate\">NULL</code> are ignored in the calculation. If no rows are selected, the result is <code class=\"notranslate\">NULL</code>. Aggregates are only allowed in select statements.", "", "functions-aggregate"));
        dz.add(new SqlFunctions("COSH", "h2", "", "<p>Calculate the hyperbolic cosine. See also Java <code class=\"notranslate\">Math.cosh</code>. This method returns a double.", "", "functions"));
        dz.add(new SqlFunctions("COVAR_POP", "h2", "", "<p>The population covariance. This method returns a double. Rows in which either argument is <code class=\"notranslate\">NULL</code> are ignored in the calculation. If no rows are selected, the result is <code class=\"notranslate\">NULL</code>. Aggregates are only allowed in select statements.", "", "functions-aggregate"));
        dz.add(new SqlFunctions("COVAR_SAMP", "h2", "", "<p>The sample covariance. This method returns a double. Rows in which either argument is <code class=\"notranslate\">NULL</code> are ignored in the calculation. If less than two rows are selected, the result is <code class=\"notranslate\">NULL</code>. Aggregates are only allowed in select statements.", "", "functions-aggregate"));
        dz.add(new SqlFunctions("CSVREAD", "h2", "", "<p>Returns the result set of reading the <code class=\"notranslate\">CSV</code> (comma separated values) file. For each parameter, <code class=\"notranslate\">NULL</code> means the default value should be used.", "", "functions"));
        dz.add(new SqlFunctions("CSVWRITE", "h2", "", "<p>Writes a <code class=\"notranslate\">CSV</code> (comma separated values). The file is overwritten if it exists. If only a file name is specified, it will be written to the current working directory. For each parameter, <code class=\"notranslate\">NULL</code> means the default value should be used. The default charset is the default value for this system, and the default field separator is a comma.", "", "functions"));
        dz.add(new SqlFunctions("CURRENT_CATALOG", "h2", "", "<p>Returns the name of the database.", "", "functions"));
        dz.add(new SqlFunctions("CURRENT_PATH", "h2", "", "<p>Returns the comma-separated list of quoted schema names where user-defined functions are searched when they are referenced without the schema name.", "", "functions"));
        dz.add(new SqlFunctions("CURRENT_SCHEMA", "h2", "", "<p>Returns the name of the default schema for this session.", "", "functions"));
        dz.add(new SqlFunctions("CURRVAL", "h2", "", "<p>Returns the latest generated value of the sequence for the current session. Current value may only be requested after generation of the sequence value in the current session. This method exists only for compatibility, when it isn&#39;t required use <a href=\"grammar.html#sequence_value_expression\"><code class=\"notranslate\">CURRENT VALUE FOR</code> sequenceName</a> instead. If the schema name is not set, the current schema is used. When sequence is not found, the uppercase name is also checked. This method returns a long.", "", "functions"));
        dz.add(new SqlFunctions("Cipher", "h2", "", "<p>Only the algorithm <code class=\"notranslate\">AES</code> (<code class=\"notranslate\">AES-128</code>) is supported currently.", "", "grammar"));
        dz.add(new SqlFunctions("Column", "h2", "", "<p>A column name with optional table alias and schema. _<code class=\"notranslate\">ROWID_</code> can be used to access unique row identifier.", "", "grammar"));
        dz.add(new SqlFunctions("Comment", "h2", "", "<p>Comments can be used anywhere in a command and are ignored by the database. Line comments <code class=\"notranslate\">--</code> and <code class=\"notranslate\">//</code> end with a newline.", "", "grammar"));
        dz.add(new SqlFunctions("Compare", "h2", "", "<p>Comparison operator. The operator != is the same as &lt;&gt;. The operator <code class=\"notranslate\">&amp;&amp;</code> means overlapping; it can only be used with geometry types.", "", "grammar"));
        dz.add(new SqlFunctions("Condition", "h2", "", "<p>Boolean value or condition.", "", "grammar"));
        dz.add(new SqlFunctions("DATABASE_PATH", "h2", "", "<p>Returns the directory of the database files and the database name, if it is file based. Returns <code class=\"notranslate\">NULL</code> otherwise.", "", "functions"));
        dz.add(new SqlFunctions("DATA_TYPE_SQL", "h2", "", "<p>Returns SQL representation of data type of the specified constant, domain, table column, routine result or argument.", "", "functions"));
        dz.add(new SqlFunctions("DATEADD", "h2", "", "<p>Adds units to a date-time value. The datetimeField indicates the unit. Use negative values to subtract units. addIntLong may be a long value when manipulating milliseconds, microseconds, or nanoseconds otherwise its range is restricted to int. This method returns a value with the same type as specified value if unit is compatible with this value. If specified field is a <code class=\"notranslate\">HOUR, MINUTE, SECOND, MILLISECOND</code>, etc and value is a <code class=\"notranslate\">DATE</code> value <code class=\"notranslate\">DATEADD</code> returns combined <code class=\"notranslate\">TIMESTAMP</code>. Fields <code class=\"notranslate\">DAY, MONTH, YEAR, WEEK</code>, etc are not allowed for <code class=\"notranslate\">TIME</code> values. Fields <code class=\"notranslate\">TIMEZONE_HOUR, TIMEZONE_MINUTE</code>, and <code class=\"notranslate\">TIMEZONE_SECOND</code> are only allowed for <code class=\"notranslate\">TIMESTAMP WITH TIME ZONE</code> values.", "", "functions"));
        dz.add(new SqlFunctions("DATE_TRUNC", "h2", "", "<p>Truncates the specified date-time value to the specified field.", "", "functions"));
        dz.add(new SqlFunctions("DAY_OF_MONTH", "h2", "", "<p>Returns the day of the month (1-31).", "", "functions"));
        dz.add(new SqlFunctions("DAY_OF_WEEK", "h2", "", "<p>Returns the day of the week (1-7), locale-specific.", "", "functions"));
        dz.add(new SqlFunctions("DAY_OF_YEAR", "h2", "", "<p>Returns the day of the year (1-366).", "", "functions"));
        dz.add(new SqlFunctions("DB_OBJECT_ID", "h2", "", "<p>Returns internal identifier of the specified database object as integer value or <code class=\"notranslate\">NULL</code> if object doesn&#39;t exist.", "", "functions"));
        dz.add(new SqlFunctions("DB_OBJECT_SQL", "h2", "", "<p>Returns internal SQL definition of the specified database object or <code class=\"notranslate\">NULL</code> if object doesn&#39;t exist or it is a system object without SQL definition.", "", "functions"));
        dz.add(new SqlFunctions("DECFLOAT", "h2", "", "<p>Decimal floating point number. This data type is not recommended to represent currency values, because of variable scale.", "", "datatypes"));
        dz.add(new SqlFunctions("DECODE", "h2", "", "<p>Returns the first matching value. <code class=\"notranslate\">NULL</code> is considered to match <code class=\"notranslate\">NULL</code>. If no match was found, then <code class=\"notranslate\">NULL</code> or the last parameter (if the parameter count is even) is returned. This function is provided for Oracle compatibility, use <a href=\"grammar.html#case_expression\"><code class=\"notranslate\">CASE</code></a> instead of it.", "", "functions"));
        dz.add(new SqlFunctions("DECRYPT", "h2", "", "<p>Decrypts data using a key. The supported algorithm is <code class=\"notranslate\">AES</code>. The block size is 16 bytes. This method returns bytes.", "", "functions"));
        dz.add(new SqlFunctions("DELETE", "h2", "", "<p>Deletes rows form a table. If <code class=\"notranslate\">FETCH</code> is specified, at most the specified number of rows are deleted (no limit if null or smaller than zero).", "", "commands"));
        dz.add(new SqlFunctions("DIFFERENCE", "h2", "", "<p>Returns the difference between the sounds of two strings. The difference is calculated as a number of matched characters in the same positions in <code class=\"notranslate\">SOUNDEX</code> representations of arguments. This method returns an int between 0 and 4 inclusive, or null if any of its parameters is null. Note that value of 0 means that strings are not similar to each other. Value of 4 means that strings are fully similar to each other (have the same <code class=\"notranslate\">SOUNDEX</code> representation).", "", "functions"));
        dz.add(new SqlFunctions("DISK_SPACE_USED", "h2", "", "<p>Returns the approximate amount of space used by the table specified. Does not currently take into account indexes or <code class=\"notranslate\">LOB</code>&#39;s. This function may be expensive since it has to load every page in the table.", "", "functions"));
        dz.add(new SqlFunctions("Date", "h2", "", "<p>A date literal.", "", "grammar"));
        dz.add(new SqlFunctions("ENCRYPT", "h2", "", "<p>Encrypts data using a key. The supported algorithm is <code class=\"notranslate\">AES</code>. The block size is 16 bytes. This method returns bytes.", "", "functions"));
        dz.add(new SqlFunctions("ENUM", "h2", "", "<p>A type with enumerated values. Mapped to <code class=\"notranslate\">java.lang.String</code>.", "", "datatypes"));
        dz.add(new SqlFunctions("ENVELOPE", "h2", "", "<p>Returns the minimum bounding box that encloses all specified <code class=\"notranslate\">GEOMETRY</code> values. Only 2D coordinate plane is supported. <code class=\"notranslate\">NULL</code> values are ignored in the calculation. If no rows are selected, the result is <code class=\"notranslate\">NULL</code>. Aggregates are only allowed in select statements.", "", "functions-aggregate"));
        dz.add(new SqlFunctions("ESTIMATED_ENVELOPE", "h2", "", "<p>Returns the estimated minimum bounding box that encloses all specified <code class=\"notranslate\">GEOMETRY</code> values. Only 2D coordinate plane is supported. <code class=\"notranslate\">NULL</code> values are ignored. Column must have a spatial index. This function is fast, but estimation may include uncommitted data (including data from other transactions), may return approximate bounds, or be different with actual value due to other reasons. Use with caution. If estimation is not available this function returns <code class=\"notranslate\">NULL</code>. For accurate and reliable result use <code class=\"notranslate\">ESTIMATE</code> aggregate function instead.", "", "functions"));
        dz.add(new SqlFunctions("EVERY", "h2", "", "<p>Returns true if all expressions are true. If no rows are selected, the result is <code class=\"notranslate\">NULL</code>. Aggregates are only allowed in select statements.", "", "functions-aggregate"));
        dz.add(new SqlFunctions("EXPAND", "h2", "", "<p>Expands data that was compressed using the <code class=\"notranslate\">COMPRESS</code> function. This method returns bytes.", "", "functions"));
        dz.add(new SqlFunctions("EXPLAIN", "h2", "", "<p>Shows the execution plan for a statement. When using <code class=\"notranslate\">EXPLAIN ANALYZE</code>, the statement is actually executed, and the query plan will include the actual row scan count for each table.", "", "commands"));
        dz.add(new SqlFunctions("Expression", "h2", "", "<p>Value or condition.", "", "grammar"));
        dz.add(new SqlFunctions("FILE_READ", "h2", "", "<p>Returns the contents of a file. If only one parameter is supplied, the data are returned as a <code class=\"notranslate\">BLOB</code>. If two parameters are used, the data is returned as a <code class=\"notranslate\">CLOB</code> (text). The second parameter is the character set to use, <code class=\"notranslate\">NULL</code> meaning the default character set for this system.", "", "functions"));
        dz.add(new SqlFunctions("FILE_WRITE", "h2", "", "<p>Write the supplied parameter into a file. Return the number of bytes written.", "", "functions"));
        dz.add(new SqlFunctions("FORMATDATETIME", "h2", "", "<p>Formats a date, time or timestamp as a string. The most important format characters are: y year, M month, d day, H hour, m minute, s second. For details of the format, see <code class=\"notranslate\">java.time.format.DateTimeFormatter</code>. Allowed format characters depend on data type of passed date/time value.", "", "functions"));
        dz.add(new SqlFunctions("Factor", "h2", "", "<p>A value or a numeric factor.", "", "grammar"));
        dz.add(new SqlFunctions("GEOMETRY", "h2", "", "<p>A spatial geometry type. If additional constraints are not specified this type accepts all supported types of geometries. A constraint with required geometry type and dimension system can be set by specifying name of the type and dimension system. A whitespace between them is optional. 2D dimension system does not have a name and assumed if only a geometry type name is specified. <code class=\"notranslate\">POINT</code> means 2D point, <code class=\"notranslate\">POINT</code> Z or <code class=\"notranslate\">POINTZ</code> means 3D point. <code class=\"notranslate\">GEOMETRY</code> constraint means no restrictions on type or dimension system of geometry. A constraint with required spatial reference system identifier (<code class=\"notranslate\">SRID</code>) can be set by specifying this identifier.", "", "datatypes"));
        dz.add(new SqlFunctions("H2VERSION", "h2", "", "<p>Returns the H2 version as a String.", "", "functions"));
        dz.add(new SqlFunctions("HASH", "h2", "", "<p>Calculate the hash value using an algorithm, and repeat this process for a number of iterations.", "", "functions"));
        dz.add(new SqlFunctions("HELP", "h2", "", "<p>Displays the help pages of SQL commands or keywords.", "", "commands"));
        dz.add(new SqlFunctions("HEXTORAW", "h2", "", "<p>Converts a hex representation of a string to a string. 4 hex characters per string character are used.", "", "functions"));
        dz.add(new SqlFunctions("Hex", "h2", "", "<p>The hexadecimal representation of a number or of bytes with optional space characters. Two hexadecimal digit characters are one byte.", "", "grammar"));
        dz.add(new SqlFunctions("INTEGER", "h2", "", "<p>Possible values: -2147483648 to 2147483647.", "", "datatypes"));
        dz.add(new SqlFunctions("ISO_DAY_OF_WEEK", "h2", "", "<p>Returns the <code class=\"notranslate\">ISO</code> day of the week (1 means Monday).", "", "functions"));
        dz.add(new SqlFunctions("ISO_WEEK", "h2", "", "<p>Returns the <code class=\"notranslate\">ISO</code> week (1-53) from a date/time value.", "", "functions"));
        dz.add(new SqlFunctions("ISO_YEAR", "h2", "", "<p>Returns the <code class=\"notranslate\">ISO</code> week year from a date/time value.", "", "functions"));
        dz.add(new SqlFunctions("Int", "h2", "", "<p>The maximum integer number is 2147483647, the minimum is -2147483648.", "", "grammar"));
        dz.add(new SqlFunctions("Interval", "h2", "", "<p>An interval literal.", "", "grammar"));
        dz.add(new SqlFunctions("JAVA_OBJECT", "h2", "", "<p>This type allows storing serialized Java objects. Internally, a byte array with serialized form is used. The allowed length is from 1 (useful only with custom serializer) to 1,000,000,000 bytes. The length is a size constraint; only the actual data is persisted.", "", "datatypes"));
        dz.add(new SqlFunctions("JSON", "h2", "", "<p>A binary or character string with a <code class=\"notranslate\">RFC</code> 8259-compliant <code class=\"notranslate\">JSON</code> text and data format. <code class=\"notranslate\">JSON</code> text is parsed into internal representation. Order of object members is preserved as is. Duplicate object member names are allowed.", "", "datatypes"));
        dz.add(new SqlFunctions("LINK_SCHEMA", "h2", "", "<p>Creates table links for all tables in a schema. If tables with the same name already exist, they are dropped first. The target schema is created automatically if it does not yet exist. The driver name may be empty if the driver is already loaded. The list of tables linked is returned in the form of a result set. Admin rights are required to execute this command.", "", "functions"));
        dz.add(new SqlFunctions("LISTAGG", "h2", "", "<p>Concatenates strings with a separator. The default separator is a &#39;,&#39; (without space). This method returns a string. <code class=\"notranslate\">NULL</code> values are ignored in the calculation, <code class=\"notranslate\">COALESCE</code> can be used to replace them. If no rows are selected, the result is <code class=\"notranslate\">NULL</code>.", "", "functions-aggregate"));
        dz.add(new SqlFunctions("LOCK_MODE", "h2", "", "<p>Returns the current lock mode. See <code class=\"notranslate\">SET LOCK_MODE</code>. This method returns an int.", "", "functions"));
        dz.add(new SqlFunctions("LOCK_TIMEOUT", "h2", "", "<p>Returns the lock timeout of the current session (in milliseconds).", "", "functions"));
        dz.add(new SqlFunctions("LSHIFT", "h2", "", "<p>The bitwise signed left shift operation. Shifts the first argument by the number of bits given by the second argument. Argument should have <code class=\"notranslate\">TINYINT, SMALLINT, INTEGER, BIGINT, BINARY</code>, or <code class=\"notranslate\">BINARY VARYING</code> data type. This function returns result of the same data type.", "", "functions"));
        dz.add(new SqlFunctions("Long", "h2", "", "<p>Long numbers are between -9223372036854775808 and 9223372036854775807.", "", "grammar"));
        dz.add(new SqlFunctions("MEDIAN", "h2", "", "<p>The value separating the higher half of a values from the lower half. Returns the middle value or an interpolated value between two middle values if number of values is even. Interpolation is only supported for numeric, date-time, and interval data types. <code class=\"notranslate\">NULL</code> values are ignored in the calculation. If no rows are selected, the result is <code class=\"notranslate\">NULL</code>. Aggregates are only allowed in select statements.", "", "functions-aggregate"));
        dz.add(new SqlFunctions("MEMORY_FREE", "h2", "", "<p>Returns the free memory in KB (where 1024 bytes is a KB). This method returns a long. The garbage is run before returning the value. Admin rights are required to execute this command.", "", "functions"));
        dz.add(new SqlFunctions("MEMORY_USED", "h2", "", "<p>Returns the used memory in KB (where 1024 bytes is a KB). This method returns a long. The garbage is run before returning the value. Admin rights are required to execute this command.", "", "functions"));
        dz.add(new SqlFunctions("MODE", "h2", "", "<p>Returns the value that occurs with the greatest frequency. If there are multiple values with the same frequency only one value will be returned. In this situation value will be chosen based on optional <code class=\"notranslate\">ORDER BY</code> clause that should specify exactly the same expression as argument of this function. Use ascending order to get smallest value or descending order to get largest value from multiple values with the same frequency. If this clause is not specified the exact chosen value is not determined in this situation. <code class=\"notranslate\">NULL</code> values are ignored in the calculation. If no rows are selected, the result is <code class=\"notranslate\">NULL</code>. Aggregates are only allowed in select statements.", "", "functions-aggregate"));
        dz.add(new SqlFunctions("NEXTVAL", "h2", "", "<p>Increments the sequence and returns its value. The current value of the sequence and the last identity in the current session are updated with the generated value. Used values are never re-used, even when the transaction is rolled back. This method exists only for compatibility, it&#39;s recommended to use the standard <a href=\"grammar.html#sequence_value_expression\"><code class=\"notranslate\">NEXT VALUE FOR</code> sequenceName</a> instead. If the schema name is not set, the current schema is used. When sequence is not found, the uppercase name is also checked. This method returns a long.", "", "functions"));
        dz.add(new SqlFunctions("NUMERIC", "h2", "", "<p>Data type with fixed decimal precision and scale. This data type is recommended for storing currency values.", "", "datatypes"));
        dz.add(new SqlFunctions("NVL2", "h2", "", "<p>If the test value is null, then &#39;b&#39; is returned. Otherwise, &#39;a&#39; is returned. The data type of the returned value is the data type of &#39;a&#39; if this is a text type.", "", "functions"));
        dz.add(new SqlFunctions("Name", "h2", "", "<p>With default settings unquoted names are converted to upper case. The maximum name length is 256 characters.", "", "grammar"));
        dz.add(new SqlFunctions("Null", "h2", "", "<p><code class=\"notranslate\">NULL</code> is a value without data type and means &#39;unknown value&#39;.", "", "grammar"));
        dz.add(new SqlFunctions("Number", "h2", "", "<p>The maximum length of the number depends on the data type used.", "", "grammar"));
        dz.add(new SqlFunctions("Numeric", "h2", "", "<p>The data type of a numeric literal is the one of numeric data types, such as <code class=\"notranslate\">NUMERIC, DECFLOAT, BIGINT</code>, or <code class=\"notranslate\">INTEGER</code> depending on format and value.", "", "grammar"));
        dz.add(new SqlFunctions("ORA_HASH", "h2", "", "<p>Computes a hash value. Optional bucket argument determines the maximum returned value. This argument should be between 0 and 4294967295, default is 4294967295. Optional seed argument is combined with the given expression to return the different values for the same expression. This argument should be between 0 and 4294967295, default is 0. This method returns a long value between 0 and the specified or default bucket value inclusive.", "", "functions"));
        dz.add(new SqlFunctions("Operand", "h2", "", "<p>Performs the concatenation of character string, binary string, or array values. In the default mode, the result is <code class=\"notranslate\">NULL</code> if either parameter is <code class=\"notranslate\">NULL</code>. In compatibility modes result of string concatenation with <code class=\"notranslate\">NULL</code> parameter can be different.", "", "grammar"));
        dz.add(new SqlFunctions("PARSEDATETIME", "h2", "", "<p>Parses a string and returns a <code class=\"notranslate\">TIMESTAMP WITH TIME ZONE</code> value. The most important format characters are: y year, M month, d day, H hour, m minute, s second. For details of the format, see <code class=\"notranslate\">java.time.format.DateTimeFormatter</code>.", "", "functions"));
        dz.add(new SqlFunctions("PERCENTILE_CONT", "h2", "", "<p>Return percentile of values from the group with interpolation. Interpolation is only supported for numeric, date-time, and interval data types. Argument must be between 0 and 1 inclusive. Argument must be the same for all rows in the same group. If argument is <code class=\"notranslate\">NULL</code>, the result is <code class=\"notranslate\">NULL</code>. <code class=\"notranslate\">NULL</code> values are ignored in the calculation. If no rows are selected, the result is <code class=\"notranslate\">NULL</code>. Aggregates are only allowed in select statements.", "", "functions-aggregate"));
        dz.add(new SqlFunctions("PERCENTILE_DISC", "h2", "", "<p>Return percentile of values from the group. Interpolation is not performed. Argument must be between 0 and 1 inclusive. Argument must be the same for all rows in the same group. If argument is <code class=\"notranslate\">NULL</code>, the result is <code class=\"notranslate\">NULL</code>. <code class=\"notranslate\">NULL</code> values are ignored in the calculation. If no rows are selected, the result is <code class=\"notranslate\">NULL</code>. Aggregates are only allowed in select statements.", "", "functions-aggregate"));
        dz.add(new SqlFunctions("QUOTE_IDENT", "h2", "", "<p>Quotes the specified identifier. Identifier is surrounded by double quotes. If identifier contains double quotes they are repeated twice.", "", "functions"));
        dz.add(new SqlFunctions("Query", "h2", "", "<p>A query, such as <code class=\"notranslate\">SELECT</code>, explicit table, or table value.", "", "grammar"));
        dz.add(new SqlFunctions("RANDOM_UUID", "h2", "", "<p>Returns a new <code class=\"notranslate\">UUID</code> with 122 pseudo random bits.", "", "functions"));
        dz.add(new SqlFunctions("RATIO_TO_REPORT", "h2", "", "<p>Returns the ratio of a value to the sum of all values. If argument is <code class=\"notranslate\">NULL</code> or sum of all values is 0, then the value of function is <code class=\"notranslate\">NULL</code>. Window ordering and window frame clauses are not allowed for this function.", "", "functions-window"));
        dz.add(new SqlFunctions("RAWTOHEX", "h2", "", "<p>Converts a string or bytes to the hex representation. 4 hex characters per string character are used. This method returns a string.", "", "functions"));
        dz.add(new SqlFunctions("READONLY", "h2", "", "<p>Returns true if the database is read-only.", "", "functions"));
        dz.add(new SqlFunctions("REAL", "h2", "", "<p>A single precision floating point number. Should not be used to represent currency values, because of rounding problems. Precision value for <code class=\"notranslate\">FLOAT</code> type name should be from 1 to 24.", "", "datatypes"));
        dz.add(new SqlFunctions("REGR_AVGX", "h2", "", "<p>The average (mean) value of dependent expression. Rows in which either argument is <code class=\"notranslate\">NULL</code> are ignored in the calculation. If no rows are selected, the result is <code class=\"notranslate\">NULL</code>. For details about the data type see <a href=\"functions-aggregate.html#avg\"><code class=\"notranslate\">AVG</code></a>. Aggregates are only allowed in select statements.", "", "functions-aggregate"));
        dz.add(new SqlFunctions("REGR_AVGY", "h2", "", "<p>The average (mean) value of independent expression. Rows in which either argument is <code class=\"notranslate\">NULL</code> are ignored in the calculation. If no rows are selected, the result is <code class=\"notranslate\">NULL</code>. For details about the data type see <a href=\"functions-aggregate.html#avg\"><code class=\"notranslate\">AVG</code></a>. Aggregates are only allowed in select statements.", "", "functions-aggregate"));
        dz.add(new SqlFunctions("REGR_COUNT", "h2", "", "<p>Returns the number of rows in the group. This method returns a long. Rows in which either argument is <code class=\"notranslate\">NULL</code> are ignored in the calculation. If no rows are selected, the result is 0. Aggregates are only allowed in select statements.", "", "functions-aggregate"));
        dz.add(new SqlFunctions("REGR_INTERCEPT", "h2", "", "<p>The y-intercept of the regression line. This method returns a double. Rows in which either argument is <code class=\"notranslate\">NULL</code> are ignored in the calculation. If no rows are selected, the result is <code class=\"notranslate\">NULL</code>. Aggregates are only allowed in select statements.", "", "functions-aggregate"));
        dz.add(new SqlFunctions("REGR_R2", "h2", "", "<p>The coefficient of determination. This method returns a double. Rows in which either argument is <code class=\"notranslate\">NULL</code> are ignored in the calculation. If no rows are selected, the result is <code class=\"notranslate\">NULL</code>. Aggregates are only allowed in select statements.", "", "functions-aggregate"));
        dz.add(new SqlFunctions("REGR_SLOPE", "h2", "", "<p>The slope of the line. This method returns a double. Rows in which either argument is <code class=\"notranslate\">NULL</code> are ignored in the calculation. If no rows are selected, the result is <code class=\"notranslate\">NULL</code>. Aggregates are only allowed in select statements.", "", "functions-aggregate"));
        dz.add(new SqlFunctions("REGR_SXX", "h2", "", "<p>The the sum of squares of independent expression. Rows in which either argument is <code class=\"notranslate\">NULL</code> are ignored in the calculation. If no rows are selected, the result is <code class=\"notranslate\">NULL</code>. Aggregates are only allowed in select statements.", "", "functions-aggregate"));
        dz.add(new SqlFunctions("REGR_SXY", "h2", "", "<p>The the sum of products independent expression times dependent expression. Rows in which either argument is <code class=\"notranslate\">NULL</code> are ignored in the calculation. If no rows are selected, the result is <code class=\"notranslate\">NULL</code>. Aggregates are only allowed in select statements.", "", "functions-aggregate"));
        dz.add(new SqlFunctions("REGR_SYY", "h2", "", "<p>The the sum of squares of dependent expression. Rows in which either argument is <code class=\"notranslate\">NULL</code> are ignored in the calculation. If no rows are selected, the result is <code class=\"notranslate\">NULL</code>. Aggregates are only allowed in select statements.", "", "functions-aggregate"));
        dz.add(new SqlFunctions("ROLLBACK", "h2", "", "<p>Rolls back a transaction. If a savepoint name is used, the transaction is only rolled back to the specified savepoint.", "", "commands"));
        dz.add(new SqlFunctions("ROTATELEFT", "h2", "", "<p>The bitwise left rotation operation. Rotates the first argument by the number of bits given by the second argument. Argument should have <code class=\"notranslate\">TINYINT, SMALLINT, INTEGER, BIGINT, BINARY</code>, or <code class=\"notranslate\">BINARY VARYING</code> data type. This function returns result of the same data type.", "", "functions"));
        dz.add(new SqlFunctions("ROTATERIGHT", "h2", "", "<p>The bitwise right rotation operation. Rotates the first argument by the number of bits given by the second argument. Argument should have <code class=\"notranslate\">TINYINT, SMALLINT, INTEGER, BIGINT, BINARY</code>, or <code class=\"notranslate\">BINARY VARYING</code> data type. This function returns result of the same data type.", "", "functions"));
        dz.add(new SqlFunctions("ROW", "h2", "", "<p>A row value data type. This data type should not be normally used as data type of a column.", "", "datatypes"));
        dz.add(new SqlFunctions("ROWNUM", "h2", "", "<p>Returns the number of the current row. This method returns a long value. It is supported for <code class=\"notranslate\">SELECT</code> statements, as well as for <code class=\"notranslate\">DELETE</code> and <code class=\"notranslate\">UPDATE</code>. The first row has the row number 1, and is calculated before ordering and grouping the result set, but after evaluating index conditions (even when the index conditions are specified in an outer query). Use the <a href=\"functions-window.html#row_number\"><code class=\"notranslate\">ROW_NUMBER</code>() <code class=\"notranslate\">OVER</code> ()</a> function to get row numbers after grouping or in specified order.", "", "functions"));
        dz.add(new SqlFunctions("RSHIFT", "h2", "", "<p>The bitwise signed right shift operation. Shifts the first argument by the number of bits given by the second argument. Argument should have <code class=\"notranslate\">TINYINT, SMALLINT, INTEGER, BIGINT, BINARY</code>, or <code class=\"notranslate\">BINARY VARYING</code> data type. This function returns result of the same data type.", "", "functions"));
        dz.add(new SqlFunctions("RUNSCRIPT", "h2", "", "<p>Runs a SQL script from a file. The script is a text file containing SQL statements; each statement must end with &#39;;&#39;. This command can be used to restore a database from a backup. The password must be in single quotes; it is case sensitive and can contain spaces.", "", "commands"));
        dz.add(new SqlFunctions("SAVEPOINT", "h2", "", "<p>Create a new savepoint. See also <code class=\"notranslate\">ROLLBACK</code>. Savepoints are only valid until the transaction is committed or rolled back.", "", "commands"));
        dz.add(new SqlFunctions("SCRIPT", "h2", "", "<p>Creates a SQL script from the database.", "", "commands"));
        dz.add(new SqlFunctions("SECURE_RAND", "h2", "", "<p>Generates a number of cryptographically secure random numbers. This method returns bytes.", "", "functions"));
        dz.add(new SqlFunctions("SELECT", "h2", "", "<p>Selects data from a table or multiple tables.", "", "commands"));
        dz.add(new SqlFunctions("SESSION_ID", "h2", "", "<p>Returns the unique session id number for the current database connection. This id stays the same while the connection is open. This method returns an int. The database engine may re-use a session id after the connection is closed.", "", "functions"));
        dz.add(new SqlFunctions("SET", "h2", "", "<p>Updates a variable with the given value. The new value is returned. When used in a query, the value is updated in the order the rows are read. When used in a subquery, not all rows might be read depending on the query plan. This can be used to implement running totals / cumulative sums.", "", "functions"));
        dz.add(new SqlFunctions("SHOW", "h2", "", "<p>Lists the schemas, tables, or the columns of a table.", "", "commands"));
        dz.add(new SqlFunctions("SHUTDOWN", "h2", "", "<p>This statement closes all open connections to the database and closes the database. This command is usually not required, as the database is closed automatically when the last connection to it is closed.", "", "commands"));
        dz.add(new SqlFunctions("SIGNAL", "h2", "", "<p>Throw an <code class=\"notranslate\">SQLException</code> with the passed <code class=\"notranslate\">SQLState</code> and reason.", "", "functions"));
        dz.add(new SqlFunctions("SINH", "h2", "", "<p>Calculate the hyperbolic sine. See also Java <code class=\"notranslate\">Math.sinh</code>. This method returns a double.", "", "functions"));
        dz.add(new SqlFunctions("SMALLINT", "h2", "", "<p>Possible values: -32768 to 32767.", "", "datatypes"));
        dz.add(new SqlFunctions("STRINGDECODE", "h2", "", "<p>Converts a encoded string using the Java string literal encoding format. Special characters are \\b, \\t, \\n, \\f, \\r, \\\", \\\\, \\&lt;octal&gt;, \\u&lt;unicode&gt;. This method returns a string.", "", "functions"));
        dz.add(new SqlFunctions("STRINGENCODE", "h2", "", "<p>Encodes special characters in a string using the Java string literal encoding format. Special characters are \\b, \\t, \\n, \\f, \\r, \\\", \\\\, \\&lt;octal&gt;, \\u&lt;unicode&gt;. This method returns a string.", "", "functions"));
        dz.add(new SqlFunctions("STRINGTOUTF8", "h2", "", "<p>Encodes a string to a byte array using the <code class=\"notranslate\">UTF8</code> encoding format. This method returns bytes.", "", "functions"));
        dz.add(new SqlFunctions("String", "h2", "", "<p>A character string literal starts and ends with a single quote. Two single quotes can be used to create a single quote inside a string. Prefix <code class=\"notranslate\">N</code> means a national character string literal; H2 does not distinguish regular and national character string literals in any way, this prefix has no effect in H2.", "", "grammar"));
        dz.add(new SqlFunctions("Summand", "h2", "", "<p>A value or a numeric sum.", "", "grammar"));
        dz.add(new SqlFunctions("TABLE", "h2", "", "<p>Returns the result set. <code class=\"notranslate\">TABLE_DISTINCT</code> removes duplicate rows.", "", "functions"));
        dz.add(new SqlFunctions("TANH", "h2", "", "<p>Calculate the hyperbolic tangent. See also Java <code class=\"notranslate\">Math.tanh</code>. This method returns a double.", "", "functions"));
        dz.add(new SqlFunctions("TINYINT", "h2", "", "<p>Possible values are: -128 to 127.", "", "datatypes"));
        dz.add(new SqlFunctions("TO_CHAR", "h2", "", "<p>Oracle-compatible <code class=\"notranslate\">TO_CHAR</code> function that can format a timestamp, a number, or text.", "", "functions"));
        dz.add(new SqlFunctions("TRANSACTION_ID", "h2", "", "<p>Returns the current transaction id for this session. This method returns <code class=\"notranslate\">NULL</code> if there is no uncommitted change, or if the database is not persisted. Otherwise a value of the following form is returned: <code class=\"notranslate\">logFileId-position-sessionId</code>. This method returns a string. The value is unique across database restarts (values are not re-used).", "", "functions"));
        dz.add(new SqlFunctions("TRANSLATE", "h2", "", "<p>Oracle-compatible <code class=\"notranslate\">TRANSLATE</code> function that replaces a sequence of characters in a string with another set of characters.", "", "functions"));
        dz.add(new SqlFunctions("TRIM_ARRAY", "h2", "", "<p>Removes the specified number of elements from the end of the array.", "", "functions"));
        dz.add(new SqlFunctions("TRUNC", "h2", "", "<p>When a numeric argument is specified, truncates it to a number of digits (to the next value closer to 0) and returns value of the same type as argument, but with adjusted precision and scale, if applicable.", "", "functions"));
        dz.add(new SqlFunctions("TRUNCATE_VALUE", "h2", "", "<p>Truncate a value to the required precision. If force flag is set to <code class=\"notranslate\">FALSE</code> fixed precision values are not truncated. The method returns a value with the same data type as the first parameter.", "", "functions"));
        dz.add(new SqlFunctions("Term", "h2", "", "<p>A value. Parameters can be indexed, for example <code class=\"notranslate\">?1</code> meaning the first parameter.", "", "grammar"));
        dz.add(new SqlFunctions("Time", "h2", "", "<p>A time literal. A value is between 0:00:00 and 23:59:59.999999999 and has nanosecond resolution.", "", "grammar"));
        dz.add(new SqlFunctions("Timestamp", "h2", "", "<p>A timestamp literal.", "", "grammar"));
        dz.add(new SqlFunctions("ULSHIFT", "h2", "", "<p>The bitwise unsigned left shift operation. Shifts the first argument by the number of bits given by the second argument. Argument should have <code class=\"notranslate\">TINYINT, SMALLINT, INTEGER, BIGINT, BINARY</code>, or <code class=\"notranslate\">BINARY VARYING</code> data type. This function returns result of the same data type.", "", "functions"));
        dz.add(new SqlFunctions("UNNEST", "h2", "", "<p>Returns the result set. Number of columns is equal to number of arguments, plus one additional column with row number if <code class=\"notranslate\">WITH ORDINALITY</code> is specified. Number of rows is equal to length of longest specified array. If multiple arguments are specified and they have different length, cells with missing values will contain null values.", "", "functions"));
        dz.add(new SqlFunctions("UPDATE", "h2", "", "<p>Updates data in a table. <code class=\"notranslate\">ORDER BY</code> is supported for MySQL compatibility, but it is ignored. If <code class=\"notranslate\">FETCH</code> is specified, at most the specified number of rows are updated (no limit if null or smaller than zero).", "", "commands"));
        dz.add(new SqlFunctions("URSHIFT", "h2", "", "<p>The bitwise unsigned right shift operation. Shifts the first argument by the number of bits given by the second argument. Argument should have <code class=\"notranslate\">TINYINT, SMALLINT, INTEGER, BIGINT, BINARY</code>, or <code class=\"notranslate\">BINARY VARYING</code> data type. This function returns result of the same data type.", "", "functions"));
        dz.add(new SqlFunctions("UTF8TOSTRING", "h2", "", "<p>Decodes a byte array in the <code class=\"notranslate\">UTF8</code> format to a string.", "", "functions"));
        dz.add(new SqlFunctions("VARCHAR_IGNORECASE", "h2", "", "<p>Same as <code class=\"notranslate\">VARCHAR</code>, but not case sensitive when comparing. Stored in mixed case.", "", "datatypes"));
        dz.add(new SqlFunctions("Value", "h2", "", "<p>A literal value of any data type, or null.", "", "grammar"));
        dz.add(new SqlFunctions("WITH", "h2", "", "<p>Can be used to create a recursive or non-recursive query (common table expression). For recursive queries the first select has to be a <code class=\"notranslate\">UNION</code>. One or more common table entries can be referred to by name. Column name declarations are now optional - the column names will be inferred from the named select queries. The final action in a <code class=\"notranslate\">WITH</code> statement can be a select, insert, update, merge, delete or create table.", "", "commands"));
        dz.add(new SqlFunctions("XMLATTR", "h2", "", "<p>Creates an XML attribute element of the form <code class=\"notranslate\">name=value</code>. The value is encoded as XML text. This method returns a string.", "", "functions"));
        dz.add(new SqlFunctions("XMLCDATA", "h2", "", "<p>Creates an <code class=\"notranslate\">XML CDATA</code> element. If the value contains <code class=\"notranslate\">]]&gt;</code>, an XML text element is created instead. This method returns a string.", "", "functions"));
        dz.add(new SqlFunctions("XMLCOMMENT", "h2", "", "<p>Creates an XML comment. Two dashes (<code class=\"notranslate\">--</code>) are converted to <code class=\"notranslate\">- -</code>. This method returns a string.", "", "functions"));
        dz.add(new SqlFunctions("XMLNODE", "h2", "", "<p>Create an XML node element. An empty or null attribute string means no attributes are set. An empty or null content string means the node is empty. The content is indented by default if it contains a newline. This method returns a string.", "", "functions"));
        dz.add(new SqlFunctions("XMLSTARTDOC", "h2", "", "<p>Returns the XML declaration. The result is always <code class=\"notranslate\">&lt;?xml version=</code>1.0<code class=\"notranslate\">?&gt;</code>.", "", "functions"));
        dz.add(new SqlFunctions("XMLTEXT", "h2", "", "<p>Creates an XML text element. If enabled, newline and linefeed is converted to an XML entity (&amp;#). This method returns a string.", "", "functions"));
        dz.add(new SqlFunctions("ZERO", "h2", "", "<p>Returns the value 0. This function can be used even if numeric literals are disabled.", "", "functions"));
        dz.add(new SqlFunctions("ADDDATE", "mysql", "", "Add time values (intervals) to a date value", "", "datetime"));
        dz.add(new SqlFunctions("AES_DECRYPT", "mysql", "", "Decrypt using AES", "", "encryption"));
        dz.add(new SqlFunctions("AES_ENCRYPT", "mysql", "", "Encrypt using AES", "", "encryption"));
        dz.add(new SqlFunctions("BENCHMARK", "mysql", "", "Repeatedly execute an expression", "", "misc"));
        dz.add(new SqlFunctions("BIN", "mysql", "", "Return a string containing binary representation of a number", "", "misc"));
        dz.add(new SqlFunctions("BIN_TO_UUID", "mysql", "", "Convert binary UUID to string", "", "misc"));
        dz.add(new SqlFunctions("BIT_AND", "mysql", "", "Return bitwise AND", "", "aggregate"));
        dz.add(new SqlFunctions("BIT_COUNT", "mysql", "", "Return the number of bits that are set", "", "bitwise"));
        dz.add(new SqlFunctions("BIT_OR", "mysql", "", "Return bitwise OR", "", "aggregate"));
        dz.add(new SqlFunctions("BIT_XOR", "mysql", "", "Return bitwise XOR", "", "aggregate"));
        dz.add(new SqlFunctions("CAN_ACCESS_COLUMN", "mysql", "", "Internal use only", "", "misc"));
        dz.add(new SqlFunctions("CAN_ACCESS_DATABASE", "mysql", "", "Internal use only", "", "misc"));
        dz.add(new SqlFunctions("CAN_ACCESS_TABLE", "mysql", "", "Internal use only", "", "misc"));
        dz.add(new SqlFunctions("CAN_ACCESS_USER", "mysql", "", "Internal use only", "", "misc"));
        dz.add(new SqlFunctions("CAN_ACCESS_VIEW", "mysql", "", "Internal use only", "", "misc"));
        dz.add(new SqlFunctions("CAST", "mysql", "", "Cast a value as a certain type", "", "misc"));
        dz.add(new SqlFunctions("CEILING", "mysql", "", "Return the smallest integer value not less than the argument", "", "math"));
        dz.add(new SqlFunctions("CHARACTER_LENGTH", "mysql", "", "Synonym for CHAR_LENGTH()", "", "misc"));
        dz.add(new SqlFunctions("CHARSET", "mysql", "", "Return the character set of the argument", "", "misc"));
        dz.add(new SqlFunctions("COERCIBILITY", "mysql", "", "Return the collation coercibility value of the string argument", "", "misc"));
        dz.add(new SqlFunctions("COLLATION", "mysql", "", "Return the collation of the string argument", "", "misc"));
        dz.add(new SqlFunctions("CONNECTION_ID", "mysql", "", "Return the connection ID (thread ID) for the connection", "", "misc"));
        dz.add(new SqlFunctions("CONV", "mysql", "", "Convert numbers between different number bases", "", "math"));
        dz.add(new SqlFunctions("CONVERT_TZ", "mysql", "", "Convert from one time zone to another", "", "datetime"));
        dz.add(new SqlFunctions("COUNTDISTINCT", "mysql", "", "Return the count of a number of different values", "", "aggregate"));
        dz.add(new SqlFunctions("CRC32", "mysql", "", "Compute a cyclic redundancy check value", "", "math"));
        dz.add(new SqlFunctions("CURDATE", "mysql", "", "Return the current date", "", "datetime"));
        dz.add(new SqlFunctions("CURTIME", "mysql", "", "Return the current time", "", "datetime"));
        dz.add(new SqlFunctions("DATABASE", "mysql", "", "Return the default (current) database name", "", "misc"));
        dz.add(new SqlFunctions("DATE_ADD", "mysql", "", "Add time values (intervals) to a date value", "", "datetime"));
        dz.add(new SqlFunctions("DATE_FORMAT", "mysql", "", "Format date as specified", "", "datetime"));
        dz.add(new SqlFunctions("DATE_SUB", "mysql", "", "Subtract a time value (interval) from a date", "", "datetime"));
        dz.add(new SqlFunctions("DAY", "mysql", "", "Synonym for DAYOFMONTH()", "", "datetime"));
        dz.add(new SqlFunctions("DAYOFMONTH", "mysql", "", "Return the day of the month (0-31)", "", "datetime"));
        dz.add(new SqlFunctions("DAYOFWEEK", "mysql", "", "Return the weekday index of the argument", "", "datetime"));
        dz.add(new SqlFunctions("DAYOFYEAR", "mysql", "", "Return the day of the year (1-366)", "", "datetime"));
        dz.add(new SqlFunctions("DEFAULT", "mysql", "", "Return the default value for a table column", "", "misc"));
        dz.add(new SqlFunctions("ELT", "mysql", "", "Return string at index number", "", "misc"));
        dz.add(new SqlFunctions("EXPORT_SET", "mysql", "", "Return a string such that for every bit set in the value bits, you      get an on string and for every unset bit, you get an off string", "", "misc"));
        dz.add(new SqlFunctions("ExtractValue", "mysql", "", "Extract a value from an XML string using XPath notation", "", "misc"));
        dz.add(new SqlFunctions("FIELD", "mysql", "", "Index (position) of first argument in subsequent arguments", "", "misc"));
        dz.add(new SqlFunctions("FIND_IN_SET", "mysql", "", "Index (position) of first argument within second argument", "", "misc"));
        dz.add(new SqlFunctions("FORMAT", "mysql", "", "Return a number formatted to specified number of decimal places", "", "misc"));
        dz.add(new SqlFunctions("FORMAT_BYTES", "mysql", "", "Convert byte count to value with units", "", "misc"));
        dz.add(new SqlFunctions("FORMAT_PICO_TIME", "mysql", "", "Convert time in picoseconds to value with units", "", "misc"));
        dz.add(new SqlFunctions("FOUND_ROWS", "mysql", "", "For a SELECT with a LIMIT clause, the number of rows that would be      returned were there no LIMIT clause", "", "misc"));
        dz.add(new SqlFunctions("FROM_BASE64", "mysql", "", "Decode base64 encoded string and return result", "", "misc"));
        dz.add(new SqlFunctions("FROM_DAYS", "mysql", "", "Convert a day number to a date", "", "datetime"));
        dz.add(new SqlFunctions("FROM_UNIXTIME", "mysql", "", "Format Unix timestamp as a date", "", "datetime"));
        dz.add(new SqlFunctions("GET_DD_COLUMN_PRIVILEGES", "mysql", "", "Internal use only", "", "misc"));
        dz.add(new SqlFunctions("GET_DD_CREATE_OPTIONS", "mysql", "", "Internal use only", "", "misc"));
        dz.add(new SqlFunctions("GET_DD_INDEX_SUB_PART_LENGTH", "mysql", "", "Internal use only", "", "misc"));
        dz.add(new SqlFunctions("GET_FORMAT", "mysql", "", "Return a date format string", "", "datetime"));
        dz.add(new SqlFunctions("GET_LOCK", "mysql", "", "Get a named lock", "", "misc"));
        dz.add(new SqlFunctions("GROUPING", "mysql", "", "Distinguish super-aggregate ROLLUP rows from regular rows", "", "misc"));
        dz.add(new SqlFunctions("GROUP_CONCAT", "mysql", "", "Return a concatenated string", "", "aggregate"));
        dz.add(new SqlFunctions("GTID_SUBSET", "mysql", "", "Return true if all GTIDs in subset are also in set; otherwise      false.", "", "misc"));
        dz.add(new SqlFunctions("GTID_SUBTRACT", "mysql", "", "Return all GTIDs in set that are not in subset.", "", "misc"));
        dz.add(new SqlFunctions("GeomCollection", "mysql", "", "Construct geometry collection from geometries", "", "geo"));
        dz.add(new SqlFunctions("GeometryCollection", "mysql", "", "Construct geometry collection from geometries", "", "geo"));
        dz.add(new SqlFunctions("HEX", "mysql", "", "Hexadecimal representation of decimal or string value", "", "misc"));
        dz.add(new SqlFunctions("ICU_VERSION", "mysql", "", "ICU library version", "", "misc"));
        dz.add(new SqlFunctions("IFNULL", "mysql", "", "Null if/else construct", "", "control"));
        dz.add(new SqlFunctions("IN", "mysql", "", "Whether a value is within a set of values", "", "misc"));
        dz.add(new SqlFunctions("INET6_ATON", "mysql", "", "Return the numeric value of an IPv6 address", "", "misc"));
        dz.add(new SqlFunctions("INET6_NTOA", "mysql", "", "Return the IPv6 address from a numeric value", "", "misc"));
        dz.add(new SqlFunctions("INET_ATON", "mysql", "", "Return the numeric value of an IP address", "", "misc"));
        dz.add(new SqlFunctions("INET_NTOA", "mysql", "", "Return the IP address from a numeric value", "", "misc"));
        dz.add(new SqlFunctions("INSTR", "mysql", "", "Return the index of the first occurrence of substring", "", "misc"));
        dz.add(new SqlFunctions("INTERNAL_AUTO_INCREMENT", "mysql", "", "Internal use only", "", "misc"));
        dz.add(new SqlFunctions("INTERNAL_AVG_ROW_LENGTH", "mysql", "", "Internal use only", "", "misc"));
        dz.add(new SqlFunctions("INTERNAL_CHECKSUM", "mysql", "", "Internal use only", "", "misc"));
        dz.add(new SqlFunctions("INTERNAL_CHECK_TIME", "mysql", "", "Internal use only", "", "misc"));
        dz.add(new SqlFunctions("INTERNAL_DATA_FREE", "mysql", "", "Internal use only", "", "misc"));
        dz.add(new SqlFunctions("INTERNAL_DATA_LENGTH", "mysql", "", "Internal use only", "", "misc"));
        dz.add(new SqlFunctions("INTERNAL_DD_CHAR_LENGTH", "mysql", "", "Internal use only", "", "misc"));
        dz.add(new SqlFunctions("INTERNAL_GET_COMMENT_OR_ERROR", "mysql", "", "Internal use only", "", "misc"));
        dz.add(new SqlFunctions("INTERNAL_GET_ENABLED_ROLE_JSON", "mysql", "", "Internal use only", "", "misc"));
        dz.add(new SqlFunctions("INTERNAL_GET_HOSTNAME", "mysql", "", "Internal use only", "", "misc"));
        dz.add(new SqlFunctions("INTERNAL_GET_USERNAME", "mysql", "", "Internal use only", "", "misc"));
        dz.add(new SqlFunctions("INTERNAL_GET_VIEW_WARNING_OR_ERROR", "mysql", "", "Internal use only", "", "misc"));
        dz.add(new SqlFunctions("INTERNAL_INDEX_COLUMN_CARDINALITY", "mysql", "", "Internal use only", "", "misc"));
        dz.add(new SqlFunctions("INTERNAL_INDEX_LENGTH", "mysql", "", "Internal use only", "", "misc"));
        dz.add(new SqlFunctions("INTERNAL_IS_ENABLED_ROLE", "mysql", "", "Internal use only", "", "misc"));
        dz.add(new SqlFunctions("INTERNAL_IS_MANDATORY_ROLE", "mysql", "", "Internal use only", "", "misc"));
        dz.add(new SqlFunctions("INTERNAL_KEYS_DISABLED", "mysql", "", "Internal use only", "", "misc"));
        dz.add(new SqlFunctions("INTERNAL_MAX_DATA_LENGTH", "mysql", "", "Internal use only", "", "misc"));
        dz.add(new SqlFunctions("INTERNAL_TABLE_ROWS", "mysql", "", "Internal use only", "", "misc"));
        dz.add(new SqlFunctions("INTERNAL_UPDATE_TIME", "mysql", "", "Internal use only", "", "misc"));
        dz.add(new SqlFunctions("IS", "mysql", "", "Test a value against a boolean", "", "misc"));
        dz.add(new SqlFunctions("ISNULL", "mysql", "", "Test whether the argument is NULL", "", "misc"));
        dz.add(new SqlFunctions("IS_FREE_LOCK", "mysql", "", "Whether the named lock is free", "", "misc"));
        dz.add(new SqlFunctions("IS_IPV4", "mysql", "", "Whether argument is an IPv4 address", "", "misc"));
        dz.add(new SqlFunctions("IS_IPV4_COMPAT", "mysql", "", "Whether argument is an IPv4-compatible address", "", "misc"));
        dz.add(new SqlFunctions("IS_IPV4_MAPPED", "mysql", "", "Whether argument is an IPv4-mapped address", "", "misc"));
        dz.add(new SqlFunctions("IS_IPV6", "mysql", "", "Whether argument is an IPv6 address", "", "misc"));
        dz.add(new SqlFunctions("IS_USED_LOCK", "mysql", "", "Whether the named lock is in use; return connection identifier if      true", "", "misc"));
        dz.add(new SqlFunctions("IS_UUID", "mysql", "", "Whether argument is a valid UUID", "", "misc"));
        dz.add(new SqlFunctions("JSON_ARRAY_APPEND", "mysql", "", "Append data to JSON document", "", "json"));
        dz.add(new SqlFunctions("JSON_ARRAY_INSERT", "mysql", "", "Insert into JSON array", "", "json"));
        dz.add(new SqlFunctions("JSON_CONTAINS", "mysql", "", "Whether JSON document contains specific object at path", "", "json"));
        dz.add(new SqlFunctions("JSON_CONTAINS_PATH", "mysql", "", "Whether JSON document contains any data at path", "", "json"));
        dz.add(new SqlFunctions("JSON_DEPTH", "mysql", "", "Maximum depth of JSON document", "", "json"));
        dz.add(new SqlFunctions("JSON_EXTRACT", "mysql", "", "Return data from JSON document", "", "json"));
        dz.add(new SqlFunctions("JSON_INSERT", "mysql", "", "Insert data into JSON document", "", "json"));
        dz.add(new SqlFunctions("JSON_KEYS", "mysql", "", "Array of keys from JSON document", "", "json"));
        dz.add(new SqlFunctions("JSON_LENGTH", "mysql", "", "Number of elements in JSON document", "", "json"));
        dz.add(new SqlFunctions("JSON_MERGE", "mysql", "", "Merge JSON documents, preserving duplicate keys. Deprecated      synonym for JSON_MERGE_PRESERVE()", "", "json"));
        dz.add(new SqlFunctions("JSON_MERGE_PATCH", "mysql", "", "Merge JSON documents, replacing values of duplicate keys", "", "json"));
        dz.add(new SqlFunctions("JSON_MERGE_PRESERVE", "mysql", "", "Merge JSON documents, preserving duplicate keys", "", "json"));
        dz.add(new SqlFunctions("JSON_OVERLAPS", "mysql", "", "Compares two JSON documents, returns TRUE (1) if these have any      key-value pairs or array elements in common, otherwise FALSE (0)", "", "json"));
        dz.add(new SqlFunctions("JSON_PRETTY", "mysql", "", "Print a JSON document in human-readable format", "", "json"));
        dz.add(new SqlFunctions("JSON_QUOTE", "mysql", "", "Quote JSON document", "", "json"));
        dz.add(new SqlFunctions("JSON_REMOVE", "mysql", "", "Remove data from JSON document", "", "json"));
        dz.add(new SqlFunctions("JSON_REPLACE", "mysql", "", "Replace values in JSON document", "", "json"));
        dz.add(new SqlFunctions("JSON_SCHEMA_VALID", "mysql", "", "Validate JSON document against JSON schema; returns TRUE/1 if      document validates against schema, or FALSE/0 if it does not", "", "json"));
        dz.add(new SqlFunctions("JSON_SCHEMA_VALIDATION_REPORT", "mysql", "", "Validate JSON document against JSON schema; returns report in JSON      format on outcome on validation including success or failure and      reasons for failure", "", "json"));
        dz.add(new SqlFunctions("JSON_SEARCH", "mysql", "", "Path to value within JSON document", "", "json"));
        dz.add(new SqlFunctions("JSON_SET", "mysql", "", "Insert data into JSON document", "", "json"));
        dz.add(new SqlFunctions("JSON_STORAGE_FREE", "mysql", "", "Freed space within binary representation of JSON column value      following partial update", "", "json"));
        dz.add(new SqlFunctions("JSON_STORAGE_SIZE", "mysql", "", "Space used for storage of binary representation of a JSON document", "", "json"));
        dz.add(new SqlFunctions("JSON_TABLE", "mysql", "", "Return data from a JSON expression as a relational table", "", "json"));
        dz.add(new SqlFunctions("JSON_TYPE", "mysql", "", "Type of JSON value", "", "json"));
        dz.add(new SqlFunctions("JSON_UNQUOTE", "mysql", "", "Unquote JSON value", "", "json"));
        dz.add(new SqlFunctions("JSON_VALID", "mysql", "", "Whether JSON value is valid", "", "json"));
        dz.add(new SqlFunctions("JSON_VALUE", "mysql", "", "Extract value from JSON document at location pointed to by path      provided; return this value as VARCHAR(512) or specified type", "", "json"));
        dz.add(new SqlFunctions("LAST_INSERT_ID", "mysql", "", "Value of the AUTOINCREMENT column for the last INSERT", "", "misc"));
        dz.add(new SqlFunctions("LCASE", "mysql", "", "Synonym for LOWER()", "", "misc"));
        dz.add(new SqlFunctions("LENGTH", "mysql", "", "Return the length of a string in bytes", "", "misc"));
        dz.add(new SqlFunctions("LIKE", "mysql", "", "Simple pattern matching", "", "misc"));
        dz.add(new SqlFunctions("LOAD_FILE", "mysql", "", "Load the named file", "", "misc"));
        dz.add(new SqlFunctions("LOG2", "mysql", "", "Return the base-2 logarithm of the argument", "", "math"));
        dz.add(new SqlFunctions("LineString", "mysql", "", "Construct LineString from Point values", "", "geo"));
        dz.add(new SqlFunctions("MAKEDATE", "mysql", "", "Create a date from the year and day of year", "", "datetime"));
        dz.add(new SqlFunctions("MAKETIME", "mysql", "", "Create time from hour, minute, second", "", "datetime"));
        dz.add(new SqlFunctions("MAKE_SET", "mysql", "", "Return a set of comma-separated strings that have the      corresponding bit in bits set", "", "misc"));
        dz.add(new SqlFunctions("MASTER_POS_WAIT", "mysql", "", "Block until the replica has read and applied all updates up to the      specified position", "", "misc"));
        dz.add(new SqlFunctions("MATCH", "mysql", "", "Perform full-text search", "", "misc"));
        dz.add(new SqlFunctions("MBRContains", "mysql", "", "Whether MBR of one geometry contains MBR of another", "", "geo"));
        dz.add(new SqlFunctions("MBRCoveredBy", "mysql", "", "Whether one MBR is covered by another", "", "geo"));
        dz.add(new SqlFunctions("MBRCovers", "mysql", "", "Whether one MBR covers another", "", "geo"));
        dz.add(new SqlFunctions("MBRDisjoint", "mysql", "", "Whether MBRs of two geometries are disjoint", "", "geo"));
        dz.add(new SqlFunctions("MBREquals", "mysql", "", "Whether MBRs of two geometries are equal", "", "geo"));
        dz.add(new SqlFunctions("MBRIntersects", "mysql", "", "Whether MBRs of two geometries intersect", "", "geo"));
        dz.add(new SqlFunctions("MBROverlaps", "mysql", "", "Whether MBRs of two geometries overlap", "", "geo"));
        dz.add(new SqlFunctions("MBRTouches", "mysql", "", "Whether MBRs of two geometries touch", "", "geo"));
        dz.add(new SqlFunctions("MBRWithin", "mysql", "", "Whether MBR of one geometry is within MBR of another", "", "geo"));
        dz.add(new SqlFunctions("MD5", "mysql", "", "Calculate MD5 checksum", "", "encryption"));
        dz.add(new SqlFunctions("MICROSECOND", "mysql", "", "Return the microseconds from argument", "", "datetime"));
        dz.add(new SqlFunctions("MID", "mysql", "", "Return a substring starting from the specified position", "", "misc"));
        dz.add(new SqlFunctions("MultiLineString", "mysql", "", "Contruct MultiLineString from LineString values", "", "geo"));
        dz.add(new SqlFunctions("MultiPoint", "mysql", "", "Construct MultiPoint from Point values", "", "geo"));
        dz.add(new SqlFunctions("MultiPolygon", "mysql", "", "Construct MultiPolygon from Polygon values", "", "geo"));
        dz.add(new SqlFunctions("NAME_CONST", "mysql", "", "Cause the column to have the given name", "", "misc"));
        dz.add(new SqlFunctions("NOW", "mysql", "", "Return the current date and time", "", "datetime"));
        dz.add(new SqlFunctions("OCT", "mysql", "", "Return a string containing octal representation of a number", "", "misc"));
        dz.add(new SqlFunctions("ORD", "mysql", "", "Return character code for leftmost character of the argument", "", "misc"));
        dz.add(new SqlFunctions("PERIOD_ADD", "mysql", "", "Add a period to a year-month", "", "datetime"));
        dz.add(new SqlFunctions("PERIOD_DIFF", "mysql", "", "Return the number of months between periods", "", "datetime"));
        dz.add(new SqlFunctions("POSITION", "mysql", "", "Synonym for LOCATE()", "", "misc"));
        dz.add(new SqlFunctions("POW", "mysql", "", "Return the argument raised to the specified power", "", "math"));
        dz.add(new SqlFunctions("PS_CURRENT_THREAD_ID", "mysql", "", "Performance Schema thread ID for current thread", "", "misc"));
        dz.add(new SqlFunctions("PS_THREAD_ID", "mysql", "", "Performance Schema thread ID for given thread", "", "misc"));
        dz.add(new SqlFunctions("Point", "mysql", "", "Construct Point from coordinates", "", "geo"));
        dz.add(new SqlFunctions("Polygon", "mysql", "", "Construct Polygon from LineString arguments", "", "geo"));
        dz.add(new SqlFunctions("QUOTE", "mysql", "", "Escape the argument for use in an SQL statement", "", "misc"));
        dz.add(new SqlFunctions("RANDOM_BYTES", "mysql", "", "Return a random byte vector", "", "encryption"));
        dz.add(new SqlFunctions("REGEXP", "mysql", "", "Whether string matches regular expression", "", "misc"));
        dz.add(new SqlFunctions("REGEXP_INSTR", "mysql", "", "Starting index of substring matching regular expression", "", "misc"));
        dz.add(new SqlFunctions("RELEASE_ALL_LOCKS", "mysql", "", "Release all current named locks", "", "misc"));
        dz.add(new SqlFunctions("RELEASE_LOCK", "mysql", "", "Release the named lock", "", "misc"));
        dz.add(new SqlFunctions("REVERSE", "mysql", "", "Reverse the characters in a string", "", "misc"));
        dz.add(new SqlFunctions("RLIKE", "mysql", "", "Whether string matches regular expression", "", "misc"));
        dz.add(new SqlFunctions("ROLES_GRAPHML", "mysql", "", "Return a GraphML document representing memory role subgraphs", "", "misc"));
        dz.add(new SqlFunctions("ROW_COUNT", "mysql", "", "The number of rows updated", "", "misc"));
        dz.add(new SqlFunctions("SCHEMA", "mysql", "", "Synonym for DATABASE()", "", "misc"));
        dz.add(new SqlFunctions("SEC_TO_TIME", "mysql", "", "Converts seconds to 'hh:mm:ss' format", "", "datetime"));
        dz.add(new SqlFunctions("SESSION_USER", "mysql", "", "Synonym for USER()", "", "misc"));
        dz.add(new SqlFunctions("SHA", "mysql", "", "Calculate an SHA-1 160-bit checksum", "", "encryption"));
        dz.add(new SqlFunctions("SHA2", "mysql", "", "Calculate an SHA-2 checksum", "", "encryption"));
        dz.add(new SqlFunctions("SLEEP", "mysql", "", "Sleep for a number of seconds", "", "misc"));
        dz.add(new SqlFunctions("SOURCE_POS_WAIT", "mysql", "", "Block until the replica has read and applied all updates up to the      specified position", "", "misc"));
        dz.add(new SqlFunctions("STATEMENT_DIGEST", "mysql", "", "Compute statement digest hash value", "", "encryption"));
        dz.add(new SqlFunctions("STATEMENT_DIGEST_TEXT", "mysql", "", "Compute normalized statement digest", "", "encryption"));
        dz.add(new SqlFunctions("STD", "mysql", "", "Return the population standard deviation", "", "aggregate"));
        dz.add(new SqlFunctions("STDDEV", "mysql", "", "Return the population standard deviation", "", "aggregate"));
        dz.add(new SqlFunctions("STRCMP", "mysql", "", "Compare two strings", "", "misc"));
        dz.add(new SqlFunctions("STR_TO_DATE", "mysql", "", "Convert a string to a date", "", "datetime"));
        dz.add(new SqlFunctions("ST_Area", "mysql", "", "Return Polygon or MultiPolygon area", "", "geo"));
        dz.add(new SqlFunctions("ST_AsGeoJSON", "mysql", "", "Generate GeoJSON object from geometry", "", "geo"));
        dz.add(new SqlFunctions("ST_AsWKB", "mysql", "", "Convert from internal geometry format to WKB", "", "geo"));
        dz.add(new SqlFunctions("ST_AsWKT", "mysql", "", "Convert from internal geometry format to WKT", "", "geo"));
        dz.add(new SqlFunctions("ST_Buffer", "mysql", "", "Return geometry of points within given distance from geometry", "", "geo"));
        dz.add(new SqlFunctions("ST_Buffer_Strategy", "mysql", "", "Produce strategy option for ST_Buffer()", "", "geo"));
        dz.add(new SqlFunctions("ST_Centroid", "mysql", "", "Return centroid as a point", "", "geo"));
        dz.add(new SqlFunctions("ST_Collect", "mysql", "", "Aggregate spatial values into collection", "", "geo"));
        dz.add(new SqlFunctions("ST_Contains", "mysql", "", "Whether one geometry contains another", "", "geo"));
        dz.add(new SqlFunctions("ST_ConvexHull", "mysql", "", "Return convex hull of geometry", "", "geo"));
        dz.add(new SqlFunctions("ST_Crosses", "mysql", "", "Whether one geometry crosses another", "", "geo"));
        dz.add(new SqlFunctions("ST_Difference", "mysql", "", "Return point set difference of two geometries", "", "geo"));
        dz.add(new SqlFunctions("ST_Dimension", "mysql", "", "Dimension of geometry", "", "geo"));
        dz.add(new SqlFunctions("ST_Disjoint", "mysql", "", "Whether one geometry is disjoint from another", "", "geo"));
        dz.add(new SqlFunctions("ST_Distance", "mysql", "", "The distance of one geometry from another", "", "geo"));
        dz.add(new SqlFunctions("ST_Distance_Sphere", "mysql", "", "Minimum distance on earth between two geometries", "", "geo"));
        dz.add(new SqlFunctions("ST_EndPoint", "mysql", "", "End Point of LineString", "", "geo"));
        dz.add(new SqlFunctions("ST_Envelope", "mysql", "", "Return MBR of geometry", "", "geo"));
        dz.add(new SqlFunctions("ST_Equals", "mysql", "", "Whether one geometry is equal to another", "", "geo"));
        dz.add(new SqlFunctions("ST_ExteriorRing", "mysql", "", "Return exterior ring of Polygon", "", "geo"));
        dz.add(new SqlFunctions("ST_FrechetDistance", "mysql", "", "The discrete Fr\u00c3\u00a9chet distance of one geometry from another", "", "geo"));
        dz.add(new SqlFunctions("ST_GeoHash", "mysql", "", "Produce a geohash value", "", "geo"));
        dz.add(new SqlFunctions("ST_GeomCollFromTxt", "mysql", "", "Return geometry collection from WKT", "", "geo"));
        dz.add(new SqlFunctions("ST_GeomFromGeoJSON", "mysql", "", "Generate geometry from GeoJSON object", "", "geo"));
        dz.add(new SqlFunctions("ST_GeometryCollectionFromWKB", "mysql", "", "Return geometry collection from WKB", "", "geo"));
        dz.add(new SqlFunctions("ST_GeometryFromText", "mysql", "", "Return geometry from WKT", "", "geo"));
        dz.add(new SqlFunctions("ST_GeometryFromWKB", "mysql", "", "Return geometry from WKB", "", "geo"));
        dz.add(new SqlFunctions("ST_GeometryN", "mysql", "", "Return N-th geometry from geometry collection", "", "geo"));
        dz.add(new SqlFunctions("ST_GeometryType", "mysql", "", "Return name of geometry type", "", "geo"));
        dz.add(new SqlFunctions("ST_HausdorffDistance", "mysql", "", "The discrete Hausdorff distance of one geometry from another", "", "geo"));
        dz.add(new SqlFunctions("ST_InteriorRingN", "mysql", "", "Return N-th interior ring of Polygon", "", "geo"));
        dz.add(new SqlFunctions("ST_Intersection", "mysql", "", "Return point set intersection of two geometries", "", "geo"));
        dz.add(new SqlFunctions("ST_Intersects", "mysql", "", "Whether one geometry intersects another", "", "geo"));
        dz.add(new SqlFunctions("ST_IsClosed", "mysql", "", "Whether a geometry is closed and simple", "", "geo"));
        dz.add(new SqlFunctions("ST_IsEmpty", "mysql", "", "Whether a geometry is empty", "", "geo"));
        dz.add(new SqlFunctions("ST_IsSimple", "mysql", "", "Whether a geometry is simple", "", "geo"));
        dz.add(new SqlFunctions("ST_IsValid", "mysql", "", "Whether a geometry is valid", "", "geo"));
        dz.add(new SqlFunctions("ST_LatFromGeoHash", "mysql", "", "Return latitude from geohash value", "", "geo"));
        dz.add(new SqlFunctions("ST_Latitude", "mysql", "", "Return latitude of Point", "", "geo"));
        dz.add(new SqlFunctions("ST_Length", "mysql", "", "Return length of LineString", "", "geo"));
        dz.add(new SqlFunctions("ST_LineInterpolatePoint", "mysql", "", "The point a given percentage along a LineString", "", "geo"));
        dz.add(new SqlFunctions("ST_LineInterpolatePoints", "mysql", "", "The points a given percentage along a LineString", "", "geo"));
        dz.add(new SqlFunctions("ST_LineStringFromText", "mysql", "", "Construct LineString from WKT", "", "geo"));
        dz.add(new SqlFunctions("ST_LineStringFromWKB", "mysql", "", "Construct LineString from WKB", "", "geo"));
        dz.add(new SqlFunctions("ST_LongFromGeoHash", "mysql", "", "Return longitude from geohash value", "", "geo"));
        dz.add(new SqlFunctions("ST_Longitude", "mysql", "", "Return longitude of Point", "", "geo"));
        dz.add(new SqlFunctions("ST_MakeEnvelope", "mysql", "", "Rectangle around two points", "", "geo"));
        dz.add(new SqlFunctions("ST_MultiLineStringFromText", "mysql", "", "Construct MultiLineString from WKT", "", "geo"));
        dz.add(new SqlFunctions("ST_MultiLineStringFromWKB", "mysql", "", "Construct MultiLineString from WKB", "", "geo"));
        dz.add(new SqlFunctions("ST_MultiPointFromText", "mysql", "", "Construct MultiPoint from WKT", "", "geo"));
        dz.add(new SqlFunctions("ST_MultiPointFromWKB", "mysql", "", "Construct MultiPoint from WKB", "", "geo"));
        dz.add(new SqlFunctions("ST_MultiPolygonFromText", "mysql", "", "Construct MultiPolygon from WKT", "", "geo"));
        dz.add(new SqlFunctions("ST_MultiPolygonFromWKB", "mysql", "", "Construct MultiPolygon from WKB", "", "geo"));
        dz.add(new SqlFunctions("ST_NumGeometries", "mysql", "", "Return number of geometries in geometry collection", "", "geo"));
        dz.add(new SqlFunctions("ST_NumInteriorRings", "mysql", "", "Return number of interior rings in Polygon", "", "geo"));
        dz.add(new SqlFunctions("ST_NumPoints", "mysql", "", "Return number of points in LineString", "", "geo"));
        dz.add(new SqlFunctions("ST_Overlaps", "mysql", "", "Whether one geometry overlaps another", "", "geo"));
        dz.add(new SqlFunctions("ST_PointAtDistance", "mysql", "", "The point a given distance along a LineString", "", "geo"));
        dz.add(new SqlFunctions("ST_PointFromGeoHash", "mysql", "", "Convert geohash value to POINT value", "", "geo"));
        dz.add(new SqlFunctions("ST_PointFromText", "mysql", "", "Construct Point from WKT", "", "geo"));
        dz.add(new SqlFunctions("ST_PointFromWKB", "mysql", "", "Construct Point from WKB", "", "geo"));
        dz.add(new SqlFunctions("ST_PointN", "mysql", "", "Return N-th point from LineString", "", "geo"));
        dz.add(new SqlFunctions("ST_PolygonFromText", "mysql", "", "Construct Polygon from WKT", "", "geo"));
        dz.add(new SqlFunctions("ST_PolygonFromWKB", "mysql", "", "Construct Polygon from WKB", "", "geo"));
        dz.add(new SqlFunctions("ST_SRID", "mysql", "", "Return spatial reference system ID for geometry", "", "geo"));
        dz.add(new SqlFunctions("ST_Simplify", "mysql", "", "Return simplified geometry", "", "geo"));
        dz.add(new SqlFunctions("ST_StartPoint", "mysql", "", "Start Point of LineString", "", "geo"));
        dz.add(new SqlFunctions("ST_SwapXY", "mysql", "", "Return argument with X/Y coordinates swapped", "", "geo"));
        dz.add(new SqlFunctions("ST_SymDifference", "mysql", "", "Return point set symmetric difference of two geometries", "", "geo"));
        dz.add(new SqlFunctions("ST_Touches", "mysql", "", "Whether one geometry touches another", "", "geo"));
        dz.add(new SqlFunctions("ST_Transform", "mysql", "", "Transform coordinates of geometry", "", "geo"));
        dz.add(new SqlFunctions("ST_Union", "mysql", "", "Return point set union of two geometries", "", "geo"));
        dz.add(new SqlFunctions("ST_Validate", "mysql", "", "Return validated geometry", "", "geo"));
        dz.add(new SqlFunctions("ST_Within", "mysql", "", "Whether one geometry is within another", "", "geo"));
        dz.add(new SqlFunctions("ST_X", "mysql", "", "Return X coordinate of Point", "", "geo"));
        dz.add(new SqlFunctions("ST_Y", "mysql", "", "Return Y coordinate of Point", "", "geo"));
        dz.add(new SqlFunctions("SUBDATE", "mysql", "", "Synonym for DATE_SUB() when invoked with three arguments", "", "datetime"));
        dz.add(new SqlFunctions("SUBSTR", "mysql", "", "Return the substring as specified", "", "misc"));
        dz.add(new SqlFunctions("SUBSTRING_INDEX", "mysql", "", "Return a substring from a string before the specified number of      occurrences of the delimiter", "", "misc"));
        dz.add(new SqlFunctions("SYSDATE", "mysql", "", "Return the time at which the function executes", "", "datetime"));
        dz.add(new SqlFunctions("SYSTEM_USER", "mysql", "", "Synonym for USER()", "", "misc"));
        dz.add(new SqlFunctions("TIMESTAMPADD", "mysql", "", "Add an interval to a datetime expression", "", "datetime"));
        dz.add(new SqlFunctions("TIMESTAMPDIFF", "mysql", "", "Return the difference of two datetime expressions, using the units      specified", "", "datetime"));
        dz.add(new SqlFunctions("TIME_FORMAT", "mysql", "", "Format as time", "", "datetime"));
        dz.add(new SqlFunctions("TIME_TO_SEC", "mysql", "", "Return the argument converted to seconds", "", "datetime"));
        dz.add(new SqlFunctions("TO_BASE64", "mysql", "", "Return the argument converted to a base-64 string", "", "misc"));
        dz.add(new SqlFunctions("TO_DAYS", "mysql", "", "Return the date argument converted to days", "", "datetime"));
        dz.add(new SqlFunctions("TO_SECONDS", "mysql", "", "Return the date or datetime argument converted to seconds since      Year 0", "", "datetime"));
        dz.add(new SqlFunctions("TRUNCATE", "mysql", "", "Truncate to specified number of decimal places", "", "math"));
        dz.add(new SqlFunctions("UCASE", "mysql", "", "Synonym for UPPER()", "", "misc"));
        dz.add(new SqlFunctions("UNCOMPRESS", "mysql", "", "Uncompress a string compressed", "", "encryption"));
        dz.add(new SqlFunctions("UNCOMPRESSED_LENGTH", "mysql", "", "Return the length of a string before compression", "", "encryption"));
        dz.add(new SqlFunctions("UNHEX", "mysql", "", "Return a string containing hex representation of a number", "", "misc"));
        dz.add(new SqlFunctions("UNIX_TIMESTAMP", "mysql", "", "Return a Unix timestamp", "", "datetime"));
        dz.add(new SqlFunctions("USER", "mysql", "", "The user name and host name provided by the client", "", "misc"));
        dz.add(new SqlFunctions("UTC_DATE", "mysql", "", "Return the current UTC date", "", "datetime"));
        dz.add(new SqlFunctions("UTC_TIME", "mysql", "", "Return the current UTC time", "", "datetime"));
        dz.add(new SqlFunctions("UTC_TIMESTAMP", "mysql", "", "Return the current UTC date and time", "", "datetime"));
        dz.add(new SqlFunctions("UUID_SHORT", "mysql", "", "Return an integer-valued universal identifier", "", "misc"));
        dz.add(new SqlFunctions("UUID_TO_BIN", "mysql", "", "Convert string UUID to binary", "", "misc"));
        dz.add(new SqlFunctions("UpdateXML", "mysql", "", "Return replaced XML fragment", "", "misc"));
        dz.add(new SqlFunctions("VALIDATE_PASSWORD_STRENGTH", "mysql", "", "Determine strength of password", "", "encryption"));
        dz.add(new SqlFunctions("VALUES", "mysql", "", "Define the values to be used during an INSERT", "", "misc"));
        dz.add(new SqlFunctions("VARIANCE", "mysql", "", "Return the population standard variance", "", "aggregate"));
        dz.add(new SqlFunctions("VERSION", "mysql", "", "Return a string that indicates the MySQL server version", "", "misc"));
        dz.add(new SqlFunctions("WAIT_FOR_EXECUTED_GTID_SET", "mysql", "", "Wait until the given GTIDs have executed on the replica.", "", "misc"));
        dz.add(new SqlFunctions("WEEKDAY", "mysql", "", "Return the weekday index", "", "datetime"));
        dz.add(new SqlFunctions("WEEKOFYEAR", "mysql", "", "Return the calendar week of the date (1-53)", "", "datetime"));
        dz.add(new SqlFunctions("WEIGHT_STRING", "mysql", "", "Return the weight string for a string", "", "misc"));
        dz.add(new SqlFunctions("YEARWEEK", "mysql", "", "Return the year and week", "", "datetime"));
        dz.add(new SqlFunctions("asynchronous_connection_failover_add_managed", "mysql", "", "Add group member source server configuration information to a      replication channel source list", "", "misc"));
        dz.add(new SqlFunctions("asynchronous_connection_failover_add_source", "mysql", "", "Add source server configuration information server to a      replication channel source list", "", "misc"));
        dz.add(new SqlFunctions("asynchronous_connection_failover_delete_managed", "mysql", "", "Remove a managed group from a replication channel source list", "", "misc"));
        dz.add(new SqlFunctions("asynchronous_connection_failover_delete_source", "mysql", "", "Remove a source server from a replication channel source list", "", "misc"));
        dz.add(new SqlFunctions("asynchronous_connection_failover_reset", "mysql", "", "Remove all settings relating to group replication asynchronous      failover", "", "misc"));
        dz.add(new SqlFunctions("group_replication_disable_member_action", "mysql", "", "Disable member action for event specified", "", "misc"));
        dz.add(new SqlFunctions("group_replication_enable_member_action", "mysql", "", "Enable member action for event specified", "", "misc"));
        dz.add(new SqlFunctions("group_replication_get_communication_protocol", "mysql", "", "Get version of group replication communication protocol currently      in use", "", "misc"));
        dz.add(new SqlFunctions("group_replication_get_write_concurrency", "mysql", "", "Get maximum number of consensus instances currently set for group", "", "misc"));
        dz.add(new SqlFunctions("group_replication_reset_member_actions", "mysql", "", "Reset all member actions to defaults and configuration version      number to 1", "", "misc"));
        dz.add(new SqlFunctions("group_replication_set_as_primary", "mysql", "", "Make a specific group member the primary", "", "misc"));
        dz.add(new SqlFunctions("group_replication_set_communication_protocol", "mysql", "", "Set version for group replication communication protocol to use", "", "misc"));
        dz.add(new SqlFunctions("group_replication_set_write_concurrency", "mysql", "", "Set maximum number of consensus instances that can be executed in      parallel", "", "misc"));
        dz.add(new SqlFunctions("group_replication_switch_to_multi_primary_mode", "mysql", "", "Changes the mode of a group running in single-primary mode to      multi-primary mode", "", "misc"));
        dz.add(new SqlFunctions("group_replication_switch_to_single_primary_mode", "mysql", "", "Changes the mode of a group running in multi-primary mode to      single-primary mode", "", "misc"));
        dz.add(new SqlFunctions("print", "mysql", "", "Graphic or space characters", "", "pattern"));
        dz.add(new SqlFunctions("space", "mysql", "", "Space, tab, newline, and carriage return", "", "pattern"));
        dz.add(new SqlFunctions("validate_password", "mysql", "", "Length &lt; 4", "", "encryption"));
        dz.add(new SqlFunctions("xdigit", "mysql", "", "Hexadecimal digit characters", "", "pattern"));
        dz.add(new SqlFunctions("btrim", "postgresql", "", "Remove the longest string consisting only of          characters in <tt class=\"PARAMETER\">characters</tt> (a          space by default) from the start and end of <tt class=          \"PARAMETER\">string</tt></td>", "btrim('xyxtrimyyx',          'xy')", "string"));
        dz.add(new SqlFunctions("char_length", "postgresql", "", "Number of characters in string</td>", "char_length('jose')", "string"));
        dz.add(new SqlFunctions("convert", "postgresql", "", "Convert string to <tt class=          \"PARAMETER\">dest_encoding</tt>. The original encoding is          specified by <tt class=\"PARAMETER\">src_encoding</tt>. The          <tt class=\"PARAMETER\">string</tt> must be valid in this          encoding. Conversions can be defined by <tt class=          \"COMMAND\">CREATE CONVERSION</tt>. Also there are some          predefined conversions. See <a href=          \"functions-string.html#CONVERSION-NAMES\">Table 9-8</a>          for available conversions.</td>", "convert('text_in_utf8', 'UTF8',          'LATIN1')", "string"));
        dz.add(new SqlFunctions("convert_from", "postgresql", "", "Convert string to the database encoding. The original          encoding is specified by <tt class=          \"PARAMETER\">src_encoding</tt>. The <tt class=          \"PARAMETER\">string</tt> must be valid in this          encoding.</td>", "convert_from('text_in_utf8',          'UTF8')", "string"));
        dz.add(new SqlFunctions("convert_to", "postgresql", "", "Convert string to <tt class=          \"PARAMETER\">dest_encoding</tt>.</td>", "convert_to('some text',          'UTF8')", "string"));
        dz.add(new SqlFunctions("div", "postgresql", "", "integer quotient of <tt class=          \"PARAMETER\">y</tt>/<tt class=\"PARAMETER\">x</tt></td>", "div(9,4)", "math"));
        dz.add(new SqlFunctions("initcap", "postgresql", "", "Convert the first letter of each word to upper case          and the rest to lower case. Words are sequences of          alphanumeric characters separated by non-alphanumeric          characters.</td>", "initcap('hi THOMAS')", "string"));
        dz.add(new SqlFunctions("pg_client_encoding", "postgresql", "", "Current client encoding name</td>", "pg_client_encoding()", "string"));
        dz.add(new SqlFunctions("quote_ident", "postgresql", "", "Return the given string suitably quoted to be used as          an identifier in an <acronym class=          \"ACRONYM\">SQL</acronym> statement string. Quotes are          added only if necessary (i.e., if the string contains          non-identifier characters or would be case-folded).          Embedded quotes are properly doubled. See also <a href=          \"plpgsql-statements.html#PLPGSQL-QUOTE-LITERAL-EXAMPLE\">Example          39-1</a>.</td>", "quote_ident('Foo bar')", "string"));
        dz.add(new SqlFunctions("quote_literal", "postgresql", "", "Return the given string suitably quoted to be used as          a string literal in an <acronym class=          \"ACRONYM\">SQL</acronym> statement string. Embedded          single-quotes and backslashes are properly doubled. Note          that <code class=\"FUNCTION\">quote_literal</code> returns          null on null input; if the argument might be null,          <code class=\"FUNCTION\">quote_nullable</code> is often          more suitable. See also <a href=          \"plpgsql-statements.html#PLPGSQL-QUOTE-LITERAL-EXAMPLE\">Example          39-1</a>.</td>", "quote_literal(E'O\\'Reilly')", "string"));
        dz.add(new SqlFunctions("quote_nullable", "postgresql", "", "Return the given string suitably quoted to be used as          a string literal in an <acronym class=          \"ACRONYM\">SQL</acronym> statement string; or, if the          argument is null, return <tt class=\"LITERAL\">NULL</tt>.          Embedded single-quotes and backslashes are properly          doubled. See also <a href=          \"plpgsql-statements.html#PLPGSQL-QUOTE-LITERAL-EXAMPLE\">Example          39-1</a>.</td>", "quote_nullable(NULL)", "string"));
        dz.add(new SqlFunctions("regexp_split_to_table", "postgresql", "", "Split <tt class=\"PARAMETER\">string</tt> using a POSIX          regular expression as the delimiter. See <a href=          \"functions-matching.html#FUNCTIONS-POSIX-REGEXP\">Section          9.7.3</a> for more information.</td>", "regexp_split_to_table('hello          world', E'\\\\s+')", "string"));
        dz.add(new SqlFunctions("to_ascii", "postgresql", "", "Convert <tt class=\"PARAMETER\">string</tt> to          <acronym class=\"ACRONYM\">ASCII</acronym> from another          encoding (only supports conversion from <tt class=          \"LITERAL\">LATIN1</tt>, <tt class=\"LITERAL\">LATIN2</tt>,          <tt class=\"LITERAL\">LATIN9</tt>, and <tt class=          \"LITERAL\">WIN1250</tt> encodings)</td>", "to_ascii('Karel')", "string"));
        dz.add(new SqlFunctions("to_hex", "postgresql", "", "Convert <tt class=\"PARAMETER\">number</tt> to its          equivalent hexadecimal representation</td>", "to_hex(2147483647)", "string"));
        dz.add(new SqlFunctions("translate", "postgresql", "", "Any character in <tt class=\"PARAMETER\">string</tt>          that matches a character in the <tt class=          \"PARAMETER\">from</tt> set is replaced by the          corresponding character in the <tt class=          \"PARAMETER\">to</tt> set. If <tt class=          \"PARAMETER\">from</tt> is longer than <tt class=          \"PARAMETER\">to</tt>, occurrences of the extra characters          in <tt class=\"PARAMETER\">from</tt> are removed.</td>", "translate('12345', '143',          'ax')", "string"));
        dz.add(new SqlFunctions("width_bucket", "postgresql", "", "return the bucket to which <tt class=          \"PARAMETER\">operand</tt> would be assigned in an          equidepth histogram with <tt class=\"PARAMETER\">count</tt>          buckets, in the range <tt class=\"PARAMETER\">b1</tt> to          <tt class=\"PARAMETER\">b2</tt></td>", "width_bucket(5.35, 0.024, 10.06,          5)", "math"));
        dz.add(new SqlFunctions("abs", "sqlite", "abs( X )", "<p>  The abs(X) function returns the absolute value of the numeric  argument X.  Abs(X) returns NULL if X is NULL.  Abs(X) returns 0.0 if X is a string or blob  that cannot be converted to a numeric value.  If X is the  integer -9223372036854775808 then abs(X) throws an integer overflow  error since there is no equivalent positive 64-bit two complement value.", "", "scalar"));
        dz.add(new SqlFunctions("acosh", "sqlite", "acosh( X )", "<p>  Return the hyperbolic arccosine of X.", "", "math"));
        dz.add(new SqlFunctions("asinh", "sqlite", "asinh( X )", "<p>  Return the hyperbolic arcsine of X.", "", "math"));
        dz.add(new SqlFunctions("atanh", "sqlite", "atanh( X )", "<p>  Return the hyperbolic arctangent of X.", "", "math"));
        dz.add(new SqlFunctions("avg", "sqlite", "avg( X )", "<p>  The avg() function  returns the average value of all non-NULL <i>X</i> within a  group.  String and BLOB values that do not look like numbers are  interpreted as 0.  The result of avg() is always a floating point value whenever  there is at least one non-NULL input even if all  inputs are integers.  The result of avg() is NULL if  there are no non-NULL inputs.  The result of avg() is computed  as <a href=\"lang_aggfunc.html#sumunc\">total()</a>/<a href=\"lang_aggfunc.html#count\">count()</a> so all of the constraints that apply to  <a href=\"lang_aggfunc.html#sumunc\">total()</a> also apply to avg().", "", "aggregate"));
        dz.add(new SqlFunctions("changes", "sqlite", "changes()", "<p>  The changes() function returns the number of database rows that were changed  or inserted or deleted by the most recently completed INSERT, DELETE,  or UPDATE statement, exclusive of statements in lower-level triggers.  The changes() SQL function is a wrapper around the <a href=\"c3ref/changes.html\">sqlite3_changes64()</a>  C/C++ function and hence follows the same rules for counting changes.", "", "scalar"));
        dz.add(new SqlFunctions("char", "sqlite", "char( X1 , X2 ,..., XN )", "<p>  The char(X1,X2,...,XN) function returns a string composed of characters having the   unicode code point values of integers X1 through XN, respectively.", "", "scalar"));
        dz.add(new SqlFunctions("cosh", "sqlite", "cosh( X )", "<p>  Return the hyperbolic cosine of X.", "", "math"));
        dz.add(new SqlFunctions("count", "sqlite", "count( X ) count(*)", "<p>  The count(X) function returns  a count of the number of times  that <i>X</i> is not NULL in a group.  The count(*) function  (with no arguments) returns the total number of rows in the group.", "", "aggregate"));
        dz.add(new SqlFunctions("cume_dist", "sqlite", "cume_dist()", "<p> The cumulative distribution. Calculated as       <i>row-number</i>/<i>partition-rows</i>, where <i>row-number</i> is       the value returned by row_number() for the last peer in the group       and <i>partition-rows</i> the number of rows in the partition.  </p>", "", "window"));
        dz.add(new SqlFunctions("dense_rank", "sqlite", "dense_rank()", "<p> The number of the current row's peer group within its partition - the       rank of the current row without gaps. Rows are numbered starting       from 1 in the order defined by the ORDER BY clause in the window       definition. If there is no ORDER BY clause, then all rows are       considered peers and this function always returns 1.  </p>", "", "window"));
        dz.add(new SqlFunctions("first_value", "sqlite", "first_value(expr)", "<p> This built-in window function calculates the window frame for each       row in the same way as an aggregate window function. It returns the       value of <i>expr</i> evaluated against the first row in the window frame       for each row.  </p>", "", "window"));
        dz.add(new SqlFunctions("group_concat", "sqlite", "group_concat( X ) group_concat( X , Y ) string_agg( X , Y )", "<p>  The group_concat() function returns  a string which is the concatenation of  all non-NULL values of <i>X</i>.  If parameter <i>Y</i> is present then  it is used as the separator  between instances of <i>X</i>.A comma (\",\") is used as the separator  if <i>Y</i> is omitted.  <p>  The string_agg(X,Y) function is an alias  for group_concat(X,Y).  String_agg() is compatible with PostgreSQL  and SQL-Server and group_concat() is compatible with MySQL.  <p>  The order of the concatenated elements is arbitrary unless an  ORDER BY argument is included immediately after the last parameter.", "", "aggregate"));
        dz.add(new SqlFunctions("hex", "sqlite", "hex( X )", "<p>  The hex() function interprets its argument as a BLOB and returns  a string which is the upper-case hexadecimal rendering of the content of  that blob.  <p>  If the argument <i>X</i> in \"hex(<i>X</i>)\" is an  integer or floating point number, then \"interprets its argument as a BLOB\" means  that the binary number is first converted into a UTF8 text representation, then  that text is interpreted as a BLOB.  Hence, \"hex(12345678)\" renders  as \"3132333435363738\" not the binary representation of the integer value  \"0000000000BC614E\".  <p>  See also:  <a href=\"lang_corefunc.html#unhex\">unhex()</a>", "", "scalar"));
        dz.add(new SqlFunctions("iif", "sqlite", "iif( X , Y , Z )", "<p>  The iif(X,Y,Z) function returns the value Y if X is true, and Z otherwise.  The iif(X,Y,Z) function is logically equivalent to and generates the same  <a href=\"opcode.html\">bytecode</a> as the <a href=\"lang_expr.html#case\">CASE expression</a> \"CASE WHEN X THEN Y ELSE Z END\".", "", "scalar"));
        dz.add(new SqlFunctions("lag", "sqlite", "lag(expr)<br>lag(expr, offset)<br>lag(expr, offset, default)", "<p> The first form of the lag() function returns the result of evaluating       expression <i>expr</i> against the previous row in the partition. Or, if       there is no previous row (because the current row is the first), NULL.      </p><p> If the <i>offset</i> argument is provided, then it must be a       non-negative integer. In this case the value returned is the result       of evaluating <i>expr</i> against the row <i>offset</i> rows before the       current row within the partition. If <i>offset</i> is 0, then       <i>expr</i> is evaluated against the current row. If there is no row       <i>offset</i> rows before the current row, NULL is returned.      </p><p> If <i>default</i> is also provided, then it is returned instead of      NULL if the row identified by <i>offset</i> does not exist.  </p>", "", "window"));
        dz.add(new SqlFunctions("last_insert_rowid", "sqlite", "last_insert_rowid()", "<p>  The last_insert_rowid() function returns the <a href=\"lang_createtable.html#rowid\">ROWID</a>  of the last row insert from the database connection which invoked the  function.  The last_insert_rowid() SQL function is a wrapper around the  <a href=\"c3ref/last_insert_rowid.html\">sqlite3_last_insert_rowid()</a> C/C++ interface function.", "", "scalar"));
        dz.add(new SqlFunctions("last_value", "sqlite", "last_value(expr)", "<p> This built-in window function calculates the window frame for each       row in the same way as an aggregate window function. It returns the       value of <i>expr</i> evaluated against the last row in the window frame       for each row.  </p>", "", "window"));
        dz.add(new SqlFunctions("lead", "sqlite", "lead(expr)<br>lead(expr, offset)<br>lead(expr, offset, default)", "<p> The first form of the lead() function returns the result of evaluating       expression <i>expr</i> against the next row in the partition. Or, if       there is no next row (because the current row is the last), NULL.      </p><p> If the <i>offset</i> argument is provided, then it must be a       non-negative integer. In this case the value returned is the result       of evaluating <i>expr</i> against the row <i>offset</i> rows after the       current row within the partition. If <i>offset</i> is 0, then       <i>expr</i> is evaluated against the current row. If there is no row       <i>offset</i> rows after the current row, NULL is returned.      </p><p> If <i>default</i> is also provided, then it is returned instead of      NULL if the row identified by <i>offset</i> does not exist.  </p>", "", "window"));
        dz.add(new SqlFunctions("like", "sqlite", "like( X , Y ) like( X , Y , Z )", "<p>  The like() function is used to implement the  \"<b>Y LIKE X &#91;ESCAPE Z&#93;</b>\" expression.   If the optional ESCAPE clause is present, then the  like() function is invoked with three arguments.  Otherwise, it is  invoked with two arguments only. Note that the X and Y parameters are  reversed in the like() function relative to the infix <a href=\"lang_expr.html#like\">LIKE</a> operator.  X is the pattern and Y is the string to match against that pattern.  Hence, the following expressions are equivalent:  <blockquote><pre>     name LIKE '%neon%'     like('%neon%',name)  </pre></blockquote>  <p>The <a href=\"c3ref/create_function.html\">sqlite3_create_function()</a> interface can be used to override the  like() function and thereby change the operation of the  <a href=\"lang_expr.html#like\">LIKE</a> operator.  When overriding the like() function, it may be important  to override both the two and three argument versions of the like()   function. Otherwise, different code may be called to implement the  <a href=\"lang_expr.html#like\">LIKE</a> operator depending on whether or not an ESCAPE clause was   specified.", "", "scalar"));
        dz.add(new SqlFunctions("likelihood", "sqlite", "likelihood( X , Y )", "<p>  The likelihood(X,Y) function returns argument X unchanged.  The value Y in likelihood(X,Y) must be a floating point constant  between 0.0 and 1.0, inclusive.  The likelihood(X) function is a no-op that the code generator  optimizes away so that it consumes no CPU cycles during run-time  (that is, during calls to <a href=\"c3ref/step.html\">sqlite3_step()</a>).  The purpose of the likelihood(X,Y) function is to provide a hint  to the query planner that the argument X is a boolean that is  true with a probability of approximately Y.  The <a href=\"lang_corefunc.html#unlikely\">unlikely(X)</a> function is short-hand for likelihood(X,0.0625).  The <a href=\"lang_corefunc.html#likely\">likely(X)</a> function is short-hand for likelihood(X,0.9375).", "", "scalar"));
        dz.add(new SqlFunctions("likely", "sqlite", "likely( X )", "<p>  The likely(X) function returns the argument X unchanged.  The likely(X) function is a no-op that the code generator  optimizes away so that it consumes no CPU cycles at  run-time (that is, during calls to <a href=\"c3ref/step.html\">sqlite3_step()</a>).  The purpose of the likely(X) function is to provide a hint  to the query planner that the argument X is a boolean value  that is usually true. The likely(X) function is equivalent  to <a href=\"lang_corefunc.html#likelihood\">likelihood</a>(X,0.9375). See also: <a href=\"lang_corefunc.html#unlikely\">unlikely(X)</a>.", "", "scalar"));
        dz.add(new SqlFunctions("load_extension", "sqlite", "load_extension( X ) load_extension( X , Y )", "<p>  The load_extension(X,Y) function loads <a href=\"loadext.html\">SQLite extensions</a> out of the shared  library file named X using the entry point Y.  The result of load_extension()  is always a NULL.  If Y is omitted then the default entry point name is used.  The load_extension() function raises an exception if the extension fails to  load or initialize correctly.  <p>The load_extension() function will fail if the extension attempts to   modify or delete an SQL function or collating sequence.  The  extension can add new functions or collating sequences, but cannot  modify or delete existing functions or collating sequences because  those functions and/or collating sequences might be used elsewhere  in the currently running SQL statement.  To load an extension that  changes or deletes functions or collating sequences, use the  <a href=\"c3ref/load_extension.html\">sqlite3_load_extension()</a> C-language API.</p>  <p>For security reasons, extension loading is disabled by default and must  be enabled by a prior call to <a href=\"c3ref/enable_load_extension.html\">sqlite3_enable_load_extension()</a>.</p>", "", "scalar"));
        dz.add(new SqlFunctions("max", "sqlite", "max( X , Y ,...)", "<p>  The multi-argument max() function returns the argument with the   maximum value, or return NULL if any argument is NULL.   The multi-argument max() function searches its arguments from left to right  for an argument that defines a collating function and uses that collating  function for all string comparisons.  If none of the arguments to max()  define a collating function, then the BINARY collating function is used.  Note that <b>max()</b> is a simple function when  it has 2 or more arguments but operates as an  <a href=\"lang_aggfunc.html#max_agg\">aggregate function</a> if given only a single argument.", "", "aggregate"));
        dz.add(new SqlFunctions("min", "sqlite", "min( X , Y ,...)", "<p>  The multi-argument min() function returns the argument with the  minimum value.  The multi-argument min() function searches its arguments from left to right  for an argument that defines a collating function and uses that collating  function for all string comparisons.  If none of the arguments to min()  define a collating function, then the BINARY collating function is used.  Note that <b>min()</b> is a simple function when  it has 2 or more arguments but operates as an   <a href=\"lang_aggfunc.html#min_agg\">aggregate function</a> if given  only a single argument.", "", "aggregate"));
        dz.add(new SqlFunctions("nth_value", "sqlite", "nth_value(expr, N)", "<p> This built-in window function calculates the window frame for each       row in the same way as an aggregate window function. It returns the       value of <i>expr</i> evaluated against the row <i>N</i> of the window       frame. Rows are numbered within the window frame starting from 1 in       the order defined by the ORDER BY clause if one is present, or in       arbitrary order otherwise. If there is no <i>N</i>th row in the       partition, then NULL is returned.  </p>", "", "window"));
        dz.add(new SqlFunctions("ntile", "sqlite", "ntile(N)", "<p> Argument <i>N</i> is handled as an integer. This function divides the       partition into N groups as evenly as possible and assigns an integer       between 1 and <i>N</i> to each group, in the order defined by the ORDER       BY clause, or in arbitrary order otherwise. If necessary, larger groups       occur first. This function returns the integer value assigned to the       group that the current row is a part of.  </p>", "", "window"));
        dz.add(new SqlFunctions("percent_rank", "sqlite", "percent_rank()", "<p> Despite the name, this function always returns a value between 0.0       and 1.0 equal to (<i>rank</i> - 1)/(<i>partition-rows</i> - 1), where       <i>rank</i> is the value returned by built-in window function rank()       and <i>partition-rows</i> is the total number of rows in the       partition. If the partition contains only one row, this function       returns 0.0.  </p>", "", "window"));
        dz.add(new SqlFunctions("quote", "sqlite", "quote( X )", "<p>  The quote(X) function returns the text of an SQL literal which  is the value of its argument suitable for inclusion into an SQL statement.  Strings are surrounded by single-quotes with escapes on interior quotes  as needed.  BLOBs are encoded as hexadecimal literals.  Strings with embedded NUL characters cannot be represented as string  literals in SQL and hence the returned string literal is truncated prior  to the first NUL.", "", "scalar"));
        dz.add(new SqlFunctions("randomblob", "sqlite", "randomblob( N )", "<p>  The randomblob(N) function return an N-byte blob containing pseudo-random  bytes. If N is less than 1 then a 1-byte random blob is returned.  <p>Hint:  applications can generate globally unique identifiers  using this function together with <a href=\"lang_corefunc.html#hex\">hex()</a> and/or  <a href=\"lang_corefunc.html#lower\">lower()</a> like this:</p>  <blockquote>  hex(randomblob(16))<br></br>  lower(hex(randomblob(16)))  </blockquote>", "", "scalar"));
        dz.add(new SqlFunctions("rank", "sqlite", "rank()", "<p> The row_number() of the first peer in each group - the rank of the       current row with gaps. If there is no ORDER BY clause, then all rows       are considered peers and this function always returns 1.  </p>", "", "window"));
        dz.add(new SqlFunctions("row_number", "sqlite", "row_number()", "<p> The number of the row within the current partition. Rows are       numbered starting from 1 in the order defined by the ORDER BY clause in       the window definition, or in arbitrary order otherwise.  </p>", "", "window"));
        dz.add(new SqlFunctions("sinh", "sqlite", "sinh( X )", "<p>  Return the hyperbolic sine of X.", "", "math"));
        dz.add(new SqlFunctions("soundex", "sqlite", "soundex( X )", "<p>  The soundex(X) function returns a string that is the soundex encoding   of the string X.  The string \"?000\" is returned if the argument is NULL or contains  no ASCII alphabetic characters.  This function is omitted from SQLite by default.  It is only available if the <a href=\"compile.html#soundex\">SQLITE_SOUNDEX</a> compile-time option  is used when SQLite is built.", "", "scalar"));
        dz.add(new SqlFunctions("sqlite_compileoption_get", "sqlite", "sqlite_compileoption_get( N )", "<p>  The sqlite_compileoption_get() SQL function is a wrapper around the  <a href=\"c3ref/compileoption_get.html\">sqlite3_compileoption_get()</a> C/C++ function.  This routine returns the N-th compile-time option used to build SQLite  or NULL if N is out of range.  See also the <a href=\"pragma.html#pragma_compile_options\">compile_options pragma</a>.", "", "scalar"));
        dz.add(new SqlFunctions("sqlite_compileoption_used", "sqlite", "sqlite_compileoption_used( X )", "<p>  The sqlite_compileoption_used() SQL function is a wrapper around the  <a href=\"c3ref/compileoption_get.html\">sqlite3_compileoption_used()</a> C/C++ function.  When the argument X to sqlite_compileoption_used(X) is a string which  is the name of a compile-time option, this routine returns true (1) or  false (0) depending on whether or not that option was used during the  build.", "", "scalar"));
        dz.add(new SqlFunctions("sqlite_offset", "sqlite", "sqlite_offset( X )", "<p>  The sqlite_offset(X) function returns the byte offset in the database  file for the beginning of the record from which value would be read.  If X is not a column in an ordinary table, then sqlite_offset(X) returns  NULL.  The value returned by sqlite_offset(X) might reference either the  original table or an index, depending on the query.  If the value X would  normally be extracted from an index, the sqlite_offset(X) returns the  offset to the corresponding index record.  If the value X would be  extracted from the original table, then sqlite_offset(X) returns the offset  to the table record.  <p>The sqlite_offset(X) SQL function is only available if SQLite is built  using the <a href=\"compile.html#enable_offset_sql_func\">-DSQLITE_ENABLE_OFFSET_SQL_FUNC</a> compile-time option.", "", "scalar"));
        dz.add(new SqlFunctions("sqlite_source_id", "sqlite", "sqlite_source_id()", "<p>  The sqlite_source_id() function returns a string that identifies the  specific version of the source code that was used to build the SQLite  library.  The string returned by sqlite_source_id() is  the date and time that the source code was checked in followed by  the SHA3-256 hash for that check-in.  This function is  an SQL wrapper around the <a href=\"c3ref/libversion.html\">sqlite3_sourceid()</a> C interface.", "", "scalar"));
        dz.add(new SqlFunctions("sqlite_version", "sqlite", "sqlite_version()", "<p>  The sqlite_version() function returns the version string for the SQLite  library that is running.  This function is an SQL  wrapper around the <a href=\"c3ref/libversion.html\">sqlite3_libversion()</a> C-interface.", "", "scalar"));
        dz.add(new SqlFunctions("sum", "sqlite", "sum( X ) total( X )", "<p>  The sum() and total() aggregate functions  return the sum of all non-NULL values in the group.  If there are no non-NULL input rows then sum() returns  NULL but total() returns 0.0.  NULL is not normally a helpful result for the sum of no rows  but the SQL standard requires it and most other  SQL database engines implement sum() that way so SQLite does it in the  same way in order to be compatible.   The non-standard total() function  is provided as a convenient way to work around this design problem  in the SQL language.</p>  <p>The result of total() is always a floating point value.  The result of sum() is an integer value if all non-NULL inputs are integers.  If any input to sum() is neither an integer nor a NULL,  then sum() returns a floating point value  which is an approximation of the mathematical sum.</p>  <p>Sum() will throw an \"integer overflow\" exception if all inputs  are integers or NULL  and an integer overflow occurs at any point during the computation.  No overflow error is ever raised if any prior input was a floating point  value.  Total() never throws an integer overflow.  <p>When summing floating-point values, if the magnitudes of the values  differ wildly then the resulting sum might be imprecise due to the fact that  <a href=\"floatingpoint.html#fpapprox\">IEEE 754 floating point values are approximations</a>.  Use the decimal_sum(X) aggregate in the <a href=\"floatingpoint.html#decext\">decimal extension</a> to obtain  an exact summation of floating point numbers.  Consider this test case:<p><blockquote><pre>CREATE TABLE t1(x REAL);INSERT INTO t1 VALUES(1.55e+308),(1.23),(3.2e-16),(-1.23),(-1.55e308);SELECT sum(x), decimal_sum(x) FROM t1;</pre></blockquote></p>  <p>The large values &plusmn;1.55e+308 cancel each other out, but the  cancellation does not occur until the end of the sum and in the meantime  the large +1.55e+308 swamps the tiny 3.2e-16 value.  The end result is  an imprecise result for the sum().  The decimal_sum() aggregate  generates an exact answer, at the cost of additional CPU and memory usage.  Note also that decimal_sum() is not built into the SQLite core; it is a  <a href=\"loadext.html\">loadable extension</a>.  <p>If sum of inputs is too large to represent as a IEEE 754 floating  point value, then a +Infinity or -Infinity result may be returned.  If very large values with differing signs are used  such that the SUM() or TOTAL() function is  unable to determine if the correct result is +Infinity or -Infinity  or some other value in between, then the result is NULL.  Hence, for  example, the following query returns NULL:<p><blockquote><pre>WITH t1(x) AS (VALUES(1.0),(-9e+999),(2.0),(+9e+999),(3.0)) SELECT sum(x) FROM t1;</pre></blockquote></p>", "", "aggregate"));
        dz.add(new SqlFunctions("tanh", "sqlite", "tanh( X )", "<p>  Return the hyperbolic tangent of X.", "", "math"));
        dz.add(new SqlFunctions("total_changes", "sqlite", "total_changes()", "<p>  The total_changes() function returns the number of row changes  caused by INSERT, UPDATE or DELETE  statements since the current database connection was opened.  This function is a wrapper around the <a href=\"c3ref/total_changes.html\">sqlite3_total_changes64()</a>  C/C++ interface.", "", "scalar"));
        dz.add(new SqlFunctions("unhex", "sqlite", "unhex( X ) unhex( X , Y )", "<p>  The unhex(X,Y) function returns a BLOB value which is the decoding of the  hexadecimal string X.  If X contains any  characters that are not hexadecimal digits and which are not in Y,   then unhex(X,Y) returns NULL. If Y is omitted, it is  understood to be an empty string and hence X must be a pure hexadecimal string.  All hexadecimal digits in X must occur in pairs, with both digits of each  pair beginning immediately adjacent to one another, or else unhex(X,Y)  returns NULL.  If either parameter X or Y is NULL, then unhex(X,Y) returns NULL.  The X input may contain an arbitrary mix of upper and lower case hexadecimal  digits.  Hexadecimal digits in Y have no affect on the translation of X.  Only  characters in Y that are not hexadecimal digits are ignored in X.  <p>  See also:  <a href=\"lang_corefunc.html#hex\">hex()</a>", "", "scalar"));
        dz.add(new SqlFunctions("unlikely", "sqlite", "unlikely( X )", "<p>  The unlikely(X) function returns the argument X unchanged.  The unlikely(X) function is a no-op that the code generator  optimizes away so that it consumes no CPU cycles at  run-time (that is, during calls to <a href=\"c3ref/step.html\">sqlite3_step()</a>).  The purpose of the unlikely(X) function is to provide a hint  to the query planner that the argument X is a boolean value  that is usually not true. The unlikely(X) function is equivalent  to <a href=\"lang_corefunc.html#likelihood\">likelihood</a>(X, 0.0625).", "", "scalar"));
        dz.add(new SqlFunctions("zeroblob", "sqlite", "zeroblob( N )", "<p>  The zeroblob(N) function returns a BLOB consisting of N bytes of 0x00.  SQLite manages these zeroblobs very efficiently.  Zeroblobs can be used to  reserve space for a BLOB that is later written using   <a href=\"c3ref/blob_open.html\">incremental BLOB I/O</a>.  This SQL function is implemented using the <a href=\"c3ref/result_blob.html\">sqlite3_result_zeroblob()</a>  routine from the C/C++ interface.", "", "scalar"));
        knownFunctions = Collections.unmodifiableList(dz);
    }
}

