/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.pro.notebook;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.timestored.kdb.QueryResultI;
import com.timestored.qstudio.kdb.KdbHelper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.temporal.ChronoField;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;
import javax.sql.rowset.serial.SerialArray;
import javax.sql.rowset.serial.SerialException;
import kx.c;

public class ResultSetSerializer
extends JsonSerializer<ResultSet> {
    private static final Logger LOG = Logger.getLogger(ResultSetSerializer.class.getName());
    private final boolean extendedFormatWithTypes;
    private final boolean convertUndersoresToCamel;
    public static final LocalTime LOCAL_TIME_NULL = LocalTime.ofNanoOfDay(1L);
    static final long MILLS_IN_DAY = 86400000L;

    public ResultSetSerializer(boolean sanitizeHtml) {
        this(true, false, sanitizeHtml);
    }

    public ResultSetSerializer(boolean extendedFormatWithTypes, boolean convertUndersoresToCamel, boolean sanitizeHtml) {
        this.extendedFormatWithTypes = extendedFormatWithTypes;
        this.convertUndersoresToCamel = convertUndersoresToCamel;
    }

    @Override
    public Class<ResultSet> handledType() {
        return ResultSet.class;
    }

    public String toString(QueryResultI qr) throws IOException, JsonProcessingException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(128);
        JsonGenerator jgen = new JsonFactory().createGenerator(baos);
        SimpleModule module = new SimpleModule();
        module.addSerializer(c.Dict.class, new DictSerializer());
        module.addSerializer(UUID.class, new UUIDSerializer());
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule(module);
        jgen.setCodec(mapper);
        jgen.writeStartObject();
        if (qr.getRs() != null) {
            jgen.writeFieldName("tbl");
            this.serialize(qr.getRs(), jgen, (SerializerProvider)null);
        }
        if (qr.getConsoleView() != null) {
            jgen.writeFieldName("console");
            this.ws(jgen, qr.getConsoleView());
        }
        if (qr.getE() != null) {
            jgen.writeFieldName("exception");
            if (qr.getE() instanceof c.KException) {
                c.KException ke = (c.KException)qr.getE();
                this.ws(jgen, ke.getLocalizedMessage());
            } else {
                this.ws(jgen, qr.getE().getLocalizedMessage());
            }
        }
        if (qr.isExceededMax()) {
            jgen.writeFieldName("exceededMaxRows");
            jgen.writeBoolean(qr.isExceededMax());
        }
        if (qr.getK() != null && qr.getRs() == null) {
            jgen.writeFieldName("k");
            String ks = mapper.writerWithDefaultPrettyPrinter().writeValueAsString(qr.getK());
            jgen.writeRawValue(ks);
        }
        jgen.writeEndObject();
        jgen.close();
        return baos.toString("UTF-8");
    }

    public String toStringSingleRowOnly(ResultSet rs2) throws IOException, JsonProcessingException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(128);
        JsonGenerator jgen = new JsonFactory().createGenerator(baos);
        this.serialize(rs2, jgen, null, true);
        jgen.close();
        return baos.toString("UTF-8");
    }

    public String toString(ResultSet rs2) throws IOException, JsonProcessingException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(256);
        JsonGenerator jgen = new JsonFactory().createGenerator(baos);
        this.serialize(rs2, jgen, (SerializerProvider)null);
        jgen.close();
        return baos.toString("UTF-8");
    }

    public String toString(ResultSet rs2, boolean exceededMaxRows) throws IOException, JsonProcessingException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(128);
        JsonGenerator jgen = new JsonFactory().createGenerator(baos);
        jgen.writeStartObject();
        if (exceededMaxRows) {
            jgen.writeFieldName("exceededMaxRows");
            jgen.writeBoolean(exceededMaxRows);
        }
        jgen.writeFieldName("tbl");
        this.serialize(rs2, jgen, (SerializerProvider)null);
        jgen.writeEndObject();
        jgen.close();
        return baos.toString("UTF-8");
    }

    private static long toEpochSecond(LocalTime t, LocalDate d, ZoneOffset o) {
        long epochDay = d.toEpochDay();
        long secs = epochDay * 86400L + (long)t.toSecondOfDay();
        return secs -= (long)o.getTotalSeconds();
    }

    public static long toEpochSecond(LocalTime t) {
        return t == LOCAL_TIME_NULL ? Integer.MIN_VALUE : (long)((int)((ResultSetSerializer.toEpochSecond(t, LocalDate.of(1970, 1, 1), ZoneOffset.ofTotalSeconds(0)) * 1000L + (long)(t.getNano() / 1000000)) % 86400000L));
    }

    @Override
    public void serialize(ResultSet rs2, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
        this.serialize(rs2, jgen, provider, false);
    }

    private void ws(JsonGenerator jgen, String s) throws IOException {
        jgen.writeString(s);
    }

    private void serialize(ResultSet rs2, JsonGenerator jgen, SerializerProvider provider, boolean singleRowOnly) throws IOException, JsonProcessingException {
        try {
            ResultSetMetaData rsmd = rs2.getMetaData();
            int numColumns = rsmd.getColumnCount();
            String[] columnNames = new String[numColumns];
            int[] columnTypes = new int[numColumns];
            for (int i = 0; i < columnNames.length; ++i) {
                columnNames[i] = rsmd.getColumnLabel(i + 1);
                columnTypes[i] = rsmd.getColumnType(i + 1);
            }
            if (this.extendedFormatWithTypes) {
                jgen.writeStartObject();
                jgen.writeFieldName("data");
            }
            rs2.beforeFirst();
            String[] niceNames = this.convertUndersoresToCamel ? ResultSetSerializer.convertToCamel(columnNames) : columnNames;
            Map<String, String> colNamesToJsTypes = this.serialiseRSarray(rs2, jgen, provider, columnNames, niceNames, columnTypes, singleRowOnly);
            if (this.extendedFormatWithTypes) {
                jgen.writeFieldName("types");
                jgen.writeStartObject();
                block8: for (int c2 = 0; c2 < columnNames.length; ++c2) {
                    jgen.writeFieldName(niceNames[c2]);
                    String typ = colNamesToJsTypes.get(columnNames[c2]);
                    if (typ != null) {
                        this.ws(jgen, typ);
                        continue;
                    }
                    switch (columnTypes[c2]) {
                        case -5: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 6: 
                        case 7: 
                        case 8: {
                            this.ws(jgen, "number");
                            continue block8;
                        }
                        case 2000: {
                            this.ws(jgen, rs2.getObject(c2 + 1) instanceof Number ? "number" : "");
                            continue block8;
                        }
                        case -16: 
                        case -9: 
                        case -1: 
                        case 12: {
                            this.ws(jgen, "string");
                            continue block8;
                        }
                        default: {
                            this.ws(jgen, "");
                        }
                    }
                }
                jgen.writeEndObject();
                jgen.writeEndObject();
            }
        }
        catch (SQLException e) {
            throw new ResultSetSerializerException(e);
        }
    }

    private static String toProperCase(String s) {
        return s == null ? null : (s.length() > 1 ? s.substring(0, 1).toUpperCase() + s.substring(1).toLowerCase() : s.toUpperCase());
    }

    static String[] convertToCamel(String[] columnNames) {
        String[] r = new String[columnNames.length];
        for (int i = 0; i < r.length; ++i) {
            r[i] = columnNames[i].toLowerCase();
            if (r[i] == null || !r[i].contains("_")) continue;
            String[] parts = r[i].split("_");
            String camelCaseString = parts.length > 0 ? parts[0] : "";
            for (int j = 1; j < parts.length; ++j) {
                camelCaseString = camelCaseString + ResultSetSerializer.toProperCase(parts[j]);
            }
            r[i] = camelCaseString;
        }
        return r;
    }

    private Map<String, String> serialiseRSarray(ResultSet rs2, JsonGenerator jgen, SerializerProvider provider, String[] columnNames, String[] niceNames, int[] columnTypes, boolean singleRowOnly) throws IOException, SQLException {
        if (!singleRowOnly) {
            jgen.writeStartArray();
        }
        HashMap<String, String> colNamesToJsTypes = new HashMap<String, String>(3);
        int row = 0;
        while (rs2.next()) {
            ++row;
            jgen.writeStartObject();
            for (int i = 0; i < columnNames.length; ++i) {
                jgen.writeFieldName(niceNames[i]);
                try {
                    this.writeOneCol(rs2, jgen, provider, columnNames, columnTypes, colNamesToJsTypes, i);
                    continue;
                }
                catch (SQLException e) {
                    jgen.writeNull();
                }
            }
            jgen.writeEndObject();
        }
        if (singleRowOnly && row != 1) {
            throw new IllegalStateException("MUST be only one row");
        }
        if (!singleRowOnly) {
            jgen.writeEndArray();
        }
        return colNamesToJsTypes;
    }

    private void writeOneCol(ResultSet rs2, JsonGenerator jgen, SerializerProvider provider, String[] columnNames, int[] columnTypes, Map<String, String> colNamesToJsTypes, int i) throws SQLException, IOException, SerialException {
        switch (columnTypes[i]) {
            case 4: {
                long l = rs2.getInt(i + 1);
                if (rs2.wasNull()) {
                    jgen.writeNull();
                    break;
                }
                jgen.writeNumber(l);
                break;
            }
            case -5: {
                long l = rs2.getLong(i + 1);
                if (rs2.wasNull()) {
                    jgen.writeNull();
                    break;
                }
                jgen.writeNumber(l);
                break;
            }
            case 2: 
            case 3: {
                jgen.writeNumber(rs2.getBigDecimal(i + 1));
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                double d = rs2.getDouble(i + 1);
                if (rs2.wasNull()) {
                    jgen.writeNull();
                    break;
                }
                jgen.writeNumber(d);
                break;
            }
            case -16: 
            case -9: 
            case -1: 
            case 12: {
                this.ws(jgen, rs2.getString(i + 1));
                break;
            }
            case -7: 
            case 16: {
                boolean b = rs2.getBoolean(i + 1);
                if (rs2.wasNull()) {
                    jgen.writeNull();
                    break;
                }
                jgen.writeBoolean(b);
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                jgen.writeBinary(rs2.getBytes(i + 1));
                break;
            }
            case -6: 
            case 5: {
                long l = rs2.getShort(i + 1);
                if (rs2.wasNull()) {
                    jgen.writeNull();
                    break;
                }
                jgen.writeNumber(l);
                break;
            }
            case 91: 
            case 92: 
            case 93: 
            case 2013: 
            case 2014: {
                Object o = rs2.getObject(i + 1);
                if (rs2.wasNull()) {
                    jgen.writeNull();
                } else {
                    long epoch = ResultSetSerializer.toEpochMillis(o);
                    jgen.writeNumber(epoch);
                }
                int ct = columnTypes[i];
                String typ = ct == 92 || ct == 2013 ? "Time" : (ct == 91 ? "DateOnly" : "Date");
                colNamesToJsTypes.putIfAbsent(columnNames[i], typ);
                break;
            }
            case 2004: {
                Blob blob = rs2.getBlob(i);
                provider.defaultSerializeValue(blob.getBinaryStream(), jgen);
                blob.free();
                break;
            }
            case 2005: {
                Clob clob = rs2.getClob(i);
                provider.defaultSerializeValue(clob.getCharacterStream(), jgen);
                clob.free();
                break;
            }
            case 2003: {
                Object oo = rs2.getObject(i + 1);
                if (oo instanceof SerialArray) {
                    SerialArray sa = (SerialArray)oo;
                    oo = sa.getArray();
                }
                boolean isNumArray = false;
                try {
                    isNumArray = this.writeArray(jgen, oo);
                }
                catch (IOException ioe) {
                    LOG.warning("Unrecognised " + columnNames[i] + " of type " + columnTypes[i] + " with value: " + oo + " " + ioe);
                    jgen.writeNull();
                }
                if (isNumArray) {
                    colNamesToJsTypes.putIfAbsent(columnNames[i], "numarray");
                    break;
                }
                colNamesToJsTypes.putIfAbsent(columnNames[i], "string");
                break;
            }
            case 2002: {
                throw new RuntimeException("ResultSetSerializer not yet implemented for SQL type STRUCT");
            }
            case 2001: {
                throw new RuntimeException("ResultSetSerializer not yet implemented for SQL type DISTINCT");
            }
            case 2006: {
                throw new RuntimeException("ResultSetSerializer not yet implemented for SQL type REF");
            }
            default: {
                Object obj = rs2.getObject(i + 1);
                if (obj instanceof Number) {
                    colNamesToJsTypes.putIfAbsent(columnNames[i], "number");
                    double d = rs2.getDouble(i + 1);
                    if (rs2.wasNull()) {
                        jgen.writeNull();
                        break;
                    }
                    jgen.writeNumber(d);
                    break;
                }
                if (obj instanceof Timestamp) {
                    jgen.writeNumber(((Timestamp)obj).getTime());
                    colNamesToJsTypes.putIfAbsent(columnNames[i], "Date");
                    break;
                }
                long epoch2 = ResultSetSerializer.toEpochMillis(obj);
                if (epoch2 != Long.MIN_VALUE) {
                    jgen.writeNumber(epoch2);
                    String typ2 = obj instanceof OffsetTime ? "Time" : "Date";
                    colNamesToJsTypes.putIfAbsent(columnNames[i], typ2);
                    break;
                }
                try {
                    colNamesToJsTypes.putIfAbsent(columnNames[i], "string");
                    if (provider != null) {
                        provider.defaultSerializeValue(obj, jgen);
                        break;
                    }
                    this.ws(jgen, obj == null ? "" : obj.toString());
                    break;
                }
                catch (IOException ioe) {
                    LOG.warning("Unrecognised " + columnNames[i] + " of type " + columnTypes[i] + " with value: " + obj);
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean writeArray(JsonGenerator jgen, Object oo) throws IOException {
        boolean isNumArray = false;
        if (oo.getClass().isArray()) {
            boolean isH2array = false;
            if (oo instanceof Object[] && ((Object[])oo).length > 0) {
                Object obj = ((Object[])oo)[0];
                boolean bl = isH2array = obj instanceof Integer || obj instanceof Long || obj instanceof Float || obj instanceof Double;
            }
            if (isH2array || oo instanceof int[] || oo instanceof long[] || oo instanceof double[] || oo instanceof float[] || oo instanceof Integer[] || oo instanceof Long[] || oo instanceof Double[] || oo instanceof Float[]) {
                isNumArray = true;
                jgen.writeStartArray();
                int n = Array.getLength(oo);
                for (int mi = 0; mi < n; ++mi) {
                    try {
                        Object o = Array.get(oo, mi);
                        if (c.qn(o)) {
                            jgen.writeNull();
                            continue;
                        }
                        jgen.writeObject(o);
                        continue;
                    }
                    catch (IllegalStateException ioe) {
                        throw new IOException("2Unrecognised column type value");
                    }
                }
                jgen.writeEndArray();
                return isNumArray;
            } else {
                String s = KdbHelper.asText(oo);
                if (s == null || s.equals("") || s.equals("::")) throw new IOException("3Unrecognised column type value");
                jgen.writeString(s);
            }
            return isNumArray;
        } else {
            if (!(oo instanceof String)) throw new IOException("2Unrecognised column type value");
            jgen.writeString((String)oo);
        }
        return isNumArray;
    }

    private static long toEpochMillis(Object o) {
        long epoch = Long.MIN_VALUE;
        if (o instanceof Date) {
            epoch = ((Date)o).getTime();
        } else if (o instanceof java.util.Date) {
            epoch = ((java.util.Date)o).getTime();
        } else if (o instanceof LocalDate) {
            epoch = ((LocalDate)o).atStartOfDay(ZoneId.of("UTC")).toInstant().toEpochMilli();
        } else if (o instanceof LocalTime) {
            epoch = ResultSetSerializer.toEpochSecond((LocalTime)o);
        } else if (o instanceof LocalDateTime) {
            epoch = ((LocalDateTime)o).toInstant(ZoneOffset.UTC).toEpochMilli();
        } else if (o instanceof Instant) {
            epoch = ((Instant)o).toEpochMilli();
        } else if (o instanceof OffsetTime) {
            epoch = ((OffsetTime)o).getLong(ChronoField.MILLI_OF_DAY);
        } else if (o instanceof OffsetDateTime) {
            epoch = ((OffsetDateTime)o).toInstant().toEpochMilli();
        }
        return epoch;
    }

    class DictSerializer
    extends StdSerializer<c.Dict> {
        public DictSerializer() {
            this(null);
        }

        public DictSerializer(Class<c.Dict> t) {
            super(t);
        }

        @Override
        public void serialize(c.Dict dict, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeStartObject();
            for (int i = 0; i < c.n(dict); ++i) {
                jgen.writeFieldName("" + c.at(dict.x, i));
                provider.defaultSerializeValue(c.at(dict.y, i), jgen);
            }
            jgen.writeEndObject();
        }
    }

    class UUIDSerializer
    extends StdSerializer<UUID> {
        public UUIDSerializer() {
            this(null);
        }

        public UUIDSerializer(Class<UUID> t) {
            super(t);
        }

        @Override
        public void serialize(UUID uuid, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeString(uuid.toString());
        }
    }

    public static class ResultSetSerializerException
    extends JsonProcessingException {
        private static final long serialVersionUID = -914957626413580734L;

        public ResultSetSerializerException(Throwable cause) {
            super(cause);
        }
    }
}

