/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.pro.notebook;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.base.Preconditions;
import com.google.common.io.Resources;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import com.timestored.connections.ConnectionManager;
import com.timestored.connections.ServerConfig;
import com.timestored.misc.DirWatch;
import com.timestored.misc.IOUtils;
import com.timestored.pro.notebook.ResultSetSerializer;
import com.timestored.qstudio.CommonActions;
import com.timestored.qstudio.model.QueryResult;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.sql.rowset.CachedRowSet;
import lombok.NonNull;

public class NotebookServer {
    private static final Logger LOG = Logger.getLogger(NotebookServer.class.getName());
    private static final int PORT_LOW = 8088;
    private int port = -1;
    @NonNull
    private final ConnectionManager connectionManager;
    @NonNull
    private final File markdownDir;
    private HttpServer server;
    private ExecutorService httpThreadPool;
    private final FileFilter fileFilter = DirWatch.generateFileFilter(Pattern.compile("^\\..*|^target$"));
    private MyHandler markdownHandler;
    private static final String HARDWIRED_KDBNAME = "localhost:5000";
    public static final String EXAMPLE_KDB_FILE = "kdb-all.md";

    public File initDirWithExamples() throws IOException {
        File PAGES_DIR = new File(this.markdownDir, "pages");
        File exampleFileCreated = null;
        if (!PAGES_DIR.isDirectory() || !PAGES_DIR.exists()) {
            ServerConfig sc = this.connectionManager.getServer(HARDWIRED_KDBNAME);
            if (sc == null) {
                sc = this.connectionManager.getServerConnections().stream().filter(mySC -> mySC.isKDB()).findFirst().orElse(null);
            }
            File duckdbFile = new File(PAGES_DIR, "duckdb-examples.md");
            IOUtils.writeStringToFile(IOUtils.toString(NotebookServer.class, "markdown-examples.md"), new File(PAGES_DIR, "markdown-examples.md"));
            IOUtils.writeStringToFile(IOUtils.toString(NotebookServer.class, "duckdb-examples.md"), duckdbFile);
            exampleFileCreated = duckdbFile;
            if (sc != null) {
                String kdbAll = IOUtils.toString(NotebookServer.class, EXAMPLE_KDB_FILE);
                kdbAll = sc != null && !sc.getName().equals(HARDWIRED_KDBNAME) ? kdbAll.replace(HARDWIRED_KDBNAME, sc.getName()) : kdbAll;
                IOUtils.writeStringToFile(kdbAll, new File(PAGES_DIR, EXAMPLE_KDB_FILE));
                String kdbSimple = IOUtils.toString(NotebookServer.class, "kdb-simple-examples.md");
                kdbSimple = sc != null && !sc.getName().equals(HARDWIRED_KDBNAME) ? kdbSimple.replace(HARDWIRED_KDBNAME, sc.getName()) : kdbSimple;
                File kdbEgFile = new File(PAGES_DIR, "kdb-simple-examples.md");
                IOUtils.writeStringToFile(kdbSimple, kdbEgFile);
                exampleFileCreated = kdbEgFile;
            }
        }
        return exampleFileCreated;
    }

    public int start() throws Exception {
        DirWatch dirWatch = new DirWatch(1000L, this.fileFilter, false);
        dirWatch.setRoot(this.markdownDir);
        dirWatch.addListener(new DirWatch.DirWatchListener(){

            @Override
            public void changeOccurred() {
                NotebookServer.this.refreshPageList();
            }
        });
        int port = 8088;
        for (int offset = 0; offset < 100; ++offset) {
            try {
                port = 8088 + offset;
                InetSocketAddress sockAddr = new InetSocketAddress(port);
                this.server = HttpServer.create(sockAddr, 0);
                this.httpThreadPool = Executors.newFixedThreadPool(5);
                this.server.setExecutor(this.httpThreadPool);
                this.markdownHandler = new MyHandler(this.connectionManager, this.markdownDir);
                this.server.createContext("/", this.markdownHandler);
                this.server.setExecutor(null);
                this.server.start();
                this.port = port;
                return port;
            }
            catch (BindException e) {
                LOG.fine("Can't get port: " + port + " trying higher");
                continue;
            }
        }
        this.refreshPageList();
        LOG.severe("Couldn't get free port for NotebookServer.");
        return -1;
    }

    public String getHttpMarkdown(String filePathOrNull) {
        String qry = "";
        if (filePathOrNull != null && NotebookServer.hasMarkdownFileEnding(filePathOrNull)) {
            try {
                File f = new File(filePathOrNull);
                if (f.getCanonicalPath().startsWith(this.markdownDir.getCanonicalPath())) {
                    Path parentPath = new File(this.markdownDir, "pages").toPath();
                    qry = "/" + NotebookServer.getLinkForFile(parentPath, f) + "?sheet=" + NotebookServer.getLinkForFile(parentPath, f);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return "http://localhost:" + this.port + "/markdown" + qry;
    }

    String getHttpAddress() {
        return "http://localhost:" + this.port;
    }

    public static boolean hasMarkdownFileEnding(String filePath) {
        String e = filePath.toLowerCase();
        return e.endsWith(".markdown") || e.endsWith(".mdown") || e.endsWith(".mkdn") || e.endsWith(".md");
    }

    public synchronized void refreshPageList() {
        LOG.info("refreshPageList");
        File[] pagesToWatch = new File[]{new File(this.markdownDir, "pages")};
        FileFilter markdownFilter = pathname -> pathname.isDirectory() || NotebookServer.hasMarkdownFileEnding(pathname.getName());
        ArrayList<File> pages = new ArrayList<File>(DirWatch.generateFileCache(pagesToWatch, markdownFilter));
        try {
            this.markdownHandler.setAllMarkdownPages(pages);
        }
        catch (JsonProcessingException e) {
            LOG.severe("Error generating markdown json:" + e.toString());
        }
    }

    public void stop() {
        this.server.stop(1);
        this.httpThreadPool.shutdownNow();
    }

    private static String getRequestBody(HttpExchange t) throws IOException {
        int i;
        StringBuilder postReqSb = new StringBuilder();
        InputStream ios = t.getRequestBody();
        while ((i = ios.read()) != -1) {
            postReqSb.append((char)i);
        }
        return postReqSb.toString();
    }

    private static <T> T getRequestBodyJson(HttpExchange t, Class<T> c2) throws IOException {
        Object ct = t.getRequestHeaders().get("Content-Type");
        if (ct == null || ct.size() == 0 || !((String)ct.get(0)).equalsIgnoreCase("application/json")) {
            throw new RuntimeException("Expected JSON request");
        }
        String body = NotebookServer.getRequestBody(t);
        ObjectMapper objectMapper = new ObjectMapper();
        return objectMapper.readValue(body, c2);
    }

    static String getLinkForFile(Path pagesDir, File f) {
        Path a = pagesDir.relativize(f.toPath());
        String s = a.toString();
        s = s.endsWith(".md") ? s.substring(0, s.length() - 3) : s;
        if ((s = s.replace(File.separatorChar, '/')).toLowerCase().endsWith("/index")) {
            s = s.substring(0, s.length() - 5);
        } else if (s.equalsIgnoreCase("index")) {
            s = "";
        }
        return s;
    }

    private static boolean isTextContentType(String path) {
        String p;
        int dotPos = path.lastIndexOf(46);
        switch (p = (dotPos >= 0 ? path.substring(dotPos + 1) : "").toLowerCase()) {
            case "css": 
            case "js": 
            case "html": 
            case "htm": 
            case "json": 
            case "xml": 
            case "svg": 
            case "md": 
            case "csv": {
                return true;
            }
        }
        return false;
    }

    private static String getContentType(String path) {
        String p;
        int dotPos = path.lastIndexOf(46);
        switch (p = (dotPos >= 0 ? path.substring(dotPos + 1) : "").toLowerCase()) {
            case "css": {
                return "text/css";
            }
            case "js": {
                return "application/javascript";
            }
            case "html": 
            case "htm": {
                return "text/html";
            }
            case "json": {
                return "application/json";
            }
            case "xml": {
                return "application/xml";
            }
            case "png": {
                return "image/png";
            }
            case "jpg": 
            case "jpeg": {
                return "image/jpeg";
            }
            case "gif": {
                return "image/gif";
            }
            case "svg": {
                return "image/svg+xml";
            }
            case "bmp": {
                return "image/bmp";
            }
            case "tiff": 
            case "tif": {
                return "image/tiff";
            }
            case "mp3": {
                return "audio/mpeg";
            }
            case "wav": {
                return "audio/wav";
            }
            case "ogg": {
                return "audio/ogg";
            }
            case "mp4": {
                return "video/mp4";
            }
            case "webm": {
                return "video/webm";
            }
            case "zip": {
                return "application/zip";
            }
            case "pdf": {
                return "application/pdf";
            }
            case "xls": {
                return "application/vnd.ms-excel";
            }
            case "xlsx": {
                return "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
            }
            case "md": {
                return "text/markdown";
            }
            case "csv": {
                return "text/csv";
            }
            case "ico": {
                return "image/x-icon";
            }
        }
        return "text/plain";
    }

    private static byte[] readResourceBytes(String resourcePath) throws IOException {
        if (NotebookServer.isTextContentType(resourcePath)) {
            return IOUtils.toString(NotebookServer.class, resourcePath).getBytes(Charset.forName("UTF-8"));
        }
        return Resources.toByteArray(Resources.getResource(NotebookServer.class, resourcePath));
    }

    public NotebookServer(@NonNull ConnectionManager connectionManager, @NonNull File markdownDir) {
        if (connectionManager == null) {
            throw new NullPointerException("connectionManager is marked non-null but is null");
        }
        if (markdownDir == null) {
            throw new NullPointerException("markdownDir is marked non-null but is null");
        }
        this.connectionManager = connectionManager;
        this.markdownDir = markdownDir;
    }

    private static class MyHandler
    implements HttpHandler {
        @NonNull
        private final ConnectionManager connectionManager;
        @NonNull
        private final File markdownDir;
        @NonNull
        private final Path parentPath;
        private int updateId = -1;
        private List<File> allMarkdownPages = Collections.emptyList();
        private String fullTabbsJson = "";
        private static final String MARKDOWN = "<!DOCTYPE html>\r\n<html lang=\"en\">\r\n  <head>\r\n    <meta charset=\"utf-8\" />\r\n    <base href=\"/\"/>\r\n    <link rel=\"icon\" href=\"/favicon.ico\" />\r\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1\" />\r\n    <meta name=\"theme-color\" content=\"#000000\" />\r\n    <title>qStudio</title>\r\n    <script>window.pulseconfig={}</script>\r\n    <script defer=\"defer\" src=\"/static/js/main.1cdfdc19.js\"></script>\r\n<link href=\"/static/css/main.647099bf.css\" rel=\"stylesheet\"></head>\r\n  <body><noscript>You need to enable JavaScript to run this app.</noscript>\r\n    <div id=\"root\"></div></body></html>\r\n";
        private static final String PRE = "<!DOCTYPE html>\r\n<html lang=\"en\">\r\n  <head>\r\n    <meta charset=\"utf-8\">\r\n    <title>qStudio</title>\r\n    <link rel=\"stylesheet\" href=\"/style.css\">\r\n  </head>\r\n  <body>";
        private static final String POST = "</body></html>";
        private static final String PRQL_PRE = ":prql:";
        private static final Object BUNDLE_PATH = "/api/dashboard/mdbundle";
        private static final String USE_PULSE_HTML = "<html><body><a href='https://www.timestored.com/qstudio/help/issues/sqlnotebook-access-denied?utm_source=sqlnotebook&utm_medium=app&utm_campaign=sqlnotebook'><h1>SQLNotebook Access Denied</h1></a></body></html>";

        public void setAllMarkdownPages(List<File> allMarkdownPages) throws JsonProcessingException {
            this.allMarkdownPages = allMarkdownPages;
            DashboardData dd = new DashboardData(this.parentPath, allMarkdownPages, ++this.updateId);
            this.fullTabbsJson = dd.toJSON();
        }

        public MyHandler(ConnectionManager connectionManager, File markdownDir) {
            this.connectionManager = Preconditions.checkNotNull(connectionManager);
            this.markdownDir = Preconditions.checkNotNull(markdownDir);
            this.parentPath = new File(markdownDir, "pages").toPath();
        }

        @Override
        public void handle(HttpExchange t) throws IOException {
            String requestedURL = "http://" + t.getRequestHeaders().getFirst("Host") + t.getRequestURI();
            URL u = new URL(requestedURL);
            String path = u.getPath();
            if (!path.equals(BUNDLE_PATH)) {
                LOG.info("Client Request: " + path + " from " + u.getHost() + ":" + u.getPort());
            }
            try {
                if (!this.handle(t, path)) {
                    this.writeReply(t, MyHandler.toB("Not Handled"), 200);
                }
            }
            catch (IOException e) {
                this.writeReply(t, MyHandler.toB(e.toString()), 502);
            }
        }

        private static byte[] toB(String s) {
            return s.getBytes(Charset.forName("UTF-8"));
        }

        private String toS(String s) {
            return s == null ? "\"\"" : "\"" + s.replaceAll("\"", "\\\"") + "\"";
        }

        public boolean handle(HttpExchange t, String path) throws IOException {
            String response = null;
            StringBuilder sb = new StringBuilder();
            t.getResponseHeaders().set("Access-Control-Allow-Origin", "http://localhost:3000");
            t.getResponseHeaders().set("Access-Control-Allow-Headers", "*");
            t.getResponseHeaders().set("Access-Control-Allow-Methods", "POST, GET, OPTIONS, DELETE");
            t.getResponseHeaders().set("Access-Control-Allow-Credentials", "true");
            String method = t.getRequestMethod();
            method = method == null ? "" : method.toUpperCase();
            boolean isMyIp = MyHandler.isThisMyIpAddress(t.getRemoteAddress());
            if (!isMyIp) {
                this.writeReply(t, USE_PULSE_HTML.getBytes(Charset.forName("UTF-8")), 403);
            } else if (method.equals("OPTIONS")) {
                response = "";
            } else if (path.equals("/")) {
                sb.append(PRE);
                sb.append("<a href='/markdown'>markdown</a>");
                sb.append(POST);
                response = sb.toString();
            } else if (path.startsWith("/markdown")) {
                String newConfig = "{\"version\":" + this.toS("3.04") + ",\"isQStudio\":true}";
                String m = MARKDOWN.replace("window.pulseconfig={}", "window.pulseconfig=" + newConfig);
                response = sb.append(m).toString();
            } else if (path.equals("/api/dbserver/") || path.equals("/api/dbserver/list-private")) {
                t.getResponseHeaders().set("Content-Type", "application/json");
                sb.append("[");
                List<ServerConfig> conns = this.connectionManager.getServerConnections();
                for (int i = 0; i < conns.size(); ++i) {
                    ServerConfig sc = conns.get(i);
                    if (i > 0) {
                        sb.append(",\r\n\t");
                    }
                    sb.append("{\"id\": " + (i + 2) + ", \"name\": \"" + sc.getName().replace("\\", "\\\\") + "\", \"jdbcType\": \"" + sc.getJdbcType().toString() + "\" }");
                }
                sb.append("]");
                response = sb.toString();
            } else if (path.startsWith("/api/a.json")) {
                String qry = t.getRequestURI().getQuery();
                if (path.equalsIgnoreCase("/api/a.json") && qry != null && qry.startsWith("server=BABELDB&query=QUERY_SYMBOLS('")) {
                    String searchText = qry.substring("server=BABELDB&query=QUERY_SYMBOLS('".length());
                    searchText = searchText.length() > 2 ? searchText.substring(0, searchText.length() - 2) : searchText;
                    response = "{\"tbl\":{\"data\":[{\"symbol\":\"1000BONKUSDC\",\"database\":\"BINANCE\",\"query\":\"1000BONKUSDC\",\"title\":\"\",\"description\":\"\"},{\"symbol\":\"1000BONKUSDC_AGGTRADE\",\"database\":\"BINANCE\",\"query\":\"1000BONKUSDC_AGGTRADE\",\"title\":\"\",\"description\":\"\"}],\"types\":{\"symbol\":\"string\",\"database\":\"string\",\"query\":\"string\",\"title\":\"string\",\"description\":\"string\"}},\"console\":\"\"}";
                } else if ("POST".equals(t.getRequestMethod().toUpperCase())) {
                    String serverPth = path.substring("/api/a.json/".length());
                    serverPth = URLDecoder.decode(serverPth, StandardCharsets.UTF_8.name());
                    QueryWithArgs qryWithArgs = (QueryWithArgs)NotebookServer.getRequestBodyJson(t, QueryWithArgs.class);
                    try {
                        response = this.runQuery(serverPth, qryWithArgs.query);
                    }
                    catch (IllegalStateException ise) {
                        response = "{\"exception\":\"Could not find server.\"}";
                    }
                }
            } else {
                if (path.equals(BUNDLE_PATH)) {
                    int reqUpdateId = -2;
                    try {
                        String body = NotebookServer.getRequestBody(t);
                        reqUpdateId = Integer.parseInt(body);
                    }
                    catch (NumberFormatException nfe) {
                        reqUpdateId = -3;
                    }
                    if (reqUpdateId == this.updateId) {
                        this.writeReply(t, MyHandler.toB("NOCHANGE"));
                        return true;
                    }
                    t.getResponseHeaders().set("Content-Type", "application/json");
                    this.writeReply(t, MyHandler.toB(this.fullTabbsJson));
                    return true;
                }
                if (path.equals("/style.css") || path.equals("/favicon.ico") || path.equals("/bundle.js")) {
                    t.getResponseHeaders().set("Content-Type", NotebookServer.getContentType(path));
                    byte[] responseRaw = NotebookServer.readResourceBytes(path.substring(1));
                    if (responseRaw != null) {
                        this.writeReply(t, responseRaw);
                        return true;
                    }
                } else if (path.startsWith("/static/") || path.startsWith("/api/static/") || path.startsWith("/img/")) {
                    String p = path.startsWith("/api/static/") ? path.substring(4) : (path.startsWith("/img/") ? "/static" + path : path);
                    File f = new File(this.markdownDir, p.substring(1));
                    if (f.exists() && f.isFile()) {
                        t.getResponseHeaders().set("Content-Type", NotebookServer.getContentType(p));
                        this.writeReply(t, Files.readAllBytes(f.toPath()));
                    } else {
                        String resPath = p.substring("/static/".length());
                        try {
                            byte[] responseRaw = null;
                            responseRaw = NotebookServer.isTextContentType(p) ? IOUtils.toString(NotebookServer.class, resPath).getBytes(Charset.forName("UTF-8")) : NotebookServer.readResourceBytes(resPath);
                            t.getResponseHeaders().set("Content-Type", NotebookServer.getContentType(p));
                            if (responseRaw != null) {
                                this.writeReply(t, responseRaw);
                                return true;
                            }
                        }
                        catch (IOException ioe) {
                            this.writeReply(t, new byte[0], 404);
                        }
                    }
                    return true;
                }
            }
            if (response != null) {
                this.writeReply(t, MyHandler.toB(response));
            }
            return response != null;
        }

        private String runQuery(String serverPth, String postedQry) throws IOException, IllegalStateException {
            System.out.println("serverPth ====== " + serverPth + " hm: " + postedQry);
            ServerConfig sc = this.connectionManager.getServer(serverPth);
            ResultSetSerializer rss = new ResultSetSerializer(false);
            if (sc != null) {
                try {
                    String qry = postedQry;
                    if (qry.startsWith(PRQL_PRE)) {
                        qry = CommonActions.compilePRQL(qry.substring(PRQL_PRE.length()), sc.getJdbcType());
                    }
                    CachedRowSet rs2 = this.connectionManager.executeQuery(sc, qry);
                    QueryResult qr = QueryResult.successfulResult(sc, postedQry, null, null, rs2, null);
                    return rss.toString(qr);
                }
                catch (SQLException e) {
                    return rss.toString(QueryResult.exceptionResult(sc, postedQry, null, e));
                }
            }
            throw new IllegalStateException("Server not found");
        }

        private void writeReply(HttpExchange t, byte[] reply) throws IOException {
            this.writeReply(t, reply, 200);
        }

        private void writeReply(HttpExchange t, byte[] reply, int code) throws IOException {
            t.sendResponseHeaders(code, reply.length);
            OutputStream os = t.getResponseBody();
            os.write(reply);
            os.close();
        }

        public static boolean isThisMyIpAddress(InetSocketAddress inetSocketAddress) {
            InetAddress addr = inetSocketAddress.getAddress();
            return addr.isAnyLocalAddress() || addr.isLoopbackAddress();
        }

        public MyHandler(@NonNull ConnectionManager connectionManager, @NonNull File markdownDir, @NonNull Path parentPath) {
            if (connectionManager == null) {
                throw new NullPointerException("connectionManager is marked non-null but is null");
            }
            if (markdownDir == null) {
                throw new NullPointerException("markdownDir is marked non-null but is null");
            }
            if (parentPath == null) {
                throw new NullPointerException("parentPath is marked non-null but is null");
            }
            this.connectionManager = connectionManager;
            this.markdownDir = markdownDir;
            this.parentPath = parentPath;
        }
    }

    public static class ArgEntry {
        private String argKey;
        private String[] argVals;
        private String argType;

        public String getArgKey() {
            return this.argKey;
        }

        public String[] getArgVals() {
            return this.argVals;
        }

        public String getArgType() {
            return this.argType;
        }

        public void setArgKey(String argKey) {
            this.argKey = argKey;
        }

        public void setArgVals(String[] argVals) {
            this.argVals = argVals;
        }

        public void setArgType(String argType) {
            this.argType = argType;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ArgEntry)) {
                return false;
            }
            ArgEntry other = (ArgEntry)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$argKey = this.getArgKey();
            String other$argKey = other.getArgKey();
            if (this$argKey == null ? other$argKey != null : !this$argKey.equals(other$argKey)) {
                return false;
            }
            if (!Arrays.deepEquals(this.getArgVals(), other.getArgVals())) {
                return false;
            }
            String this$argType = this.getArgType();
            String other$argType = other.getArgType();
            return !(this$argType == null ? other$argType != null : !this$argType.equals(other$argType));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ArgEntry;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $argKey = this.getArgKey();
            result = result * 59 + ($argKey == null ? 43 : $argKey.hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getArgVals());
            String $argType = this.getArgType();
            result = result * 59 + ($argType == null ? 43 : $argType.hashCode());
            return result;
        }

        public String toString() {
            return "NotebookServer.ArgEntry(argKey=" + this.getArgKey() + ", argVals=" + Arrays.deepToString(this.getArgVals()) + ", argType=" + this.getArgType() + ")";
        }
    }

    public static class QueryWithArgs {
        private String query;
        private String serverCmd;
        private ArgEntry[] argsArray;

        public String getQuery() {
            return this.query;
        }

        public String getServerCmd() {
            return this.serverCmd;
        }

        public ArgEntry[] getArgsArray() {
            return this.argsArray;
        }

        public void setQuery(String query) {
            this.query = query;
        }

        public void setServerCmd(String serverCmd) {
            this.serverCmd = serverCmd;
        }

        public void setArgsArray(ArgEntry[] argsArray) {
            this.argsArray = argsArray;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof QueryWithArgs)) {
                return false;
            }
            QueryWithArgs other = (QueryWithArgs)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$query = this.getQuery();
            String other$query = other.getQuery();
            if (this$query == null ? other$query != null : !this$query.equals(other$query)) {
                return false;
            }
            String this$serverCmd = this.getServerCmd();
            String other$serverCmd = other.getServerCmd();
            if (this$serverCmd == null ? other$serverCmd != null : !this$serverCmd.equals(other$serverCmd)) {
                return false;
            }
            return Arrays.deepEquals(this.getArgsArray(), other.getArgsArray());
        }

        protected boolean canEqual(Object other) {
            return other instanceof QueryWithArgs;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $query = this.getQuery();
            result = result * 59 + ($query == null ? 43 : $query.hashCode());
            String $serverCmd = this.getServerCmd();
            result = result * 59 + ($serverCmd == null ? 43 : $serverCmd.hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getArgsArray());
            return result;
        }

        public String toString() {
            return "NotebookServer.QueryWithArgs(query=" + this.getQuery() + ", serverCmd=" + this.getServerCmd() + ", argsArray=" + Arrays.deepToString(this.getArgsArray()) + ")";
        }
    }

    public static class DashboardData {
        private final int version;
        private final TabbDetails[] tabbDetails;

        public DashboardData(Path parentPath, List<File> markdownPages, int version) {
            this.version = version;
            ArrayList<TabbDetails> l = new ArrayList<TabbDetails>(markdownPages.size());
            for (File mdf : markdownPages) {
                try {
                    if (!mdf.isFile() || !mdf.canRead()) continue;
                    l.add(new TabbDetails(NotebookServer.getLinkForFile(parentPath, mdf), IOUtils.toString(mdf)));
                }
                catch (IOException e) {
                    LOG.severe("Could not read all and create full markdown:" + e.toString());
                }
            }
            this.tabbDetails = l.toArray(new TabbDetails[0]);
        }

        public String toJSON() throws JsonProcessingException {
            ObjectWriter ow = new ObjectMapper().writer().withDefaultPrettyPrinter();
            return ow.writeValueAsString(this);
        }

        public int getVersion() {
            return this.version;
        }

        public TabbDetails[] getTabbDetails() {
            return this.tabbDetails;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DashboardData)) {
                return false;
            }
            DashboardData other = (DashboardData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getVersion() != other.getVersion()) {
                return false;
            }
            return Arrays.deepEquals(this.getTabbDetails(), other.getTabbDetails());
        }

        protected boolean canEqual(Object other) {
            return other instanceof DashboardData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getVersion();
            result = result * 59 + Arrays.deepHashCode(this.getTabbDetails());
            return result;
        }

        public String toString() {
            return "NotebookServer.DashboardData(version=" + this.getVersion() + ", tabbDetails=" + Arrays.deepToString(this.getTabbDetails()) + ")";
        }

        public DashboardData(int version, TabbDetails[] tabbDetails) {
            this.version = version;
            this.tabbDetails = tabbDetails;
        }
    }

    public static class TabbDetails {
        private final String name;
        private final String jsonmodel;

        public TabbDetails(String name, String jsonmodel) {
            this.name = name;
            this.jsonmodel = jsonmodel;
        }

        public String getName() {
            return this.name;
        }

        public String getJsonmodel() {
            return this.jsonmodel;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TabbDetails)) {
                return false;
            }
            TabbDetails other = (TabbDetails)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$jsonmodel = this.getJsonmodel();
            String other$jsonmodel = other.getJsonmodel();
            return !(this$jsonmodel == null ? other$jsonmodel != null : !this$jsonmodel.equals(other$jsonmodel));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TabbDetails;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $jsonmodel = this.getJsonmodel();
            result = result * 59 + ($jsonmodel == null ? 43 : $jsonmodel.hashCode());
            return result;
        }

        public String toString() {
            return "NotebookServer.TabbDetails(name=" + this.getName() + ", jsonmodel=" + this.getJsonmodel() + ")";
        }
    }
}

