/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.pro.kdb;

import com.timestored.TimeStored;
import com.timestored.kdb.SysCommand;
import com.timestored.misc.InfoLink;
import com.timestored.qstudio.QStudioLauncher;
import com.timestored.qstudio.model.ServerModel;
import com.timestored.qstudio.model.ServerReport;
import com.timestored.qstudio.model.ServerSlashConfig;
import com.timestored.theme.Theme;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

class ServerDescriptionPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final ServerReportpanel serverReportPanel;
    private final ServerConfigPanel serverConfigPanel;
    private JTabbedPane tabpane;
    private final ServerModel serverModel;

    public ServerDescriptionPanel(ServerModel serverModel) {
        this.serverModel = serverModel;
        this.setLayout(new BorderLayout());
        this.tabpane = new JTabbedPane();
        this.serverReportPanel = new ServerReportpanel();
        this.serverConfigPanel = new ServerConfigPanel();
        this.tabpane.addTab("Server Info", ServerDescriptionPanel.scrollWrap(this.serverReportPanel));
        this.tabpane.addTab("Configuration", ServerDescriptionPanel.scrollWrap(this.serverConfigPanel));
        this.add((Component)this.tabpane, "Center");
        serverModel.addListener(new ServerModel.Listener(){

            @Override
            public void changeOccurred() {
                ServerDescriptionPanel.this.refreshGui();
            }
        });
        this.refreshGui();
    }

    private void refreshGui() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ServerDescriptionPanel.this.removeAll();
                if (ServerDescriptionPanel.this.serverModel.getServerConfig().isKDB() && ServerDescriptionPanel.this.serverModel.isConnected()) {
                    ServerDescriptionPanel.this.serverReportPanel.display(ServerDescriptionPanel.this.serverModel.getServerReport());
                    ServerDescriptionPanel.this.serverConfigPanel.display(ServerDescriptionPanel.this.serverModel.getSlashConfig());
                    ServerDescriptionPanel.this.add((Component)ServerDescriptionPanel.this.tabpane, "Center");
                } else {
                    String msg = "Server: " + ServerDescriptionPanel.this.serverModel.getName() + (ServerDescriptionPanel.this.serverModel.getServerConfig().isKDB() ? " not connected" : "");
                    JPanel p = new JPanel(new BorderLayout());
                    p.add(Theme.getHeader(msg));
                    ServerDescriptionPanel.this.add((Component)p, "Center");
                }
            }
        });
    }

    private static JScrollPane scrollWrap(JPanel panel) {
        return new JScrollPane(panel, 20, 31);
    }

    private static class ServerConfigPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private final JPanel conPanel;

        public ServerConfigPanel() {
            this.setLayout(new BorderLayout());
            JPanel headerPanel = Theme.getSubHeader("System Commands");
            this.add((Component)headerPanel, "North");
            JPanel p = new JPanel(new FlowLayout(0));
            this.conPanel = new JPanel(new GridLayout(12, 2));
            p.add(this.conPanel);
            this.add((Component)p, "Center");
        }

        public void display(ServerSlashConfig serverConfig) {
            this.conPanel.removeAll();
            if (serverConfig != null) {
                this.conPanel.removeAll();
                List<String> sysStr = Arrays.asList("c", "C", "e", "g", "o", "p", "P", "s", "t", "T", "W", "z");
                for (String sysCmd : sysStr) {
                    ServerConfigPanel.addRow(this.conPanel, SysCommand.get(sysCmd), serverConfig);
                }
            } else {
                String msg = "Could not retrieve Server Config, check server security settings.";
                this.conPanel.add(QStudioLauncher.ERR_REPORTER.getErrorReportLink(msg, msg));
            }
        }

        private static void addRow(JPanel conPanel, final SysCommand scmd, final ServerSlashConfig servCfg) {
            if (scmd != null) {
                JLabel descLabel = new JLabel("\\" + scmd.getCommand() + "    " + scmd.getShortDesc());
                conPanel.add(descLabel);
                JPanel panel = new JPanel(new BorderLayout());
                String curVal = servCfg.getVal(scmd);
                final JTextField curValTextField = new JTextField(curVal == null ? "" : curVal);
                curValTextField.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        servCfg.setVal(scmd, curValTextField.getText());
                    }
                });
                curValTextField.setEditable(scmd.isWritable() && curVal != null);
                panel.add((Component)curValTextField, "Center");
                String title = "\\" + scmd.getCommand() + " " + scmd.getArgs();
                JLabel infoLink = InfoLink.getLabel(title, scmd.getLongDesc(), scmd.getUrl(), false);
                panel.add((Component)infoLink, "East");
                panel.setAlignmentX(0.0f);
                conPanel.add(panel);
            }
        }
    }

    private static class ServerReportpanel
    extends Theme.BoxyPanel {
        private static final long serialVersionUID = 1L;
        private static final String MEM_DESCRIPTION = "<html><b>used</b> - number of bytes allocated. \r\n<br><b>heap</b> - bytes available in heap. \r\n<br><b>peak</b> - maximum heap size so far. \r\n<br><b>wmax</b> - maximum bytes available, given in -w command line parameter. \r\n<br><b>wmap</b> - mapped bytes. \r\n<br><b>mphy</b> - physical memory.";

        public ServerReportpanel() {
            this.setLayout(new BoxLayout(this, 3));
        }

        public void display(ServerReport serverReport) {
            this.removeAll();
            if (serverReport != null) {
                JPanel tabPanel = Theme.getPlainReadonlyTable(serverReport.getGeneralInfoTable());
                this.add(Theme.wrap("Server Report", tabPanel));
                JPanel infoPanel = new JPanel(new FlowLayout(0));
                infoPanel.add(InfoLink.getButton("How Memory Management Works", MEM_DESCRIPTION, TimeStored.Page.TUTE_MEM));
                this.add(Theme.wrap("Memory Usage", serverReport.getMemTab(), infoPanel));
                this.add(Theme.wrap("Table Storage", serverReport.getDiskTab()));
                this.add(Box.createGlue());
            } else {
                String msg = "Could not retrieve Server Info, check server security settings.";
                this.add(QStudioLauncher.ERR_REPORTER.getErrorReportLink(msg, msg));
            }
        }
    }
}

