/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.pro.kdb;

import com.google.common.base.Joiner;
import com.timestored.misc.IOUtils;
import com.timestored.qdoc.ParsedQFile;
import com.timestored.qdoc.QFileParser;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;

class ModuleRunner {
    private static final String QUNIT_Q = "qunit.q";
    private static final String NSFIXER_Q = "nsfixer.q";
    public static final String MATH_Q = "math.q";
    public static final String MATH_TEST_Q = "mathTest.q";
    private static final String NL = "\r\n";

    ModuleRunner() {
    }

    private static String getRunUnitTestsQuery(String namespace) throws IOException {
        return ModuleRunner.getRunUnitTestsQuery(Arrays.asList(namespace));
    }

    private static String getRunUnitTestsQuery(Collection<String> namespaces) throws IOException {
        String unittest = IOUtils.toString(ModuleRunner.class, QUNIT_Q);
        StringBuilder sb = new StringBuilder(unittest.length() + 500);
        sb.append(unittest).append(NL);
        ModuleRunner.fixNamespace(sb, "`.qunit");
        sb.append(".qunit.runTests ");
        for (String ns : namespaces) {
            sb.append("`").append(ns);
        }
        return sb.append(NL).toString();
    }

    private static StringBuilder fixNamespace(StringBuilder sb, String ns) throws IOException {
        String nsfixer = IOUtils.toString(ModuleRunner.class, NSFIXER_Q);
        sb.append(NL).append(nsfixer).append(ns);
        return sb.append(";").append(NL);
    }

    public static String getRunQUnitQuery(String testq) throws IOException {
        String fakeName = "test.q";
        ParsedQFile parsedQF = QFileParser.parse(testq, fakeName, fakeName);
        Collection<String> namespaces = parsedQF.getNamespaces();
        if (namespaces.isEmpty()) {
            throw new IllegalArgumentException("no namespaces found in this file");
        }
        String delCurrentTests = "";
        StringBuilder nsFixes = new StringBuilder();
        for (String ns : namespaces) {
            if (ns == ".") continue;
            delCurrentTests = delCurrentTests + "if[`" + ns + " in `$\".\",/:string key `;delete from `" + ns + ";];" + NL;
            ModuleRunner.fixNamespace(nsFixes, "`" + ns);
        }
        return delCurrentTests + NL + testq + ";" + NL + nsFixes + NL + ModuleRunner.getRunUnitTestsQuery(namespaces);
    }

    public static String getRunScriptModuleLoad(String qcode) throws IOException {
        String fakeName = "test.q";
        ParsedQFile parsedQF = QFileParser.parse(qcode, fakeName, fakeName);
        Collection<String> namespaces = parsedQF.getNamespaces();
        if (namespaces.isEmpty()) {
            return qcode;
        }
        StringBuilder nsFixes = new StringBuilder();
        for (String ns : namespaces) {
            ModuleRunner.fixNamespace(nsFixes, "`" + ns);
        }
        String nsList = Joiner.on("`").join(namespaces);
        return qcode + ";" + NL + nsFixes + NL + "\"Loaded Module: " + nsList + "\"";
    }

    public static String getMathModule() throws IOException {
        return IOUtils.toString(ModuleRunner.class, MATH_Q);
    }

    public static String getMathModuleExampleTests() throws IOException {
        return IOUtils.toString(ModuleRunner.class, MATH_TEST_Q);
    }
}

