/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.pro.kdb;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.timestored.pro.kdb.DotQ;
import com.timestored.pro.kdb.Dotz;
import com.timestored.pro.kdb.Function;
import com.timestored.qdoc.DocSource;
import com.timestored.qdoc.DocumentedEntity;
import com.timestored.qdoc.OpenDocumentsDocSource;
import com.timestored.qstudio.QStudioModel;
import com.timestored.qstudio.model.AdminModel;
import com.timestored.qstudio.model.ServerObjectTree;
import java.util.ArrayList;
import java.util.List;

class KdbDocSource
implements DocSource {
    private final List<DocumentedEntity> staticDocs;
    private final AdminModel adminModel;
    private static Predicate<DocumentedEntity> excludeBuiltins = de -> !de.getDocName().startsWith(".q.") && !de.getDocName().startsWith(".Q.") && !de.getDocName().startsWith(".h.") && !de.getDocName().startsWith(".j.") && !de.getDocName().startsWith(".o.");
    private final OpenDocumentsDocSource openDocsDS;

    public KdbDocSource(QStudioModel qStudioModel) {
        this.adminModel = qStudioModel.getAdminModel();
        this.openDocsDS = new OpenDocumentsDocSource(qStudioModel.getOpenDocumentsModel());
        ArrayList<Function> docs = new ArrayList<Function>(Function.getKnownfunctions());
        docs.addAll(DotQ.getKnowndotq());
        docs.addAll(Dotz.getKnowndotz());
        this.staticDocs = docs;
    }

    @Override
    public List<? extends DocumentedEntity> getDocs() {
        ArrayList<DocumentedEntity> docs = new ArrayList<DocumentedEntity>(this.staticDocs);
        ServerObjectTree selectedSeverTree = this.adminModel.getServerTree(this.adminModel.getSelectedServerName());
        if (selectedSeverTree != null) {
            docs.addAll(selectedSeverTree.getAllDocumentationEntities(excludeBuiltins));
        }
        docs.addAll(this.openDocsDS.getDocs());
        return ImmutableList.copyOf(docs).asList();
    }
}

