/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.pro.kdb;

import com.timestored.TimeStored;
import com.timestored.pro.kdb.DatabaseManager;
import com.timestored.qstudio.CommonActions;
import com.timestored.qstudio.Persistance;
import com.timestored.qstudio.UpdateHelper;
import com.timestored.qstudio.model.AdminModel;
import com.timestored.qstudio.model.DatabaseDirector;
import com.timestored.qstudio.model.QueryManager;
import com.timestored.qstudio.model.ServerModel;
import com.timestored.qstudio.model.TableSQE;
import com.timestored.sqldash.theme.DBIcons;
import com.timestored.theme.Theme;
import java.awt.event.ActionEvent;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;

class KdbActionsGenerator
implements DatabaseDirector.ActionsGenerator {
    private static final Logger LOG = Logger.getLogger(KdbActionsGenerator.class.getName());
    private final QueryManager queryManager;
    private final AdminModel adminModel;
    private final ServerModel serverModel;

    @Override
    public void addColumnMenuItems(JPopupMenu menu, TableSQE table, String column, boolean partitionColumn) {
        if (!this.serverModel.getServerConfig().isKDB()) {
            JMenuItem mi = new JMenuItem("DB Operations not supported on this database.");
            mi.setEnabled(false);
            menu.add(mi);
        } else if (partitionColumn) {
            JMenuItem mi = new JMenuItem("This is the partition column.");
            mi.setEnabled(false);
            menu.add(mi);
        } else {
            ColumnGenie colGenie = new ColumnGenie(table, column);
            colGenie.addAll(menu);
        }
    }

    private Action ww(final Action a) {
        Icon i = (Icon)a.getValue("SmallIcon");
        String nm = (String)a.getValue("Name");
        AbstractAction wrapAct = new AbstractAction(nm, i){

            @Override
            public void actionPerformed(ActionEvent e) {
                Persistance.Key warningKey = Persistance.Key.SHOW_DBM_WARNING;
                String msgHtml = "<a href='" + TimeStored.Page.QSTUDIO_HELP_DBMANAGE.url() + "'>Database Management</a> requires loading a module into the .dbm namespace of the selected server.<br/> <br/>You are advised to read the help pages before making major database changes, <br/>Some important advice includes:<br/>1. Make a backup before performing any changes.<br/>2. Expect on-disk changes to take a long time, see the console for output on work progress<br/>3. Make sure the database is freshly loaded to prevent files being locked by queries or variables.<br/>4. If the database is part of a tick setup, remember to change the config files.<br/><br/>More help can be found on the <a href='" + TimeStored.Page.QSTUDIO_HELP_DBMANAGE.url() + "'>database management help page</a><br/><br/><b>Perform the database operation?</b>";
                String title = "Load and Run .dbm module";
                int choice = CommonActions.showDismissibleWarning(Persistance.INSTANCE, warningKey, msgHtml, "Load and Run .dbm module", "Run Modification", 0);
                if (choice == 0) {
                    a.actionPerformed(e);
                }
            }
        };
        return wrapAct;
    }

    public KdbActionsGenerator(QueryManager queryManager, AdminModel adminModel, ServerModel serverModel) {
        this.queryManager = queryManager;
        this.adminModel = adminModel;
        this.serverModel = serverModel;
    }

    private class ColumnGenie {
        private final TableSQE table;
        private final String column;

        private void sendWaitRefresh(String actionTitle, String query) {
            if (query == null) {
                JOptionPane.showMessageDialog(null, actionTitle + " is not possible.");
            } else {
                KdbActionsGenerator.this.queryManager.setSelectedServerName(KdbActionsGenerator.this.serverModel.getName());
                KdbActionsGenerator.this.queryManager.sendQuery(query, actionTitle);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e1) {
                    LOG.warning("problem waiting 1354");
                }
                KdbActionsGenerator.this.adminModel.refresh(KdbActionsGenerator.this.serverModel.getServerConfig());
            }
        }

        public void addAll(JPopupMenu menu) {
            menu.add(new AbstractAction("Column: " + this.column, Theme.CIcon.TREE_ELEMENT.get16()){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                }

                @Override
                public boolean isEnabled() {
                    return false;
                }
            });
            menu.addSeparator();
            menu.add(KdbActionsGenerator.this.ww(new DeleteAction()));
            menu.add(KdbActionsGenerator.this.ww(new CopyAction()));
            menu.add(KdbActionsGenerator.this.ww(new RenameAction()));
            JMenu attribsMenu = new JMenu("Set Attribute");
            attribsMenu.add(KdbActionsGenerator.this.ww(new AttributeAction("Clear", " ", DBIcons.ATTRIB_N)));
            attribsMenu.add(KdbActionsGenerator.this.ww(new AttributeAction("Grouped", "g", DBIcons.ATTRIB_G)));
            attribsMenu.add(KdbActionsGenerator.this.ww(new AttributeAction("Parted", "p", DBIcons.ATTRIB_P)));
            attribsMenu.add(KdbActionsGenerator.this.ww(new AttributeAction("Sorted", "s", DBIcons.ATTRIB_S)));
            attribsMenu.add(KdbActionsGenerator.this.ww(new AttributeAction("Unique", "u", DBIcons.ATTRIB_U)));
            menu.add(attribsMenu);
            menu.addSeparator();
        }

        public ColumnGenie(TableSQE table, String column) {
            this.table = table;
            this.column = column;
        }

        private class DeleteAction
        extends AbstractAction {
            final String query;

            public DeleteAction() {
                super("Delete Column", Theme.CIcon.DELETE.get16());
                this.query = DatabaseManager.getDeleteColumnQuery(ColumnGenie.this.table.getName(), ColumnGenie.this.column);
            }

            @Override
            public boolean isEnabled() {
                return this.query != null;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ColumnGenie.this.sendWaitRefresh("Delete Column: " + ColumnGenie.this.column, this.query);
                UpdateHelper.registerEvent("kdb_delcol");
            }
        }

        private class AttributeAction
        extends AbstractAction {
            private final String attrib;

            public AttributeAction(String label, String attrib, DBIcons icon) {
                super(label, icon.get16());
                this.attrib = attrib;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                String q = DatabaseManager.getSetAttributeColumnQuery(ColumnGenie.this.table.getName(), ColumnGenie.this.column, this.attrib);
                ColumnGenie.this.sendWaitRefresh("Set Attribute " + this.attrib + ": " + ColumnGenie.this.column, q);
                UpdateHelper.registerEvent("kdb_attribcol");
            }
        }

        private class RenameAction
        extends AbstractAction {
            public RenameAction() {
                super("Rename Column", Theme.CIcon.RENAME.get16());
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                String newCol = JOptionPane.showInputDialog("Enter name for new column:");
                if (newCol != null) {
                    String q = DatabaseManager.getRenameColumnQuery(ColumnGenie.this.table.getName(), ColumnGenie.this.column, newCol);
                    ColumnGenie.this.sendWaitRefresh("Rename Column: " + ColumnGenie.this.column, q);
                }
                UpdateHelper.registerEvent("kdb_renamecol");
            }
        }

        private class CopyAction
        extends AbstractAction {
            public CopyAction() {
                super("Copy Column", Theme.CIcon.COPY.get16());
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                String newCol = JOptionPane.showInputDialog("Enter name for new column:");
                if (newCol != null) {
                    String q = DatabaseManager.getCopyColumnQuery(ColumnGenie.this.table.getName(), ColumnGenie.this.column, newCol);
                    ColumnGenie.this.sendWaitRefresh("Copy Column: " + ColumnGenie.this.column, q);
                }
                UpdateHelper.registerEvent("kdb_copycol");
            }
        }
    }
}

