/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.pro.kdb;

import com.timestored.TimeStored;
import com.timestored.docs.Document;
import com.timestored.docs.OpenDocumentsModel;
import com.timestored.jgrowl.Growler;
import com.timestored.messages.Msg;
import com.timestored.misc.IOUtils;
import com.timestored.pro.kdb.ModuleRunner;
import com.timestored.qstudio.CommonActions;
import com.timestored.qstudio.Persistance;
import com.timestored.qstudio.QStudioModel;
import com.timestored.qstudio.UpdateHelper;
import com.timestored.theme.ShortcutAction;
import com.timestored.theme.Theme;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JOptionPane;
import lombok.NonNull;

class KdbActions {
    private static final Logger LOG = Logger.getLogger(KdbActions.class.getName());
    private static List<Action> proActions = null;
    @NonNull
    private final CommonActions commonActions;
    @NonNull
    private final OpenDocumentsModel openDocumentsModel;
    @NonNull
    private final Growler growler;
    @NonNull
    private final Persistance persistance;

    private KdbActions(@NonNull CommonActions commonActions, @NonNull QStudioModel qStudioModel, @NonNull Growler growler, @NonNull Persistance persistance) {
        if (commonActions == null) {
            throw new NullPointerException("commonActions is marked non-null but is null");
        }
        if (qStudioModel == null) {
            throw new NullPointerException("qStudioModel is marked non-null but is null");
        }
        if (growler == null) {
            throw new NullPointerException("growler is marked non-null but is null");
        }
        if (persistance == null) {
            throw new NullPointerException("persistance is marked non-null but is null");
        }
        this.commonActions = commonActions;
        this.openDocumentsModel = qStudioModel.getOpenDocumentsModel();
        this.growler = growler;
        this.persistance = persistance;
    }

    public static List<Action> getProActions(@NonNull CommonActions commonActions, @NonNull QStudioModel qStudioModel, @NonNull Growler growler, Persistance persistance) {
        if (commonActions == null) {
            throw new NullPointerException("commonActions is marked non-null but is null");
        }
        if (qStudioModel == null) {
            throw new NullPointerException("qStudioModel is marked non-null but is null");
        }
        if (growler == null) {
            throw new NullPointerException("growler is marked non-null but is null");
        }
        return new KdbActions(commonActions, qStudioModel, growler, persistance).getProActions();
    }

    private List<Action> getProActions() {
        if (proActions == null) {
            ShortcutAction unitTestAction = new ShortcutAction("Unit Test Current Script", Theme.CIcon.SCRIPT_GO, "Unit test all namespaces within the current script.", 84, 84){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent ae) {
                    KdbActions.this.runQUnitTests();
                    UpdateHelper.registerEvent("pro_unit");
                }
            };
            ShortcutAction loadScriptAction = new ShortcutAction(Msg.get(Msg.Key.LOAD_SCRIPT_MODULE), Theme.CIcon.SERVER_GO, "Load this q script onto current server.", 76, 76){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    KdbActions.this.runScriptModuleLoad();
                    UpdateHelper.registerEvent("pro_load");
                }
            };
            ShortcutAction profileAction = new ShortcutAction(Msg.get(Msg.Key.PROFILE_SELECTION), Theme.CIcon.CLOCK_GO, "Profile highlighted Q query on current server.", 74, 74){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent ae) {
                    String qry = KdbActions.this.openDocumentsModel.getSelectedDocument().getSelectedText();
                    if (qry.length() <= 0) {
                        qry = KdbActions.this.openDocumentsModel.getSelectedDocument().getContent();
                    }
                    if (qry.length() > 0) {
                        try {
                            String prof = IOUtils.toString(CommonActions.class, "profile.q");
                            String fullQuery = prof + "@[;1] .prof.profile \"" + qry.replace("\"", "\\\"") + "\"";
                            KdbActions.this.commonActions.sendQuery(fullQuery, "PROFILE -> " + qry);
                        }
                        catch (IOException e) {
                            LOG.log(Level.SEVERE, "Problem loading profile.q", e);
                        }
                    }
                    UpdateHelper.registerEvent("pro_profile");
                }
            };
            ArrayList<Action> l = new ArrayList<Action>();
            l.add(unitTestAction);
            l.add(loadScriptAction);
            l.add(profileAction);
            proActions = l;
        }
        return proActions;
    }

    private void runScriptModuleLoad() {
        String qry = null;
        try {
            Document doc = this.openDocumentsModel.getSelectedDocument();
            qry = ModuleRunner.getRunScriptModuleLoad(doc.getContent());
            this.commonActions.sendQuery(qry, "Loading -> " + doc.getTitle());
        }
        catch (IOException io) {
            this.growler.showWarning("Could not load script loader module", "Module Load Fail");
        }
    }

    private void runQUnitTests() {
        Persistance.Key warningKey = Persistance.Key.SHOW_QDOC_WARNING;
        String msgHtml = "<a href='" + TimeStored.Page.QUNIT_HELP.url() + "'>QUnit</a> is a framework for implementing testing in kdb. <br/> <br/>Running qunit tests involves: <br/>1. Loading the qunit module into the .qunit namespace. <br/>2. Loading all test functions within the currently selected document. <br/>3. Running the tests, checking all assertions are met. <br/>4. Reporting a table of results. <br/><br/>Tests must be properly structured and more help can be found on the <a href='" + TimeStored.Page.QSTUDIO_HELP_QUNIT.url() + "'>qunit help page</a><br/><br/><b>Run the qunit tests?</b>";
        String title = "Load and Run .qunit module";
        int choice = CommonActions.showDismissibleWarning(this.persistance, warningKey, msgHtml, "Load and Run .qunit module", "Run Tests", 0);
        if (choice == 0) {
            String qry = null;
            try {
                String testq = this.openDocumentsModel.getSelectedDocument().getContent();
                try {
                    qry = ModuleRunner.getRunQUnitQuery(testq);
                }
                catch (IllegalArgumentException iae) {
                    String message = "no namespace found in this file";
                    JOptionPane.showMessageDialog(null, message);
                }
            }
            catch (IOException io) {
                this.growler.showWarning("Could not load testing module", "Module Load Fail");
            }
            if (qry != null) {
                String t = this.openDocumentsModel.getSelectedDocument().getTitle();
                this.commonActions.sendQuery(qry, "TEST file -> " + t);
            }
        }
    }
}

