/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.pro.kdb;

import com.google.common.base.Preconditions;
import com.timestored.misc.IOUtils;
import com.timestored.pro.kdb.ModuleRunner;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

class DatabaseManager {
    public static String GET_TREE_QUERY = "/ qstudio - get server tree \r\n{   nsl:\".\",/:string `,key `;    \r\n    nsf:{[ns] \r\n        ff:{ [viewset; v; fullname; sname]\r\n            findColArgs:{$[.Q.qt x; cols x; 100h~type x; (value x)1; `$()]};\r\n            safeCount: {$[.Q.qp x; $[`pn in key `.Q; {$[count x;sum x;-1]} .Q.pn y; -1]; count x]};\r\n            (@[type;v;0h]; .[safeCount;(v;fullname);-2]; @[.Q.qt;v;0b]; @[.Q.qp;v;0b]; @[findColArgs;v;()]; .[in;(sname;viewset);0b])};\r\n        vws: system \"b \",ns;\r\n        n: asc key[`$ns] except `;\r\n        fn: $[ns~enlist \".\"; n; ns,/:\".\",/:string n];\r\n        n!.'[ ff[vws;;;]; flip ( @[`$ns; n]; fn; n)]};\r\n    (`$nsl)!@[nsf;;()!()] each nsl}[]";
    private static volatile String pre = null;
    private static final String ns = ".dbm";
    private static final List<String> ATTRIBS = Arrays.asList("", "g", "p", "u", "s");

    DatabaseManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static StringBuilder getDbmLoaded() throws IOException {
        if (pre == null) {
            Class<DatabaseManager> clazz = DatabaseManager.class;
            // MONITORENTER : com.timestored.pro.kdb.DatabaseManager.class
            if (pre == null) {
                pre = IOUtils.toString(ModuleRunner.class, "dbm.q") + IOUtils.toString(ModuleRunner.class, "nsfixer.q") + "`.dbm; \r\n";
            }
            // MONITOREXIT : clazz
        }
        StringBuilder sb = new StringBuilder(pre.length() + 300);
        sb.append(pre);
        return sb;
    }

    public static String getDeleteColumnQuery(String table, String column) {
        return DatabaseManager.callFunc("deleteCol", table, column);
    }

    public static String getCopyColumnQuery(String table, String oldCol, String newCol) {
        return DatabaseManager.callFunc("copyCol", table, oldCol, newCol);
    }

    public static String getRenameColumnQuery(String table, String oldCol, String newCol) {
        return DatabaseManager.callFunc("renameCol", table, oldCol, newCol);
    }

    public static String getSetAttributeColumnQuery(String table, String col, String attrib) {
        Preconditions.checkNotNull(attrib);
        String a = attrib.trim().toLowerCase();
        Preconditions.checkArgument(ATTRIBS.contains(a));
        return DatabaseManager.callFunc("setAttrCol", table, col, a);
    }

    private static String callFunc(String funcName, String ... args) {
        try {
            StringBuilder sb = DatabaseManager.getDbmLoaded();
            sb.append("{r:").append(ns).append(".").append(funcName).append("[");
            for (int i = 0; i < args.length; ++i) {
                sb.append(i > 0 ? "; `" : " `").append(args[i]);
            }
            sb.append("]").append("; delete from `.dbm; r}[]");
            return sb.toString();
        }
        catch (IOException e) {
            return null;
        }
    }
}

