/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.pro.kdb;

import com.google.common.base.Preconditions;
import com.timestored.TimeStored;
import com.timestored.kdb.KdbConnection;
import com.timestored.misc.HtmlUtils;
import com.timestored.misc.IOUtils;
import com.timestored.qdoc.HtmlPqfOutputter;
import com.timestored.qstudio.model.TableModelHtmlConverter;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.SQLException;
import kx.c;
import kx.jdbc;

class DatabaseHtmlReport {
    private static final String QSTUDIO_LINK = "<a class='qlogo' href='" + TimeStored.Page.QSTUDIO.url() + "' target='a'>q<span>Studio</span></a>";
    private static final String DATABASE_REPORT_Q = "dbreport.q";

    DatabaseHtmlReport() {
    }

    public static void generate(KdbConnection kdbConn, File destFile) throws IOException, SQLException {
        destFile.createNewFile();
        Preconditions.checkArgument(destFile.isFile() && destFile.canWrite(), "Must be able to write to destination file");
        Preconditions.checkNotNull(kdbConn);
        Preconditions.checkArgument(kdbConn.isConnected());
        Object k = null;
        boolean hasTables = false;
        try {
            hasTables = (Boolean)kdbConn.query("0<count system \"a\"");
            if (!hasTables) {
                throw new IOException("no tables in kdb process " + kdbConn.getName());
            }
            String dbreportq = IOUtils.toString(DatabaseHtmlReport.class, DATABASE_REPORT_Q);
            k = kdbConn.query(dbreportq);
        }
        catch (c.KException e) {
            throw new IOException("Kdb Exception:", e);
        }
        Object[] resArray = (Object[])k;
        jdbc.ExtendedResultSet rs2 = jdbc.getRS(resArray[0], "Database Report");
        PrintWriter pw = new PrintWriter(destFile);
        String title = kdbConn.getName() + " database structure";
        String header = "<style type=\"text/css\">html table {width:auto;} table td,table th { padding:2px; }</style>";
        pw.println(HtmlUtils.getTSPageHead(title, QSTUDIO_LINK, "<link rel=\"stylesheet\" href=\"qdoc.css\" type=\"text/css\" media=\"screen\" />" + header, true));
        pw.println("<h1>" + title + "</h1>");
        if (hasTables) {
            try {
                pw.println(TableModelHtmlConverter.convert(rs2));
                c.Dict details = (c.Dict)resArray[1];
                DatabaseHtmlReport.printTableDetails(pw, details);
            }
            catch (ClassCastException cce) {
                pw.println("error parsing table details.");
            }
        } else {
            pw.println("No tables");
        }
        pw.println(HtmlUtils.getTSPageTail(QSTUDIO_LINK));
        pw.close();
        HtmlPqfOutputter.saveQdocCssTo(destFile.getParent());
    }

    private static void printTableDetails(PrintWriter pw, c.Dict details) throws SQLException {
        String tableName;
        int i;
        Object[] tableMetas = (Object[])details.y;
        pw.println("<ul>");
        for (i = 0; i < tableMetas.length; ++i) {
            tableName = ((String[])details.x)[i];
            pw.println("<li><a href='#tab-" + tableName + "'>" + tableName + "</a></li>");
        }
        pw.println("</ul>");
        for (i = 0; i < tableMetas.length; ++i) {
            tableName = ((String[])details.x)[i];
            pw.println("<h3 id='tab-" + tableName + "'>" + tableName + "</h3>");
            jdbc.ExtendedResultSet metaTM = jdbc.getRS(tableMetas[i], "TableDetails");
            if (metaTM != null) {
                pw.println(TableModelHtmlConverter.convert(metaTM));
                continue;
            }
            pw.println("Could not understand kdb result.");
        }
    }
}

