/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.pro.dolphindb;

import com.timestored.babeldb.BabelDBJdbcDriver;
import com.timestored.babeldb.SimpleResultSet;
import com.timestored.misc.IOUtils;
import com.timestored.qdoc.BuiltinDocumentedEntities;
import com.timestored.qdoc.DocSource;
import com.timestored.theme.Theme;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;

public class DosDocs
extends BuiltinDocumentedEntities
implements DocSource {
    private static List<DosDocs> KNOWN_FUNCS = null;
    private final String params;

    protected DosDocs(String docname, String description, String params, String cal, String eg) {
        super(docname, description, cal, eg);
        this.params = params == null ? "" : params;
    }

    @Override
    public ImageIcon getIcon() {
        return Theme.CIcon.FUNCTION_ELEMENT.get16();
    }

    public synchronized List<DosDocs> getDocs() {
        return DosDocs.getKnownFunctions();
    }

    private static String gt(ResultSet rs2, String colName) throws SQLException {
        String s = rs2.getString(colName);
        return s == null ? "" : s.replace("\\n", "\n");
    }

    public static synchronized List<DosDocs> getKnownFunctions() {
        if (KNOWN_FUNCS == null) {
            KNOWN_FUNCS = new ArrayList<DosDocs>();
            try {
                String json = IOUtils.toString(DosDocs.class, "docs.json");
                SimpleResultSet rs2 = BabelDBJdbcDriver.fromTxt(json);
                while (rs2.next()) {
                    KNOWN_FUNCS.add(new DosDocs(DosDocs.gt(rs2, "title"), DosDocs.gt(rs2, "exp"), DosDocs.gt(rs2, "params"), DosDocs.gt(rs2, "cal"), DosDocs.gt(rs2, "eg")));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return KNOWN_FUNCS;
    }

    @Override
    public String getSource() {
        return "Dolphin";
    }

    @Override
    public String getLink() {
        String page = this.docname;
        int pos = page.indexOf("(");
        if (pos != -1) {
            page = page.substring(0, pos);
        }
        String e = page.toLowerCase().charAt(0) + "/" + page + ".html";
        return "https://docs.dolphindb.cn/en/help200/FunctionsandCommands/FunctionReferences/" + e;
    }
}

