/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.pro.csvloader;

import com.timestored.pro.csvloader.TabListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

class KdbTypeMatcherTabListener
implements TabListener {
    private HashMap<String, Set<RECOGNISED_TYPES>> colnameToTypeMatches = new HashMap();

    KdbTypeMatcherTabListener() {
    }

    @Override
    public void tabEvent(String[] colNames, List<String[]> rowData) {
        for (int c2 = 0; c2 < colNames.length; ++c2) {
            String cn = colNames[c2];
            if (!this.colnameToTypeMatches.containsKey(cn)) {
                EnumSet<RECOGNISED_TYPES> allPossible = EnumSet.allOf(RECOGNISED_TYPES.class);
                this.colnameToTypeMatches.put(cn, allPossible);
            }
            Set<RECOGNISED_TYPES> possible = this.colnameToTypeMatches.get(cn);
            block1: for (RECOGNISED_TYPES rtype : possible) {
                for (int r = 0; r < rowData.size(); ++r) {
                    String s = rowData.get(r)[c2].trim();
                    if (s.isEmpty() || rtype.recognises(s)) continue;
                    possible.remove(rtype);
                    continue block1;
                }
            }
        }
    }

    public Map<String, Character> getRecognisedKdbTypes() {
        HashMap<String, Character> r = new HashMap<String, Character>();
        for (Map.Entry<String, Set<RECOGNISED_TYPES>> e : this.colnameToTypeMatches.entrySet()) {
            if (e.getValue().isEmpty()) continue;
            ArrayList types = new ArrayList(e.getValue());
            Collections.sort(types);
            if (((RECOGNISED_TYPES)types.get(0)).kdbTypeLetter == '*') continue;
            r.put(e.getKey(), Character.valueOf(((RECOGNISED_TYPES)types.get(0)).kdbTypeLetter));
        }
        return r;
    }

    private static enum RECOGNISED_TYPES implements Comparable<RECOGNISED_TYPES>
    {
        EMPTY('*', ""){

            @Override
            public boolean recognises(String s) {
                return s.trim().isEmpty();
            }
        }
        ,
        DATE('D', ""){

            @Override
            public boolean recognises(String s) {
                boolean match = false;
                String[] r = s.split("[\\/\\-\\.]");
                if (r.length == 3) {
                    try {
                        int a = Integer.parseInt(r[0]);
                        int b = Integer.parseInt(r[1]);
                        int c2 = Integer.parseInt(r[2]);
                        match = a > 0 && a <= 31 && b > 0 && b <= 31 && c2 > 0 && c2 <= 9999 || c2 > 0 && c2 <= 31 && b > 0 && b <= 31 && a > 0 && a <= 9999;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                return match;
            }
        }
        ,
        MINUTE('U', "^(?:[0-2])?[0-9]:[0-5][0-9]$"),
        SECOND('V', "^(?:[0-2])?[0-9]:[0-5][0-9](:[0-5][0-9])?$"),
        TIME('T', "^(?:[0-2])?[0-9]:[0-5][0-9](:[0-5][0-9](\\.?[0-9]*))??$"),
        LONG('J', "^-?\\d{1,19}$"),
        DOUBLE('F', "[-+]?[0-9]*\\.?[0-9]+(e[+-]?\\d+)?");

        private final String regex;
        private final char kdbTypeLetter;

        private RECOGNISED_TYPES(char kdbTypeLetter, String regex) {
            this.kdbTypeLetter = kdbTypeLetter;
            this.regex = regex;
        }

        public boolean recognises(String s) {
            if (this.equals(DOUBLE) && !s.matches(this.regex)) {
                System.out.println(s);
            }
            return s.matches(this.regex);
        }
    }
}

