/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.pro.csvloader;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

class JFilePicker
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final JLabel label;
    private final JTextField textField;
    private final JButton button;
    private final JFileChooser fileChooser = new JFileChooser();
    private Mode mode;

    JFilePicker(String textFieldLabel, String buttonLabel) {
        this.setLayout(new FlowLayout(1, 5, 5));
        this.label = new JLabel(textFieldLabel);
        this.textField = new JTextField(30);
        this.textField.setEditable(false);
        this.button = new JButton(buttonLabel);
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JFilePicker.this.buttonActionPerformed(evt);
            }
        });
        this.add(this.label);
        this.add(this.textField);
        this.add(this.button);
    }

    private void buttonActionPerformed(ActionEvent evt) {
        if (this.mode == Mode.OPEN) {
            if (this.fileChooser.showOpenDialog(this) == 0) {
                this.textField.setText(this.fileChooser.getSelectedFile().getAbsolutePath());
            }
        } else if (this.mode == Mode.SAVE && this.fileChooser.showSaveDialog(this) == 0) {
            this.textField.setText(this.fileChooser.getSelectedFile().getAbsolutePath());
        }
    }

    public void addFileFilter(FileFilter fileFilter) {
        this.fileChooser.addChoosableFileFilter(fileFilter);
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public String getSelectedFilePath() {
        return this.textField.getText();
    }

    public File getSelectedFile() {
        return this.fileChooser.getSelectedFile();
    }

    public void setSelectedFile(File file) {
        if (file != null && file.exists()) {
            if (!file.getAbsolutePath().equals(this.textField.getText())) {
                this.textField.setText(file.getAbsolutePath());
            }
        } else {
            this.textField.setText("");
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.fileChooser.addActionListener(actionListener);
    }

    static enum Mode {
        OPEN,
        SAVE;

    }
}

