/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.pro.csvloader;

import com.google.common.base.Preconditions;
import com.timestored.connections.ConnectionManager;
import com.timestored.connections.ServerConfig;
import com.timestored.kdb.KdbConnection;
import com.timestored.pro.csvloader.CSVLoader;
import com.timestored.pro.csvloader.CsvConfig;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

class CsvLoaderModel {
    private CsvConfig csvConfig;
    private File csvFile;
    private String tableName;
    private ServerConfig selectedServer;
    private final List<Listener> listeners = new CopyOnWriteArrayList<Listener>();
    private final ConnectionManager connectionManager;

    public CsvLoaderModel(ConnectionManager connectionManager, File file) throws IOException {
        this.connectionManager = Preconditions.checkNotNull(connectionManager);
        this.setCsvFile(file);
        List<String> names = connectionManager.getServerNames();
        if (!names.isEmpty()) {
            this.selectedServer = connectionManager.getServer(names.get(0));
        }
        this.csvConfig = CsvConfig.detect(file);
    }

    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public File getCsvFile() {
        return this.csvFile;
    }

    public void setCsvFile(File csvFile) {
        boolean sameFile;
        String msg = "valid file must be selected.";
        Preconditions.checkNotNull(csvFile, msg);
        boolean bl = sameFile = this.csvFile != null && csvFile.getAbsolutePath().equals(this.csvFile.getAbsolutePath());
        if (!sameFile) {
            Preconditions.checkArgument(csvFile.isFile() && csvFile.canRead(), msg);
            this.csvFile = csvFile;
            this.notifyListeners();
        }
    }

    public void setTableName(String tableName) {
        Preconditions.checkNotNull(tableName);
        if (!tableName.equals(this.tableName)) {
            String msg = "Table name must be atleast one letter and all ascii characters only";
            Preconditions.checkArgument(tableName.matches("[a-zA-Z0-9]+"), msg);
            this.tableName = tableName;
            this.notifyListeners();
        }
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setServer(ServerConfig selectedServer) {
        if (selectedServer != null) {
            Preconditions.checkArgument(this.connectionManager.contains(selectedServer));
        }
        this.selectedServer = selectedServer;
        this.notifyListeners();
    }

    public ServerConfig getServer() {
        return this.selectedServer;
    }

    public CsvConfig getCsvConfig() {
        return this.csvConfig;
    }

    void notifyListeners() {
        for (Listener l : this.listeners) {
            l.update(this);
        }
    }

    public boolean addListener(Listener listener) {
        return this.listeners.add(listener);
    }

    public CSVLoader getCsvLoader() throws IOException {
        this.checkStateValid();
        KdbConnection kdbConn = this.connectionManager.getKdbConnection(this.selectedServer);
        if (kdbConn == null) {
            throw new IOException("Was not possible to connect.");
        }
        return new CSVLoader(this.csvFile.getAbsolutePath(), this.csvConfig, kdbConn, this.tableName);
    }

    private void checkStateValid() {
        if (this.tableName == null || this.tableName.trim().length() < 1) {
            throw new IllegalStateException("Table name must be specified");
        }
        if (this.csvFile == null || !this.csvFile.canRead() || !this.csvFile.isFile()) {
            throw new IllegalStateException("Csv file not specified or cannot be read");
        }
    }

    protected static interface Listener {
        public void update(CsvLoaderModel var1);
    }
}

