/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.pro.csvloader;

import com.google.common.base.Preconditions;
import com.timestored.connections.ConnectionManager;
import com.timestored.connections.ServerConfig;
import com.timestored.connections.ServerNameComboBox;
import com.timestored.messages.Msg;
import com.timestored.pro.csvloader.CSVLoader;
import com.timestored.pro.csvloader.CsvConfig;
import com.timestored.pro.csvloader.CsvLoaderModel;
import com.timestored.pro.csvloader.JFilePicker;
import com.timestored.qstudio.BackgroundExecutor;
import com.timestored.qstudio.QStudioFrame;
import com.timestored.qstudio.QStudioLauncher;
import com.timestored.swingxx.SwingUtils;
import com.timestored.theme.Theme;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.SortedMap;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;

public class CsvLoaderFrame
extends JFrame
implements CsvLoaderModel.Listener {
    private static final Logger LOG = Logger.getLogger(CsvLoaderFrame.class.getName());
    private static int count = 1;
    private static final int PREF_WIDTH = 1000;
    private static final int PREF_HEIGHT = 800;
    private static final int MIN_HEIGHT = 600;
    private static final int MIN_WIDTH = 700;
    private static final long serialVersionUID = 1L;
    private static final Theme.InputLabeller LABELLER = Theme.getInputLabeller(80, 20);
    private final JFilePicker filePicker;
    private final JComboBox charSetComboBox;
    private final JSpinner rowSpinner;
    private final JButton loadButton;
    private final JButton cancelButton;
    private final JTextField separatorTF;
    private final JTextField quoteTF;
    private SortedMap<String, Charset> charsets;
    private final JPanel previewPanel;
    private final JCheckBox headerCheckBox;
    private final ServerNameComboBox serverComboBox;
    private final JPanel container;
    private final JTextField tableNameTextField;
    private JDialog progressCancelDialog;
    private final CsvLoaderModel csvLoaderModel;
    private LoadWorker loadWorker;
    private JTextField rowLoadTextField;

    public static void showCsvImporter(QStudioFrame qStudioFrame, ConnectionManager connectionManager, ServerConfig selectedServer) throws IOException {
        File file;
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(0);
        fc.setDialogTitle(Msg.get(Msg.Key.SELECT_FILE_TO_IMPORT));
        fc.setDialogType(0);
        fc.setMultiSelectionEnabled(false);
        fc.setApproveButtonText(Msg.get(Msg.Key.IMPORT));
        if (fc.showOpenDialog(null) == 0 && (file = fc.getSelectedFile()) != null) {
            CsvLoaderModel csvLoaderModel = new CsvLoaderModel(connectionManager, file);
            csvLoaderModel.setServer(selectedServer);
            CsvLoaderFrame window = new CsvLoaderFrame(csvLoaderModel);
            SwingUtils.setSensibleDimensions(qStudioFrame, window);
            window.setLocationRelativeTo(qStudioFrame);
            window.setVisible(true);
            window.setDefaultCloseOperation(2);
        }
    }

    CsvLoaderFrame(final CsvLoaderModel csvLoaderModel) {
        this.csvLoaderModel = Preconditions.checkNotNull(csvLoaderModel);
        String tName = csvLoaderModel.getTableName();
        if (tName == null || tName.trim().length() == 0) {
            csvLoaderModel.setTableName("tab" + count++);
        }
        this.setDefaultCloseOperation(2);
        this.setIconImage(Theme.CIcon.CSV.get16().getImage());
        this.setTitle("CSV Importer");
        this.filePicker = new JFilePicker("Pick a file", "Browse...");
        this.filePicker.setMode(JFilePicker.Mode.OPEN);
        this.filePicker.setSelectedFile(csvLoaderModel.getCsvFile());
        this.filePicker.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CsvLoaderFrame.this.filePicker.getSelectedFile() != null) {
                    csvLoaderModel.setCsvFile(CsvLoaderFrame.this.filePicker.getSelectedFile());
                }
            }
        });
        this.serverComboBox = new ServerNameComboBox(csvLoaderModel.getConnectionManager());
        this.serverComboBox.setPreferredSize(new Dimension(600, (int)this.serverComboBox.getPreferredSize().getHeight()));
        this.serverComboBox.setSelectedItem(csvLoaderModel.getServer().getName());
        this.serverComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                csvLoaderModel.setServer(CsvLoaderFrame.this.serverComboBox.getSelectedServer());
            }
        });
        this.tableNameTextField = new JTextField();
        this.tableNameTextField.setColumns(20);
        this.tableNameTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                csvLoaderModel.setTableName(CsvLoaderFrame.this.tableNameTextField.getText());
            }
        });
        this.tableNameTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                try {
                    csvLoaderModel.setTableName(CsvLoaderFrame.this.tableNameTextField.getText());
                }
                catch (IllegalArgumentException iae) {
                    JOptionPane.showMessageDialog(CsvLoaderFrame.this, iae.getMessage());
                }
            }
        });
        this.charsets = Charset.availableCharsets();
        this.charSetComboBox = new JComboBox<Object>(this.charsets.keySet().toArray());
        this.charSetComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String cs2 = (String)CsvLoaderFrame.this.charSetComboBox.getSelectedItem();
                csvLoaderModel.getCsvConfig().setCharset(cs2);
                csvLoaderModel.notifyListeners();
            }
        });
        this.rowSpinner = new JSpinner(new SpinnerNumberModel(0, 0, Integer.MAX_VALUE, 1));
        this.rowSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                try {
                    Integer row = (Integer)CsvLoaderFrame.this.rowSpinner.getValue();
                    csvLoaderModel.getCsvConfig().setSkipLines(row);
                    csvLoaderModel.notifyListeners();
                }
                catch (ClassCastException classCastException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        });
        this.headerCheckBox = new JCheckBox("Contains header row");
        this.headerCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                csvLoaderModel.getCsvConfig().setContainsHeader(CsvLoaderFrame.this.headerCheckBox.isSelected());
                csvLoaderModel.notifyListeners();
            }
        });
        this.separatorTF = new JTextField(1);
        this.separatorTF.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                csvLoaderModel.getCsvConfig().setSeparator(e.getKeyChar());
                csvLoaderModel.notifyListeners();
            }
        });
        this.separatorTF.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                CsvLoaderFrame.this.separatorTF.selectAll();
            }
        });
        this.quoteTF = new JTextField(1);
        this.quoteTF.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                csvLoaderModel.getCsvConfig().setQuote(e.getKeyChar());
                csvLoaderModel.notifyListeners();
            }
        });
        this.quoteTF.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                CsvLoaderFrame.this.quoteTF.selectAll();
            }
        });
        this.previewPanel = new JPanel(new BorderLayout());
        this.previewPanel.setBorder(BorderFactory.createTitledBorder("Preview"));
        this.loadButton = new JButton("Load", Theme.CIcon.SERVER_GO.get16());
        this.loadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CsvLoaderFrame.this.executeLoad(CsvLoaderFrame.this, csvLoaderModel);
            }
        });
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CsvLoaderFrame.this.dispatchEvent(new WindowEvent(CsvLoaderFrame.this, 201));
            }
        });
        Box b = Box.createVerticalBox();
        b.add(this.getImportPanel());
        b.add(this.getSeparatorPanel());
        b.add(this.getDestinationPanel());
        this.container = new JPanel(new BorderLayout());
        this.container.add((Component)b, "North");
        this.container.add((Component)this.previewPanel, "Center");
        this.container.add((Component)this.getSaveCancelPanel(), "South");
        this.setMinimumSize(new Dimension(700, 600));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.container, "Center");
        csvLoaderModel.addListener(this);
        this.refreshUI();
    }

    private JPanel getSaveCancelPanel() {
        JPanel saveCancelPanel = new JPanel();
        JPanel p = CsvLoaderFrame.getGrid(this.loadButton, this.cancelButton);
        p.setPreferredSize(new Dimension(300, 40));
        p.setMinimumSize(new Dimension(300, 40));
        saveCancelPanel.add(p);
        return saveCancelPanel;
    }

    private JPanel getSeparatorPanel() {
        TitlePanel sepPanel = new TitlePanel("Separator Options");
        ((Container)sepPanel).add(CsvLoaderFrame.getGrid(LABELLER.get("Separator:", this.separatorTF, "separator"), LABELLER.get("Quote:", this.quoteTF, "quote")));
        return sepPanel;
    }

    private JPanel getImportPanel() {
        TitlePanel p = new TitlePanel("Import");
        ((Container)p).add(this.filePicker);
        ((Container)p).add(LABELLER.get("Character Set:", this.charSetComboBox, "charSet"));
        ((Container)p).add(CsvLoaderFrame.getGrid(LABELLER.get("From Row:", this.rowSpinner, "row"), this.headerCheckBox));
        return p;
    }

    private synchronized void executeLoad(JFrame parent, CsvLoaderModel csvLoaderModel) {
        if (this.loadWorker != null) {
            this.showMsg("Load already in progress, must finish current load operation before starting another");
            return;
        }
        try {
            CSVLoader csvLoader = csvLoaderModel.getCsvLoader();
            if (csvLoader.checkTableNameFree()) {
                this.loadWorker = new LoadWorker(csvLoader);
                this.progressCancelDialog = new JDialog((Frame)parent, "Loading...");
                JProgressBar pbar = new JProgressBar();
                pbar.setIndeterminate(true);
                this.rowLoadTextField = new JTextField(40);
                this.rowLoadTextField.setText("0 rows loaded");
                JButton cancelButton = new JButton("Cancel");
                cancelButton.addActionListener(new ActionListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void actionPerformed(ActionEvent e) {
                        CsvLoaderFrame csvLoaderFrame = CsvLoaderFrame.this;
                        synchronized (csvLoaderFrame) {
                            if (CsvLoaderFrame.this.loadWorker != null) {
                                CsvLoaderFrame.this.loadWorker.cancel(true);
                            }
                        }
                    }
                });
                this.progressCancelDialog.setLayout(new BorderLayout());
                this.progressCancelDialog.add((Component)pbar, "North");
                this.progressCancelDialog.add((Component)this.rowLoadTextField, "Center");
                this.progressCancelDialog.add((Component)cancelButton, "South");
                this.progressCancelDialog.setLocationRelativeTo(null);
                this.progressCancelDialog.setSize(200, 100);
                this.progressCancelDialog.setVisible(true);
                BackgroundExecutor.EXECUTOR.execute(this.loadWorker);
            } else {
                this.showMsg("That table name is already in use please choose another");
            }
        }
        catch (IOException e) {
            this.showMsg("IO error communicating with server", e);
        }
        catch (IllegalStateException ise) {
            this.showMsg(ise.getMessage(), ise);
        }
    }

    private void showMsg(Object message) {
        this.showMsg(message, null);
    }

    private void showMsg(Object message, Exception e) {
        if (message instanceof String) {
            LOG.log(Level.INFO, (String)message, e);
        }
        JOptionPane.showMessageDialog(this, message);
    }

    private static JPanel getGrid(Component left, Component right) {
        JPanel g = new JPanel(new BorderLayout());
        g.add(left, "West");
        g.add(right, "Center");
        return g;
    }

    private JPanel getDestinationPanel() {
        TitlePanel p = new TitlePanel("Destination");
        p.add(LABELLER.get(Msg.get(Msg.Key.SERVER) + ":", this.serverComboBox, Msg.get(Msg.Key.SERVER)));
        p.add(LABELLER.get("Table:", this.tableNameTextField, "tableName"));
        return p;
    }

    private void refreshUI() {
        ServerConfig sc;
        CsvConfig csvConfig = this.csvLoaderModel.getCsvConfig();
        Charset ch = (Charset)this.charsets.get(csvConfig.getCharset());
        if (ch != null && !this.charSetComboBox.getSelectedItem().equals(ch.name())) {
            this.charSetComboBox.setSelectedItem(ch.name());
        }
        if (!this.rowSpinner.getValue().equals(csvConfig.getSkipLines())) {
            this.rowSpinner.setValue(csvConfig.getSkipLines());
        }
        if (!this.separatorTF.getText().equals(Character.valueOf(csvConfig.getSeparator()))) {
            this.separatorTF.setText("" + csvConfig.getSeparator());
        }
        if (!this.quoteTF.getText().equals(Character.valueOf(csvConfig.getQuote()))) {
            this.quoteTF.setText("" + csvConfig.getQuote());
        }
        if (!this.headerCheckBox.isSelected() == csvConfig.containsHeader()) {
            this.headerCheckBox.setSelected(csvConfig.containsHeader());
        }
        String tName = this.csvLoaderModel.getTableName();
        if (!this.tableNameTextField.getText().equals(tName)) {
            this.tableNameTextField.setText(tName);
        }
        if ((sc = this.csvLoaderModel.getServer()) != null) {
            this.serverComboBox.setSelectedItem(sc.getName());
        }
        File pfile = this.csvLoaderModel.getCsvFile();
        this.filePicker.setSelectedFile(this.csvLoaderModel.getCsvFile());
        boolean validFile = pfile != null && pfile.isFile() && pfile.canRead();
        this.loadButton.setEnabled(validFile);
        this.previewPanel.removeAll();
        if (validFile) {
            String t = "CSV Importer - ";
            t = t + (pfile != null ? pfile.getName() : "");
            this.setTitle(t);
            TableModel tm = null;
            try {
                tm = CSVLoader.getTopTable(pfile.getAbsolutePath(), csvConfig, 100);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            if (tm != null) {
                JXTable tab = Theme.getStripedTable(tm);
                tab.setSortable(false);
                this.previewPanel.add((Component)new JScrollPane(tab), "Center");
            } else {
                this.previewPanel.add((Component)Theme.getHtmlText("Cannot parse file"), "Center");
            }
        } else {
            this.previewPanel.add((Component)Theme.getHtmlText("Please select a valid file"), "Center");
        }
        this.previewPanel.revalidate();
    }

    @Override
    public void update(CsvLoaderModel csvLoaderModel) {
        this.refreshUI();
    }

    private class TitlePanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private JPanel b;

        public TitlePanel(String title) {
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createTitledBorder(title));
            this.b = Theme.getVerticalBoxPanel();
            this.add((Component)this.b, "Center");
        }

        @Override
        public Component add(Component c2) {
            return this.b.add(c2);
        }
    }

    private class LoadWorker
    extends SwingWorker<Integer, Integer> {
        private final CSVLoader csvLoader;
        int rows = 0;

        public LoadWorker(CSVLoader csvLoader) {
            this.csvLoader = csvLoader;
        }

        @Override
        public Integer doInBackground() {
            final CsvLoaderFrame frame = CsvLoaderFrame.this;
            String errMessage = null;
            try {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        frame.setCursor(Cursor.getPredefinedCursor(3));
                    }
                });
                while (this.csvLoader.processRow() && !this.isCancelled()) {
                    this.rows = this.csvLoader.getRowsLoaded();
                    if (this.rows % 100 != 0) continue;
                    this.publish(this.rows);
                }
            }
            catch (IOException ioe) {
                errMessage = "Problem sending data to server, not all data may have been sent";
            }
            catch (IllegalArgumentException iae) {
                errMessage = iae.getMessage();
            }
            catch (IllegalStateException ise) {
                errMessage = ise.getMessage();
            }
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    frame.setCursor(Cursor.getPredefinedCursor(0));
                }
            });
            if (errMessage != null) {
                JOptionPane.showMessageDialog(frame, errMessage, "Error loading file", 2);
            }
            return this.rows;
        }

        @Override
        protected void process(List<Integer> rowReports) {
            Integer r = rowReports.get(rowReports.size() - 1);
            CsvLoaderFrame.this.rowLoadTextField.setText(r.toString() + " rows loaded");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void done() {
            Integer bReport = null;
            Exception e = null;
            CsvLoaderFrame csvLoaderFrame = CsvLoaderFrame.this;
            synchronized (csvLoaderFrame) {
                CsvLoaderFrame.this.progressCancelDialog.setVisible(false);
                CsvLoaderFrame.this.progressCancelDialog.dispose();
                CsvLoaderFrame.this.progressCancelDialog = null;
                CsvLoaderFrame.this.loadWorker = null;
            }
            try {
                bReport = (Integer)this.get();
            }
            catch (InterruptedException ie) {
                e = ie;
            }
            catch (ExecutionException ee) {
                e = ee;
            }
            catch (CancellationException ce) {
                e = ce;
            }
            if (e != null) {
                LOG.log(Level.WARNING, "csv loader problem", e);
            }
            if (e instanceof CancellationException) {
                CsvLoaderFrame.this.showMsg(this.rows + " rows loaded then user cancelled.");
            } else if (bReport != null) {
                CsvLoaderFrame.this.showMsg(this.rows + " rows sent");
            } else {
                String txt = "Problem Running CSV Load";
                CsvLoaderFrame.this.showMsg(QStudioLauncher.ERR_REPORTER.getErrorReportLink(e, txt));
            }
        }
    }
}

