/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.pro.csvloader;

import au.com.bytecode.opencsv.CSVReader;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.io.Files;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;

class CsvConfig {
    private String charset = "UTF-8";
    private char separator = (char)44;
    private char quote = (char)34;
    private boolean containsHeader = true;
    private int skipLines = 0;

    CsvConfig() {
    }

    String getCharset() {
        return this.charset;
    }

    char getSeparator() {
        return this.separator;
    }

    char getQuote() {
        return this.quote;
    }

    boolean containsHeader() {
        return this.containsHeader;
    }

    int getSkipLines() {
        return this.skipLines;
    }

    CsvConfig setCharset(String charset) {
        this.charset = charset;
        return this;
    }

    CsvConfig setSeparator(char separator) {
        this.separator = separator;
        return this;
    }

    CsvConfig setQuote(char quote) {
        this.quote = quote;
        return this;
    }

    CsvConfig setContainsHeader(boolean containsHeader) {
        this.containsHeader = containsHeader;
        return this;
    }

    CsvConfig setSkipLines(int skipLines) {
        this.skipLines = skipLines;
        return this;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("charset", this.charset).add("separator", this.separator).add("quote", this.quote).add("containsHeader", this.containsHeader).add("skipLines", this.skipLines).toString();
    }

    public int hashCode() {
        return Objects.hashCode(this.charset, Character.valueOf(this.separator), Character.valueOf(this.quote), this.containsHeader, this.skipLines);
    }

    public boolean equals(Object object) {
        if (object instanceof CsvConfig) {
            CsvConfig that = (CsvConfig)object;
            return Objects.equal(this.charset, that.charset) && Objects.equal(Character.valueOf(this.separator), Character.valueOf(that.separator)) && Objects.equal(Character.valueOf(this.quote), Character.valueOf(that.quote)) && Objects.equal(this.containsHeader, that.containsHeader) && Objects.equal(this.skipLines, that.skipLines);
        }
        return false;
    }

    public static CsvConfig detect(File csvFile) throws IOException {
        CsvConfig csvConfig = new CsvConfig();
        BufferedReader r = Files.newReader(csvFile, Charset.defaultCharset());
        char[] b = new char[2048];
        r.read(b);
        r.close();
        for (char c2 : b) {
            if (c2 != '|') continue;
            csvConfig.setSeparator('|');
            break;
        }
        for (char c2 : b) {
            if (c2 == '\n') break;
            if (c2 != '.') continue;
            csvConfig.setContainsHeader(false);
        }
        return csvConfig;
    }

    public CSVReader getCsvReader(File f) throws UnsupportedEncodingException, FileNotFoundException {
        CSVReader reader = new CSVReader((Reader)new InputStreamReader((InputStream)new FileInputStream(f), this.getCharset()), this.getSeparator(), this.getQuote(), this.getSkipLines());
        return reader;
    }
}

