/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.pro.csvloader;

import au.com.bytecode.opencsv.CSVReader;
import com.google.common.base.Preconditions;
import com.timestored.kdb.KdbConnection;
import com.timestored.pro.csvloader.BufferedReadProc;
import com.timestored.pro.csvloader.CsvConfig;
import com.timestored.pro.csvloader.KdbTypeMatcherTabListener;
import com.timestored.pro.csvloader.PreviewTabListener;
import com.timestored.pro.csvloader.TabListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.table.TableModel;
import kx.c;

class CSVLoader {
    private static final Logger LOG = Logger.getLogger(CSVLoader.class.getName());
    private static final int KDB_BUFFER_ROWS = 100;
    private final KdbConnection kdbConn;
    private final String tableName;
    private final KdbTypeMatcherTabListener kdbTypeListener;
    private final KdbSendTabListener kdbSendTabListener;
    private final BufferedReadProc bufferedReader;
    private final CSVReader reader;
    private boolean readerClosed = false;
    private int rowsLoaded = 0;

    public CSVLoader(String csvFile, CsvConfig csvConfig, KdbConnection kdbConn, String tableName) throws UnsupportedEncodingException, FileNotFoundException {
        File f = CSVLoader.getFile(csvFile);
        this.kdbConn = Preconditions.checkNotNull(kdbConn);
        this.tableName = Preconditions.checkNotNull(tableName);
        this.bufferedReader = new BufferedReadProc(csvConfig, 100);
        this.kdbTypeListener = new KdbTypeMatcherTabListener();
        this.bufferedReader.addTabListener(this.kdbTypeListener);
        this.kdbSendTabListener = new KdbSendTabListener(kdbConn, tableName);
        this.bufferedReader.addTabListener(this.kdbSendTabListener);
        this.reader = csvConfig.getCsvReader(f);
    }

    public int processAll() throws IOException {
        while (this.processRow()) {
        }
        return this.rowsLoaded;
    }

    boolean processRow() throws IOException {
        if (this.readerClosed) {
            throw new IllegalStateException("reader closed at EOF, cant process more");
        }
        if (this.rowsLoaded == 0 && !this.checkTableNameFree()) {
            throw new IllegalArgumentException("Tablename already in use on server.");
        }
        String[] values = this.reader.readNext();
        if (values != null) {
            this.bufferedReader.procRow(this.rowsLoaded++, values);
        } else {
            this.close();
            if (this.rowsLoaded > 0) {
                Map<String, Character> types = this.kdbTypeListener.getRecognisedKdbTypes();
                if (!types.isEmpty()) {
                    String castQuery = CSVLoader.getUpdateCast(types, this.tableName) + ";";
                    this.kdbConn.send(castQuery);
                }
                String castCommonSymbols = "{@[`" + this.tableName + ";x;\"S\"$]} each where 0.5>{{(count distinct x)%count x } each flip $[count strCols:exec c from meta x where t=\"C\";strCols#x;()]} " + this.tableName + ";";
                this.kdbConn.send(castCommonSymbols);
            }
        }
        return values != null;
    }

    boolean checkTableNameFree() throws IOException {
        boolean variableExists = true;
        try {
            variableExists = (Boolean)this.kdbConn.query("`" + this.tableName + " in key `.");
        }
        catch (c.KException e) {
            throw new IOException(e);
        }
        catch (ClassCastException cce) {
            variableExists = true;
        }
        return !variableExists;
    }

    private void close() throws IOException {
        this.readerClosed = true;
        this.reader.close();
        this.bufferedReader.flush();
        this.rowsLoaded = this.kdbSendTabListener.getRowsSent();
    }

    public int getRowsLoaded() {
        return this.rowsLoaded;
    }

    private static String getUpdateCast(Map<String, Character> types, String tableName) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Character> e : types.entrySet()) {
            sb.append("@[`" + tableName + ";`$\"" + e.getKey() + "\";\"" + e.getValue() + "\"$];");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static TableModel getTopTable(String csvFile, CsvConfig csvConfig, int maxRowsShown) {
        File f = CSVLoader.getFile(csvFile);
        Charset cs2 = Charset.forName(csvConfig.getCharset());
        Preconditions.checkNotNull(cs2);
        BufferedReadProc bufferedReader = new BufferedReadProc(csvConfig, maxRowsShown);
        PreviewTabListener pTabListener = new PreviewTabListener();
        bufferedReader.addTabListener(pTabListener);
        int rowsToRead = maxRowsShown + (csvConfig.containsHeader() ? 1 : 0);
        TableModel tm = null;
        try {
            int row = 0;
            try (CSVReader reader = csvConfig.getCsvReader(f);){
                String[] values = reader.readNext();
                while (values != null && row < rowsToRead) {
                    bufferedReader.procRow(row++, values);
                    values = reader.readNext();
                }
                bufferedReader.flush();
                tm = pTabListener.getTopAsTableModel();
            }
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, "getTopTable", e);
        }
        return tm;
    }

    private static File getFile(String fileName) {
        Preconditions.checkNotNull(fileName);
        File f = new File(fileName);
        Preconditions.checkArgument(f.exists() && f.canRead());
        return f;
    }

    private static c.Flip getTable(List<String[]> rowData, String[] colNames) {
        Object[] data = new Object[colNames.length];
        for (int c2 = 0; c2 < colNames.length; ++c2) {
            char[][] colVals = new char[rowData.size()][];
            for (int r = 0; r < rowData.size(); ++r) {
                colVals[r] = rowData.get(r)[c2].toCharArray();
            }
            data[c2] = colVals;
        }
        return new c.Flip(new c.Dict(colNames, data));
    }

    private static class KdbSendTabListener
    implements TabListener {
        private final KdbConnection kdbConn;
        private final String tableName;
        private int rowsSent = 0;

        public KdbSendTabListener(KdbConnection kdbConn, String tableName) {
            this.kdbConn = Preconditions.checkNotNull(kdbConn);
            this.tableName = Preconditions.checkNotNull(tableName);
        }

        @Override
        public void tabEvent(String[] colNames, List<String[]> rowData) {
            c.Flip tab = CSVLoader.getTable(rowData, colNames);
            Object[] updStatement = new Object[]{"insert".toCharArray(), this.tableName, tab};
            try {
                this.kdbConn.send(updStatement);
                this.rowsSent += rowData.size();
            }
            catch (IOException e) {
                LOG.log(Level.WARNING, "loadToServer", e);
            }
        }

        public int getRowsSent() {
            return this.rowsSent;
        }
    }
}

