/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.pro.csvloader;

import au.com.bytecode.opencsv.CSVReadProc;
import com.timestored.pro.csvloader.CSVLoader;
import com.timestored.pro.csvloader.CsvConfig;
import com.timestored.pro.csvloader.TabListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;

class BufferedReadProc
implements CSVReadProc {
    private static final Logger LOG = Logger.getLogger(CSVLoader.class.getName());
    private final int bufferSize;
    private boolean firstRow = true;
    private String[] colNames = null;
    private final List<TabListener> tabListeners = new CopyOnWriteArrayList<TabListener>();
    private final CsvConfig csvConfig;
    private final List<String[]> rowData;

    public boolean addTabListener(TabListener tabListener) {
        return this.tabListeners.add(tabListener);
    }

    public void flush() {
        LOG.info("BufferedReadProc flushing " + this.rowData.size() + " rows.");
        if (!this.rowData.isEmpty()) {
            for (TabListener tl : this.tabListeners) {
                tl.tabEvent(this.colNames, this.rowData);
            }
            this.rowData.clear();
        }
    }

    public BufferedReadProc(CsvConfig csvConfig, int bufferSize) {
        this.csvConfig = csvConfig;
        this.bufferSize = bufferSize;
        this.rowData = new ArrayList<String[]>(bufferSize);
    }

    @Override
    public void procRow(int rowIndex, String ... values) {
        if (this.firstRow) {
            this.colNames = BufferedReadProc.getColumnTitles(this.csvConfig, values);
        }
        if (!this.firstRow || !this.csvConfig.containsHeader()) {
            if (values.length < this.colNames.length) {
                String[] v = new String[this.colNames.length];
                for (int i = 0; i < v.length; ++i) {
                    v[i] = i < values.length ? values[i] : "";
                }
                values = v;
            }
            this.rowData.add(values);
            if (this.rowData.size() == this.bufferSize) {
                for (TabListener tl : this.tabListeners) {
                    tl.tabEvent(this.colNames, this.rowData);
                    LOG.info("tabEvent " + this.rowData.size() + " rows.");
                }
                this.rowData.clear();
            }
        }
        this.firstRow = false;
    }

    private static String[] getColumnTitles(CsvConfig csvConfig, String[] values) {
        String[] cNames = values;
        if (!csvConfig.containsHeader()) {
            cNames = new String[values.length];
            for (int i = 0; i < values.length; ++i) {
                cNames[i] = "c" + i;
            }
        }
        return cNames;
    }
}

