/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.plugins;

import com.timestored.connections.JdbcTypes;
import com.timestored.misc.DynamicClassLoader;
import com.timestored.plugins.Curler;
import com.timestored.plugins.DatabaseAuthenticationService;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Driver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class PluginLoader {
    private static final Logger log = Logger.getLogger(PluginLoader.class.getName());
    private static DatabaseAuthenticationService databaseAuthenticationService;
    private static Map<List<URL>, URLClassLoader> urlsToClassLoaders;
    private static URLClassLoader latestLoader;

    private PluginLoader() {
    }

    public static List<File> getDirectories(String appname) {
        File userD = new File(System.getProperty("user.home") + File.separator + appname + File.separator + "libs");
        File curD = new File(System.getProperty("user.dir") + File.separator + "libs");
        ArrayList<File> d = new ArrayList<File>();
        d.add(userD);
        d.add(curD);
        return d;
    }

    private static synchronized URLClassLoader getMyLoaderFromHardRefresh(String appname) {
        URLClassLoader cl;
        ArrayList l = new ArrayList();
        PluginLoader.getJars(PluginLoader.getDirectories(appname)).forEach(f -> {
            try {
                l.add(f.toURL());
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        });
        Collections.sort(l, (a, b) -> a.toString().compareTo(b.toString()));
        URLClassLoader r = urlsToClassLoaders.get(l);
        if (r != null) {
            return r;
        }
        latestLoader = cl = new URLClassLoader(l.toArray(new URL[0]), PluginLoader.class.getClassLoader());
        urlsToClassLoaders.put(l, cl);
        return cl;
    }

    private static List<File> getJars(List<File> directories) {
        ArrayList<File> r = new ArrayList<File>();
        for (File d : directories) {
            if (!d.exists() || !d.isDirectory()) continue;
            for (File f : d.listFiles()) {
                if (!f.exists() || !f.getName().endsWith(".jar")) continue;
                r.add(f);
            }
        }
        return r;
    }

    public static boolean loadPlugins(String appname) {
        ArrayList<DatabaseAuthenticationService> instances = new ArrayList<DatabaseAuthenticationService>();
        for (File dir : PluginLoader.getDirectories(appname)) {
            if (!dir.exists() || !dir.isDirectory()) continue;
            instances.addAll(DynamicClassLoader.loadInstances(dir, DatabaseAuthenticationService.class, true));
            List<Driver> list = DynamicClassLoader.loadInstances(dir, Driver.class, true);
        }
        if (!instances.isEmpty()) {
            databaseAuthenticationService = (DatabaseAuthenticationService)instances.get(0);
        }
        if (databaseAuthenticationService != null) {
            PluginLoader.writePropIfNotExist("jdbc.isKDB", "true");
            PluginLoader.writePropIfNotExist("jdbc.dbRequired", "false");
            PluginLoader.writePropIfNotExist("jdbc.driver", "kx.jdbc");
            PluginLoader.writePropIfNotExist("jdbc.urlFormat", "jdbc:q:@HOST@:@PORT@");
            PluginLoader.writePropIfNotExist("jdbc.niceName", "Kdb with " + databaseAuthenticationService.getName());
            PluginLoader.writePropIfNotExist("jdbc.authenticator", databaseAuthenticationService.getClass().getCanonicalName());
        }
        return databaseAuthenticationService != null;
    }

    private static void writePropIfNotExist(String key, String value) {
        if (System.getProperty(key) == null) {
            System.setProperty(key, value);
        }
    }

    public static Class<?> getCClass(String appname, String className) throws ClassNotFoundException {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e1) {
            try {
                if (latestLoader != null) {
                    return latestLoader.loadClass(className);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            log.info("Could not find class already loaded. Refreshing from folders / jars.");
            return PluginLoader.getMyLoaderFromHardRefresh(appname).loadClass(className);
        }
    }

    public static File installDriver(String appname, JdbcTypes jdbcTypes) throws IOException {
        try {
            Class<?> c2 = PluginLoader.getCClass(appname, jdbcTypes.getDriver());
            if (c2 != null) {
                log.info("installDriver skipped as class already loaded.");
                return null;
            }
        }
        catch (ClassNotFoundException c2) {
            // empty catch block
        }
        Exception e = null;
        for (File installDir : PluginLoader.getDirectories(appname.toLowerCase())) {
            for (String u : jdbcTypes.getDownloadURLs()) {
                try {
                    String filename = u.substring(u.lastIndexOf(47) + 1);
                    File f = new File(installDir, filename);
                    Curler.downloadFileTo(u, f);
                    log.info("File downloaded: " + f.getAbsolutePath());
                    PluginLoader.getCClass(appname, jdbcTypes.getDriver());
                    return f;
                }
                catch (Exception e1) {
                    e = e1;
                }
            }
        }
        throw new IOException(e);
    }

    static {
        urlsToClassLoaders = new HashMap<List<URL>, URLClassLoader>();
    }
}

