/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.misc;

import com.google.common.io.Files;
import com.timestored.misc.SaveableFrame;
import java.awt.Component;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.junit.Assert;

public class TestHelper {
    private static final int DEFAULT_WIDTH = 400;
    private static final int DEFAULT_HEIGHT = 400;
    private static final String TEST_OUTPUT_DIR = "target" + File.separator + "testout" + File.separator;

    public static String getOutDir() throws IOException {
        System.out.println(new File(".").getAbsolutePath());
        Files.createParentDirs(new File(TEST_OUTPUT_DIR + File.separator + "a.txt"));
        return TEST_OUTPUT_DIR;
    }

    public static File saveComponentImage(Component c2, String filename, int width, int height) throws IOException {
        File f = new File(TestHelper.getOutDir() + filename);
        SaveableFrame.saveComponentImage(c2, width, height, f);
        return f;
    }

    public static File saveComponentImage(Component c2, String filename) throws IOException {
        File f = new File(TestHelper.getOutDir() + filename);
        SaveableFrame.saveComponentImage(c2, 400, 400, f);
        return f;
    }

    public static boolean assertFilesMatch(File file, InputStream knownFile) {
        if (knownFile != null) {
            try {
                String msg = "checking file match for: " + file.getName();
                Assert.assertTrue((String)msg, (boolean)TestHelper.isEqual(new FileInputStream(file), knownFile));
                return true;
            }
            catch (FileNotFoundException e) {
                Assert.fail((String)("generated image not found: " + e.toString()));
            }
            catch (IOException e) {
                Assert.fail((String)("generated image IO fail: " + e.toString()));
            }
        } else {
            Assert.fail((String)("known image not found: " + file.getName()));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isEqual(InputStream i1, InputStream i2) throws IOException {
        byte[] buf1 = new byte[65536];
        byte[] buf2 = new byte[65536];
        try {
            int len;
            DataInputStream d2 = new DataInputStream(i2);
            while ((len = i1.read(buf1)) > 0) {
                d2.readFully(buf2, 0, len);
                for (int i = 0; i < len; ++i) {
                    if (buf1[i] == buf2[i]) continue;
                    boolean bl = false;
                    return bl;
                }
            }
            boolean bl = d2.read() < 0;
            return bl;
        }
        catch (EOFException ioe) {
            boolean bl = false;
            return bl;
        }
        finally {
            i1.close();
            i2.close();
        }
    }
}

