/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.misc;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.JFrame;

public class SaveableFrame
extends JFrame {
    private static final Logger LOG = Logger.getLogger(SaveableFrame.class.getName());
    private static final long serialVersionUID = 1L;
    private static final int DEF_WIDTH = 900;
    private static final int DEF_HEIGHT = 300;

    public SaveableFrame(Component cp, int width, int height) {
        this.setLayout(new BorderLayout());
        if (cp != null) {
            this.add(cp, "Center");
        }
        this.setSize(new Dimension(width, height));
        this.setVisible(true);
    }

    public void close() {
        WindowEvent wev = new WindowEvent(this, 201);
        Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(wev);
    }

    public static void saveComponentImage(Component a, File file) throws IOException {
        SaveableFrame.saveComponentImage(a, 900, 300, file);
    }

    public static void saveComponentImage(Component a, int width, int height, File file) throws IOException {
        Dimension d = new Dimension(width, height);
        a.setSize(d);
        a.setPreferredSize(d);
        SaveableFrame.layoutComponent(a);
        BufferedImage bi = new BufferedImage(width, height, 2);
        Graphics2D g = bi.createGraphics();
        a.paint(g);
        g.dispose();
        ImageIO.write((RenderedImage)bi, "png", file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void layoutComponent(Component component) {
        Object object = component.getTreeLock();
        synchronized (object) {
            component.doLayout();
            if (component instanceof Container) {
                Object object2 = ((Container)component).getTreeLock();
                synchronized (object2) {
                    for (Component child : ((Container)component).getComponents()) {
                        SaveableFrame.layoutComponent(child);
                    }
                }
            }
        }
    }

    public static void saveFrame(SaveableFrame f, File file) {
        SaveableFrame.saveFrame(f, file, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveFrame(final SaveableFrame f, final File file, boolean includeWatermark) {
        final AtomicBoolean finished = new AtomicBoolean(false);
        EventQueue.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                f.requestFocus();
                try {
                    SaveableFrame.saveComponentImage(f, f.getSize().width, f.getSize().height, file);
                }
                catch (IOException e) {
                    LOG.log(Level.SEVERE, "eframe.saveToFile(filepath)", e);
                }
                f.close();
                AtomicBoolean atomicBoolean = finished;
                synchronized (atomicBoolean) {
                    finished.set(true);
                    finished.notifyAll();
                }
            }
        });
        while (!finished.get()) {
            try {
                AtomicBoolean atomicBoolean = finished;
                synchronized (atomicBoolean) {
                    finished.wait();
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }
}

