/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.misc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.InvalidPreferencesFormatException;
import java.util.prefs.Preferences;

public class KeyedPrefs<Key extends Enum<Key>> {
    private static final Logger LOG = Logger.getLogger(KeyedPrefs.class.getName());
    private final Preferences pref;
    private final List<Listener> listeners = new CopyOnWriteArrayList<Listener>();

    public KeyedPrefs(String nodeName) {
        this.pref = Preferences.userRoot().node(nodeName);
    }

    public void put(Key key, String value) {
        this.pref.put(((Enum)key).name(), value);
    }

    public String get(Key key, String def) {
        return this.pref.get(((Enum)key).name(), def);
    }

    public void putBoolean(Key key, boolean value) {
        this.pref.putBoolean(((Enum)key).name(), value);
    }

    public boolean getBoolean(Key key, boolean def) {
        return this.pref.getBoolean(((Enum)key).name(), def);
    }

    public void putInt(Key key, int value) {
        this.pref.putInt(((Enum)key).name(), value);
    }

    public int getInt(Key key, int def) {
        return this.pref.getInt(((Enum)key).name(), def);
    }

    public void putLong(Key key, long val2) {
        this.pref.putLong(((Enum)key).name(), val2);
    }

    public long getLong(Key key, long def) {
        return this.pref.getLong(((Enum)key).name(), def);
    }

    public Preferences getPref() {
        return this.pref;
    }

    public String toXML() {
        ByteArrayOutputStream baOS = new ByteArrayOutputStream();
        String s = null;
        try {
            this.pref.exportSubtree(baOS);
            s = baOS.toString();
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, "Couldn't convert preferences to xml", e);
        }
        catch (BackingStoreException e) {
            LOG.log(Level.WARNING, "Couldn't convert preferences to xml", e);
        }
        return s;
    }

    public static void importXML(String xmlSettings) {
        if (xmlSettings != null) {
            ByteArrayInputStream is = new ByteArrayInputStream(xmlSettings.getBytes());
            try {
                Preferences.importPreferences(is);
            }
            catch (IOException e) {
                LOG.log(Level.WARNING, "Couldn't import xml preferences", e);
            }
            catch (InvalidPreferencesFormatException e) {
                LOG.log(Level.WARNING, "Couldn't import xml preferences", e);
            }
        }
    }

    public void addListener(Listener l) {
        this.listeners.add(l);
    }

    public void removeListener(Listener l) {
        this.listeners.remove(l);
    }

    public void notifyListeners() {
        for (Listener l : this.listeners) {
            l.changeEvent();
        }
    }

    public static interface Listener {
        public void changeEvent();
    }
}

