/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.misc;

import com.timestored.TimeStored;
import com.timestored.misc.HtmlUtils;
import com.timestored.theme.Theme;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

public class InfoLink
extends JLabel {
    private static final long serialVersionUID = 1L;

    public static JLabel getLabel(String title, String text, String webUrl, boolean showTitleText) {
        return InfoLink.getLabel(title, text, webUrl, InfoLink.addHttp(webUrl), showTitleText);
    }

    private static String addHttp(String webUrl) {
        boolean hasHttp = webUrl.toLowerCase().startsWith("http://") || webUrl.toLowerCase().startsWith("https://");
        String actualUrl = hasHttp ? webUrl : "http://" + webUrl;
        return actualUrl;
    }

    public static JLabel getLabel(String title, String text, TimeStored.Page webPage, boolean showTitleText) {
        return InfoLink.getLabel(title, text, webPage.niceUrl(), webPage.url(), true);
    }

    private static JLabel getLabel(String title, String text, String niceWebUrl, final String actualWebUrl, boolean showTitleText) {
        JLabel l = new JLabel(Theme.CIcon.INFO.get());
        if (text != null && text.length() > 0) {
            l.setToolTipText("<html><b>" + title + "</b><br><br>" + text + "<br><br><a href='" + actualWebUrl + "' >" + niceWebUrl + "</a></html>");
        }
        if (showTitleText) {
            l.setText(title);
        }
        if (HtmlUtils.isBrowseSupported()) {
            l.setCursor(Cursor.getPredefinedCursor(12));
            l.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    HtmlUtils.browse(actualWebUrl);
                }
            });
        }
        return l;
    }

    public static JButton getButton(String title, String text, TimeStored.Page webPage) {
        return InfoLink.getButton(title, text, webPage.niceUrl(), webPage.url());
    }

    public static JButton getButton(String title, String text, String niceWebUrl, final String actualWebUrl) {
        JButton b = new JButton(Theme.CIcon.INFO.get());
        if (text != null && text.length() > 0) {
            b.setToolTipText("<html><b>" + title + "</b><br><br>" + text + "<br><br><a href='" + actualWebUrl + "' >" + niceWebUrl + "</a></html>");
        }
        b.setText(title);
        if (HtmlUtils.isBrowseSupported()) {
            b.setCursor(Cursor.getPredefinedCursor(12));
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    HtmlUtils.browse(actualWebUrl);
                }
            });
        }
        return b;
    }

    public static void showMessageDialog(Component parent, String htmlBody, String title) {
        JLabel label = new JLabel();
        Font font = label.getFont();
        StringBuffer style = new StringBuffer("font-family:" + font.getFamily() + ";");
        style.append("font-weight:" + (font.isBold() ? "bold" : "normal") + ";");
        style.append("font-size:" + font.getSize() + "pt;");
        String html = "<html><body style=\"" + style + "\">" + htmlBody + "</body></html>";
        JEditorPane ep = Theme.getHtmlText(html);
        JOptionPane.showMessageDialog(parent, ep, title, 1);
    }
}

