/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.misc;

import com.google.common.io.CharStreams;
import com.google.common.io.Files;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;

public class IOUtils {
    public static String toString(File file, Charset charset, int bytes) throws IOException {
        int bytesToRead = bytes != -1 ? bytes : (int)file.length();
        byte[] buffer = new byte[bytesToRead];
        BufferedInputStream f = new BufferedInputStream(new FileInputStream(file));
        f.read(buffer);
        f.close();
        return new String(buffer, charset);
    }

    public static String toString(File file, Charset charset) throws IOException {
        return IOUtils.toString(file, charset, -1);
    }

    public static String toString(File file) throws IOException {
        return IOUtils.toString(file, Charset.forName("UTF-8"), -1);
    }

    public static String toString(Class c2, String resourceName) throws IOException {
        InputStream is = c2.getResourceAsStream(resourceName);
        return CharStreams.toString(new InputStreamReader(is, Charset.forName("UTF-8")));
    }

    public static void writeStringToFile(String s, File file) throws IOException {
        file.getParentFile().mkdirs();
        PrintWriter pw = new PrintWriter(file, Charset.forName("UTF-8").name());
        pw.print(s);
        pw.close();
    }

    public static String toString(Throwable e) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        e.printStackTrace(new PrintStream(bos));
        return bos.toString();
    }

    public static File createTempCopy(String filename, InputStream is) throws IOException {
        File tempf = Files.createTempDir();
        File f = new File(tempf, filename);
        byte[] buffer = new byte[is.available()];
        is.read(buffer);
        Files.write(buffer, f);
        return f;
    }

    public static boolean containsMoreThanMaxFiles(File file, int maxFiles) {
        return IOUtils.countFiles(file, maxFiles, 0) > maxFiles;
    }

    private static int countFiles(File file, int maxFiles, int currentCount) {
        int i = currentCount;
        String[] fileNames = file.list();
        if ((i += fileNames.length) > maxFiles) {
            return i;
        }
        for (String fn : fileNames) {
            File f = new File(file, fn);
            if (!f.isDirectory() || (i = IOUtils.countFiles(f, maxFiles, i)) <= maxFiles) continue;
            return i;
        }
        return i;
    }

    public static String getFileEnding(File file) {
        String p = file == null ? "" : file.getAbsolutePath().toLowerCase();
        int dotPos = p.lastIndexOf(46);
        return dotPos >= 0 ? p.substring(dotPos + 1) : "";
    }
}

