/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.misc;

import com.google.common.base.Joiner;
import com.timestored.theme.Theme;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JOptionPane;

public class HtmlUtils {
    private static final Logger LOG;
    public static final String END = "</body></html>";
    public static final String START = "<html><body>";
    private static final boolean browseSupported;
    private static final String HEAD_PRE = "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\"\"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\"><html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en\" ><head><meta http-equiv=\"content-type\" content=\"text/html; charset=iso-8859-1\" />";
    private static final String FAVICON_LINK = "<link rel=\"shortcut icon\" type=\"image/png\" href=\"https://www.timestored.com/favicon.png\" />";
    private static int counter;

    public static String getHead(String title, String headContent) {
        return "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\"\"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\"><html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en\" ><head><meta http-equiv=\"content-type\" content=\"text/html; charset=iso-8859-1\" /><title>" + title + "</title>" + headContent + "</head><body>";
    }

    public static String getTail() {
        return END;
    }

    public static String getTSPageHead(String title, String subTitleLink, String headContent, boolean withTSFavicon) {
        StringBuilder s = new StringBuilder(200);
        s.append(HtmlUtils.getHead(title, headContent + FAVICON_LINK));
        s.append("\r\n<div id='wrap'><div id='page'>");
        s.append("\r\n<div id='header'><h2>" + subTitleLink + "</h2></div>");
        s.append("\r\n<div id='main'>");
        return s.toString();
    }

    public static String getTSPageTail(String subTitleLink) {
        StringBuilder s = new StringBuilder(200);
        s.append("\r\n</div>");
        s.append("<div id='footer'> <p>&copy; 2019 ");
        s.append(subTitleLink);
        s.append(" | <a target='a' href='https://www.timestored.com'>TimeStored.com</a></div>");
        s.append("\r\n</div></div>\r\n");
        s.append(END);
        return s.toString();
    }

    public static String toList(List<String> items) {
        return "<ul><li>" + Joiner.on("</li><li>").join(items) + "</li></ul>";
    }

    public static String toList(String ... items) {
        return "<ul><li>" + Joiner.on("</li><li>").join(items) + "</li></ul>";
    }

    public static String toList(Map<String, String> smap, boolean hideEmpty) {
        if (smap.isEmpty()) {
            return "";
        }
        return "<ul>" + HtmlUtils.expandMapToHtml(smap, hideEmpty, "<li><strong>", "</strong> - ", "", "</li>") + "</ul>";
    }

    public static String toDefinitions(Map<String, String> smap, boolean hideEmpty) {
        if (smap.isEmpty()) {
            return "";
        }
        return "<dl>" + HtmlUtils.expandMapToHtml(smap, hideEmpty, "<dt>", "</dt>", "<dl>", "</dl>") + "</dl>";
    }

    public static String toTable(Map<String, String> smap, boolean hideEmpty) {
        if (smap.isEmpty()) {
            return "";
        }
        return "<table>" + HtmlUtils.expandMapToHtml(smap, hideEmpty, "<tr><th>", "</th>", "<td>", "</td></tr>") + "</table>";
    }

    private static String expandMapToHtml(Map<String, String> smap, boolean hideEmpty, String preKey, String postKey, String preVal, String postVal) {
        StringBuilder sb = new StringBuilder();
        ArrayList<String> keyList = new ArrayList<String>(smap.keySet());
        for (String key : keyList) {
            String val2 = smap.get(key);
            if (hideEmpty && (val2 == null || val2.trim().isEmpty())) continue;
            sb.append(preKey).append(key).append(postKey);
            sb.append(preVal).append(val2 + postVal);
        }
        return sb.toString();
    }

    public static String extractBody(String htmlDoc) {
        if (htmlDoc != null && !htmlDoc.trim().isEmpty()) {
            String t = HtmlUtils.getTextInsideTag(htmlDoc, "body");
            if (t == null) {
                t = HtmlUtils.getTextInsideTag(htmlDoc, "html");
            }
            if (t == null) {
                t = htmlDoc;
            }
            return t;
        }
        return "";
    }

    private static String getTextInsideTag(String htmlDoc, String tag) {
        String b = "<" + tag + ">";
        int st2 = htmlDoc.indexOf(b);
        int end = htmlDoc.lastIndexOf("</" + tag + ">");
        if (st2 == -1 || end == -1) {
            return null;
        }
        return htmlDoc.substring(st2 + b.length(), end);
    }

    public static boolean browse(String url) {
        if (browseSupported) {
            try {
                Desktop.getDesktop().browse(new URI(url));
                return true;
            }
            catch (IOException | URISyntaxException e) {
                LOG.log(Level.WARNING, "couldn't open browser", e);
                String msg = "Could not open browser. Here is the URL:\r\n" + url;
                JOptionPane.showMessageDialog(null, Theme.getHtmlText(msg), "Error Opening Browser", 2);
            }
        }
        return false;
    }

    public static boolean isBrowseSupported() {
        return browseSupported;
    }

    public static Action getWWWaction(String title, String url) {
        return new WwwAction(title, url);
    }

    public static void appendQCodeArea(StringBuilder sb, String code) {
        sb.append("\r\n<textarea rows='2' cols='80' class='code' id='code");
        sb.append(counter);
        sb.append("'>");
        sb.append(code);
        sb.append("</textarea> <script type='text/javascript'>CodeMirror.fromTextArea(document.getElementById('code");
        sb.append(counter);
        sb.append("'),  {  lineNumbers: true, matchBrackets: true,  mode: \"text/x-plsql\", readOnly:true });</script>");
        ++counter;
    }

    public static String getXhtmlTop(String title) {
        return "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\"><html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en\" ><head>\r\n<meta http-equiv=\"content-type\" content=\"text/html; charset=iso-8859-1\" />\r\n<title>" + title + "</title></head><body>";
    }

    public static String getXhtmlBottom() {
        return " </body></html>";
    }

    public static String getTSTemplateTop(String title) {
        return "<?php \r\ninclude 'template.php';\r\necho $t->getSmallHeadedTop(\"" + title + "\", null, \"codemirror.js\");\r\necho getHelpTop();\t\r\n?>\r\n";
    }

    public static String getTSTemplateBottom() {
        return "\r\n<?php \r\necho getHelpBottom();\r\necho $t->getSmallHeadedBottom(); \r\n?>";
    }

    public static String escapeHTML(String txt) {
        StringBuilder out = new StringBuilder(Math.max(16, txt.length()));
        return HtmlUtils.appendEscapedHtml(out, txt).toString();
    }

    public static StringBuilder appendEscapedHtml(StringBuilder sb, String txt) {
        boolean previousWasASpace = false;
        block8: for (char c2 : txt.toCharArray()) {
            if (c2 == ' ') {
                if (previousWasASpace) {
                    sb.append("&nbsp;");
                    previousWasASpace = false;
                    continue;
                }
                previousWasASpace = true;
            } else {
                previousWasASpace = false;
            }
            switch (c2) {
                case '<': {
                    sb.append("&lt;");
                    continue block8;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block8;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block8;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block8;
                }
                case '\n': {
                    sb.append("\n<br />");
                    continue block8;
                }
                case '\t': {
                    sb.append("&nbsp; &nbsp; &nbsp;");
                    continue block8;
                }
                default: {
                    if (c2 < '\u0080') {
                        sb.append(c2);
                        continue block8;
                    }
                    sb.append("&#").append((int)c2).append(";");
                }
            }
        }
        return sb;
    }

    public static String cleanAtt(String name) {
        return name.replace("'", "&lsquo;");
    }

    public static String clean(String s) {
        return s.trim().replace(",", "-").replace(":", "-").replace(" ", "-").replace("'", "-").toLowerCase();
    }

    public static void appendImage(StringBuilder sb, String imgFilename, String alt, int height, int width) {
        sb.append("<img src='").append(imgFilename).append("'");
        if (alt != null && alt.trim().length() > 0) {
            sb.append(" alt='").append(HtmlUtils.cleanAtt(alt)).append("' ");
        }
        sb.append(" height='").append(height).append("' width='").append(width).append("'");
        sb.append(" />");
    }

    static {
        Desktop desktop;
        LOG = Logger.getLogger(HtmlUtils.class.getName());
        counter = 13;
        boolean browsey = false;
        if (Desktop.isDesktopSupported() && (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.BROWSE)) {
            browsey = true;
        }
        browseSupported = browsey;
    }

    private static class WwwAction
    extends AbstractAction {
        private final String url;

        WwwAction(String title, String url) {
            super(title, Theme.CIcon.TEXT_HTML.get16());
            this.url = url;
            this.setEnabled(HtmlUtils.isBrowseSupported());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            HtmlUtils.browse(this.url);
        }
    }
}

