/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.misc;

import com.google.common.base.Preconditions;
import com.timestored.misc.HtmlUtils;
import com.timestored.theme.Theme;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.IllegalComponentStateException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class ErrorReporter {
    private static final Logger LOG = Logger.getLogger(ErrorReporter.class.getName());
    private final String websiteUrl;
    private final String email;
    private final String emailTitle;
    private final long timeDelayBetweenReports;
    private long lastErrTime = 0L;

    public ErrorReporter(String websiteUrl, String email, String emailTitle, int delayBetweenReports) {
        Preconditions.checkNotNull(websiteUrl);
        Preconditions.checkNotNull(email);
        Preconditions.checkNotNull(emailTitle);
        Preconditions.checkArgument(websiteUrl.contains("?"));
        Preconditions.checkArgument(delayBetweenReports >= 0);
        this.websiteUrl = websiteUrl;
        this.email = email;
        this.emailTitle = emailTitle;
        this.timeDelayBetweenReports = 60000 * delayBetweenReports;
    }

    public UncaughtErrorReporter getUncaughtExceptionHandler() {
        return new UncaughtErrorReporter();
    }

    public void showReportErrorDialog(Throwable e, String description) {
        this.showReportErrorDialog(this.getErrDetails(e, description));
    }

    private String getErrDetails(Throwable e, String description) {
        String stackTrace = "..";
        if (e != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            stackTrace = sw.toString();
        }
        String version = System.getProperty("java.version");
        String os = System.getProperty("os.name");
        return "\r\n\r\nDetails:\r\n\r\nOS=" + (os == null ? "unknown" : os) + "\r\nJava=" + (version == null ? "unknown" : version) + "\r\nDes=" + (description == null ? "unknown" : description) + "\r\nStack=" + stackTrace;
    }

    public void showReportErrorDialog(String errDetails) {
        boolean enoughTimeDelay;
        boolean bl = enoughTimeDelay = System.currentTimeMillis() - this.lastErrTime > this.timeDelayBetweenReports;
        if (enoughTimeDelay) {
            this.lastErrTime = System.currentTimeMillis();
            String msg = "An error occurred, to allow us to fix the problem please click report below which will contact us via the website or email  " + this.email + "\r\n\r\nTechnical Details:\r\n";
            JPanel b = new JPanel(new BorderLayout());
            b.add((Component)Theme.getTextArea("repError", msg), "North");
            JTextArea errTA = Theme.getTextArea("errDetails", errDetails);
            errTA.setFont(new Font("Verdana", 1, 12));
            errTA.setForeground(Color.GRAY);
            errTA.setWrapStyleWord(false);
            errTA.setLineWrap(false);
            b.add((Component)new JScrollPane(errTA), "Center");
            b.setPreferredSize(new Dimension(400, 300));
            Object[] options = new String[]{"Report", "Close"};
            int choice = JOptionPane.showOptionDialog(null, b, "Error", 2, 0, Theme.CIcon.ERROR.get(), options, options[0]);
            if (choice == 0) {
                try {
                    HtmlUtils.browse(this.websiteUrl + "&details=" + URLEncoder.encode(errDetails, "UTF-8"));
                }
                catch (UnsupportedEncodingException e1) {
                    LOG.log(Level.FINE, "no luck");
                }
            }
        }
    }

    private static String getEncoded(String s, int maxUnencodedLength) {
        try {
            String t = s.substring(0, Math.min(s.length(), maxUnencodedLength));
            return URLEncoder.encode(t, "UTF-8");
        }
        catch (UnsupportedEncodingException e1) {
            LOG.log(Level.FINE, "no luck");
            return "";
        }
    }

    public Component getErrorReportLink(Throwable e, String description) {
        String txt = "" + description + "<br /><font color='red'>" + e.toString() + "<br /></font>";
        return this.getErrorReportLink(txt, this.getErrDetails(e, description));
    }

    public Component getErrorReportLink(String shortDescription, String errDetails) {
        String encodedSubject = ErrorReporter.getEncoded(this.emailTitle, 30);
        final String encodedDetails = ErrorReporter.getEncoded(errDetails, 435);
        JEditorPane editPane = Theme.getHtmlText("<html>" + shortDescription + "<br />If you believe this is a bug contact:<br /><a href='mailto:" + this.email + "?Subject=" + encodedSubject + "&Body=" + encodedDetails + "'>" + this.email + "</a> to report the problem please.</html>");
        JButton reportButton = new JButton("Report via Website", Theme.CIcon.TEXT_HTML.get16());
        reportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HtmlUtils.browse(ErrorReporter.this.websiteUrl + "&details=" + encodedDetails);
            }
        });
        JPanel p = new JPanel(new BorderLayout());
        p.add((Component)editPane, "Center");
        p.add((Component)reportButton, "East");
        JPanel c2 = new JPanel();
        c2.add(p);
        return c2;
    }

    private class UncaughtErrorReporter
    implements Thread.UncaughtExceptionHandler {
        private UncaughtErrorReporter() {
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            boolean showException = true;
            String m = e.getMessage();
            if (e instanceof IllegalComponentStateException && m.contains("component must be showing")) {
                showException = false;
            }
            LOG.log(Level.WARNING, "uncaught error", e);
            if (showException) {
                ErrorReporter.this.showReportErrorDialog(e, null);
            }
        }
    }
}

