/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.misc;

import com.timestored.misc.Base64;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.SecretKeySpec;

public class Encryptor {
    public static byte[] encrypt(byte[] utf8, String keyString) throws IOException {
        try {
            Cipher ecipher = Cipher.getInstance("DES");
            ecipher.init(1, Encryptor.getKey(keyString));
            byte[] enc = ecipher.doFinal(utf8);
            return enc;
        }
        catch (IllegalBlockSizeException e) {
            throw new IOException(e);
        }
        catch (GeneralSecurityException e) {
            throw new IOException(e);
        }
    }

    public static String encrypt(String str, String keyString) throws IOException {
        return Base64.encodeBytes(Encryptor.encrypt(str.getBytes("UTF8"), keyString));
    }

    private static Key getKey(String keyString) throws IOException {
        byte[] p = Base64.decode(keyString);
        SecretKeySpec key = new SecretKeySpec(p, 0, p.length, "DES");
        return key;
    }

    public static byte[] decrypt(byte[] dec, String keyString) throws IOException {
        try {
            Cipher dcipher = Cipher.getInstance("DES");
            dcipher.init(2, Encryptor.getKey(keyString));
            return dcipher.doFinal(dec);
        }
        catch (IllegalBlockSizeException e) {
            throw new IOException(e);
        }
        catch (GeneralSecurityException e) {
            throw new IOException(e);
        }
    }

    public static String decrypt(String str, String keyString) throws IOException {
        return new String(Encryptor.decrypt(Base64.decode(str.getBytes()), keyString), "UTF8");
    }
}

