/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.misc;

import com.google.common.collect.Lists;
import com.timestored.misc.Visitor;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Logger;

public class DynamicClassLoader {
    private static final Logger log = Logger.getLogger(DynamicClassLoader.class.getName());

    private DynamicClassLoader() {
    }

    public static <T> List<T> loadInstances(File dir, Class<T> interfaceWanted, boolean onlyLoadFirstMatch) {
        log.info("Searching for plugins in folder: " + dir.getAbsolutePath());
        InstanceFinderVisitor<T> v = new InstanceFinderVisitor<T>(interfaceWanted, onlyLoadFirstMatch);
        try {
            DynamicClassLoader.visitJarFileJavaClasses(dir, v);
        }
        catch (IOException e) {
            log.warning("Problem while searching for plugins" + e.toString());
        }
        return ((InstanceFinderVisitor)v).instances;
    }

    private static void visitJarFileJavaClasses(File dir, Visitor<ClassDetails> visitor) throws IOException {
        if (!dir.exists()) {
            return;
        }
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        };
        String[] children = dir.list(filter);
        if (children != null) {
            for (int child = 0; child < children.length; ++child) {
                String filename = dir.getAbsolutePath() + "/" + children[child];
                log.info("Looking for plugins inside: " + filename);
                URL url = new URL("jar:file:" + filename + "/!/");
                JarURLConnection conn = (JarURLConnection)url.openConnection();
                JarFile jarFile = conn.getJarFile();
                Enumeration<JarEntry> e = jarFile.entries();
                while (e.hasMoreElements()) {
                    String externalName;
                    JarEntry entry = e.nextElement();
                    String name = entry.getName();
                    if (entry.isDirectory() || !name.endsWith(".class") || visitor.visit(new ClassDetails(externalName = name.substring(0, name.indexOf(46)).replace('/', '.'), url))) continue;
                    return;
                }
            }
        }
    }

    private static class ClassDetails {
        private final String className;
        private final URL classUrl;

        public ClassDetails(String className, URL classUrl) {
            this.className = className;
            this.classUrl = classUrl;
        }

        public String getClassName() {
            return this.className;
        }

        public URL getClassUrl() {
            return this.classUrl;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ClassDetails)) {
                return false;
            }
            ClassDetails other = (ClassDetails)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$className = this.getClassName();
            String other$className = other.getClassName();
            if (this$className == null ? other$className != null : !this$className.equals(other$className)) {
                return false;
            }
            URL this$classUrl = this.getClassUrl();
            URL other$classUrl = other.getClassUrl();
            return !(this$classUrl == null ? other$classUrl != null : !((Object)this$classUrl).equals(other$classUrl));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ClassDetails;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $className = this.getClassName();
            result = result * 59 + ($className == null ? 43 : $className.hashCode());
            URL $classUrl = this.getClassUrl();
            result = result * 59 + ($classUrl == null ? 43 : ((Object)$classUrl).hashCode());
            return result;
        }

        public String toString() {
            return "DynamicClassLoader.ClassDetails(className=" + this.getClassName() + ", classUrl=" + this.getClassUrl() + ")";
        }
    }

    private static class InstanceFinderVisitor<T>
    implements Visitor<ClassDetails> {
        private final Class<T> interfaceWanted;
        private final boolean stopAtFirstMatch;
        private final List<T> instances = Lists.newArrayList();

        @Override
        public boolean visit(ClassDetails classDetails) {
            try {
                URLClassLoader loader = new URLClassLoader(new URL[]{classDetails.classUrl});
                try {
                    Class<?> c2 = loader.loadClass(classDetails.className);
                    Class<?>[] interfaces = c2.getInterfaces();
                    for (int i = 0; i < interfaces.length; ++i) {
                        if (this.interfaceWanted != interfaces[i]) continue;
                        log.info("Found Plugin with correct interface: " + classDetails.className);
                        Method addURL = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
                        addURL.setAccessible(true);
                        ClassLoader cl = ClassLoader.getSystemClassLoader();
                        addURL.invoke((Object)cl, classDetails.classUrl);
                        Object o = c2.newInstance();
                        this.instances.add(o);
                        return !this.stopAtFirstMatch;
                    }
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                }
                catch (IllegalAccessError illegalAccessError) {
                }
                catch (VerifyError verifyError) {
                }
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (SecurityException securityException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            return true;
        }

        public InstanceFinderVisitor(Class<T> interfaceWanted, boolean stopAtFirstMatch) {
            this.interfaceWanted = interfaceWanted;
            this.stopAtFirstMatch = stopAtFirstMatch;
        }

        public List<T> getInstances() {
            return this.instances;
        }
    }
}

