/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.misc;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationMonitor;
import org.apache.commons.io.monitor.FileAlterationObserver;

public class DirWatch {
    private static final Logger LOG = Logger.getLogger(DirWatch.class.getName());
    private final List<DirWatchListener> listeners = new CopyOnWriteArrayList<DirWatchListener>();
    private final FileFilter fileFilter;
    private final ChangedFileAlterationListener fileAlterationListener;
    private final long refreshTimer;
    public static final int MAX_FILES_TO_WATCH = 1000;
    private FileAlterationMonitor monitor;
    private FileAlterationObserver fao;

    public DirWatch(long refreshTimer, FileFilter fileFilter, boolean ignoreFileChanges) {
        this.fileFilter = fileFilter;
        this.fileAlterationListener = new ChangedFileAlterationListener(ignoreFileChanges);
        this.refreshTimer = refreshTimer;
    }

    public void setRoot(File root) throws Exception {
        Preconditions.checkNotNull(root);
        this.stop();
        this.fao = new FileAlterationObserver(root, this.fileFilter);
        this.fao.addListener(this.fileAlterationListener);
        this.monitor = new FileAlterationMonitor(this.refreshTimer, this.fao);
        this.monitor.start();
    }

    public void stop() {
        if (this.fao != null) {
            this.fao.removeListener(this.fileAlterationListener);
        }
        if (this.monitor != null) {
            this.monitor.removeObserver(this.fao);
            this.fao = null;
            try {
                this.monitor.stop();
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "problem stopping", e);
            }
            this.monitor = null;
        }
    }

    public void addListener(DirWatchListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(DirWatchListener listener) {
        this.listeners.remove(listener);
    }

    public static FileFilter generateFileFilter(final Pattern regex) {
        return new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return !regex.matcher(pathname.getName()).matches();
            }
        };
    }

    public static Collection<File> generateFileCache(File[] files, FileFilter fileFilter) {
        if (files != null && files.length > 0) {
            ArrayList<File> fs = new ArrayList<File>();
            DirWatch.addChildren(fs, files, fileFilter);
            return fs;
        }
        return Collections.emptyList();
    }

    private static void addChildren(List<File> fs, File[] list, FileFilter fileFilter) {
        if (list != null) {
            fs.addAll(Arrays.asList(list));
            for (File curF : list) {
                if (fs.size() >= 1000) continue;
                DirWatch.addChildren(fs, DirWatch.getFiles(fileFilter, curF), fileFilter);
            }
        }
    }

    public static File[] getFiles(FileFilter fileFilter, File f) {
        File[] files = new File[]{};
        files = fileFilter == null ? f.listFiles() : f.listFiles(fileFilter);
        return files;
    }

    private class ChangedFileAlterationListener
    implements FileAlterationListener {
        private final boolean ignoreFileChanges;

        @Override
        public void onStart(FileAlterationObserver observer) {
            LOG.fine("The WindowsFileListener has started on " + observer.getDirectory().getAbsolutePath());
        }

        @Override
        public void onDirectoryCreate(File directory) {
            this.n();
        }

        private void n() {
            for (DirWatchListener l : DirWatch.this.listeners) {
                l.changeOccurred();
            }
        }

        @Override
        public void onDirectoryChange(File directory) {
            this.n();
        }

        @Override
        public void onDirectoryDelete(File directory) {
            this.n();
        }

        @Override
        public void onFileCreate(File file) {
            this.n();
        }

        @Override
        public void onFileChange(File file) {
            if (!this.ignoreFileChanges) {
                this.n();
            }
        }

        @Override
        public void onFileDelete(File file) {
            this.n();
        }

        @Override
        public void onStop(FileAlterationObserver observer) {
            LOG.fine("The WindowsFileListener has stopped on " + observer.getDirectory().getAbsolutePath());
        }

        public ChangedFileAlterationListener(boolean ignoreFileChanges) {
            this.ignoreFileChanges = ignoreFileChanges;
        }
    }

    public static interface DirWatchListener {
        public void changeOccurred();
    }
}

