/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.misc;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CmdRunner {
    private static final Logger LOG = Logger.getLogger(CmdRunner.class.getName());
    private static final String REG_EXP = "\"(\\\"|[^\"])*?\"|[^ ]+";
    private static final Pattern PATTERN = Pattern.compile("\"(\\\"|[^\"])*?\"|[^ ]+", 10);

    public static String run(String[] commands, String[] envp, File dir) throws IOException {
        Process p = Runtime.getRuntime().exec(commands, envp, dir);
        LOG.info("getRuntime().exec " + commands);
        return CmdRunner.waitGobbleReturn(p);
    }

    private static String waitGobbleReturn(Process p) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps2 = new PrintStream(baos);
        new Thread(new StreamGobbler(p.getInputStream(), ps2)).start();
        new Thread(new StreamGobbler(p.getErrorStream(), ps2)).start();
        try {
            p.waitFor();
            return baos.toString("utf-8");
        }
        catch (InterruptedException e) {
            LOG.log(Level.SEVERE, "CmdRunner Run Error", e);
        }
        catch (UnsupportedEncodingException e) {
            LOG.log(Level.SEVERE, "CmdRunner Run Error", e);
        }
        return "";
    }

    public static String run(String[] commands) throws IOException {
        return CmdRunner.run(commands, null, null);
    }

    public static String run(String command) throws IOException {
        Process p = Runtime.getRuntime().exec(command, null, null);
        LOG.info("getRuntime().exec " + command);
        return CmdRunner.waitGobbleReturn(p);
    }

    public static Process startProc(String command, File dir) throws IOException {
        Process p = Runtime.getRuntime().exec(command, null, dir);
        CmdRunner.gobbleStreams(p);
        return p;
    }

    public static Process startProc(String[] commands, String[] envp, File dir) throws IOException {
        Process p = Runtime.getRuntime().exec(commands, envp, dir);
        LOG.info("getRuntime().exec " + Joiner.on(' ').join(commands));
        CmdRunner.gobbleStreams(p);
        return p;
    }

    private static void gobbleStreams(Process p) {
        new Thread(new StreamGobbler(p.getInputStream(), System.out)).start();
        new Thread(new StreamGobbler(p.getErrorStream(), System.err)).start();
    }

    public static String[] parseCommand(String cmd) {
        if (cmd == null || cmd.length() == 0) {
            return new String[0];
        }
        cmd = cmd.trim();
        Matcher matcher = PATTERN.matcher(cmd);
        ArrayList<String> matches = new ArrayList<String>();
        while (matcher.find()) {
            String s = matcher.group();
            if (s.length() >= 2) {
                boolean hasQuotes;
                boolean bl = hasQuotes = s.charAt(0) == '\"' && s.charAt(s.length() - 1) == '\"' || s.charAt(0) == '\'' && s.charAt(s.length() - 1) == '\'';
                if (hasQuotes) {
                    s = s.substring(1, s.length() - 1);
                }
            }
            matches.add(s);
        }
        String[] parsedCommand = matches.toArray(new String[0]);
        return parsedCommand;
    }

    private static class StreamGobbler
    implements Runnable {
        private InputStreamReader isr;
        private PrintStream ps;

        public StreamGobbler(InputStream is, PrintStream outputPS) {
            this.isr = new InputStreamReader(is);
            this.ps = Preconditions.checkNotNull(outputPS);
        }

        @Override
        public void run() {
            try {
                BufferedReader br = new BufferedReader(this.isr);
                String line = null;
                while ((line = br.readLine()) != null) {
                    this.ps.println(line);
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }
}

