/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.misc;

import com.formdev.flatlaf.FlatDarculaLaf;
import com.formdev.flatlaf.FlatDarkLaf;
import com.formdev.flatlaf.FlatIntelliJLaf;
import com.formdev.flatlaf.FlatLightLaf;
import com.formdev.flatlaf.intellijthemes.FlatAllIJThemes;
import com.formdev.flatlaf.intellijthemes.FlatOneDarkIJTheme;
import com.formdev.flatlaf.themes.FlatMacDarkLaf;
import com.formdev.flatlaf.themes.FlatMacLightLaf;
import com.google.common.io.Files;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import javax.imageio.ImageIO;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class AppLaunchHelper {
    private static final Logger LOG = Logger.getLogger(AppLaunchHelper.class.getName());
    private static final Map<String, String> nameToLookFeelClassName = new HashMap<String, String>();
    private static final List<String> NAMES = new ArrayList<String>();
    public static final String SPACER_PREFIX = " ------ ";

    private static void add(String shortName, String classname) {
        nameToLookFeelClassName.put(shortName, classname);
        NAMES.add(shortName);
    }

    public static List<String> getLafNamesWithSpacerStrings() {
        return NAMES;
    }

    public static boolean isLafDark(String lafName) {
        String ln;
        if (lafName != null && ((ln = lafName.toLowerCase()).contains("dark") || ln.contains("darcula"))) {
            return true;
        }
        for (FlatAllIJThemes.FlatIJLookAndFeelInfo lfinfo : FlatAllIJThemes.INFOS) {
            if (!lfinfo.getName().equals(lafName)) continue;
            return lfinfo.isDark();
        }
        return false;
    }

    public static String getLFclassname(String lfname) {
        return nameToLookFeelClassName.get(lfname);
    }

    public static void setMacAndWindowsAppearance(String title, BufferedImage image) {
        if (System.getProperty("os.name").toLowerCase().indexOf("mac") >= 0) {
            System.setProperty("apple.awt.application.name", title);
            System.setProperty("apple.awt.application.appearance", "system");
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", title);
            if (image != null) {
                try {
                    AppLaunchHelper.setApplicationIconImagePrivate(image);
                }
                catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    LOG.warning("problem setting mac image: " + e.toString());
                }
            }
        }
    }

    private static void setApplicationIconImagePrivate(BufferedImage image) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, ClassNotFoundException {
        Class<?> appClass = Class.forName("com.apple.eawt.Application");
        Object application = appClass.getMethod("getApplication", new Class[0]).invoke(null, new Object[0]);
        if (application != null) {
            try {
                Method setDockIconImage = application.getClass().getMethod("setDockIconImage", Image.class);
                try {
                    setDockIconImage.invoke(application, image);
                }
                catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {}
            }
            catch (NoSuchMethodException mnfe) {
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                try {
                    ImageIO.write((RenderedImage)image, "png", stream);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                try {
                    Class<?> nsDataClass = Class.forName("com.apple.cocoa.foundation.NSData");
                    Constructor<?> constructor = nsDataClass.getConstructor(new byte[0].getClass());
                    Object nsData = constructor.newInstance(new Object[]{stream.toByteArray()});
                    Class<?> nsImageClass = Class.forName("com.apple.cocoa.application.NSImage");
                    Object nsImage = nsImageClass.getConstructor(nsDataClass).newInstance(nsData);
                    Object napplication = AppLaunchHelper.getNSApplication();
                    napplication.getClass().getMethod("setApplicationIconImage", nsImageClass).invoke(application, nsImage);
                }
                catch (ClassNotFoundException nsDataClass) {
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private static Object getNSApplication() throws ClassNotFoundException {
        try {
            Class<?> applicationClass = Class.forName("com.apple.cocoa.application.NSApplication");
            return applicationClass.getMethod("sharedApplication", new Class[0]).invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean setTheme(String theme) {
        try {
            String lfCLassname = AppLaunchHelper.getLFclassname(theme);
            if (lfCLassname != null) {
                UIManager.setLookAndFeel(lfCLassname);
                return true;
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException exception) {
            // empty catch block
        }
        return false;
    }

    public static void logToUsersFolder(String folder) {
        try {
            String p = System.getProperty("user.home") + File.separator + folder + File.separator + "a";
            Files.createParentDirs(new File(p));
            FileHandler fh = new FileHandler("%h/" + folder + "/log%g.log", 0x100000, 1, true);
            fh.setFormatter(new SimpleFormatter());
            Logger.getLogger("").addHandler(fh);
        }
        catch (IOException ex) {
            LOG.log(Level.SEVERE, ex.getMessage(), ex);
        }
        catch (SecurityException ex) {
            LOG.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    static {
        String defaultClassName = UIManager.getSystemLookAndFeelClassName();
        try {
            for (UIManager.LookAndFeelInfo lookAndFeelInfo : UIManager.getInstalledLookAndFeels()) {
                if (!"Windows".equals(lookAndFeelInfo.getName())) continue;
                defaultClassName = lookAndFeelInfo.getClassName();
                break;
            }
        }
        catch (Exception e) {
            LOG.warning("Problem initialising AppLaunchHelper static. " + e.toString());
        }
        NAMES.add(" ------  Core Themes  ------ ");
        AppLaunchHelper.add("Light", defaultClassName);
        try {
            AppLaunchHelper.add("Dark", FlatOneDarkIJTheme.class.getCanonicalName());
            AppLaunchHelper.add("IntelliJ", FlatIntelliJLaf.class.getCanonicalName());
            AppLaunchHelper.add("Darcula", FlatDarculaLaf.class.getCanonicalName());
            AppLaunchHelper.add("Flat Light", FlatLightLaf.class.getCanonicalName());
            AppLaunchHelper.add("Flat Dark", FlatDarkLaf.class.getCanonicalName());
            AppLaunchHelper.add("Mac Flat Dark", FlatMacDarkLaf.class.getCanonicalName());
            AppLaunchHelper.add("Mac Flat Light", FlatMacLightLaf.class.getCanonicalName());
            NAMES.add(" ------  System Themes  ------ ");
            for (UIManager.LookAndFeelInfo lookAndFeelInfo : UIManager.getInstalledLookAndFeels()) {
                AppLaunchHelper.add(lookAndFeelInfo.getName(), lookAndFeelInfo.getClassName());
            }
            NAMES.add(" ------  Intellij Themes  ------ ");
            for (UIManager.LookAndFeelInfo lookAndFeelInfo : FlatAllIJThemes.INFOS) {
                if (lookAndFeelInfo.getName().toLowerCase().contains("(material)")) continue;
                AppLaunchHelper.add(lookAndFeelInfo.getName(), lookAndFeelInfo.getClassName());
            }
            NAMES.add(" ------  Material Themes  ------ ");
            for (UIManager.LookAndFeelInfo lookAndFeelInfo : FlatAllIJThemes.INFOS) {
                if (!lookAndFeelInfo.getName().toLowerCase().contains("(material)")) continue;
                AppLaunchHelper.add(lookAndFeelInfo.getName(), lookAndFeelInfo.getClassName());
            }
        }
        catch (Exception e) {
            LOG.severe("Could not add the themes from flatlaf.");
        }
    }
}

