/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.misc;

import com.timestored.connections.JdbcTypes;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AIFacade {
    private static String openAIkey = "";
    private static final String SQL_PREP = "You are an sql expert. Given an input question, step by step create a syntactically correct sql query to run.\r\nUnless the user specifies in the question a specific number of examples to obtain, query for at most 1000 results using the LIMIT clause as per SQL. You can order the results to return the most informative data in the database.\r\nNever query for all columns from a table. You must query only the columns that are needed to answer the question. Wrap each column name in double quotes (\") to denote them as delimited identifiers.\r\nPay attention to use only the column names you can see in the tables below. Be careful to not query for columns that do not exist. Also, pay attention to which column is in which table.\r\n";
    private static final String SQL_Q1 = "Question: Select the first two rows from the trade table?";
    private static final String SQL_A1 = "Answer: SELECT * FROM trade LIMIT 2";
    private static final String SQL_Q2 = "Question: Select the most recent 20 minutes of 'NFLX' bid ask quotes?";
    private static final String SQL_A2 = "Answer: SELECT TIME,BID,ASK FROM quote WHERE NAME='NFLX' AND TIME>timestampadd(minute,-20,date_trunc('minute',CURRENT_TIMESTAMP())) ORDER BY TIME ASC;";
    private static final String SQL_Q3 = "Question: Find the number of trades for JPM grouped by week?";
    private static final String SQL_A3 = "Answer: select COUNT(*) as trade_count,DATE_TRUNC('week', time)  as ttime FROM trade WHERE symbol = 'JPM' GROUP BY ttime";
    private static final String KDB_PREP = "You are a kdb+ expert. Given an input question, step by step create a syntactically correct kdb query to run.\r\nUnless the user specifies in the question a specific number of examples to obtain, query for at most 5 results using take #. \r\nPay attention to use only the column names you can see in the tables below. \r\nBe careful to not query for columns that do not exist. Also, pay attention to which column is in which table.\r\n'ORDER BY' does not work in kdb. LIMIT does not work in kdb. 'GROUP BY' does not work in kdb.\r\n\r\nOnly use the following tables:";
    private static final String KDB_Q1 = "Question: Select the first two rows from the trade table?";
    private static final String KDB_A1 = "Answer: select time,sym,status,quantity,destination,orderType,percent,pnl,price,name,avgPrice from trade where date=.z.d-1,i<2";
    private static final String KDB_Q2 = "Question: Find the number of trades for JPM grouped by week?";
    private static final String KDB_A2 = "Answer: select count i by 7 xbar `date$time from trade where sym=`JPM";
    private static final String KDB_Q3 = "Question: Find the price of 'NFLX' trades in 15 minute bars from trades?";
    private static final String KDB_A3 = "Answer: select count i by 15 xbar time.minute from trade where sym=`NFLX";

    private static final String getKDBMessages(String tblInfo, String question) {
        String tbls = tblInfo != null ? tblInfo : "";
        return "[{\"role\": \"user\", \"content\": \"" + KDB_PREP.replace("\n", "\\n").replace("\r", "\\r").replace("\"", "\\\"") + tbls.replace("\n", "\\n").replace("\r", "\\r") + "\"}\r\n,{\"role\": \"user\", \"content\": \"" + "Question: Select the first two rows from the trade table?" + "\"}\r\n,{\"role\": \"assistant\", \"content\": \"" + KDB_A1 + "\"}\r\n,{\"role\": \"user\", \"content\": \"" + "Question: Find the number of trades for JPM grouped by week?" + "\"}\r\n,{\"role\": \"assistant\", \"content\": \"" + KDB_A2 + "\"}\r\n,{\"role\": \"user\", \"content\": \"" + KDB_Q3 + "\"}\r\n,{\"role\": \"assistant\", \"content\": \"" + KDB_A3 + "\"}\r\n,{\"role\": \"user\", \"content\": \"Question: " + question.replace("\n", "\\n").replace("\r", "\\r") + "\"}\r\n,{\"role\": \"assistant\", \"content\": \"Answer: \"}\r\n]\r\n";
    }

    private static final String getSQLMessages(String tblInfo, String question) {
        String tbls = tblInfo != null ? tblInfo : "";
        return "[{\"role\": \"user\", \"content\": \"" + SQL_PREP.replace("\n", "\\n").replace("\r", "\\r").replace("\"", "\\\"") + tbls.replace("\n", "\\n").replace("\r", "\\r") + "\"}\r\n,{\"role\": \"user\", \"content\": \"" + "Question: Select the first two rows from the trade table?" + "\"}\r\n,{\"role\": \"assistant\", \"content\": \"" + SQL_A1 + "\"}\r\n,{\"role\": \"user\", \"content\": \"" + SQL_Q2 + "\"}\r\n,{\"role\": \"assistant\", \"content\": \"" + SQL_A2 + "\"}\r\n,{\"role\": \"user\", \"content\": \"" + "Question: Find the number of trades for JPM grouped by week?" + "\"}\r\n,{\"role\": \"assistant\", \"content\": \"" + SQL_A3 + "\"}\r\n,{\"role\": \"user\", \"content\": \"Question: " + question.replace("\n", "\\n").replace("\r", "\\r") + "\"}\r\n,{\"role\": \"assistant\", \"content\": \"Answer: \"}\r\n]\r\n";
    }

    public static AIresult queryOpenAIstructured(JdbcTypes jdbcType, String tblInfo, String question) throws IOException {
        String ret = AIFacade.queryOpenAI(jdbcType, tblInfo, question);
        return AIFacade.processJSON(ret);
    }

    private static String unescape(String qCode) {
        return qCode.replace("\\\\", "\\").replace("\\t", "\t").replace("\\r", "\r").replace("\\n", "\n").replace("\\\"", "\"");
    }

    public static String queryOpenAI(JdbcTypes jdbcType, String tblInfo, String question) throws IOException {
        if (openAIkey == null || openAIkey.length() < 2) {
            throw new IllegalStateException("Open AI key isn't set");
        }
        System.setProperty("https.protocols", "TLSv1.2");
        String msgs = jdbcType.isKDB() ? AIFacade.getKDBMessages(tblInfo, question) : AIFacade.getSQLMessages(tblInfo, question);
        return AIFacade.queryOpenAIRaw(msgs);
    }

    public static AIresult queryOpenAIstructured(String singleQuestion) throws IOException {
        String qry = singleQuestion.replace("\n", "\\n").replace("\r", "\\r").replace("\"", "\\\"");
        String qryJson = "[{\"role\": \"user\", \"content\": \"" + qry + "\"}]";
        String ret = AIFacade.queryOpenAIRaw(qryJson);
        return AIFacade.processJSON(ret);
    }

    private static String queryOpenAIRaw(String msgs) throws IOException {
        String jsonInputString = "{\r\n\r\n    \"model\": \"gpt-3.5-turbo\",\r\n\r\n    \"messages\": " + msgs + "\r\n  }";
        String url = "https://api.openai.com/v1/chat/completions";
        HttpURLConnection urlConnection = (HttpURLConnection)new URL("https://api.openai.com/v1/chat/completions").openConnection();
        urlConnection.setDoOutput(true);
        urlConnection.setRequestProperty("Authorization", "Bearer " + openAIkey);
        urlConnection.setRequestProperty("Accept", "application/json");
        urlConnection.setRequestProperty("Content-Type", "application/json");
        urlConnection.setRequestMethod("POST");
        urlConnection.setConnectTimeout(15000);
        urlConnection.setReadTimeout(15000);
        try (OutputStream os = urlConnection.getOutputStream();){
            System.out.println(jsonInputString);
            byte[] input = jsonInputString.getBytes("utf-8");
            os.write(input, 0, input.length);
        }
        if (urlConnection.getResponseCode() == 200) {
            StringBuffer response = new StringBuffer();
            try (BufferedReader in = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));){
                String inputLine;
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine).append("\n");
                }
            }
            return response.toString();
        }
        return "{\"error\":" + urlConnection.getResponseCode() + ", \"errmsg\":\"" + urlConnection.getResponseMessage().replace('\"', '\'') + "\"}";
    }

    static AIresult processJSON(String rawJSON) {
        String s;
        int p;
        String firstContent = "";
        String firstCode = "";
        if (rawJSON.contains("\"errmsg\":") || rawJSON.contains("\"error\":")) {
            throw new IllegalStateException(rawJSON);
        }
        int cIdx = rawJSON.indexOf("\"content\":");
        int logIdx = rawJSON.indexOf("logprobs");
        if (cIdx > 0 && logIdx > cIdx && (p = (s = rawJSON.substring(cIdx + "\"content\":".length(), logIdx)).lastIndexOf("}")) > 0) {
            int firstCidx;
            if ((s = s.substring(0, p)).indexOf("\"") >= 0 && s.lastIndexOf("\"") > s.indexOf("\"")) {
                s = s.substring(s.indexOf("\"") + 1, s.lastIndexOf("\""));
            }
            firstContent = s;
            firstCode = s;
            String[] starts = new String[]{"answer:", "correct one:", "query:"};
            String lowerS = s.toLowerCase();
            for (String st2 : starts) {
                if (lowerS.indexOf(st2) <= 0) continue;
                firstCode = s.substring(lowerS.indexOf(st2) + st2.length());
                break;
            }
            if ((firstCidx = firstCode.indexOf("```\n")) >= 0 && firstCode.lastIndexOf("```") > firstCidx) {
                firstCode = firstCode.substring(firstCidx + "```\n".length(), firstCode.lastIndexOf("```"));
            }
        }
        firstCode = AIFacade.unescape(firstCode);
        firstContent = AIFacade.unescape(firstContent);
        firstContent = AIFacade.wrap(firstContent, 120, "\n", false, "", "");
        return new AIresult(rawJSON, firstContent, firstCode);
    }

    public static String wrap(String src, int lineLength, String newLineStr, boolean wrapLongWords, String longWordBreak, String longWordLinePrefix) {
        if (src == null) {
            return null;
        }
        String nl = newLineStr == null ? System.getProperty("line.separator") : newLineStr;
        String lwb = longWordBreak == null ? "" : longWordBreak;
        String lwprefix = longWordLinePrefix == null ? "" : longWordLinePrefix;
        int lLength = lineLength - newLineStr.length();
        if (lLength < 1) {
            lLength = 1;
        }
        if (wrapLongWords && lLength - lwb.length() - lwprefix.length() < 1) {
            lLength += lwb.length() + lwprefix.length();
        }
        int remaining = lLength;
        int breakLength = lwb.length();
        Matcher m = Pattern.compile(".+?[ \\t]|.+?(?:" + nl + ")|.+?$").matcher(src);
        StringBuilder cache = new StringBuilder();
        while (m.find()) {
            String word = m.group();
            while (wrapLongWords && word.length() > lLength) {
                cache.append(word.substring(0, remaining - breakLength)).append(lwb).append(nl);
                word = lwprefix + word.substring(remaining - breakLength);
                remaining = lLength;
            }
            if (word.length() > remaining) {
                cache.append(nl).append(word);
                remaining = lLength;
            } else {
                cache.append(word);
            }
            remaining -= word.length();
        }
        return cache.toString();
    }

    public static String getOpenAIkey() {
        return openAIkey;
    }

    public static void setOpenAIkey(String openAIkey) {
        AIFacade.openAIkey = openAIkey;
    }

    public static class AIresult {
        private final String jsonReturned;
        private final String firstContent;
        private final String firstCode;

        public AIresult(String jsonReturned, String firstContent, String firstCode) {
            this.jsonReturned = jsonReturned;
            this.firstContent = firstContent;
            this.firstCode = firstCode;
        }

        public String getJsonReturned() {
            return this.jsonReturned;
        }

        public String getFirstContent() {
            return this.firstContent;
        }

        public String getFirstCode() {
            return this.firstCode;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AIresult)) {
                return false;
            }
            AIresult other = (AIresult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$jsonReturned = this.getJsonReturned();
            String other$jsonReturned = other.getJsonReturned();
            if (this$jsonReturned == null ? other$jsonReturned != null : !this$jsonReturned.equals(other$jsonReturned)) {
                return false;
            }
            String this$firstContent = this.getFirstContent();
            String other$firstContent = other.getFirstContent();
            if (this$firstContent == null ? other$firstContent != null : !this$firstContent.equals(other$firstContent)) {
                return false;
            }
            String this$firstCode = this.getFirstCode();
            String other$firstCode = other.getFirstCode();
            return !(this$firstCode == null ? other$firstCode != null : !this$firstCode.equals(other$firstCode));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AIresult;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $jsonReturned = this.getJsonReturned();
            result = result * 59 + ($jsonReturned == null ? 43 : $jsonReturned.hashCode());
            String $firstContent = this.getFirstContent();
            result = result * 59 + ($firstContent == null ? 43 : $firstContent.hashCode());
            String $firstCode = this.getFirstCode();
            result = result * 59 + ($firstCode == null ? 43 : $firstCode.hashCode());
            return result;
        }

        public String toString() {
            return "AIFacade.AIresult(jsonReturned=" + this.getJsonReturned() + ", firstContent=" + this.getFirstContent() + ", firstCode=" + this.getFirstCode() + ")";
        }
    }
}

