/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.kdb;

import com.google.common.io.Files;
import com.timestored.connections.ConnectionManager;
import com.timestored.connections.ServerConfig;
import com.timestored.kdb.KdbConnection;
import com.timestored.misc.CmdRunner;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import kx.c;
import org.apache.commons.dbcp2.PoolableConnection;
import org.junit.Assert;

public class KdbTestHelper {
    private static final Logger LOG = Logger.getLogger(KdbTestHelper.class.getName());
    private static final String QHOST = "localhost";
    public static final int QPORT = 15000;
    public static final String TEST_SERVER_NAME = "testServer";
    public static final ServerConfig SERVER_CONFIG = new ServerConfig("localhost", 15000, "", "", "testServer");
    public static final ServerConfig SERVER_CONFIG_B = new ServerConfig("localhost", 15001, "", "");
    public static final ServerConfig DISCONNECTED_SERVER_CONFIG = new ServerConfig("localhost", 10201, "", "", "DISCONNECTED_SERVER");
    private static Process proc;
    private static Process proc_b;
    private static ConnectionManager connMan;
    private static KdbConnection kdbConn;
    private static PoolableConnection conn;
    private static File latestDir;
    private static Connection CACHED_CONN;

    public static KdbConnection getNewKdbConnection() throws c.KException, IOException, InterruptedException {
        KdbTestHelper.killAnyOpenProcesses();
        KdbTestHelper.startQ();
        kdbConn = new KdbConnection(QHOST, 15000);
        return kdbConn;
    }

    private static void startQ() throws IOException, InterruptedException {
        if (proc != null || proc_b != null) {
            throw new IllegalStateException("Q Proc already started");
        }
        latestDir = Files.createTempDir();
        proc = CmdRunner.startProc("q -p 15000", latestDir);
        proc_b = CmdRunner.startProc("q -p 15001", latestDir);
        Thread.sleep(200L);
    }

    private static void l(Exception e) {
        LOG.log(Level.WARNING, "error", e);
    }

    public static void killAnyOpenProcesses() throws IOException {
        if (kdbConn != null) {
            KdbTestHelper.closeConn(kdbConn);
        } else if (conn != null) {
            try {
                conn.createStatement().execute("q)exit 0");
            }
            catch (Exception e) {
                KdbTestHelper.l(e);
            }
            try {
                conn.close();
            }
            catch (Exception e) {
                KdbTestHelper.l(e);
            }
            connMan.returnConn(SERVER_CONFIG, conn, true);
        } else {
            try {
                KdbTestHelper.closeConn(new KdbConnection(QHOST, 15000));
            }
            catch (IOException e) {
            }
            catch (c.KException e) {
                throw new IOException("q proc already open and passworded");
            }
        }
        if (proc != null) {
            try {
                proc.destroy();
            }
            catch (Exception e) {
                KdbTestHelper.l(e);
            }
        }
        if (proc_b != null) {
            try {
                proc_b.destroy();
            }
            catch (Exception e) {
                KdbTestHelper.l(e);
            }
        }
        proc = null;
        proc_b = null;
        conn = null;
        kdbConn = null;
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private static void closeConn(KdbConnection kc) {
        LOG.info("kdbConn.close()");
        try {
            kc.send("exit 0");
        }
        catch (Exception e) {
            KdbTestHelper.l(e);
        }
        try {
            kc.close();
        }
        catch (Exception e) {
            KdbTestHelper.l(e);
        }
    }

    public static String getServerName() {
        return SERVER_CONFIG.getName();
    }

    public static String getServerNameB() {
        return SERVER_CONFIG_B.getName();
    }

    public static Connection getNewConn() throws IOException {
        KdbTestHelper.killAnyOpenProcesses();
        try {
            KdbTestHelper.startQ();
            connMan = ConnectionManager.newInstance();
            try {
                connMan.addServer(SERVER_CONFIG);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            try {
                connMan.addServer(SERVER_CONFIG_B);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            conn = connMan.getConnection(SERVER_CONFIG);
            Statement st2 = conn.createStatement();
            st2.execute("q)static:([] sym:1000?`4; price:1000?100.0)");
        }
        catch (SQLException se) {
            try {
                conn = connMan.getConnection(SERVER_CONFIG);
            }
            catch (IOException e) {
                throw new IOException(se);
            }
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
        return conn;
    }

    public static ConnectionManager getNewConnectedMangager() throws IOException, InterruptedException {
        ConnectionManager cMan = ConnectionManager.newInstance();
        KdbTestHelper.killAnyOpenProcesses();
        KdbTestHelper.startQ();
        try {
            cMan.addServer(SERVER_CONFIG);
            cMan.addServer(SERVER_CONFIG_B);
            cMan.addServer(DISCONNECTED_SERVER_CONFIG);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return cMan;
    }

    public static File getLatestDir() {
        return latestDir;
    }

    public static <T> T waitForType(Supplier<T> supplier) {
        for (int i = 0; i < 100; ++i) {
            T o = supplier.get();
            if (o != null) {
                return o;
            }
            try {
                Thread.sleep(80L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        Assert.fail((String)"Failed waiting for condition");
        return null;
    }

    public static void assertContains(String haystack, String needle) {
        if (!haystack.contains(needle)) {
            Assert.assertEquals((Object)haystack, (Object)needle);
        }
    }

    public static void assertContains(String haystack, String needle, String comment) {
        if (!haystack.contains(needle)) {
            Assert.assertEquals((String)haystack, (Object)needle, (Object)comment);
        }
    }

    public static boolean assertStartsWith(String s, String start) {
        if (!s.startsWith(start)) {
            System.out.println(s);
        }
        Assert.assertEquals((Object)start, (Object)(s.length() >= start.length() ? s.substring(0, start.length()) : s));
        return s.startsWith(start);
    }

    public static boolean assertEndsWith(String s, String end) {
        if (!s.endsWith(end)) {
            System.out.println(s);
        }
        Assert.assertEquals((Object)end, (Object)(s.length() >= end.length() ? s.substring(s.length() - end.length()) : s));
        return s.endsWith(end);
    }

    public static ResultSet queryKdb(String sqlQuery) throws SQLException, IOException {
        if (CACHED_CONN == null) {
            CACHED_CONN = KdbTestHelper.getNewConn();
        }
        Statement stmt = CACHED_CONN.createStatement();
        return stmt.executeQuery(sqlQuery);
    }

    static {
        connMan = ConnectionManager.newInstance();
        CACHED_CONN = null;
    }
}

