/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.kdb;

import com.timestored.connections.ServerConfig;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.logging.Logger;
import kx.c;

public class KdbConnection {
    private static final Logger LOG = Logger.getLogger(KdbConnection.class.getName());
    private static final int RETRIES = 1;
    private c c;
    private final String host;
    private final int port;
    private final String username;
    private final String password;
    private final boolean useTLS;
    private final boolean useAsync;
    private boolean closed = false;

    KdbConnection(String host, int port, String username, String password, boolean useTLS, boolean useAsync) throws c.KException, IOException {
        this.host = host;
        this.port = port;
        this.username = username;
        this.password = password;
        this.useTLS = useTLS;
        this.useAsync = useAsync;
        this.reconnect();
    }

    KdbConnection(String host, int port) throws c.KException, IOException {
        this(host, port, null, null, false, false);
    }

    public KdbConnection(ServerConfig sconf) throws c.KException, IOException {
        this(sconf.getHost(), sconf.getPort(), sconf.getUsername(), sconf.getPassword(), sconf.isUseTLS(), sconf.isUseAsync());
    }

    public void close() throws IOException {
        LOG.info("close");
        this.closed = true;
        this.c.close();
    }

    public Object query(String query) throws IOException, c.KException {
        LOG.info("querying -> " + query);
        if (this.closed) {
            throw new IllegalStateException("we were closed");
        }
        Object ret = null;
        boolean sent = false;
        int r = 0;
        while (!sent) {
            block9: {
                try {
                    if (this.useAsync) {
                        this.c.ks(query);
                    } else {
                        ret = this.c.k(query);
                    }
                    sent = true;
                    LOG.fine("query queried");
                }
                catch (IOException e) {
                    try {
                        this.reconnect();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (r < true) break block9;
                    LOG.info("giving up reconnecting");
                    throw new IOException(e);
                }
            }
            ++r;
        }
        if (this.useAsync) {
            return this.c.k();
        }
        return ret;
    }

    public void send(String s) throws IOException {
        this.sendObject(s);
    }

    private void sendObject(Object obj) throws IOException {
        LOG.info("sending -> " + obj);
        if (this.closed) {
            throw new IllegalStateException("we were closed");
        }
        boolean sent = false;
        int r = 0;
        while (!sent) {
            block8: {
                try {
                    if (obj instanceof String) {
                        this.c.ks((String)obj);
                    } else {
                        this.c.ks(obj);
                    }
                    sent = true;
                    LOG.info("query sent");
                }
                catch (IOException e) {
                    try {
                        LOG.info("query failed to send... reconnecting...");
                        this.reconnect();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (r < true) break block8;
                    LOG.info("giving up reconnecting");
                    throw new IOException(e);
                }
            }
            ++r;
        }
    }

    public void send(Object o) throws IOException {
        this.sendObject(o);
    }

    public Object k() throws UnsupportedEncodingException, c.KException, IOException {
        return this.c.k();
    }

    private void reconnect() throws IOException {
        if (this.closed) {
            throw new IllegalStateException("we were closed");
        }
        try {
            LOG.info("Trying reconnect host:" + this.host);
            this.c = new c(this.host, this.port, this.username + ":" + this.password, this.useTLS);
            kx.c.setEncoding("UTF-8");
        }
        catch (c.KException e) {
            throw new IOException(e);
        }
    }

    public String getName() {
        return this.host + ":" + this.port;
    }

    public boolean isConnected() {
        return !this.closed && this.c.s.isConnected();
    }
}

