/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.jgrowl;

import com.timestored.jgrowl.Growl;
import com.timestored.jgrowl.Theme;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.border.Border;

class StandardTheme
implements Theme {
    private static final Logger LOG = Logger.getLogger(Theme.class.getName());
    private static final int TOP_SPACER = 150;
    private static final int BORDER_WIDTH = 1;
    private static final int MESSAGE_WIDTH = 400;
    private static final int RIGHT_SPACER = 77;
    private static final int PAD = 3;
    private static final int SPACE_HACK = 75;

    StandardTheme() {
    }

    @Override
    public long getFadeTimerDelay() {
        return 50L;
    }

    @Override
    public int getSpaceBetweenItems() {
        return 5;
    }

    @Override
    public int getMoveSpeed() {
        return 10;
    }

    @Override
    public float getFadeRate() {
        return 0.01f;
    }

    @Override
    public int getTopSpacer() {
        return 150;
    }

    @Override
    public int getFadeRangeMinimum() {
        return 200;
    }

    @Override
    public int getLeftRuler(JFrame parentFrame) {
        return parentFrame.getX() + parentFrame.getWidth() - 477;
    }

    private static Border getBorder(Growl growl, boolean hover) {
        Color c2 = Color.LIGHT_GRAY;
        int ll = growl.getLogLevel().intValue();
        if (ll >= Level.SEVERE.intValue()) {
            c2 = Color.RED;
        } else if (ll >= Level.WARNING.intValue()) {
            c2 = Color.ORANGE;
        }
        if (hover) {
            c2 = c2.darker();
        }
        Border b = BorderFactory.createLineBorder(c2, 1);
        if (growl.getTitle() == null) {
            BorderFactory.createLineBorder(c2, 0);
        } else if (growl.getTitle().length() == 0) {
            b = BorderFactory.createTitledBorder(b, growl.getTitle());
        }
        return b;
    }

    static JLabel getLabelWithFixedWidth(String msg, int adjustment) {
        JLabel label = new JLabel("<html><body style='width:" + (324 + adjustment) + "px'>" + msg + "</body></html>");
        label.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        label.setMaximumSize(new Dimension(399, Integer.MAX_VALUE));
        return label;
    }

    @Override
    public Window getWindow(Growl message, final JFrame parentFrame) {
        JWindow frame = new JWindow();
        new BoxLayout(frame, 3);
        frame.setAlwaysOnTop(parentFrame.isFocused());
        frame.setMaximumSize(new Dimension(400, Integer.MAX_VALUE));
        final JPanel panel = new JPanel();
        new BoxLayout(panel, 3);
        JComponent c2 = message.getMessagePanel();
        if (c2 == null) {
            c2 = StandardTheme.getLabelWithFixedWidth(message.getMessage(), 0);
        } else {
            ((Component)c2).setMaximumSize(new Dimension(399, Integer.MAX_VALUE));
            ((Component)c2).setMinimumSize(new Dimension(22, 22));
        }
        final Border border = StandardTheme.getBorder(message, false);
        final Border hoverBorder = StandardTheme.getBorder(message, true);
        panel.setBorder(border);
        frame.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                parentFrame.toFront();
                super.mousePressed(e);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                panel.setBorder(hoverBorder);
                super.mouseEntered(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                panel.setBorder(border);
                super.mouseExited(e);
            }
        });
        panel.add(c2);
        frame.add(panel);
        frame.pack();
        frame.setMinimumSize(new Dimension(400, 0));
        frame.setVisible(true);
        return frame;
    }

    public static enum Icon {
        INFO("dialog-information.png"),
        WARNING("dialog-warning.png"),
        SEVERE("dialog-error.png");

        private final ImageIcon imageIcon;
        private final ImageIcon imageIcon16;
        public final ImageIcon imageIcon32;

        public ImageIcon get() {
            return this.imageIcon;
        }

        public ImageIcon get16() {
            return this.imageIcon16;
        }

        public ImageIcon get32() {
            return this.imageIcon32;
        }

        private Icon(String loc) {
            ImageIcon ii = null;
            ImageIcon ii16 = null;
            ImageIcon ii32 = null;
            try {
                ii = new ImageIcon(Theme.class.getResource(loc));
                Image i = ii.getImage();
                ii16 = new ImageIcon(i.getScaledInstance(16, 16, 16));
                ii32 = new ImageIcon(i.getScaledInstance(32, 32, 16));
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "missing icon image", e);
            }
            this.imageIcon = ii;
            this.imageIcon16 = ii16;
            this.imageIcon32 = ii32;
        }
    }
}

