/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.jgrowl;

import com.timestored.jgrowl.AbstractGrowler;
import com.timestored.jgrowl.FadingGrowler;
import com.timestored.jgrowl.StandardTheme;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.UIManager;

class GrowlerFacade
extends AbstractGrowler {
    private static final Icon INFO_ICON;
    private static final Icon WARNING_ICON;
    private static final Icon ERROR_ICON;
    private final FadingGrowler gc;
    private static final Logger LOG;

    public GrowlerFacade(FadingGrowler growlerCore) {
        this.gc = growlerCore;
    }

    @Override
    public void show(Level logLevel, String message, String title, boolean sticky, ImageIcon imageIcon) {
        Icon ii = null;
        if (logLevel.equals(Level.SEVERE)) {
            ii = ERROR_ICON;
        } else if (logLevel.equals(Level.WARNING)) {
            ii = WARNING_ICON;
        } else if (logLevel.equals(Level.INFO)) {
            ii = INFO_ICON;
        }
        this.gc.show(message, title, ii, sticky, logLevel);
    }

    @Override
    public void show(Level logLevel, JPanel messagePanel, String title, boolean sticky) {
        this.gc.show(logLevel, messagePanel, title, sticky);
    }

    static {
        LOG = Logger.getLogger(GrowlerFacade.class.getName());
        Icon ii = null;
        Icon wi = null;
        Icon ei = null;
        try {
            ii = UIManager.getIcon("OptionPane.informationIcon");
            wi = UIManager.getIcon("OptionPane.warningIcon");
            ei = UIManager.getIcon("OptionPane.errorIcon");
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Could not get builtin icons for growlers", e);
        }
        try {
            if (ii == null) {
                ii = StandardTheme.Icon.INFO.get();
            }
            if (ei == null) {
                ei = StandardTheme.Icon.SEVERE.get();
            }
            if (wi == null) {
                wi = StandardTheme.Icon.WARNING.get();
            }
        }
        catch (Exception e) {
            LOG.log(Level.FINE, "Could not get user createed icons for growlers", e);
        }
        INFO_ICON = ii;
        WARNING_ICON = wi;
        ERROR_ICON = ei;
    }
}

