/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.jgrowl;

import com.timestored.jgrowl.Growl;
import com.timestored.jgrowl.Theme;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JWindow;

class FadingGrowler {
    private static final Logger LOG = Logger.getLogger(FadingGrowler.class.getName());
    private final Theme theme;
    private final JFrame parentFrame;
    private int lastSeenY;
    private final List<DisplayedItem> displayedItems = new ArrayList<DisplayedItem>();
    private static ExecutorService executor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startFadingThread() {
        if (executor == null) {
            FadingGrowler fadingGrowler = this;
            synchronized (fadingGrowler) {
                if (executor == null) {
                    executor = Executors.newCachedThreadPool();
                    executor.execute(new Runnable(){

                        @Override
                        public void run() {
                            while (true) {
                                try {
                                    while (true) {
                                        Thread.sleep(FadingGrowler.this.theme.getFadeTimerDelay());
                                        EventQueue.invokeLater(new Runnable(){

                                            /*
                                             * WARNING - Removed try catching itself - possible behaviour change.
                                             */
                                            @Override
                                            public void run() {
                                                List list = FadingGrowler.this.displayedItems;
                                                synchronized (list) {
                                                    FadingGrowler.this.updateDisplayItems();
                                                }
                                            }
                                        });
                                    }
                                }
                                catch (InterruptedException ex) {
                                    LOG.log(Level.SEVERE, null, ex);
                                    continue;
                                }
                                break;
                            }
                        }
                    });
                }
            }
        }
    }

    public FadingGrowler(JFrame parentFrame, Theme theme) {
        this.parentFrame = parentFrame;
        this.lastSeenY = parentFrame.getY();
        this.theme = theme;
        parentFrame.addWindowFocusListener(new WindowFocusListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void windowLostFocus(WindowEvent e) {
                List list = FadingGrowler.this.displayedItems;
                synchronized (list) {
                    for (DisplayedItem d : FadingGrowler.this.displayedItems) {
                        d.frame.setAlwaysOnTop(false);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void windowGainedFocus(WindowEvent e) {
                List list = FadingGrowler.this.displayedItems;
                synchronized (list) {
                    for (DisplayedItem d : FadingGrowler.this.displayedItems) {
                        d.frame.setAlwaysOnTop(true);
                    }
                }
            }
        });
    }

    public synchronized void show(String message, String title, Icon icon, boolean sticky, Level logLevel) {
        this.startFadingThread();
        LOG.log(logLevel, title + ": " + message);
        this.addItem(new Growl(message, title, icon, sticky, logLevel));
    }

    public void show(Level logLevel, JPanel messagePanel, String title, boolean sticky) {
        this.startFadingThread();
        LOG.log(logLevel, title + ": Custom JPanel");
        this.addItem(new Growl(messagePanel, title, null, sticky, logLevel));
    }

    private void addItem(final Growl message) {
        EventQueue.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Window frame = FadingGrowler.this.theme.getWindow(message, FadingGrowler.this.parentFrame);
                List list = FadingGrowler.this.displayedItems;
                synchronized (list) {
                    int top = FadingGrowler.this.parentFrame.getY() + (FadingGrowler.this.parentFrame.getHeight() - 100);
                    if (FadingGrowler.this.displayedItems.size() > 0) {
                        Window lastFrame = ((DisplayedItem)FadingGrowler.this.displayedItems.get(FadingGrowler.this.displayedItems.size() - 1)).frame;
                        top = lastFrame.getY() + lastFrame.getHeight() + FadingGrowler.this.theme.getSpaceBetweenItems();
                    }
                    frame.setLocation(FadingGrowler.this.theme.getLeftRuler(FadingGrowler.this.parentFrame), top);
                    final DisplayedItem di = new DisplayedItem(frame, message);
                    frame.addMouseListener(new MouseAdapter(){

                        @Override
                        public void mousePressed(MouseEvent e) {
                            di.lifeLeft = 0.0f;
                            super.mousePressed(e);
                        }
                    });
                    FadingGrowler.this.displayedItems.add(di);
                }
            }
        });
    }

    private void updateDisplayItems() {
        int parentTop = this.parentFrame.getY() + 2 * this.parentFrame.getHeight() / 3;
        int parentYmove = 0;
        if (this.parentFrame.getY() != this.lastSeenY) {
            parentYmove = this.parentFrame.getY() - this.lastSeenY;
            this.lastSeenY = this.parentFrame.getY();
        }
        Iterator<DisplayedItem> it = this.displayedItems.iterator();
        int prevTop = parentTop;
        while (it.hasNext()) {
            int fadeLevel;
            DisplayedItem dispItem = it.next();
            Window fm = dispItem.frame;
            int y = fm.getY();
            Point p = fm.getMousePosition();
            if (p != null && fm.contains(p) && dispItem.lifeLeft > 0.0f) {
                dispItem.lifeLeft = 1.0f;
                FadingGrowler.setAlpha((double)dispItem.lifeLeft > 1.0 ? 1.0f : dispItem.lifeLeft, fm);
                break;
            }
            if (!dispItem.message.isSticky() && y < (fadeLevel = parentTop + Math.min(this.theme.getFadeRangeMinimum(), this.parentFrame.getHeight() / 2))) {
                dispItem.lifeLeft -= this.theme.getFadeRate();
            }
            if (y > prevTop) {
                y -= this.theme.getMoveSpeed();
            }
            prevTop = y + this.theme.getSpaceBetweenItems() + fm.getHeight();
            if (dispItem.lifeLeft > 0.0f) {
                FadingGrowler.setAlpha((double)dispItem.lifeLeft > 1.0 ? 1.0f : dispItem.lifeLeft, fm);
                fm.setLocation(this.theme.getLeftRuler(this.parentFrame), y + parentYmove);
                continue;
            }
            it.remove();
            fm.setVisible(false);
        }
    }

    private static void setAlpha(float alpha, Window win) {
        block3: {
            try {
                Class<?> awtutil = Class.forName("com.sun.awt.AWTUtilities");
                Method setWindowOpaque = awtutil.getMethod("setWindowOpacity", Window.class, Float.TYPE);
                setWindowOpaque.invoke(null, win, Float.valueOf(alpha));
            }
            catch (Exception ex) {
                if (win instanceof JWindow) {
                    ((JWindow)win).getRootPane().putClientProperty("Window.alpha", new Float(alpha));
                }
                if (!(win instanceof JFrame)) break block3;
                ((JFrame)win).getRootPane().putClientProperty("Window.alpha", new Float(alpha));
            }
        }
    }

    private static class DisplayedItem {
        private final Growl message;
        private final Window frame;
        private float lifeLeft;

        public DisplayedItem(Window frame, Growl message) {
            this.frame = frame;
            this.message = message;
            this.lifeLeft = 1.0f;
        }
    }
}

