/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.jgrowl;

import com.timestored.jgrowl.Growler;
import com.timestored.jgrowl.GrowlerFactory;
import com.timestored.qstudio.UpdateHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class Demo
implements Runnable {
    private Growler growler;
    private JTextArea textArea;
    private JTextField titleField;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Demo());
    }

    @Override
    public void run() {
        JFrame frame = new JFrame("JGrowl Demo");
        frame.setDefaultCloseOperation(3);
        frame.setPreferredSize(new Dimension(640, 480));
        Container c2 = frame.getContentPane();
        c2.setLayout(new BorderLayout(5, 5));
        this.growler = GrowlerFactory.getGrowler(frame);
        this.textArea = new JTextArea("Hello World! This is my message");
        this.titleField = new JTextField(" Growler Title ");
        JPanel buttonPanel = new JPanel(new GridLayout(1, 0));
        buttonPanel.add(this.getButton(Level.INFO, false));
        buttonPanel.add(this.getButton(Level.WARNING, false));
        buttonPanel.add(this.getButton(Level.SEVERE, false));
        buttonPanel.add(this.getButton(Level.INFO, true));
        JButton addCustomButton = new JButton("Custom");
        addCustomButton.addActionListener(ae -> this.growler.show(Level.INFO, UpdateHelper.getUpdateGrowler("DEMOVS"), null, true));
        buttonPanel.add(addCustomButton);
        JPanel p = new JPanel(new GridLayout(2, 3));
        p.add(buttonPanel);
        p.add(this.titleField);
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.add(p);
        c2.add((Component)panel, "North");
        c2.add((Component)this.textArea, "Center");
        frame.pack();
        frame.setVisible(true);
    }

    private JButton getButton(Level l, boolean sticky) {
        JButton addButton = new JButton(l.getName() + (sticky ? " sticky" : ""));
        addButton.addActionListener(e -> this.growler.show(l, this.textArea.getText(), this.titleField.getText(), sticky, null));
        return addButton;
    }
}

