/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.docs;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.timestored.docs.Document;
import com.timestored.docs.OpenDocumentsModel;
import com.timestored.misc.FifoBuffer;
import com.timestored.qstudio.model.KeyInterface;
import com.timestored.qstudio.model.PersistanceInterface;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class RecentDocumentPersister
implements OpenDocumentsModel.Listener {
    private final FifoBuffer<String> recentFilePaths = new FifoBuffer(9);
    private final PersistanceInterface persistance;
    private final KeyInterface recentDocsKey;
    private final KeyInterface lastOpenedFolderKey;

    public RecentDocumentPersister(PersistanceInterface persistance, KeyInterface recentDocsKey, KeyInterface lastOpenedFolderKey) {
        this.persistance = Preconditions.checkNotNull(persistance);
        this.recentDocsKey = Preconditions.checkNotNull(recentDocsKey);
        this.lastOpenedFolderKey = Preconditions.checkNotNull(lastOpenedFolderKey);
        this.recentFilePaths.addAll(RecentDocumentPersister.getFilePaths(persistance, recentDocsKey));
    }

    private static List<String> getFilePaths(PersistanceInterface persistance, KeyInterface filekey) {
        String[] recDocs;
        ArrayList<String> filepaths = Lists.newArrayList();
        String recent = persistance.get(filekey, "");
        for (String filepath : recDocs = recent.split(";")) {
            if (filepath.trim().isEmpty()) continue;
            filepaths.add(filepath);
        }
        return filepaths;
    }

    private void persistRecentDocuments() {
        String recent = Joiner.on(";").join(this.recentFilePaths.getAll());
        this.persistance.put(this.recentDocsKey, recent);
    }

    public List<String> getRecentFilePaths() {
        return this.recentFilePaths.getAll();
    }

    public File getOpenFolder(PersistanceInterface persistance) {
        File f;
        String path = persistance.get(this.lastOpenedFolderKey, "");
        if (!path.equals("") && (f = new File(path)).isDirectory()) {
            return f;
        }
        return null;
    }

    @Override
    public void docClosed(Document document) {
        if (document.getFilePath() != null) {
            this.recentFilePaths.add(document.getFilePath());
        }
        this.persistRecentDocuments();
    }

    @Override
    public void docAdded(Document document) {
        if (document.getFilePath() != null) {
            this.recentFilePaths.add(document.getFilePath());
        }
        this.persistRecentDocuments();
    }

    @Override
    public void docSaved() {
    }

    @Override
    public void docSelected(Document document) {
    }

    @Override
    public void docContentModified() {
    }

    @Override
    public void docCaratModified() {
    }

    @Override
    public void ignoredFolderPatternSelected(Pattern ignoredFolderPattern) {
    }

    @Override
    public void folderSelected(File selectedFolder) {
        String path = selectedFolder == null ? "" : selectedFolder.getAbsolutePath();
        this.persistance.put(this.lastOpenedFolderKey, path);
    }
}

