/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.docs;

import com.timestored.docs.Document;
import com.timestored.docs.DocumentActions;
import com.timestored.swingxx.AAction;
import java.awt.Desktop;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import lombok.NonNull;

public class DocumentsPopupMenu
extends JPopupMenu {
    private static final Logger log = Logger.getLogger(DocumentsPopupMenu.class.getName());
    private static final long serialVersionUID = 1L;

    public DocumentsPopupMenu(DocumentActions documentActions, final @NonNull Document document) {
        String p;
        if (document == null) {
            throw new NullPointerException("document is marked non-null but is null");
        }
        this.setName("DocumentsPopupMenu");
        Action closeOthersAction = documentActions.getCloseOtherFilesAction(document);
        this.add(closeOthersAction);
        closeOthersAction.setEnabled(document != null);
        this.add(documentActions.getCloseFileAction(document));
        this.add(documentActions.getCloseAllToRightFileAction(document));
        this.add(documentActions.getCloseAllFileAction());
        String fp = document != null ? document.getFilePath() : null;
        final String parentPath = p = fp != null ? new File(fp).getParentFile().getAbsolutePath() : null;
        AbstractAction reloadDoc = new AbstractAction("Reload"){

            @Override
            public void actionPerformed(ActionEvent e) {
                String message = "Are you sure you want to reload the current file and lose the changes made?";
                int choice = JOptionPane.showConfirmDialog(null, message, "Reload File", 0, 2);
                if (choice == 0) {
                    try {
                        document.reloadFromFile();
                    }
                    catch (IOException e1) {
                        JOptionPane.showMessageDialog(null, "Error reloading content from disk.");
                    }
                }
            }
        };
        AbstractAction openParentPath = new AbstractAction("Open Containing Folder"){

            @Override
            public void actionPerformed(ActionEvent e) {
                File parentFolder = new File(parentPath);
                if (parentFolder.exists()) {
                    try {
                        Desktop.getDesktop().open(parentFolder);
                    }
                    catch (IOException ioe) {
                        String message = "Could not open folder";
                        log.log(Level.WARNING, message, ioe);
                        JOptionPane.showMessageDialog(null, message);
                    }
                } else {
                    JOptionPane.showMessageDialog(null, "Folder no longer exists");
                }
            }
        };
        AAction copyFilePathToClipboard = new AAction("Full File Path to Clipboard", e -> {
            StringSelection sel = new StringSelection(p);
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(sel, sel);
        });
        AAction copyFileNameToClipboard = new AAction("Filename to Clipboard", e -> {
            StringSelection sel = new StringSelection(document.getTitle());
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(sel, sel);
        });
        reloadDoc.setEnabled(p != null);
        copyFilePathToClipboard.setEnabled(p != null);
        openParentPath.setEnabled(parentPath != null);
        this.addSeparator();
        this.add(reloadDoc);
        this.addSeparator();
        this.add(openParentPath);
        this.add(copyFilePathToClipboard);
        this.add(copyFileNameToClipboard);
    }
}

