/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.docs;

import com.github.vertical_blank.sqlformatter.SqlFormatter;
import com.github.vertical_blank.sqlformatter.core.FormatConfig;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.timestored.docs.Document;
import com.timestored.docs.OpenDocumentsModel;
import com.timestored.messages.Msg;
import com.timestored.qstudio.UpdateHelper;
import com.timestored.swingxx.AAction;
import com.timestored.swingxx.SwingUtils;
import com.timestored.theme.Icon;
import com.timestored.theme.ShortcutAction;
import com.timestored.theme.Theme;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import jsyntaxpane.actions.FindNextAction;
import jsyntaxpane.actions.FindReplaceAction;
import jsyntaxpane.actions.GotoLineAction;
import jsyntaxpane.actions.RedoAction;
import jsyntaxpane.actions.ToggleCommentsAction;
import jsyntaxpane.actions.UndoAction;

public class DocumentActions {
    private static final Logger LOG = Logger.getLogger(DocumentActions.class.getName());
    private static final long FILE_WARNING_SIZE_MB = 1L;
    private final OpenDocumentsModel openDocumentsModel;
    private File lastSelectedOpenFileFolder;
    private File lastSelectedSaveFolder;
    private final Action openFolderAction;
    private final Action closeFolderAction;
    private final Action saveFileAction;
    private final Action closeFileAction;
    private final Action closeAllFileAction = new CloseAllFileAction();
    private final Action saveAsFileAction = new SaveAsFileAction();
    private final Action newFileAction;
    private final List<Action> fileActions;
    private final Action nextDocumentAction;
    private final Action prevDocumentAction;
    private final Action cutAction;
    private final Action copyAction;
    private final Action selectCurrentStatementAction;
    private final Action upperAction;
    private final Action lowerAction;
    private final Action formatAction;
    private final List<Action> editorActions;
    private final Action generateDocumentationAction;
    private final Supplier<String[]> defaultFiletypeExtension;
    private boolean saveWithWindowsLineEndings = true;
    private static final int shortModifier = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    private static final KeyStroke OUTLINE_DOC_KS = KeyStroke.getKeyStroke(73, shortModifier);

    public DocumentActions(OpenDocumentsModel openDocumentsModel, Supplier<String[]> defaultFiletypeExtension) {
        this(openDocumentsModel, defaultFiletypeExtension, null);
    }

    public DocumentActions(final OpenDocumentsModel openDocumentsModel, Supplier<String[]> defaultFiletypeExtension, Action generateDocumentationAction) {
        this.openDocumentsModel = Preconditions.checkNotNull(openDocumentsModel);
        this.defaultFiletypeExtension = defaultFiletypeExtension;
        this.generateDocumentationAction = generateDocumentationAction;
        if (generateDocumentationAction != null) {
            generateDocumentationAction.putValue("MnemonicKey", 68);
        }
        final String oFolder = Msg.get(Msg.Key.OPEN_FOLDER);
        this.openFolderAction = new AbstractAction(oFolder + "..."){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JFileChooser fc = DocumentActions.getFileChooser(DocumentActions.this.lastSelectedOpenFileFolder);
                fc.setFileSelectionMode(1);
                fc.setMultiSelectionEnabled(false);
                fc.setDialogTitle(Msg.get(Msg.Key.BROWSE_FOLDER));
                fc.setApproveButtonText(oFolder);
                if (fc.showOpenDialog(null) == 0) {
                    File f = fc.getSelectedFile();
                    if (f.isDirectory()) {
                        DocumentActions.this.lastSelectedOpenFileFolder = f;
                        openDocumentsModel.setSelectedFolder(f);
                    } else {
                        String message = Msg.get(Msg.Key.INVALID_DIRECTORY);
                        JOptionPane.showMessageDialog(null, message);
                    }
                } else {
                    LOG.info(Msg.get(Msg.Key.OPEN_CANCELLED));
                }
                UpdateHelper.registerEvent("doc_openfolder");
            }
        };
        this.closeFolderAction = new AAction(Msg.get(Msg.Key.CLOSE_FOLDER), e -> openDocumentsModel.setSelectedFolder(null));
        this.newFileAction = new ShortcutAction(Msg.get(Msg.Key.NEW_FILE), Theme.CIcon.DOCUMENT_NEW, 78){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                openDocumentsModel.addDocument();
                UpdateHelper.registerEvent("doc_newfile");
            }
        };
        this.closeFileAction = new ShortcutAction(Msg.get(Msg.Key.CLOSE), null, Msg.get(Msg.Key.CLOSE), 67, 115){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DocumentActions.this.closeWithConfirmation(openDocumentsModel.getSelectedDocument());
                UpdateHelper.registerEvent("doc_closefile");
            }
        };
        this.saveFileAction = new ShortcutAction(Msg.get(Msg.Key.SAVE_FILE), Theme.CIcon.SAVE, 83){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent ae) {
                try {
                    Document selDoc = openDocumentsModel.getSelectedDocument();
                    if (selDoc.getFilePath() != null) {
                        openDocumentsModel.saveDocument(DocumentActions.this.saveWithWindowsLineEndings);
                    } else {
                        DocumentActions.this.letUserChooseFileAndSave();
                    }
                }
                catch (IOException e) {
                    String msg = Msg.get(Msg.Key.SAVE_FILE_ERROR);
                    LOG.info(msg);
                    JOptionPane.showMessageDialog(null, msg, Msg.get(Msg.Key.SAVE_ERROR), 0);
                }
                UpdateHelper.registerEvent("doc_savefile");
            }
        };
        this.nextDocumentAction = new ShortcutAction(Msg.get(Msg.Key.NEXT_DOCUMENT), null, 34){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent ae) {
                openDocumentsModel.gotoNextDocument();
                UpdateHelper.registerEvent("doc_nextdoc");
            }
        };
        this.prevDocumentAction = new ShortcutAction(Msg.get(Msg.Key.PREV_DOCUMENT), null, 33){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent ae) {
                openDocumentsModel.gotoPrevDocument();
                UpdateHelper.registerEvent("doc_prevdoc");
            }
        };
        this.fileActions = Collections.unmodifiableList(Arrays.asList(this.openFolderAction, this.closeFileAction, this.closeAllFileAction, this.closeFolderAction, this.saveFileAction, this.saveAsFileAction));
        this.selectCurrentStatementAction = new SelectCurrentStatementAction();
        this.upperAction = new UpperAction();
        this.lowerAction = new LowerAction();
        this.formatAction = new FormatAction();
        this.cutAction = DocumentActions.getAction(Msg.get(Msg.Key.CUT), Theme.CIcon.EDIT_CUT, new DefaultEditorKit.CutAction(), 88);
        this.copyAction = DocumentActions.getAction(Msg.get(Msg.Key.COPY), Theme.CIcon.EDIT_COPY, new DefaultEditorKit.CopyAction(), 67);
        Action findNextAction = DocumentActions.getAction(Msg.get(Msg.Key.FIND_NEXT), Theme.CIcon.EDIT_FIND_NEXT, new FindNextAction(), 114);
        Action toggleCommentAction = DocumentActions.getAction(Msg.get(Msg.Key.TOGGLE_COMMENTS), Theme.CIcon.EDIT_COMMENT, new ToggleCommentsAction(), 47);
        toggleCommentAction.putValue("LineComments", "/ ");
        findNextAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke("F3"));
        ArrayList<Action> acts = new ArrayList<Action>();
        acts.add(this.cutAction);
        acts.add(this.copyAction);
        acts.add(DocumentActions.getAction(Msg.get(Msg.Key.PASTE), Theme.CIcon.EDIT_PASTE, new DefaultEditorKit.PasteAction(), 86));
        acts.add(toggleCommentAction);
        acts.add(DocumentActions.getAction(Msg.get(Msg.Key.FIND) + "...", Theme.CIcon.EDIT_FIND, new FindReplaceAction(), 72));
        acts.add(findNextAction);
        acts.add(DocumentActions.getAction(Msg.get(Msg.Key.GOTO_LINE) + "...", Theme.CIcon.EDIT_GOTO_LINE, new GotoLineAction(), 71));
        acts.add(null);
        acts.add(this.selectCurrentStatementAction);
        acts.add(this.formatAction);
        acts.add(this.upperAction);
        acts.add(this.lowerAction);
        this.editorActions = Collections.unmodifiableList(acts);
        openDocumentsModel.addListener(new OpenDocumentsModel.Adapter(){

            @Override
            public void docSelected(Document document) {
                DocumentActions.this.refresh();
            }

            @Override
            public void docSaved() {
                DocumentActions.this.refresh();
            }

            @Override
            public void docContentModified() {
                DocumentActions.this.refresh();
            }

            @Override
            public void docCaratModified() {
                DocumentActions.this.refresh();
            }
        });
        this.refresh();
    }

    static void replaceSelected(JTextComponent target, Function<String, String> transform) {
        if (target != null) {
            int start = target.getSelectionStart();
            int end = target.getSelectionEnd();
            if (end > start) {
                target.replaceSelection(transform.apply(target.getSelectedText()));
                target.setSelectionStart(start);
                target.setSelectionEnd(end);
            }
        }
    }

    public Action configureAction(Action action, KeyStroke keyStroke, String shortDescription) {
        action.putValue("ShortDescription", shortDescription);
        action.putValue("AcceleratorKey", keyStroke);
        return action;
    }

    public void openFile(File file) {
        this.openFiles(Arrays.asList(file));
    }

    public void openFiles(List<File> files) {
        String errMsg = "";
        for (File f : files) {
            boolean proceed = true;
            double fileSizeMb = (double)f.length() / 1048576.0;
            if (fileSizeMb > 1.0) {
                DecimalFormat df = new DecimalFormat("##.00");
                String msg = f.getName() + " file is " + df.format(fileSizeMb) + " MB and may take some time to open. Proceed?";
                proceed = 0 == JOptionPane.showConfirmDialog(null, msg);
            }
            try {
                if (!proceed) continue;
                this.openDocumentsModel.openDocument(f);
                this.lastSelectedOpenFileFolder = f.getParentFile();
            }
            catch (IOException e) {
                errMsg = errMsg + "\r\n" + f.getAbsolutePath();
                LOG.log(Level.WARNING, "openFiles exception", e);
            }
        }
        if (errMsg.length() > 0) {
            String msg = Msg.get(Msg.Key.EROR_OPENING_FILES) + errMsg;
            JOptionPane.showMessageDialog(null, msg, Msg.get(Msg.Key.ERROR_OPENING), 0);
        }
    }

    public List<Action> getEditorActions() {
        this.refresh();
        return this.editorActions;
    }

    private static Action getAction(String title, Icon icon, Action action, int acceleratorKey) {
        action.putValue("Name", title);
        action.putValue("SmallIcon", icon.get16());
        KeyStroke k = KeyStroke.getKeyStroke(acceleratorKey, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        action.putValue("AcceleratorKey", k);
        return action;
    }

    public Action getOpenFolderAction() {
        return this.openFolderAction;
    }

    public Action getNewFileAction() {
        return this.newFileAction;
    }

    public Action getSaveFileAction() {
        return this.saveFileAction;
    }

    public Action getSaveAsFileAction() {
        return this.saveAsFileAction;
    }

    public Action getCloseFileAction() {
        return this.closeFileAction;
    }

    public Action getCloseFileAction(Document document) {
        String t = document == null ? "" : document.getTitle();
        AAction a = new AAction(Msg.get(Msg.Key.CLOSE) + " " + t, e -> this.closeWithConfirmation(document));
        a.setEnabled(document != null && this.openDocumentsModel.getDocuments().contains(document));
        return a;
    }

    public Action getCloseOtherFilesAction(Document document) {
        AAction closeOthersAction = new AAction("Close Other Tabs", e -> {
            for (Document d : this.openDocumentsModel.getDocuments()) {
                if (d.equals(document)) continue;
                this.getCloseFileAction(d).actionPerformed(null);
            }
        });
        closeOthersAction.putValue("MnemonicKey", 79);
        return closeOthersAction;
    }

    public Action getCloseAllFileAction() {
        return this.closeAllFileAction;
    }

    private void closeWithConfirmation(Document document) {
        LOG.info("closeWithConfirmation: " + document);
        try {
            if (document.hasUnsavedChanges()) {
                String message = Msg.get(Msg.Key.DOCUMENT) + document.getTitle() + Msg.get(Msg.Key.UNSAVED_CHANGES_CONFIRM);
                int choice = JOptionPane.showConfirmDialog(null, message);
                if (choice == 0) {
                    if (document.getFilePath() != null) {
                        this.openDocumentsModel.saveDocument(this.saveWithWindowsLineEndings);
                    } else {
                        this.letUserChooseFileAndSave();
                    }
                } else if (choice == 1) {
                    this.openDocumentsModel.closeDocument(document);
                }
            } else {
                this.openDocumentsModel.closeDocument(document);
            }
        }
        catch (IOException e) {
            String msg = Msg.get(Msg.Key.ERROR_SAVING);
            LOG.info(msg);
            JOptionPane.showMessageDialog(null, msg, msg, 0);
        }
    }

    private void letUserChooseFileAndSave() {
        File file = SwingUtils.askUserSaveLocation(this.lastSelectedSaveFolder, this.defaultFiletypeExtension.get());
        if (file != null) {
            try {
                this.openDocumentsModel.saveAs(file, this.saveWithWindowsLineEndings);
                this.lastSelectedSaveFolder = file.getParentFile();
            }
            catch (IOException e) {
                String msg = Msg.get(Msg.Key.ERROR_SAVING) + ": " + file;
                LOG.info(msg);
                JOptionPane.showMessageDialog(null, msg, Msg.get(Msg.Key.ERROR_SAVING), 0);
            }
        } else {
            LOG.info(Msg.get(Msg.Key.SAVE_CANCELLED));
        }
    }

    private void refresh() {
        Document d = this.openDocumentsModel.getSelectedDocument();
        this.saveFileAction.setEnabled(d.hasUnsavedChanges());
        this.cutAction.setEnabled(d.isTextSelected());
        this.copyAction.setEnabled(d.isTextSelected());
        this.lowerAction.setEnabled(d.isTextSelected());
        this.upperAction.setEnabled(d.isTextSelected());
        this.formatAction.setEnabled(true);
    }

    public Action getUndoAction() {
        return DocumentActions.getAction(Msg.get(Msg.Key.UNDO_TYPING), Theme.CIcon.EDIT_UNDO, new UndoAction(), 90);
    }

    public Action getRedoAction() {
        return DocumentActions.getAction(Msg.get(Msg.Key.REDO), Theme.CIcon.EDIT_REDO, new RedoAction(), 89);
    }

    public List<Action> getFileActions() {
        return this.fileActions;
    }

    private static JFileChooser getFileChooser(File lastSelection) {
        if (lastSelection != null) {
            return new JFileChooser(lastSelection);
        }
        return new JFileChooser();
    }

    public Action getGenerateDocumentationAction() {
        return this.generateDocumentationAction;
    }

    public List<Action> getOpenRecentActions(List<String> filePaths) {
        ArrayList<Action> r = Lists.newArrayListWithExpectedSize(filePaths.size());
        int i = 1;
        for (String fp : filePaths) {
            r.add(new AAction(i + " " + fp, e -> this.openFile(new File(fp))));
            ++i;
        }
        return r;
    }

    public Action openAllAction(List<String> filePaths) {
        return new AAction(Msg.get(Msg.Key.OPEN_ALL_RECENT), e -> {
            ArrayList<File> files = Lists.newArrayList();
            for (String fp : filePaths) {
                files.add(new File(fp));
            }
            this.openFiles(files);
        });
    }

    public void setDefaultFolder(File folder) {
        if (folder != null && folder.isDirectory()) {
            this.lastSelectedOpenFileFolder = folder;
            this.lastSelectedSaveFolder = folder;
        }
    }

    public void addActionsToEditor(JComponent component, Document document) {
        this.addAction(component, this.nextDocumentAction);
        this.addAction(component, this.prevDocumentAction);
    }

    private void addAction(JComponent component, Action action) {
        String mapkey = (String)action.getValue("Name");
        component.getActionMap().put(mapkey, action);
        KeyStroke keyStroke = (KeyStroke)action.getValue("AcceleratorKey");
        component.getInputMap().put(keyStroke, mapkey);
    }

    public Action getCloseAllToRightFileAction(Document document) {
        return new CloseAllToRightFileAction(document);
    }

    public File getLastSelectedOpenFileFolder() {
        return this.lastSelectedOpenFileFolder;
    }

    public void setSaveWithWindowsLineEndings(boolean saveWithWindowsLineEndings) {
        this.saveWithWindowsLineEndings = saveWithWindowsLineEndings;
    }

    public boolean isSaveWithWindowsLineEndings() {
        return this.saveWithWindowsLineEndings;
    }

    private class SaveAsFileAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public SaveAsFileAction() {
            super(Msg.get(Msg.Key.SAVE_AS) + "...", Theme.CIcon.SAVE_AS.get16());
            this.putValue("ShortDescription", Msg.get(Msg.Key.SAVE_AS) + "...");
            this.putValue("MnemonicKey", 65);
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            DocumentActions.this.letUserChooseFileAndSave();
        }
    }

    private class CloseAllToRightFileAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private final Document document;

        public CloseAllToRightFileAction(Document document) {
            super(Msg.get(Msg.Key.CLOSE_ALL) + " to the Right");
            this.putValue("ShortDescription", Msg.get(Msg.Key.CLOSE_ALL) + " to the Right");
            this.putValue("MnemonicKey", 82);
            this.document = Preconditions.checkNotNull(document);
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            boolean foundMe = false;
            for (Document d : DocumentActions.this.openDocumentsModel.getDocuments()) {
                if (foundMe) {
                    DocumentActions.this.closeWithConfirmation(d);
                    continue;
                }
                foundMe = foundMe || d.equals(this.document);
            }
            UpdateHelper.registerEvent("doc_closeallright");
        }
    }

    private class CloseAllFileAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public CloseAllFileAction() {
            super(Msg.get(Msg.Key.CLOSE_ALL));
            this.putValue("ShortDescription", Msg.get(Msg.Key.CLOSE_ALL));
            this.putValue("MnemonicKey", 65);
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            for (Document d : DocumentActions.this.openDocumentsModel.getDocuments()) {
                DocumentActions.this.closeWithConfirmation(d);
            }
            UpdateHelper.registerEvent("doc_closeall");
        }
    }

    public static class LowerAction
    extends TextAction {
        public LowerAction() {
            super("lowercase");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DocumentActions.replaceSelected(this.getTextComponent(e), String::toLowerCase);
            UpdateHelper.registerEvent("doc_lower");
        }
    }

    public static class FormatAction
    extends TextAction {
        public FormatAction() {
            super("Format SQL");
            Toolkit tk = Toolkit.getDefaultToolkit();
            KeyStroke k = KeyStroke.getKeyStroke(70, tk.getMenuShortcutKeyMask() | 1);
            this.putValue("AcceleratorKey", k);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FormatConfig cfg = FormatConfig.builder().maxColumnLength(120).indent("\t").build();
            JTextComponent tc = this.getTextComponent(e);
            if (tc.getSelectionStart() == tc.getSelectionEnd()) {
                tc.setSelectionStart(0);
                tc.setSelectionEnd(tc.getText().length() - 1);
            }
            DocumentActions.replaceSelected(this.getTextComponent(e), s -> SqlFormatter.format(s, cfg));
            UpdateHelper.registerEvent("doc_format");
        }
    }

    public static class UpperAction
    extends TextAction {
        public UpperAction() {
            super("UPPERCASE");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DocumentActions.replaceSelected(this.getTextComponent(e), String::toUpperCase);
            UpdateHelper.registerEvent("doc_upper");
        }
    }

    public class SelectCurrentStatementAction
    extends TextAction {
        public SelectCurrentStatementAction() {
            super("Select Current Statement");
            Toolkit tk = Toolkit.getDefaultToolkit();
            KeyStroke k = KeyStroke.getKeyStroke(46, tk.getMenuShortcutKeyMask() | 1);
            this.putValue("AcceleratorKey", k);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] startEnd = DocumentActions.this.openDocumentsModel.getSelectedDocument().getCurrentStatementBounds();
            JTextComponent txtc = this.getTextComponent(e);
            int[] bounds = Document.getStatementBounds(txtc.getText(), txtc.getCaretPosition());
            txtc.setSelectionStart(bounds[0]);
            txtc.setSelectionEnd(bounds[1]);
        }
    }
}

