/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.docs;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.timestored.misc.IOUtils;
import com.timestored.theme.Icon;
import com.timestored.theme.Theme;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;

public class Document {
    private static final Logger LOG = Logger.getLogger(Document.class.getName());
    private static AtomicInteger counter = new AtomicInteger(0);
    private final List<Listener> listeners = new CopyOnWriteArrayList<Listener>();
    private String title;
    private File file = null;
    private String savedContent = "";
    private String content = "";
    private int selectionStart = 0;
    private int selectionEnd = 0;
    private int caretPosition = 0;

    public Document() {
        int v = counter.incrementAndGet();
        this.title = "new " + v;
    }

    public Document(File file) throws IOException {
        this.file = Preconditions.checkNotNull(file);
        this.savedContent = this.content = IOUtils.toString(file, Charset.forName("UTF-8")).replace("\r", "");
        this.title = file.getName();
    }

    public void reloadFromFile() throws IOException {
        if (this.file != null) {
            String s = IOUtils.toString(this.file, Charset.forName("UTF-8")).replace("\r", "");
            this.setContent(s);
        }
    }

    public boolean hasUnsavedChanges() {
        return !this.savedContent.equals(this.content);
    }

    public boolean isReadOnly() {
        return this.file != null && !this.file.canWrite();
    }

    public String getFilePath() {
        return this.file == null ? null : this.file.getAbsolutePath();
    }

    public String getFileEnding() {
        String p = this.file == null ? "" : this.file.getAbsolutePath().toLowerCase();
        int dotPos = p.lastIndexOf(46);
        return dotPos >= 0 ? p.substring(dotPos + 1) : "";
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("title", this.title).add("file", this.file).add("selectionStart", this.selectionStart).add("selectionEnd", this.selectionEnd).add("unsavedChanges", this.hasUnsavedChanges()).toString();
    }

    public boolean isQKfileSuffix() {
        if (this.file != null) {
            String fp = this.file.getName().toUpperCase();
            return fp.endsWith(".Q") || fp.endsWith(".K");
        }
        return false;
    }

    public String getContent() {
        return this.content;
    }

    public int getSelectionEnd() {
        return this.selectionEnd;
    }

    public int getSelectionStart() {
        return this.selectionStart;
    }

    public String getSelectedText() {
        return this.content.substring(this.selectionStart, this.selectionEnd);
    }

    public boolean isTextSelected() {
        return this.selectionEnd > this.selectionStart;
    }

    public String getCurrentLine() {
        int j;
        int i;
        int LS = 10;
        for (i = Math.max(this.caretPosition - 1, 0); i > 0 && i < this.content.length() && this.content.charAt(i) != '\n'; --i) {
        }
        for (j = Math.min(this.caretPosition, this.content.length()); j < this.content.length() && this.content.charAt(j) != '\n'; ++j) {
        }
        return this.content.substring(i, j).trim();
    }

    public int[] getCurrentStatementBounds() {
        return Document.getStatementBounds(this.content, this.caretPosition);
    }

    public String getCurrentStatement() {
        int[] r = this.getCurrentStatementBounds();
        return this.content.substring(r[0], r[1]);
    }

    public static int[] getStatementBounds(String content, int caretPosition) {
        int idx;
        List<Integer> splitPoints = Document.getSqlStatementSplitpoints(content);
        if (splitPoints.isEmpty()) {
            return new int[]{0, content.length()};
        }
        for (idx = 0; idx < splitPoints.size() && splitPoints.get(idx) < caretPosition; ++idx) {
        }
        int start = idx > 0 ? splitPoints.get(idx - 1) + 1 : 0;
        int end = idx < splitPoints.size() ? splitPoints.get(idx).intValue() : content.length();
        return new int[]{start, end};
    }

    public static List<Integer> getSqlStatementSplitpoints(String sqlCode) {
        if (sqlCode == null || sqlCode.isEmpty() || sqlCode.trim().length() == 0) {
            return Collections.emptyList();
        }
        ArrayList<Integer> splitPoints = new ArrayList<Integer>();
        boolean textFound = false;
        block9: for (int i = 0; i < sqlCode.length(); ++i) {
            char c2 = sqlCode.charAt(i);
            int nextC = i < sqlCode.length() - 1 ? (int)sqlCode.charAt(i + 1) : 32;
            switch (c2) {
                case ';': {
                    splitPoints.add(i);
                    textFound = false;
                    continue block9;
                }
                case '-': {
                    if (nextC == 45) {
                        ++i;
                        ++i;
                        while (i < sqlCode.length() && sqlCode.charAt(i) != '\n') {
                            ++i;
                        }
                        if (textFound) continue block9;
                        splitPoints.add(i);
                        continue block9;
                    }
                    textFound = true;
                    continue block9;
                }
                case '`': {
                    if (nextC != 96 || i >= sqlCode.length() - 2 || sqlCode.charAt(i + 2) != '`') continue block9;
                    ++i;
                    ++i;
                    ++i;
                    while (i < sqlCode.length() && sqlCode.charAt(i) != '\n') {
                        ++i;
                    }
                    splitPoints.add(i);
                    textFound = false;
                    continue block9;
                }
                case '/': {
                    if (nextC == 42) {
                        ++i;
                        ++i;
                        while (i < sqlCode.length()) {
                            if (sqlCode.charAt(i - 1) == '*' && sqlCode.charAt(i) == '/') {
                                ++i;
                                if (textFound) break;
                                splitPoints.add(i);
                                break;
                            }
                            ++i;
                        }
                    }
                    textFound = true;
                    continue block9;
                }
                case '\\': {
                    ++i;
                    textFound = true;
                    continue block9;
                }
                case '\"': 
                case '\'': {
                    textFound = true;
                    char insidec = c2;
                    ++i;
                    while (i < sqlCode.length()) {
                        boolean notEscaped = i == sqlCode.length() || sqlCode.charAt(i - 1) != '\\';
                        c2 = sqlCode.charAt(i);
                        if (c2 == insidec && notEscaped) continue block9;
                        if (c2 == '\n' && notEscaped) {
                            splitPoints.add(i);
                            continue block9;
                        }
                        ++i;
                    }
                    continue block9;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block9;
                }
                default: {
                    textFound = true;
                }
            }
        }
        return splitPoints;
    }

    public String getTextBeforeCarat() {
        int i;
        int LS = 10;
        for (i = Math.max(this.caretPosition - 1, 0); i > 0 && i < this.content.length() && this.content.charAt(i) != '\n' && this.content.charAt(i) != ' '; --i) {
        }
        return this.content.substring(i, this.caretPosition).trim();
    }

    public void saveAs(File file, boolean useWindowsLineEndings) throws IOException {
        try {
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), Charset.forName("UTF-8")));
            if (useWindowsLineEndings) {
                bw.write(this.content.replace("\n", "\r\n"));
            } else {
                bw.write(this.content);
            }
            bw.close();
            this.file = file;
            this.title = file.getName();
            this.savedContent = this.content;
            for (Listener l : this.listeners) {
                l.docSaved();
            }
        }
        catch (IOException ex) {
            throw new IOException(ex);
        }
    }

    public void setContent(String content) {
        this.content = content.replace("\r", "");
        int l = content.length();
        if (this.selectionEnd > l) {
            this.selectionEnd = l;
        }
        if (this.selectionStart > l) {
            this.selectionStart = l;
        }
        this.notifyListenersContentModified();
    }

    public void save(boolean useWindowsLineEndings) throws IOException {
        try {
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)new FileOutputStream(this.file), "UTF8");
            BufferedWriter bw = new BufferedWriter(osw);
            if (useWindowsLineEndings) {
                bw.write(this.content.replace("\n", "\r\n"));
            } else {
                bw.write(this.content);
            }
            bw.close();
            this.savedContent = this.content;
            for (Listener l : this.listeners) {
                l.docSaved();
            }
        }
        catch (IOException ex) {
            throw new IOException(ex);
        }
    }

    public void setSelection(int selectionStart, int selectionEnd, int caretPosition) {
        Preconditions.checkArgument(selectionStart >= 0 && selectionEnd >= selectionStart);
        Preconditions.checkArgument(selectionEnd <= this.content.length());
        this.selectionStart = selectionStart;
        this.selectionEnd = selectionEnd;
        this.caretPosition = caretPosition;
        LOG.finest("(selectionStart - selectionEnd) -> " + selectionStart + " - " + selectionEnd);
        LOG.finest("setSelection -> getSelectedText() = " + this.getSelectedText());
        this.notifyListenersCaratMoved();
    }

    public void setCaratPosition(int caratPosition) {
        Preconditions.checkArgument(caratPosition <= this.content.length() && caratPosition >= 0);
        this.caretPosition = caratPosition;
        LOG.finest("caratPosition = " + caratPosition);
        this.notifyListenersCaratMoved();
    }

    public int getCaratPosition() {
        return this.caretPosition;
    }

    public void insertSelectedText(String text) {
        String t = text.replace("\r\n", "\n");
        this.content = this.content.substring(0, this.selectionStart) + "\n" + t + this.content.substring(this.selectionEnd);
        if (this.caretPosition > this.content.length()) {
            this.caretPosition = this.content.length();
        }
        int pos = this.selectionStart + t.length() + 1;
        this.notifyListenersContentModified();
        this.setCaratPosition(pos);
    }

    public void insertText(String text) {
        this.content = this.content.substring(0, this.selectionEnd) + text + this.content.substring(this.selectionEnd);
        this.notifyListenersContentModified();
    }

    public void gotoNextLine() {
        int i;
        boolean found = false;
        for (i = this.caretPosition; i < this.content.length() - 1; ++i) {
            if (this.content.charAt(i) != '\n') continue;
            found = true;
            break;
        }
        if (found) {
            this.setCaratPosition(i + 1);
        }
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    private void notifyListenersContentModified() {
        for (Listener l : this.listeners) {
            l.docContentModified();
        }
    }

    private void notifyListenersCaratMoved() {
        for (Listener l : this.listeners) {
            l.docCaratModified();
        }
    }

    public Icon getIcon() {
        Theme.CIcon icon = Theme.CIcon.PAGE;
        if (this.isReadOnly()) {
            icon = Theme.CIcon.PAGE_WHITE_ZIP;
        } else if (this.hasUnsavedChanges()) {
            icon = Theme.CIcon.PAGE_RED;
        } else if (this.isQKfileSuffix()) {
            icon = Theme.CIcon.PAGE_CODE;
        }
        return icon;
    }

    public boolean isInMemoryAndEmpty() {
        return this.getFilePath() == null && this.content.trim().isEmpty();
    }

    public void setFile(File file) {
        this.file = file;
    }

    public static interface Listener {
        public void docContentModified();

        public void docCaratModified();

        public void docSaved();
    }
}

