/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.docs;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.timestored.docs.Document;
import com.timestored.docs.OpenDocumentsModel;
import com.timestored.misc.IOUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class BackgroundDocumentsSaver
implements OpenDocumentsModel.Listener {
    private static final Logger log = Logger.getLogger(BackgroundDocumentsSaver.class.getName());
    private static final String CONTENT_MARKER = "\r\nCONTENT:\r\n";
    private static final String PATH_MARKER = "\r\nPATH:\r\n";
    private final OpenDocumentsModel openDocumentsModel;
    private final File scratchDir;
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private Date previousSave = new Date(0L);
    private boolean anyDocModified;
    private int secondsBetweenSaves;

    public BackgroundDocumentsSaver(OpenDocumentsModel openDocumentsModel, File scratchDir, int secondsBetweenSaves) {
        this.openDocumentsModel = Preconditions.checkNotNull(openDocumentsModel);
        this.scratchDir = Preconditions.checkNotNull(scratchDir);
        Preconditions.checkArgument(secondsBetweenSaves > 0);
        this.secondsBetweenSaves = secondsBetweenSaves;
        scratchDir.mkdirs();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                BackgroundDocumentsSaver.this.requestSave();
            }
        };
        this.scheduler.scheduleAtFixedRate(runnable, secondsBetweenSaves, secondsBetweenSaves, TimeUnit.SECONDS);
    }

    public synchronized void requestSave() {
        Date now;
        if (this.anyDocModified && (now = new Date()).getTime() - this.previousSave.getTime() >= (long)((this.secondsBetweenSaves - 1) * 1000)) {
            log.info("store currently open documents to scratch.");
            this.saveDocumentsScratch();
            this.previousSave = now;
            this.anyDocModified = false;
            return;
        }
        log.fine("skipping persistOpenDocuments");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void docContentModified() {
        BackgroundDocumentsSaver backgroundDocumentsSaver = this;
        synchronized (backgroundDocumentsSaver) {
            this.anyDocModified = true;
        }
    }

    @Override
    public void docCaratModified() {
    }

    @Override
    public void docSaved() {
    }

    @Override
    public void docAdded(Document document) {
    }

    @Override
    public void docClosed(Document document) {
    }

    @Override
    public void docSelected(Document document) {
    }

    @Override
    public void folderSelected(File selectedFolder) {
    }

    @Override
    public void ignoredFolderPatternSelected(Pattern ignoredFolderPattern) {
    }

    public synchronized void saveDocumentsScratch() {
        log.log(Level.INFO, "Saving docs to scratch");
        int i = 0;
        File[] existingFiles = this.scratchDir.listFiles();
        if (existingFiles != null) {
            for (File ef : existingFiles) {
                ef.delete();
            }
        }
        List<Document> documents = this.openDocumentsModel.getDocuments();
        for (Document d : documents) {
            File f = null;
            while ((f = new File(this.scratchDir, ++i + "-" + d.getTitle())).exists() && i++ < 1000) {
            }
            String firstLine = d.getFilePath() == null ? "" : d.getFilePath();
            try {
                StringBuilder sb = new StringBuilder(d.getTitle() + PATH_MARKER + firstLine);
                if (d.hasUnsavedChanges()) {
                    sb.append(CONTENT_MARKER).append(d.getContent());
                }
                IOUtils.writeStringToFile(sb.toString(), f);
            }
            catch (IOException e) {
                log.log(Level.SEVERE, "Could not save scratch files.", e);
            }
        }
    }

    public void restoreDocuments() {
        Document onlyDoc;
        ArrayList<Document> startingDocuments = Lists.newArrayList(this.openDocumentsModel.getDocuments());
        File[] files = this.scratchDir.listFiles();
        List<File> scratchFiles = Collections.emptyList();
        if (files != null) {
            scratchFiles = Lists.newArrayList(files);
        }
        for (File f : scratchFiles) {
            try {
                String c2 = IOUtils.toString(f);
                int pathPos = c2.indexOf(PATH_MARKER);
                int contentPos = c2.indexOf(CONTENT_MARKER);
                if (pathPos > 0) {
                    String title = c2.substring(0, pathPos);
                    String path = c2.substring(pathPos + PATH_MARKER.length());
                    String content = null;
                    if (contentPos > pathPos) {
                        path = c2.substring(pathPos + PATH_MARKER.length(), contentPos);
                        content = c2.substring(contentPos + CONTENT_MARKER.length());
                    }
                    Document d = null;
                    if (path.trim().length() > 0) {
                        log.info("attempting to restore existing known document");
                        File pFile = new File(path);
                        if (!pFile.exists() || !pFile.canRead()) continue;
                        try {
                            d = this.openDocumentsModel.openDocument(pFile);
                            if (content == null) continue;
                            d.setContent(content);
                        }
                        catch (IOException iOException) {}
                        continue;
                    }
                    d = this.openDocumentsModel.addDocument();
                    d.setTitle(title);
                    if (content == null) continue;
                    d.setContent(content);
                    continue;
                }
                log.log(Level.WARNING, "found scratch file I dont know how to restore: " + f.getAbsolutePath());
            }
            catch (IOException e) {
                log.log(Level.WARNING, "error restoring files from scratch: " + e);
            }
        }
        if (startingDocuments.size() == 1 && (onlyDoc = (Document)startingDocuments.get(0)).getContent().trim().isEmpty()) {
            this.openDocumentsModel.closeDocument(onlyDoc);
        }
    }

    public void shutdownNow() {
        this.scheduler.shutdownNow();
    }
}

