/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.connections;

import com.timestored.connections.ConnectionManager;
import com.timestored.connections.ServerConfig;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;

public class ServerNameComboBox
extends JComboBox {
    private static final long serialVersionUID = 1L;
    private final ConnectionManager connectionManager;

    public ServerNameComboBox(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
        connectionManager.addListener(new ConnectionManager.Listener(){

            @Override
            public void statusChange(ServerConfig serverConfig, boolean connected) {
                ServerNameComboBox.this.refresh();
            }

            @Override
            public void prefChange() {
                ServerNameComboBox.this.refresh();
            }

            @Override
            public void serverAdded(ServerConfig sc) {
            }
        });
        this.refresh();
    }

    private void refresh() {
        String selectedServer = (String)this.getSelectedItem();
        List<String> serverNames = this.connectionManager.getServerNames();
        String[] names = serverNames.toArray(new String[0]);
        this.setModel(new DefaultComboBoxModel<String>(names));
        if (serverNames.contains(selectedServer)) {
            this.setSelectedItem(selectedServer);
        }
    }

    public ServerConfig getSelectedServer() {
        return this.connectionManager.getServer((String)this.getSelectedItem());
    }
}

