/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.connections;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.timestored.connections.JdbcTypes;
import com.timestored.connections.ServerConfig;
import java.awt.Color;

@XStreamAlias(value="ServerConfig")
public class ServerConfigDTO {
    @XStreamAsAttribute
    private final String name;
    @XStreamAsAttribute
    private final String username;
    @XStreamAsAttribute
    private final String password;
    @XStreamAsAttribute
    private final String host;
    @XStreamAsAttribute
    private final int port;
    @XStreamAsAttribute
    private final String database;
    @XStreamAsAttribute
    private final JdbcTypes jdbcType;
    @XStreamAsAttribute
    private Integer clr;
    private transient Color color = null;
    @XStreamAsAttribute
    private String folder;

    public ServerConfigDTO() {
        this.name = "";
        this.password = "";
        this.username = "";
        this.host = "";
        this.port = 0;
        this.database = "";
        this.jdbcType = JdbcTypes.KDB;
    }

    ServerConfigDTO(ServerConfig sc, boolean removeLogins) {
        this.name = sc.getName();
        if (removeLogins) {
            this.password = "";
            this.username = "";
        } else {
            this.password = sc.getPassword();
            this.username = sc.getUsername();
        }
        this.host = sc.getHost();
        this.port = sc.getPort();
        this.database = sc.getDatabase();
        this.jdbcType = sc.getJdbcType();
        this.clr = sc.getColor().getRGB();
    }

    ServerConfig getInstance() {
        Color c2 = null;
        if (this.clr != null) {
            c2 = new Color(this.clr);
        }
        String n = this.name;
        if (this.folder != null && this.folder.length() > 0) {
            n = this.folder + "/" + this.name;
        }
        return new ServerConfig(this.host, this.port, this.username, this.password, n, this.jdbcType, c2, this.database);
    }
}

