/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.connections;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.timestored.connections.JdbcTypes;
import com.timestored.misc.IOUtils;
import com.timestored.plugins.ConnectionDetails;
import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import net.jcip.annotations.Immutable;

@Immutable
public class ServerConfig {
    private final String name;
    private final String username;
    private final String password;
    private final String host;
    private final int port;
    private final String database;
    private final JdbcTypes jdbcType;
    private final boolean useTLS;
    private final boolean useAsync;
    private final Color color;
    public static final Color DEFAULT_COLOR = Color.WHITE;
    public static final boolean DEFAULT_USE_TLS = false;
    public static final boolean DEFAULT_USE_ASYNC = false;

    public ServerConfig(String host, int port, String username, String password, String name, JdbcTypes jdbcType) {
        this(host, port, username, password, name, jdbcType, DEFAULT_COLOR, null, null, false, false);
    }

    public ServerConfig(String host, int port, String username, String password, String name, JdbcTypes jdbcType, Color color, String database) {
        this(host, port, username, password, name, jdbcType, color == null ? DEFAULT_COLOR : color, database, null, false, false);
    }

    public static ServerConfig forFile(String filePath) throws IOException {
        String url;
        String path = filePath.replace('\\', '/');
        File f = new File(filePath);
        String header = "";
        if (f.length() > 5L) {
            FileInputStream is = new FileInputStream(f);
            byte[] buffer = new byte[4];
            if (((InputStream)is).read(buffer) != buffer.length) {
                // empty if block
            }
            ((InputStream)is).close();
            header = new String(buffer);
        }
        String cleanName = f.getAbsolutePath().replace('/', '\\');
        if (header.equalsIgnoreCase("H:2,")) {
            url = "jdbc:h2:file:" + (path.endsWith(".mv.db") ? path.substring(0, path.length() - 6) : path);
            return new ServerConfig("localhost", 0, "sa", "", cleanName, JdbcTypes.H2, null, url);
        }
        if (header.equalsIgnoreCase("SQLi") || path.endsWith(".sqlite")) {
            url = "jdbc:sqlite:" + filePath;
            return new ServerConfig("localhost", 0, "", "", cleanName, JdbcTypes.SQLITE_JDBC, null, url);
        }
        File hsqlProps = new File(filePath + ".properties");
        if (hsqlProps.exists() && IOUtils.toString(hsqlProps).toUpperCase().contains("#HSQL")) {
            String url2 = "jdbc:hsqldb:" + filePath;
            return new ServerConfig("localhost", 0, "", "", cleanName, JdbcTypes.HSQLDB_EMBEDDED, null, url2);
        }
        String url3 = "jdbc:duckdb:" + filePath;
        return new ServerConfig("localhost", 0, "", "", cleanName, JdbcTypes.DUCKDB, null, url3);
    }

    public ServerConfig(String host, int port, String username, String password, String name, JdbcTypes jdbcType, Color color, String database, String folder, boolean useTLS, boolean useAsync) {
        if (port < 0) {
            throw new IllegalArgumentException("Must specify positive port");
        }
        if (name.endsWith("/")) {
            throw new IllegalArgumentException("Name cannot end with a /");
        }
        this.database = database;
        this.color = color == null ? DEFAULT_COLOR : color;
        this.host = Preconditions.checkNotNull(host);
        this.port = port;
        this.username = username;
        this.password = password;
        this.useTLS = useTLS;
        this.useAsync = useAsync;
        String n = name;
        if (n == null || n.trim().isEmpty()) {
            if (port == 0) {
                n = database == null || database.trim().isEmpty() ? jdbcType.name() : database.replace("jdbc:", "");
                int p = n.indexOf("/");
                if (p >= 0) {
                    n = n.substring(0, p);
                }
            } else {
                n = host.replaceAll("https://", "").replaceAll("http://", "") + ":" + port;
            }
        }
        if (folder != null) {
            if (n.contains("/")) {
                throw new IllegalArgumentException("Cant specify name with path and separate folder");
            }
            String cf = ServerConfig.cleanFolderName(folder);
            n = (cf.length() > 0 ? cf + "/" : "") + n;
        } else {
            n = Joiner.on("/").join(ServerConfig.extractParts(n));
        }
        this.name = n;
        this.jdbcType = Preconditions.checkNotNull(jdbcType);
    }

    public ServerConfig(String host, int port, String username, String password, String name) {
        this(host, port, username, password, name, JdbcTypes.KDB, null, null);
    }

    public ServerConfig(String host, int port, String username, String password) {
        this(host, port, username, password, host + ":" + port, JdbcTypes.KDB, null, null);
    }

    public ServerConfig(String host, int port) {
        this(host, port, "", "", host + ":" + port, JdbcTypes.KDB, null, null);
    }

    public String getName() {
        return this.name;
    }

    public String getUsername() {
        return this.username == null ? "" : this.username;
    }

    public String getPassword() {
        return this.password == null ? "" : this.password;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getDatabase() {
        return this.database == null ? "" : this.database;
    }

    ConnectionDetails getConnectionDetails() {
        return new ConnectionDetails(this.host, this.port, this.database, this.username, this.password);
    }

    public String getFolder() {
        int p = this.name.lastIndexOf("/");
        String s = p > -1 ? this.name.substring(0, p) : "";
        return s;
    }

    public List<String> getFolders() {
        List<String> l = ServerConfig.extractParts(this.name);
        return l.subList(0, l.size() - 1);
    }

    public static List<String> extractParts(String name) {
        if (!name.contains("/")) {
            ArrayList<String> r = new ArrayList<String>(1);
            r.add(name);
            return r;
        }
        String[] a = name.split("/");
        ArrayList<String> r = new ArrayList<String>(a.length);
        for (String s : a) {
            if (s.length() <= 0) continue;
            r.add(s);
        }
        return r;
    }

    public static String cleanFolderName(String folder) {
        List<String> folds = ServerConfig.extractParts(folder);
        return Joiner.on("/").join(folds);
    }

    public String getShortName() {
        int p = this.name.lastIndexOf("/");
        return p > -1 ? this.name.substring(p + 1) : this.name;
    }

    public JdbcTypes getJdbcType() {
        return this.jdbcType;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("name", this.name).add("username", this.username).add("host", this.host).add("port", this.port).add("cstoreType", (Object)this.jdbcType).add("database", this.database).toString();
    }

    public String getUrl() {
        return this.jdbcType.getURL(this);
    }

    public Color getColor() {
        return this.color == null ? DEFAULT_COLOR : this.color;
    }

    public boolean isDefaultColor() {
        return DEFAULT_COLOR.equals(this.color);
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.name, this.username, this.password, this.host, this.port, this.database, this.jdbcType, this.color});
    }

    public boolean equals(Object object) {
        if (object instanceof ServerConfig) {
            ServerConfig that = (ServerConfig)object;
            return Objects.equal(this.name, that.name) && Objects.equal(this.username, that.username) && Objects.equal(this.password, that.password) && Objects.equal(this.host, that.host) && Objects.equal(this.port, that.port) && Objects.equal(this.getDatabase(), that.getDatabase()) && Objects.equal(this.getFolder(), that.getFolder()) && Objects.equal((Object)this.jdbcType, (Object)that.jdbcType) && Objects.equal(this.color, that.color);
        }
        return false;
    }

    public boolean isKDB() {
        return this.jdbcType.isKDB();
    }

    public boolean isStreaming() {
        return this.jdbcType.isStreaming();
    }

    public boolean hasLogin() {
        return this.username != null && this.username.length() > 0 || this.password != null && this.password.length() > 0;
    }

    public boolean isUseTLS() {
        return this.useTLS;
    }

    public boolean isUseAsync() {
        return this.useAsync;
    }
}

