/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.connections;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;

class Msg {
    private static final String BUNDLE_NAME = "com.timestored.connections.messages";
    private static ResourceBundle rb;

    Msg() {
    }

    public static String get(Key key) {
        return rb.getString(key.toString());
    }

    public static void setLocale(Locale locale) {
        rb = ResourceBundle.getBundle(BUNDLE_NAME, locale);
    }

    static boolean checkAllKeysSpecified() {
        for (Key k : Key.values()) {
            if (Msg.get(k) != null && Msg.get(k).trim().length() >= 1) continue;
            return false;
        }
        return true;
    }

    static Set<String> getSuperfluosResourceBundleEntries() {
        HashSet<String> extraKeys = Sets.newHashSet();
        Enumeration<String> keys = rb.getKeys();
        while (keys.hasMoreElements()) {
            String k = keys.nextElement();
            if (Key.get(k) != null) continue;
            extraKeys.add(k);
        }
        return extraKeys;
    }

    static {
        Msg.setLocale(Locale.getDefault());
    }

    public static enum Key {
        HOST,
        DATABASE,
        USERNAME,
        PASSWORD,
        ADD,
        SAVE,
        DELETE,
        CANCEL,
        PORT;

        private static final Map<String, Key> lookup;

        public static Key get(String k) {
            return lookup.get(k);
        }

        static {
            lookup = Maps.newHashMap();
            for (Key k : Key.values()) {
                lookup.put(k.toString(), k);
            }
        }
    }
}

