/*
 * Decompiled with CFR 0.152.
 */
package com.timestored.connections;

import com.timestored.connections.ConnectionManager;
import com.timestored.connections.JdbcTypes;
import com.timestored.connections.ServerConfig;
import java.io.IOException;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import lombok.NonNull;

public class MetaInfo {
    private final List<ColumnInfo> columnInfo;
    private static final Logger LOG = Logger.getLogger(MetaInfo.class.getName());

    public static MetaInfo empty() {
        return new MetaInfo(Collections.emptyList());
    }

    public static MetaInfo getMetaInfo(ConnectionManager connMan, ServerConfig serverConfig) throws Exception {
        Exception err = null;
        MetaInfo r = null;
        if (serverConfig.getJdbcType().equals((Object)JdbcTypes.TDENGINE)) {
            String tdsql = "SELECT '' AS TABLE_CAT,db_name AS TABLE_SCHEM,table_name,COL_NAME AS COLUMN_NAME,0 AS DATA_TYPE,col_type AS TYPE_NAME FROM INFORMATION_SCHEMA.INS_COLUMNS";
            try {
                r = MetaInfo.fromColumnRs(serverConfig, connMan.executeQuery(serverConfig, tdsql));
            }
            catch (Exception e) {
                err = e;
            }
            catch (Throwable t) {
                LOG.info(t.getLocalizedMessage());
            }
            if (r != null && r.getColumnInfo().size() > 0) {
                return r;
            }
        }
        try {
            r = MetaInfo.getColumns(connMan, serverConfig, null, "%", "%", "%");
        }
        catch (Exception e) {
            err = e;
        }
        catch (Throwable t) {
            LOG.info(t.getLocalizedMessage());
        }
        if (r != null && r.getColumnInfo().size() > 0) {
            return r;
        }
        try {
            r = MetaInfo.getTables(connMan, serverConfig);
        }
        catch (Exception e) {
            err = e;
        }
        catch (Throwable t) {
            LOG.info(t.getLocalizedMessage());
        }
        if (r != null && r.getColumnInfo().size() > 0) {
            return r;
        }
        if (err != null) {
            throw err;
        }
        return MetaInfo.empty();
    }

    private static MetaInfo getTables(ConnectionManager connMan, ServerConfig serverConfig) throws IOException, SQLException {
        return connMan.useConn(serverConfig, conn -> {
            DatabaseMetaData md = conn.getMetaData();
            ResultSet rs2 = md.getTables(null, null, "%", new String[]{"TABLE", "VIEW"});
            if (rs2 != null) {
                ArrayList<ColumnInfo> colInfos = new ArrayList<ColumnInfo>();
                if (rs2 != null) {
                    while (rs2.next()) {
                        colInfos.add(new ColumnInfo(MetaInfo.safeGet(rs2, "TABLE_CAT"), MetaInfo.safeGet(rs2, "TABLE_SCHEM"), MetaInfo.safeGet(rs2, "TABLE_NAME"), "ColumnsNotDetected", "", 0));
                    }
                    try {
                        rs2.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return new MetaInfo(colInfos);
            }
            return null;
        });
    }

    private static MetaInfo getColumns(ConnectionManager connMan, ServerConfig serverConfig, String catalog, String schemaPattern, String tableName, String columnName) throws IOException, SQLException {
        return connMan.useConn(serverConfig, conn -> {
            MetaInfo res = null;
            DatabaseMetaData md = conn.getMetaData();
            ResultSet rs2 = md.getColumns(catalog, schemaPattern, tableName, columnName);
            if (rs2 != null) {
                res = MetaInfo.fromColumnRs(serverConfig, rs2);
                try {
                    rs2.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return res;
        });
    }

    private static String safeGet(ResultSet rs2, String col) {
        String r = "";
        try {
            r = rs2.getString(col);
            if (r == null) {
                r = "";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return r;
    }

    private static MetaInfo fromColumnRs(ServerConfig serverConfig, ResultSet rs2) throws SQLException {
        ArrayList<ColumnInfo> colInfos = new ArrayList<ColumnInfo>();
        if (rs2 != null) {
            while (rs2.next()) {
                int dataType = 0;
                try {
                    dataType = rs2.getInt("DATA_TYPE");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                String cat = MetaInfo.safeGet(rs2, "TABLE_CAT");
                String schem = MetaInfo.safeGet(rs2, "TABLE_SCHEM");
                switch (serverConfig.getJdbcType()) {
                    case MSSERVER: {
                        cat = cat.equals("master") ? "" : cat;
                        break;
                    }
                    case H2: {
                        cat = "";
                        schem = schem.equals("PUBLIC") ? "" : schem;
                        break;
                    }
                    case DUCKDB: {
                        cat = "";
                        schem = schem.equals("main") ? "" : schem;
                        break;
                    }
                    case POSTGRES: {
                        schem = schem.equals("public") ? "" : schem;
                        break;
                    }
                }
                colInfos.add(new ColumnInfo(cat, schem, MetaInfo.safeGet(rs2, "TABLE_NAME"), MetaInfo.safeGet(rs2, "COLUMN_NAME"), MetaInfo.safeGet(rs2, "TYPE_NAME"), dataType));
            }
            try {
                rs2.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new MetaInfo(colInfos);
    }

    private static String cols(JdbcTypes jdbcTypes, List<String> colNames, boolean includeColumnNames) {
        String cols;
        String string = cols = jdbcTypes.isKDB() ? "" : "*";
        if (includeColumnNames && colNames != null) {
            cols = "";
            for (int i = 0; i < colNames.size(); ++i) {
                String cn = colNames.get(i);
                cols = cols + (i > 0 ? ", " : "") + (cn.contains(" ") ? "\"" + cn + "\"" : cn);
            }
        }
        return cols;
    }

    public static String getCountQuery(JdbcTypes jdbcTypes, String fullname) {
        return (jdbcTypes.isKDB() ? "count " : "SELECT COUNT(*) FROM ") + fullname;
    }

    public static String getTop100Query(JdbcTypes jdbcTypes, List<String> colNames, String fullname, boolean isKdbPartitioned, boolean includeColumnNames) {
        String cols = MetaInfo.cols(jdbcTypes, colNames, includeColumnNames);
        String qry = "SELECT " + cols + " FROM " + fullname + " LIMIT 1000";
        if (jdbcTypes.isKDB()) {
            String s = includeColumnNames ? "select " + cols + " from " : "";
            qry = s + (isKdbPartitioned ? ".Q.ind[" + fullname + "; `long$til 1000]" : "select[1000] from " + fullname);
        } else if (jdbcTypes.equals((Object)JdbcTypes.MSSERVER)) {
            qry = "SELECT TOP 1000 " + cols + " FROM " + fullname;
        } else if (jdbcTypes.equals((Object)JdbcTypes.ORACLE)) {
            qry = "SELECT " + cols + " FROM " + fullname + " FETCH FIRST 1000 ROWS ONLY";
        }
        return qry;
    }

    public static String getBottom100query(JdbcTypes jdbcTypes, List<String> colNames, String fullname, boolean isKdbPartitioned, boolean includeColumnNames) {
        String cols = MetaInfo.cols(jdbcTypes, colNames, includeColumnNames);
        if (isKdbPartitioned) {
            return "select " + cols + " from .Q.ind[" + fullname + "; `long$-1000 + (count " + fullname + ")+til 1000]";
        }
        return "select[-1000] " + cols + " from " + fullname;
    }

    public MetaInfo(List<ColumnInfo> columnInfo) {
        this.columnInfo = columnInfo;
    }

    public List<ColumnInfo> getColumnInfo() {
        return this.columnInfo;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MetaInfo)) {
            return false;
        }
        MetaInfo other = (MetaInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<ColumnInfo> this$columnInfo = this.getColumnInfo();
        List<ColumnInfo> other$columnInfo = other.getColumnInfo();
        return !(this$columnInfo == null ? other$columnInfo != null : !((Object)this$columnInfo).equals(other$columnInfo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MetaInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<ColumnInfo> $columnInfo = this.getColumnInfo();
        result = result * 59 + ($columnInfo == null ? 43 : ((Object)$columnInfo).hashCode());
        return result;
    }

    public String toString() {
        return "MetaInfo(columnInfo=" + this.getColumnInfo() + ")";
    }

    public static class ColumnInfo {
        @NonNull
        final String cat;
        @NonNull
        final String schema;
        @NonNull
        final String tableName;
        @NonNull
        final String columnName;
        @NonNull
        final String typeName;
        final int typeNumber;

        public String getNamespace() {
            return this.cat.isEmpty() ? this.schema : (this.schema.isEmpty() ? this.cat : this.cat + "." + this.schema);
        }

        public String getFullTableName() {
            String ns = this.getNamespace();
            return ns.isEmpty() ? this.tableName : ns + "." + this.tableName;
        }

        public ColumnInfo(@NonNull String cat, @NonNull String schema, @NonNull String tableName, @NonNull String columnName, @NonNull String typeName, int typeNumber) {
            if (cat == null) {
                throw new NullPointerException("cat is marked non-null but is null");
            }
            if (schema == null) {
                throw new NullPointerException("schema is marked non-null but is null");
            }
            if (tableName == null) {
                throw new NullPointerException("tableName is marked non-null but is null");
            }
            if (columnName == null) {
                throw new NullPointerException("columnName is marked non-null but is null");
            }
            if (typeName == null) {
                throw new NullPointerException("typeName is marked non-null but is null");
            }
            this.cat = cat;
            this.schema = schema;
            this.tableName = tableName;
            this.columnName = columnName;
            this.typeName = typeName;
            this.typeNumber = typeNumber;
        }

        @NonNull
        public String getCat() {
            return this.cat;
        }

        @NonNull
        public String getSchema() {
            return this.schema;
        }

        @NonNull
        public String getTableName() {
            return this.tableName;
        }

        @NonNull
        public String getColumnName() {
            return this.columnName;
        }

        @NonNull
        public String getTypeName() {
            return this.typeName;
        }

        public int getTypeNumber() {
            return this.typeNumber;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ColumnInfo)) {
                return false;
            }
            ColumnInfo other = (ColumnInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getTypeNumber() != other.getTypeNumber()) {
                return false;
            }
            String this$cat = this.getCat();
            String other$cat = other.getCat();
            if (this$cat == null ? other$cat != null : !this$cat.equals(other$cat)) {
                return false;
            }
            String this$schema = this.getSchema();
            String other$schema = other.getSchema();
            if (this$schema == null ? other$schema != null : !this$schema.equals(other$schema)) {
                return false;
            }
            String this$tableName = this.getTableName();
            String other$tableName = other.getTableName();
            if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
                return false;
            }
            String this$columnName = this.getColumnName();
            String other$columnName = other.getColumnName();
            if (this$columnName == null ? other$columnName != null : !this$columnName.equals(other$columnName)) {
                return false;
            }
            String this$typeName = this.getTypeName();
            String other$typeName = other.getTypeName();
            return !(this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ColumnInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getTypeNumber();
            String $cat = this.getCat();
            result = result * 59 + ($cat == null ? 43 : $cat.hashCode());
            String $schema = this.getSchema();
            result = result * 59 + ($schema == null ? 43 : $schema.hashCode());
            String $tableName = this.getTableName();
            result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
            String $columnName = this.getColumnName();
            result = result * 59 + ($columnName == null ? 43 : $columnName.hashCode());
            String $typeName = this.getTypeName();
            result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
            return result;
        }

        public String toString() {
            return "MetaInfo.ColumnInfo(cat=" + this.getCat() + ", schema=" + this.getSchema() + ", tableName=" + this.getTableName() + ", columnName=" + this.getColumnName() + ", typeName=" + this.getTypeName() + ", typeNumber=" + this.getTypeNumber() + ")";
        }
    }
}

